/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for an RDS Proxy target. It represents an RDS DB instance or Aurora DB cluster that the proxy
 * can connect to. One or more targets are associated with an RDS Proxy target group.
 * </p>
 * <p>
 * This data type is used as a response element in the <code>DescribeDBProxyTargets</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBProxyTarget implements SdkPojo, Serializable, ToCopyableBuilder<DBProxyTarget.Builder, DBProxyTarget> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(DBProxyTarget::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(DBProxyTarget::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> TRACKED_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackedClusterId").getter(getter(DBProxyTarget::trackedClusterId))
            .setter(setter(Builder::trackedClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackedClusterId").build()).build();

    private static final SdkField<String> RDS_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RdsResourceId").getter(getter(DBProxyTarget::rdsResourceId)).setter(setter(Builder::rdsResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsResourceId").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(DBProxyTarget::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DBProxyTarget::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(DBProxyTarget::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<TargetHealth> TARGET_HEALTH_FIELD = SdkField.<TargetHealth> builder(MarshallingType.SDK_POJO)
            .memberName("TargetHealth").getter(getter(DBProxyTarget::targetHealth)).setter(setter(Builder::targetHealth))
            .constructor(TargetHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetHealth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            ENDPOINT_FIELD, TRACKED_CLUSTER_ID_FIELD, RDS_RESOURCE_ID_FIELD, PORT_FIELD, TYPE_FIELD, ROLE_FIELD,
            TARGET_HEALTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetArn;

    private final String endpoint;

    private final String trackedClusterId;

    private final String rdsResourceId;

    private final Integer port;

    private final String type;

    private final String role;

    private final TargetHealth targetHealth;

    private DBProxyTarget(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.endpoint = builder.endpoint;
        this.trackedClusterId = builder.trackedClusterId;
        this.rdsResourceId = builder.rdsResourceId;
        this.port = builder.port;
        this.type = builder.type;
        this.role = builder.role;
        this.targetHealth = builder.targetHealth;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The writer endpoint for the RDS DB instance or Aurora DB cluster.
     * </p>
     * 
     * @return The writer endpoint for the RDS DB instance or Aurora DB cluster.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target
     * represents an RDS DB instance.
     * </p>
     * 
     * @return The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the
     *         target represents an RDS DB instance.
     */
    public final String trackedClusterId() {
        return trackedClusterId;
    }

    /**
     * <p>
     * The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the cluster
     * identifier for an Aurora DB cluster.
     * </p>
     * 
     * @return The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the
     *         cluster identifier for an Aurora DB cluster.
     */
    public final String rdsResourceId() {
        return rdsResourceId;
    }

    /**
     * <p>
     * The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.
     * </p>
     * 
     * @return The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target
     *         represents.
     * @see TargetType
     */
    public final TargetType type() {
        return TargetType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target
     *         represents.
     * @see TargetType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A value that indicates whether the target of the proxy can be used for read/write or read-only operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link TargetRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return A value that indicates whether the target of the proxy can be used for read/write or read-only
     *         operations.
     * @see TargetRole
     */
    public final TargetRole role() {
        return TargetRole.fromValue(role);
    }

    /**
     * <p>
     * A value that indicates whether the target of the proxy can be used for read/write or read-only operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link TargetRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return A value that indicates whether the target of the proxy can be used for read/write or read-only
     *         operations.
     * @see TargetRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * Information about the connection health of the RDS Proxy target.
     * </p>
     * 
     * @return Information about the connection health of the RDS Proxy target.
     */
    public final TargetHealth targetHealth() {
        return targetHealth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(trackedClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(rdsResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetHealth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBProxyTarget)) {
            return false;
        }
        DBProxyTarget other = (DBProxyTarget) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(trackedClusterId(), other.trackedClusterId())
                && Objects.equals(rdsResourceId(), other.rdsResourceId()) && Objects.equals(port(), other.port())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(roleAsString(), other.roleAsString())
                && Objects.equals(targetHealth(), other.targetHealth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBProxyTarget").add("TargetArn", targetArn()).add("Endpoint", endpoint())
                .add("TrackedClusterId", trackedClusterId()).add("RdsResourceId", rdsResourceId()).add("Port", port())
                .add("Type", typeAsString()).add("Role", roleAsString()).add("TargetHealth", targetHealth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "TrackedClusterId":
            return Optional.ofNullable(clazz.cast(trackedClusterId()));
        case "RdsResourceId":
            return Optional.ofNullable(clazz.cast(rdsResourceId()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "TargetHealth":
            return Optional.ofNullable(clazz.cast(targetHealth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBProxyTarget, T> g) {
        return obj -> g.apply((DBProxyTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBProxyTarget> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The writer endpoint for the RDS DB instance or Aurora DB cluster.
         * </p>
         * 
         * @param endpoint
         *        The writer endpoint for the RDS DB instance or Aurora DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the
         * target represents an RDS DB instance.
         * </p>
         * 
         * @param trackedClusterId
         *        The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when
         *        the target represents an RDS DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackedClusterId(String trackedClusterId);

        /**
         * <p>
         * The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the
         * cluster identifier for an Aurora DB cluster.
         * </p>
         * 
         * @param rdsResourceId
         *        The identifier representing the target. It can be the instance identifier for an RDS DB instance, or
         *        the cluster identifier for an Aurora DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsResourceId(String rdsResourceId);

        /**
         * <p>
         * The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.
         * </p>
         * 
         * @param port
         *        The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target
         * represents.
         * </p>
         * 
         * @param type
         *        Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target
         *        represents.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target
         * represents.
         * </p>
         * 
         * @param type
         *        Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target
         *        represents.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder type(TargetType type);

        /**
         * <p>
         * A value that indicates whether the target of the proxy can be used for read/write or read-only operations.
         * </p>
         * 
         * @param role
         *        A value that indicates whether the target of the proxy can be used for read/write or read-only
         *        operations.
         * @see TargetRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetRole
         */
        Builder role(String role);

        /**
         * <p>
         * A value that indicates whether the target of the proxy can be used for read/write or read-only operations.
         * </p>
         * 
         * @param role
         *        A value that indicates whether the target of the proxy can be used for read/write or read-only
         *        operations.
         * @see TargetRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetRole
         */
        Builder role(TargetRole role);

        /**
         * <p>
         * Information about the connection health of the RDS Proxy target.
         * </p>
         * 
         * @param targetHealth
         *        Information about the connection health of the RDS Proxy target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetHealth(TargetHealth targetHealth);

        /**
         * <p>
         * Information about the connection health of the RDS Proxy target.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetHealth.Builder} avoiding the need to
         * create one manually via {@link TargetHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #targetHealth(TargetHealth)}.
         * 
         * @param targetHealth
         *        a consumer that will call methods on {@link TargetHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetHealth(TargetHealth)
         */
        default Builder targetHealth(Consumer<TargetHealth.Builder> targetHealth) {
            return targetHealth(TargetHealth.builder().applyMutation(targetHealth).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetArn;

        private String endpoint;

        private String trackedClusterId;

        private String rdsResourceId;

        private Integer port;

        private String type;

        private String role;

        private TargetHealth targetHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(DBProxyTarget model) {
            targetArn(model.targetArn);
            endpoint(model.endpoint);
            trackedClusterId(model.trackedClusterId);
            rdsResourceId(model.rdsResourceId);
            port(model.port);
            type(model.type);
            role(model.role);
            targetHealth(model.targetHealth);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getTrackedClusterId() {
            return trackedClusterId;
        }

        @Override
        public final Builder trackedClusterId(String trackedClusterId) {
            this.trackedClusterId = trackedClusterId;
            return this;
        }

        public final void setTrackedClusterId(String trackedClusterId) {
            this.trackedClusterId = trackedClusterId;
        }

        public final String getRdsResourceId() {
            return rdsResourceId;
        }

        @Override
        public final Builder rdsResourceId(String rdsResourceId) {
            this.rdsResourceId = rdsResourceId;
            return this;
        }

        public final void setRdsResourceId(String rdsResourceId) {
            this.rdsResourceId = rdsResourceId;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TargetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(TargetRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final TargetHealth.Builder getTargetHealth() {
            return targetHealth != null ? targetHealth.toBuilder() : null;
        }

        @Override
        public final Builder targetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
            return this;
        }

        public final void setTargetHealth(TargetHealth.BuilderImpl targetHealth) {
            this.targetHealth = targetHealth != null ? targetHealth.build() : null;
        }

        @Override
        public DBProxyTarget build() {
            return new DBProxyTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
