/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomAvailabilityZonesResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeCustomAvailabilityZonesResponse.Builder, DescribeCustomAvailabilityZonesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeCustomAvailabilityZonesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<CustomAvailabilityZone>> CUSTOM_AVAILABILITY_ZONES_FIELD = SdkField
            .<List<CustomAvailabilityZone>> builder(MarshallingType.LIST)
            .memberName("CustomAvailabilityZones")
            .getter(getter(DescribeCustomAvailabilityZonesResponse::customAvailabilityZones))
            .setter(setter(Builder::customAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CustomAvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<CustomAvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CustomAvailabilityZone").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CUSTOM_AVAILABILITY_ZONES_FIELD));

    private final String marker;

    private final List<CustomAvailabilityZone> customAvailabilityZones;

    private DescribeCustomAvailabilityZonesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.customAvailabilityZones = builder.customAvailabilityZones;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeCustomAvailabilityZones</code> request. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeCustomAvailabilityZones</code> request.
     *         If this parameter is specified, the response includes only records beyond the marker, up to the value
     *         specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the CustomAvailabilityZones property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCustomAvailabilityZones() {
        return customAvailabilityZones != null && !(customAvailabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.
     */
    public final List<CustomAvailabilityZone> customAvailabilityZones() {
        return customAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAvailabilityZones() ? customAvailabilityZones() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomAvailabilityZonesResponse)) {
            return false;
        }
        DescribeCustomAvailabilityZonesResponse other = (DescribeCustomAvailabilityZonesResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasCustomAvailabilityZones() == other.hasCustomAvailabilityZones()
                && Objects.equals(customAvailabilityZones(), other.customAvailabilityZones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomAvailabilityZonesResponse").add("Marker", marker())
                .add("CustomAvailabilityZones", hasCustomAvailabilityZones() ? customAvailabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "CustomAvailabilityZones":
            return Optional.ofNullable(clazz.cast(customAvailabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomAvailabilityZonesResponse, T> g) {
        return obj -> g.apply((DescribeCustomAvailabilityZonesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCustomAvailabilityZonesResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeCustomAvailabilityZones</code> request. If
         * this parameter is specified, the response includes only records beyond the marker, up to the value specified
         * by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeCustomAvailabilityZones</code>
         *        request. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.
         * </p>
         * 
         * @param customAvailabilityZones
         *        The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZones(Collection<CustomAvailabilityZone> customAvailabilityZones);

        /**
         * <p>
         * The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.
         * </p>
         * 
         * @param customAvailabilityZones
         *        The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZones(CustomAvailabilityZone... customAvailabilityZones);

        /**
         * <p>
         * The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomAvailabilityZone>.Builder} avoiding
         * the need to create one manually via {@link List<CustomAvailabilityZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomAvailabilityZone>.Builder#build()} is called
         * immediately and its result is passed to {@link #customAvailabilityZones(List<CustomAvailabilityZone>)}.
         * 
         * @param customAvailabilityZones
         *        a consumer that will call methods on {@link List<CustomAvailabilityZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAvailabilityZones(List<CustomAvailabilityZone>)
         */
        Builder customAvailabilityZones(Consumer<CustomAvailabilityZone.Builder>... customAvailabilityZones);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<CustomAvailabilityZone> customAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomAvailabilityZonesResponse model) {
            super(model);
            marker(model.marker);
            customAvailabilityZones(model.customAvailabilityZones);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<CustomAvailabilityZone.Builder> getCustomAvailabilityZones() {
            List<CustomAvailabilityZone.Builder> result = CustomAvailabilityZoneListCopier
                    .copyToBuilder(this.customAvailabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder customAvailabilityZones(Collection<CustomAvailabilityZone> customAvailabilityZones) {
            this.customAvailabilityZones = CustomAvailabilityZoneListCopier.copy(customAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAvailabilityZones(CustomAvailabilityZone... customAvailabilityZones) {
            customAvailabilityZones(Arrays.asList(customAvailabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAvailabilityZones(Consumer<CustomAvailabilityZone.Builder>... customAvailabilityZones) {
            customAvailabilityZones(Stream.of(customAvailabilityZones)
                    .map(c -> CustomAvailabilityZone.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomAvailabilityZones(Collection<CustomAvailabilityZone.BuilderImpl> customAvailabilityZones) {
            this.customAvailabilityZones = CustomAvailabilityZoneListCopier.copyFromBuilder(customAvailabilityZones);
        }

        @Override
        public DescribeCustomAvailabilityZonesResponse build() {
            return new DescribeCustomAvailabilityZonesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
