/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbProxyEndpointsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbProxyEndpointsResponse.Builder, DescribeDbProxyEndpointsResponse> {
    private static final SdkField<List<DBProxyEndpoint>> DB_PROXY_ENDPOINTS_FIELD = SdkField
            .<List<DBProxyEndpoint>> builder(MarshallingType.LIST)
            .memberName("DBProxyEndpoints")
            .getter(getter(DescribeDbProxyEndpointsResponse::dbProxyEndpoints))
            .setter(setter(Builder::dbProxyEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DBProxyEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBProxyEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbProxyEndpointsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_ENDPOINTS_FIELD,
            MARKER_FIELD));

    private final List<DBProxyEndpoint> dbProxyEndpoints;

    private final String marker;

    private DescribeDbProxyEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.dbProxyEndpoints = builder.dbProxyEndpoints;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the DBProxyEndpoints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbProxyEndpoints() {
        return dbProxyEndpoints != null && !(dbProxyEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>ProxyEndpoint</code> objects returned by the API operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbProxyEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <code>ProxyEndpoint</code> objects returned by the API operation.
     */
    public final List<DBProxyEndpoint> dbProxyEndpoints() {
        return dbProxyEndpoints;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDbProxyEndpoints() ? dbProxyEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbProxyEndpointsResponse)) {
            return false;
        }
        DescribeDbProxyEndpointsResponse other = (DescribeDbProxyEndpointsResponse) obj;
        return hasDbProxyEndpoints() == other.hasDbProxyEndpoints()
                && Objects.equals(dbProxyEndpoints(), other.dbProxyEndpoints()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbProxyEndpointsResponse")
                .add("DBProxyEndpoints", hasDbProxyEndpoints() ? dbProxyEndpoints() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyEndpoints":
            return Optional.ofNullable(clazz.cast(dbProxyEndpoints()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbProxyEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeDbProxyEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbProxyEndpointsResponse> {
        /**
         * <p>
         * The list of <code>ProxyEndpoint</code> objects returned by the API operation.
         * </p>
         * 
         * @param dbProxyEndpoints
         *        The list of <code>ProxyEndpoint</code> objects returned by the API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyEndpoints(Collection<DBProxyEndpoint> dbProxyEndpoints);

        /**
         * <p>
         * The list of <code>ProxyEndpoint</code> objects returned by the API operation.
         * </p>
         * 
         * @param dbProxyEndpoints
         *        The list of <code>ProxyEndpoint</code> objects returned by the API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyEndpoints(DBProxyEndpoint... dbProxyEndpoints);

        /**
         * <p>
         * The list of <code>ProxyEndpoint</code> objects returned by the API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBProxyEndpoint>.Builder} avoiding the need
         * to create one manually via {@link List<DBProxyEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBProxyEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #dbProxyEndpoints(List<DBProxyEndpoint>)}.
         * 
         * @param dbProxyEndpoints
         *        a consumer that will call methods on {@link List<DBProxyEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbProxyEndpoints(List<DBProxyEndpoint>)
         */
        Builder dbProxyEndpoints(Consumer<DBProxyEndpoint.Builder>... dbProxyEndpoints);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<DBProxyEndpoint> dbProxyEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbProxyEndpointsResponse model) {
            super(model);
            dbProxyEndpoints(model.dbProxyEndpoints);
            marker(model.marker);
        }

        public final List<DBProxyEndpoint.Builder> getDbProxyEndpoints() {
            List<DBProxyEndpoint.Builder> result = DBProxyEndpointListCopier.copyToBuilder(this.dbProxyEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dbProxyEndpoints(Collection<DBProxyEndpoint> dbProxyEndpoints) {
            this.dbProxyEndpoints = DBProxyEndpointListCopier.copy(dbProxyEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbProxyEndpoints(DBProxyEndpoint... dbProxyEndpoints) {
            dbProxyEndpoints(Arrays.asList(dbProxyEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbProxyEndpoints(Consumer<DBProxyEndpoint.Builder>... dbProxyEndpoints) {
            dbProxyEndpoints(Stream.of(dbProxyEndpoints).map(c -> DBProxyEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbProxyEndpoints(Collection<DBProxyEndpoint.BuilderImpl> dbProxyEndpoints) {
            this.dbProxyEndpoints = DBProxyEndpointListCopier.copyFromBuilder(dbProxyEndpoints);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDbProxyEndpointsResponse build() {
            return new DescribeDbProxyEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
