/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbSnapshotAttributesResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbSnapshotAttributesResponse.Builder, DescribeDbSnapshotAttributesResponse> {
    private static final SdkField<DBSnapshotAttributesResult> DB_SNAPSHOT_ATTRIBUTES_RESULT_FIELD = SdkField
            .<DBSnapshotAttributesResult> builder(MarshallingType.SDK_POJO)
            .memberName("DBSnapshotAttributesResult")
            .getter(getter(DescribeDbSnapshotAttributesResponse::dbSnapshotAttributesResult))
            .setter(setter(Builder::dbSnapshotAttributesResult))
            .constructor(DBSnapshotAttributesResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotAttributesResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DB_SNAPSHOT_ATTRIBUTES_RESULT_FIELD));

    private final DBSnapshotAttributesResult dbSnapshotAttributesResult;

    private DescribeDbSnapshotAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.dbSnapshotAttributesResult = builder.dbSnapshotAttributesResult;
    }

    /**
     * Returns the value of the DBSnapshotAttributesResult property for this object.
     * 
     * @return The value of the DBSnapshotAttributesResult property for this object.
     */
    public final DBSnapshotAttributesResult dbSnapshotAttributesResult() {
        return dbSnapshotAttributesResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotAttributesResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSnapshotAttributesResponse)) {
            return false;
        }
        DescribeDbSnapshotAttributesResponse other = (DescribeDbSnapshotAttributesResponse) obj;
        return Objects.equals(dbSnapshotAttributesResult(), other.dbSnapshotAttributesResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbSnapshotAttributesResponse")
                .add("DBSnapshotAttributesResult", dbSnapshotAttributesResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSnapshotAttributesResult":
            return Optional.ofNullable(clazz.cast(dbSnapshotAttributesResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSnapshotAttributesResponse, T> g) {
        return obj -> g.apply((DescribeDbSnapshotAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbSnapshotAttributesResponse> {
        /**
         * Sets the value of the DBSnapshotAttributesResult property for this object.
         *
         * @param dbSnapshotAttributesResult
         *        The new value for the DBSnapshotAttributesResult property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotAttributesResult(DBSnapshotAttributesResult dbSnapshotAttributesResult);

        /**
         * Sets the value of the DBSnapshotAttributesResult property for this object.
         *
         * This is a convenience that creates an instance of the {@link DBSnapshotAttributesResult.Builder} avoiding the
         * need to create one manually via {@link DBSnapshotAttributesResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBSnapshotAttributesResult.Builder#build()} is called immediately
         * and its result is passed to {@link #dbSnapshotAttributesResult(DBSnapshotAttributesResult)}.
         * 
         * @param dbSnapshotAttributesResult
         *        a consumer that will call methods on {@link DBSnapshotAttributesResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSnapshotAttributesResult(DBSnapshotAttributesResult)
         */
        default Builder dbSnapshotAttributesResult(Consumer<DBSnapshotAttributesResult.Builder> dbSnapshotAttributesResult) {
            return dbSnapshotAttributesResult(DBSnapshotAttributesResult.builder().applyMutation(dbSnapshotAttributesResult)
                    .build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBSnapshotAttributesResult dbSnapshotAttributesResult;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSnapshotAttributesResponse model) {
            super(model);
            dbSnapshotAttributesResult(model.dbSnapshotAttributesResult);
        }

        public final DBSnapshotAttributesResult.Builder getDbSnapshotAttributesResult() {
            return dbSnapshotAttributesResult != null ? dbSnapshotAttributesResult.toBuilder() : null;
        }

        @Override
        public final Builder dbSnapshotAttributesResult(DBSnapshotAttributesResult dbSnapshotAttributesResult) {
            this.dbSnapshotAttributesResult = dbSnapshotAttributesResult;
            return this;
        }

        public final void setDbSnapshotAttributesResult(DBSnapshotAttributesResult.BuilderImpl dbSnapshotAttributesResult) {
            this.dbSnapshotAttributesResult = dbSnapshotAttributesResult != null ? dbSnapshotAttributesResult.build() : null;
        }

        @Override
        public DescribeDbSnapshotAttributesResponse build() {
            return new DescribeDbSnapshotAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
