/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbSnapshotAttributeRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbSnapshotAttributeRequest.Builder, ModifyDbSnapshotAttributeRequest> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSnapshotIdentifier").getter(getter(ModifyDbSnapshotAttributeRequest::dbSnapshotIdentifier))
            .setter(setter(Builder::dbSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build())
            .build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(ModifyDbSnapshotAttributeRequest::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<List<String>> VALUES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValuesToAdd")
            .getter(getter(ModifyDbSnapshotAttributeRequest::valuesToAdd))
            .setter(setter(Builder::valuesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AttributeValue")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AttributeValue").build()).build()).build()).build();

    private static final SdkField<List<String>> VALUES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValuesToRemove")
            .getter(getter(ModifyDbSnapshotAttributeRequest::valuesToRemove))
            .setter(setter(Builder::valuesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AttributeValue")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AttributeValue").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD,
            ATTRIBUTE_NAME_FIELD, VALUES_TO_ADD_FIELD, VALUES_TO_REMOVE_FIELD));

    private final String dbSnapshotIdentifier;

    private final String attributeName;

    private final List<String> valuesToAdd;

    private final List<String> valuesToRemove;

    private ModifyDbSnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.attributeName = builder.attributeName;
        this.valuesToAdd = builder.valuesToAdd;
        this.valuesToRemove = builder.valuesToRemove;
    }

    /**
     * <p>
     * The identifier for the DB snapshot to modify the attributes for.
     * </p>
     * 
     * @return The identifier for the DB snapshot to modify the attributes for.
     */
    public final String dbSnapshotIdentifier() {
        return dbSnapshotIdentifier;
    }

    /**
     * <p>
     * The name of the DB snapshot attribute to modify.
     * </p>
     * <p>
     * To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot, set this
     * value to <code>restore</code>.
     * </p>
     * <note>
     * <p>
     * To view the list of attributes available to modify, use the <a>DescribeDBSnapshotAttributes</a> API action.
     * </p>
     * </note>
     * 
     * @return The name of the DB snapshot attribute to modify.</p>
     *         <p>
     *         To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot,
     *         set this value to <code>restore</code>.
     *         </p>
     *         <note>
     *         <p>
     *         To view the list of attributes available to modify, use the <a>DescribeDBSnapshotAttributes</a> API
     *         action.
     *         </p>
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * Returns true if the ValuesToAdd property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValuesToAdd() {
        return valuesToAdd != null && !(valuesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.
     * </p>
     * <p>
     * To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include
     * one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB snapshot restorable by any
     * Amazon Web Services account. Do not add the <code>all</code> value for any manual DB snapshots that contain
     * private information that you don't want available to all Amazon Web Services accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValuesToAdd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
     *         <p>
     *         To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to
     *         include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB snapshot
     *         restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB
     *         snapshots that contain private information that you don't want available to all Amazon Web Services
     *         accounts.
     */
    public final List<String> valuesToAdd() {
        return valuesToAdd;
    }

    /**
     * Returns true if the ValuesToRemove property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValuesToRemove() {
        return valuesToRemove != null && !(valuesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.
     * </p>
     * <p>
     * To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this
     * list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove authorization
     * for any Amazon Web Services account to copy or restore the DB snapshot. If you specify <code>all</code>, an
     * Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still
     * copy or restore the manual DB snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValuesToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>
     *         .</p>
     *         <p>
     *         To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set
     *         this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove
     *         authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify
     *         <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the
     *         <code>restore</code> attribute can still copy or restore the manual DB snapshot.
     */
    public final List<String> valuesToRemove() {
        return valuesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasValuesToAdd() ? valuesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValuesToRemove() ? valuesToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDbSnapshotAttributeRequest other = (ModifyDbSnapshotAttributeRequest) obj;
        return Objects.equals(dbSnapshotIdentifier(), other.dbSnapshotIdentifier())
                && Objects.equals(attributeName(), other.attributeName()) && hasValuesToAdd() == other.hasValuesToAdd()
                && Objects.equals(valuesToAdd(), other.valuesToAdd()) && hasValuesToRemove() == other.hasValuesToRemove()
                && Objects.equals(valuesToRemove(), other.valuesToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbSnapshotAttributeRequest").add("DBSnapshotIdentifier", dbSnapshotIdentifier())
                .add("AttributeName", attributeName()).add("ValuesToAdd", hasValuesToAdd() ? valuesToAdd() : null)
                .add("ValuesToRemove", hasValuesToRemove() ? valuesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbSnapshotIdentifier()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "ValuesToAdd":
            return Optional.ofNullable(clazz.cast(valuesToAdd()));
        case "ValuesToRemove":
            return Optional.ofNullable(clazz.cast(valuesToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbSnapshotAttributeRequest, T> g) {
        return obj -> g.apply((ModifyDbSnapshotAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbSnapshotAttributeRequest> {
        /**
         * <p>
         * The identifier for the DB snapshot to modify the attributes for.
         * </p>
         * 
         * @param dbSnapshotIdentifier
         *        The identifier for the DB snapshot to modify the attributes for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotIdentifier(String dbSnapshotIdentifier);

        /**
         * <p>
         * The name of the DB snapshot attribute to modify.
         * </p>
         * <p>
         * To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot, set
         * this value to <code>restore</code>.
         * </p>
         * <note>
         * <p>
         * To view the list of attributes available to modify, use the <a>DescribeDBSnapshotAttributes</a> API action.
         * </p>
         * </note>
         * 
         * @param attributeName
         *        The name of the DB snapshot attribute to modify.</p>
         *        <p>
         *        To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB
         *        snapshot, set this value to <code>restore</code>.
         *        </p>
         *        <note>
         *        <p>
         *        To view the list of attributes available to modify, use the <a>DescribeDBSnapshotAttributes</a> API
         *        action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.
         * </p>
         * <p>
         * To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to
         * include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB snapshot
         * restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB
         * snapshots that contain private information that you don't want available to all Amazon Web Services accounts.
         * </p>
         * 
         * @param valuesToAdd
         *        A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
         *        <p>
         *        To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to
         *        include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB
         *        snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any
         *        manual DB snapshots that contain private information that you don't want available to all Amazon Web
         *        Services accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToAdd(Collection<String> valuesToAdd);

        /**
         * <p>
         * A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.
         * </p>
         * <p>
         * To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to
         * include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB snapshot
         * restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB
         * snapshots that contain private information that you don't want available to all Amazon Web Services accounts.
         * </p>
         * 
         * @param valuesToAdd
         *        A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
         *        <p>
         *        To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to
         *        include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB
         *        snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any
         *        manual DB snapshots that contain private information that you don't want available to all Amazon Web
         *        Services accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToAdd(String... valuesToAdd);

        /**
         * <p>
         * A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.
         * </p>
         * <p>
         * To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this
         * list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove
         * authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify
         * <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the
         * <code>restore</code> attribute can still copy or restore the manual DB snapshot.
         * </p>
         * 
         * @param valuesToRemove
         *        A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>
         *        .</p>
         *        <p>
         *        To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot,
         *        set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to
         *        remove authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you
         *        specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the
         *        <code>restore</code> attribute can still copy or restore the manual DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToRemove(Collection<String> valuesToRemove);

        /**
         * <p>
         * A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.
         * </p>
         * <p>
         * To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this
         * list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove
         * authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify
         * <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the
         * <code>restore</code> attribute can still copy or restore the manual DB snapshot.
         * </p>
         * 
         * @param valuesToRemove
         *        A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>
         *        .</p>
         *        <p>
         *        To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot,
         *        set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to
         *        remove authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you
         *        specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the
         *        <code>restore</code> attribute can still copy or restore the manual DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToRemove(String... valuesToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbSnapshotIdentifier;

        private String attributeName;

        private List<String> valuesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> valuesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbSnapshotAttributeRequest model) {
            super(model);
            dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            attributeName(model.attributeName);
            valuesToAdd(model.valuesToAdd);
            valuesToRemove(model.valuesToRemove);
        }

        public final String getDbSnapshotIdentifier() {
            return dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getValuesToAdd() {
            if (valuesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return valuesToAdd;
        }

        @Override
        public final Builder valuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToAdd(String... valuesToAdd) {
            valuesToAdd(Arrays.asList(valuesToAdd));
            return this;
        }

        public final void setValuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
        }

        public final Collection<String> getValuesToRemove() {
            if (valuesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return valuesToRemove;
        }

        @Override
        public final Builder valuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToRemove(String... valuesToRemove) {
            valuesToRemove(Arrays.asList(valuesToRemove));
            return this;
        }

        public final void setValuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbSnapshotAttributeRequest build() {
            return new ModifyDbSnapshotAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
