/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the available processor feature information for the DB instance class of a DB instance.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor"
 * >Configuring the Processor of the DB Instance Class</a> in the <i>Amazon RDS User Guide. </i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailableProcessorFeature implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailableProcessorFeature.Builder, AvailableProcessorFeature> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AvailableProcessorFeature::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(AvailableProcessorFeature::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowedValues").getter(getter(AvailableProcessorFeature::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DEFAULT_VALUE_FIELD, ALLOWED_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String defaultValue;

    private final String allowedValues;

    private AvailableProcessorFeature(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultValue = builder.defaultValue;
        this.allowedValues = builder.allowedValues;
    }

    /**
     * <p>
     * The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.
     * </p>
     * 
     * @return The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>
     *         .
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The default value for the processor feature of the DB instance class.
     * </p>
     * 
     * @return The default value for the processor feature of the DB instance class.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The allowed values for the processor feature of the DB instance class.
     * </p>
     * 
     * @return The allowed values for the processor feature of the DB instance class.
     */
    public final String allowedValues() {
        return allowedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableProcessorFeature)) {
            return false;
        }
        AvailableProcessorFeature other = (AvailableProcessorFeature) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(allowedValues(), other.allowedValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailableProcessorFeature").add("Name", name()).add("DefaultValue", defaultValue())
                .add("AllowedValues", allowedValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailableProcessorFeature, T> g) {
        return obj -> g.apply((AvailableProcessorFeature) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailableProcessorFeature> {
        /**
         * <p>
         * The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.
         * </p>
         * 
         * @param name
         *        The name of the processor feature. Valid names are <code>coreCount</code> and
         *        <code>threadsPerCore</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The default value for the processor feature of the DB instance class.
         * </p>
         * 
         * @param defaultValue
         *        The default value for the processor feature of the DB instance class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The allowed values for the processor feature of the DB instance class.
         * </p>
         * 
         * @param allowedValues
         *        The allowed values for the processor feature of the DB instance class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String allowedValues);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String defaultValue;

        private String allowedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableProcessorFeature model) {
            name(model.name);
            defaultValue(model.defaultValue);
            allowedValues(model.allowedValues);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Transient
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getAllowedValues() {
            return allowedValues;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        @Override
        @Transient
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        @Override
        public AvailableProcessorFeature build() {
            return new AvailableProcessorFeature(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
