/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomAvailabilityZoneRequest extends RdsRequest implements
        ToCopyableBuilder<CreateCustomAvailabilityZoneRequest.Builder, CreateCustomAvailabilityZoneRequest> {
    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomAvailabilityZoneName")
            .getter(getter(CreateCustomAvailabilityZoneRequest::customAvailabilityZoneName))
            .setter(setter(Builder::customAvailabilityZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneName").build())
            .build();

    private static final SdkField<String> EXISTING_VPN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExistingVpnId").getter(getter(CreateCustomAvailabilityZoneRequest::existingVpnId))
            .setter(setter(Builder::existingVpnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingVpnId").build()).build();

    private static final SdkField<String> NEW_VPN_TUNNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewVpnTunnelName").getter(getter(CreateCustomAvailabilityZoneRequest::newVpnTunnelName))
            .setter(setter(Builder::newVpnTunnelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewVpnTunnelName").build()).build();

    private static final SdkField<String> VPN_TUNNEL_ORIGINATOR_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnTunnelOriginatorIP").getter(getter(CreateCustomAvailabilityZoneRequest::vpnTunnelOriginatorIP))
            .setter(setter(Builder::vpnTunnelOriginatorIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOriginatorIP").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_AVAILABILITY_ZONE_NAME_FIELD, EXISTING_VPN_ID_FIELD, NEW_VPN_TUNNEL_NAME_FIELD,
                    VPN_TUNNEL_ORIGINATOR_IP_FIELD));

    private final String customAvailabilityZoneName;

    private final String existingVpnId;

    private final String newVpnTunnelName;

    private final String vpnTunnelOriginatorIP;

    private CreateCustomAvailabilityZoneRequest(BuilderImpl builder) {
        super(builder);
        this.customAvailabilityZoneName = builder.customAvailabilityZoneName;
        this.existingVpnId = builder.existingVpnId;
        this.newVpnTunnelName = builder.newVpnTunnelName;
        this.vpnTunnelOriginatorIP = builder.vpnTunnelOriginatorIP;
    }

    /**
     * <p>
     * The name of the custom Availability Zone (AZ).
     * </p>
     * 
     * @return The name of the custom Availability Zone (AZ).
     */
    public final String customAvailabilityZoneName() {
        return customAvailabilityZoneName;
    }

    /**
     * <p>
     * The ID of an existing virtual private network (VPN) between the Amazon RDS website and the VMware vSphere
     * cluster.
     * </p>
     * 
     * @return The ID of an existing virtual private network (VPN) between the Amazon RDS website and the VMware vSphere
     *         cluster.
     */
    public final String existingVpnId() {
        return existingVpnId;
    }

    /**
     * <p>
     * The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.
     * </p>
     * <p>
     * Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
     * </p>
     * 
     * @return The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.</p>
     *         <p>
     *         Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
     */
    public final String newVpnTunnelName() {
        return newVpnTunnelName;
    }

    /**
     * <p>
     * The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.
     * </p>
     * <p>
     * Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
     * </p>
     * 
     * @return The IP address of network traffic from your on-premises data center. A custom AZ receives the network
     *         traffic.</p>
     *         <p>
     *         Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
     */
    public final String vpnTunnelOriginatorIP() {
        return vpnTunnelOriginatorIP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(existingVpnId());
        hashCode = 31 * hashCode + Objects.hashCode(newVpnTunnelName());
        hashCode = 31 * hashCode + Objects.hashCode(vpnTunnelOriginatorIP());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomAvailabilityZoneRequest)) {
            return false;
        }
        CreateCustomAvailabilityZoneRequest other = (CreateCustomAvailabilityZoneRequest) obj;
        return Objects.equals(customAvailabilityZoneName(), other.customAvailabilityZoneName())
                && Objects.equals(existingVpnId(), other.existingVpnId())
                && Objects.equals(newVpnTunnelName(), other.newVpnTunnelName())
                && Objects.equals(vpnTunnelOriginatorIP(), other.vpnTunnelOriginatorIP());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomAvailabilityZoneRequest")
                .add("CustomAvailabilityZoneName", customAvailabilityZoneName()).add("ExistingVpnId", existingVpnId())
                .add("NewVpnTunnelName", newVpnTunnelName()).add("VpnTunnelOriginatorIP", vpnTunnelOriginatorIP()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAvailabilityZoneName":
            return Optional.ofNullable(clazz.cast(customAvailabilityZoneName()));
        case "ExistingVpnId":
            return Optional.ofNullable(clazz.cast(existingVpnId()));
        case "NewVpnTunnelName":
            return Optional.ofNullable(clazz.cast(newVpnTunnelName()));
        case "VpnTunnelOriginatorIP":
            return Optional.ofNullable(clazz.cast(vpnTunnelOriginatorIP()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomAvailabilityZoneRequest, T> g) {
        return obj -> g.apply((CreateCustomAvailabilityZoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomAvailabilityZoneRequest> {
        /**
         * <p>
         * The name of the custom Availability Zone (AZ).
         * </p>
         * 
         * @param customAvailabilityZoneName
         *        The name of the custom Availability Zone (AZ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZoneName(String customAvailabilityZoneName);

        /**
         * <p>
         * The ID of an existing virtual private network (VPN) between the Amazon RDS website and the VMware vSphere
         * cluster.
         * </p>
         * 
         * @param existingVpnId
         *        The ID of an existing virtual private network (VPN) between the Amazon RDS website and the VMware
         *        vSphere cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingVpnId(String existingVpnId);

        /**
         * <p>
         * The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.
         * </p>
         * <p>
         * Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
         * </p>
         * 
         * @param newVpnTunnelName
         *        The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.</p>
         *        <p>
         *        Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newVpnTunnelName(String newVpnTunnelName);

        /**
         * <p>
         * The IP address of network traffic from your on-premises data center. A custom AZ receives the network
         * traffic.
         * </p>
         * <p>
         * Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
         * </p>
         * 
         * @param vpnTunnelOriginatorIP
         *        The IP address of network traffic from your on-premises data center. A custom AZ receives the network
         *        traffic.</p>
         *        <p>
         *        Specify this parameter only if <code>ExistingVpnId</code> isn't specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnTunnelOriginatorIP(String vpnTunnelOriginatorIP);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String customAvailabilityZoneName;

        private String existingVpnId;

        private String newVpnTunnelName;

        private String vpnTunnelOriginatorIP;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomAvailabilityZoneRequest model) {
            super(model);
            customAvailabilityZoneName(model.customAvailabilityZoneName);
            existingVpnId(model.existingVpnId);
            newVpnTunnelName(model.newVpnTunnelName);
            vpnTunnelOriginatorIP(model.vpnTunnelOriginatorIP);
        }

        public final String getCustomAvailabilityZoneName() {
            return customAvailabilityZoneName;
        }

        public final void setCustomAvailabilityZoneName(String customAvailabilityZoneName) {
            this.customAvailabilityZoneName = customAvailabilityZoneName;
        }

        @Override
        @Transient
        public final Builder customAvailabilityZoneName(String customAvailabilityZoneName) {
            this.customAvailabilityZoneName = customAvailabilityZoneName;
            return this;
        }

        public final String getExistingVpnId() {
            return existingVpnId;
        }

        public final void setExistingVpnId(String existingVpnId) {
            this.existingVpnId = existingVpnId;
        }

        @Override
        @Transient
        public final Builder existingVpnId(String existingVpnId) {
            this.existingVpnId = existingVpnId;
            return this;
        }

        public final String getNewVpnTunnelName() {
            return newVpnTunnelName;
        }

        public final void setNewVpnTunnelName(String newVpnTunnelName) {
            this.newVpnTunnelName = newVpnTunnelName;
        }

        @Override
        @Transient
        public final Builder newVpnTunnelName(String newVpnTunnelName) {
            this.newVpnTunnelName = newVpnTunnelName;
            return this;
        }

        public final String getVpnTunnelOriginatorIP() {
            return vpnTunnelOriginatorIP;
        }

        public final void setVpnTunnelOriginatorIP(String vpnTunnelOriginatorIP) {
            this.vpnTunnelOriginatorIP = vpnTunnelOriginatorIP;
        }

        @Override
        @Transient
        public final Builder vpnTunnelOriginatorIP(String vpnTunnelOriginatorIP) {
            this.vpnTunnelOriginatorIP = vpnTunnelOriginatorIP;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomAvailabilityZoneRequest build() {
            return new CreateCustomAvailabilityZoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
