/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomAvailabilityZoneResponse extends RdsResponse implements
        ToCopyableBuilder<CreateCustomAvailabilityZoneResponse.Builder, CreateCustomAvailabilityZoneResponse> {
    private static final SdkField<CustomAvailabilityZone> CUSTOM_AVAILABILITY_ZONE_FIELD = SdkField
            .<CustomAvailabilityZone> builder(MarshallingType.SDK_POJO).memberName("CustomAvailabilityZone")
            .getter(getter(CreateCustomAvailabilityZoneResponse::customAvailabilityZone))
            .setter(setter(Builder::customAvailabilityZone)).constructor(CustomAvailabilityZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZone").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_AVAILABILITY_ZONE_FIELD));

    private final CustomAvailabilityZone customAvailabilityZone;

    private CreateCustomAvailabilityZoneResponse(BuilderImpl builder) {
        super(builder);
        this.customAvailabilityZone = builder.customAvailabilityZone;
    }

    /**
     * Returns the value of the CustomAvailabilityZone property for this object.
     * 
     * @return The value of the CustomAvailabilityZone property for this object.
     */
    public final CustomAvailabilityZone customAvailabilityZone() {
        return customAvailabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomAvailabilityZoneResponse)) {
            return false;
        }
        CreateCustomAvailabilityZoneResponse other = (CreateCustomAvailabilityZoneResponse) obj;
        return Objects.equals(customAvailabilityZone(), other.customAvailabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomAvailabilityZoneResponse").add("CustomAvailabilityZone", customAvailabilityZone())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAvailabilityZone":
            return Optional.ofNullable(clazz.cast(customAvailabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomAvailabilityZoneResponse, T> g) {
        return obj -> g.apply((CreateCustomAvailabilityZoneResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomAvailabilityZoneResponse> {
        /**
         * Sets the value of the CustomAvailabilityZone property for this object.
         *
         * @param customAvailabilityZone
         *        The new value for the CustomAvailabilityZone property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZone(CustomAvailabilityZone customAvailabilityZone);

        /**
         * Sets the value of the CustomAvailabilityZone property for this object.
         *
         * This is a convenience that creates an instance of the {@link CustomAvailabilityZone.Builder} avoiding the
         * need to create one manually via {@link CustomAvailabilityZone#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomAvailabilityZone.Builder#build()} is called immediately and
         * its result is passed to {@link #customAvailabilityZone(CustomAvailabilityZone)}.
         * 
         * @param customAvailabilityZone
         *        a consumer that will call methods on {@link CustomAvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAvailabilityZone(CustomAvailabilityZone)
         */
        default Builder customAvailabilityZone(Consumer<CustomAvailabilityZone.Builder> customAvailabilityZone) {
            return customAvailabilityZone(CustomAvailabilityZone.builder().applyMutation(customAvailabilityZone).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private CustomAvailabilityZone customAvailabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomAvailabilityZoneResponse model) {
            super(model);
            customAvailabilityZone(model.customAvailabilityZone);
        }

        public final CustomAvailabilityZone.Builder getCustomAvailabilityZone() {
            return customAvailabilityZone != null ? customAvailabilityZone.toBuilder() : null;
        }

        public final void setCustomAvailabilityZone(CustomAvailabilityZone.BuilderImpl customAvailabilityZone) {
            this.customAvailabilityZone = customAvailabilityZone != null ? customAvailabilityZone.build() : null;
        }

        @Override
        @Transient
        public final Builder customAvailabilityZone(CustomAvailabilityZone customAvailabilityZone) {
            this.customAvailabilityZone = customAvailabilityZone;
            return this;
        }

        @Override
        public CreateCustomAvailabilityZoneResponse build() {
            return new CreateCustomAvailabilityZoneResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
