/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.
 * </p>
 * <p>
 * For more information about RDS on VMware, see the <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User
 * Guide.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomAvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomAvailabilityZone.Builder, CustomAvailabilityZone> {
    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomAvailabilityZoneId").getter(getter(CustomAvailabilityZone::customAvailabilityZoneId))
            .setter(setter(Builder::customAvailabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneId").build())
            .build();

    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomAvailabilityZoneName")
            .getter(getter(CustomAvailabilityZone::customAvailabilityZoneName))
            .setter(setter(Builder::customAvailabilityZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneName").build())
            .build();

    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomAvailabilityZoneStatus")
            .getter(getter(CustomAvailabilityZone::customAvailabilityZoneStatus))
            .setter(setter(Builder::customAvailabilityZoneStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneStatus")
                    .build()).build();

    private static final SdkField<VpnDetails> VPN_DETAILS_FIELD = SdkField.<VpnDetails> builder(MarshallingType.SDK_POJO)
            .memberName("VpnDetails").getter(getter(CustomAvailabilityZone::vpnDetails)).setter(setter(Builder::vpnDetails))
            .constructor(VpnDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_AVAILABILITY_ZONE_ID_FIELD, CUSTOM_AVAILABILITY_ZONE_NAME_FIELD, CUSTOM_AVAILABILITY_ZONE_STATUS_FIELD,
            VPN_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customAvailabilityZoneId;

    private final String customAvailabilityZoneName;

    private final String customAvailabilityZoneStatus;

    private final VpnDetails vpnDetails;

    private CustomAvailabilityZone(BuilderImpl builder) {
        this.customAvailabilityZoneId = builder.customAvailabilityZoneId;
        this.customAvailabilityZoneName = builder.customAvailabilityZoneName;
        this.customAvailabilityZoneStatus = builder.customAvailabilityZoneStatus;
        this.vpnDetails = builder.vpnDetails;
    }

    /**
     * <p>
     * The identifier of the custom AZ.
     * </p>
     * <p>
     * Amazon RDS generates a unique identifier when a custom AZ is created.
     * </p>
     * 
     * @return The identifier of the custom AZ.</p>
     *         <p>
     *         Amazon RDS generates a unique identifier when a custom AZ is created.
     */
    public final String customAvailabilityZoneId() {
        return customAvailabilityZoneId;
    }

    /**
     * <p>
     * The name of the custom AZ.
     * </p>
     * 
     * @return The name of the custom AZ.
     */
    public final String customAvailabilityZoneName() {
        return customAvailabilityZoneName;
    }

    /**
     * <p>
     * The status of the custom AZ.
     * </p>
     * 
     * @return The status of the custom AZ.
     */
    public final String customAvailabilityZoneStatus() {
        return customAvailabilityZoneStatus;
    }

    /**
     * <p>
     * Information about the virtual private network (VPN) between the VMware vSphere cluster and the Amazon Web
     * Services website.
     * </p>
     * 
     * @return Information about the virtual private network (VPN) between the VMware vSphere cluster and the Amazon Web
     *         Services website.
     */
    public final VpnDetails vpnDetails() {
        return vpnDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZoneStatus());
        hashCode = 31 * hashCode + Objects.hashCode(vpnDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAvailabilityZone)) {
            return false;
        }
        CustomAvailabilityZone other = (CustomAvailabilityZone) obj;
        return Objects.equals(customAvailabilityZoneId(), other.customAvailabilityZoneId())
                && Objects.equals(customAvailabilityZoneName(), other.customAvailabilityZoneName())
                && Objects.equals(customAvailabilityZoneStatus(), other.customAvailabilityZoneStatus())
                && Objects.equals(vpnDetails(), other.vpnDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomAvailabilityZone").add("CustomAvailabilityZoneId", customAvailabilityZoneId())
                .add("CustomAvailabilityZoneName", customAvailabilityZoneName())
                .add("CustomAvailabilityZoneStatus", customAvailabilityZoneStatus()).add("VpnDetails", vpnDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(customAvailabilityZoneId()));
        case "CustomAvailabilityZoneName":
            return Optional.ofNullable(clazz.cast(customAvailabilityZoneName()));
        case "CustomAvailabilityZoneStatus":
            return Optional.ofNullable(clazz.cast(customAvailabilityZoneStatus()));
        case "VpnDetails":
            return Optional.ofNullable(clazz.cast(vpnDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomAvailabilityZone, T> g) {
        return obj -> g.apply((CustomAvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomAvailabilityZone> {
        /**
         * <p>
         * The identifier of the custom AZ.
         * </p>
         * <p>
         * Amazon RDS generates a unique identifier when a custom AZ is created.
         * </p>
         * 
         * @param customAvailabilityZoneId
         *        The identifier of the custom AZ.</p>
         *        <p>
         *        Amazon RDS generates a unique identifier when a custom AZ is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZoneId(String customAvailabilityZoneId);

        /**
         * <p>
         * The name of the custom AZ.
         * </p>
         * 
         * @param customAvailabilityZoneName
         *        The name of the custom AZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZoneName(String customAvailabilityZoneName);

        /**
         * <p>
         * The status of the custom AZ.
         * </p>
         * 
         * @param customAvailabilityZoneStatus
         *        The status of the custom AZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZoneStatus(String customAvailabilityZoneStatus);

        /**
         * <p>
         * Information about the virtual private network (VPN) between the VMware vSphere cluster and the Amazon Web
         * Services website.
         * </p>
         * 
         * @param vpnDetails
         *        Information about the virtual private network (VPN) between the VMware vSphere cluster and the Amazon
         *        Web Services website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnDetails(VpnDetails vpnDetails);

        /**
         * <p>
         * Information about the virtual private network (VPN) between the VMware vSphere cluster and the Amazon Web
         * Services website.
         * </p>
         * This is a convenience that creates an instance of the {@link VpnDetails.Builder} avoiding the need to create
         * one manually via {@link VpnDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpnDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #vpnDetails(VpnDetails)}.
         * 
         * @param vpnDetails
         *        a consumer that will call methods on {@link VpnDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnDetails(VpnDetails)
         */
        default Builder vpnDetails(Consumer<VpnDetails.Builder> vpnDetails) {
            return vpnDetails(VpnDetails.builder().applyMutation(vpnDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String customAvailabilityZoneId;

        private String customAvailabilityZoneName;

        private String customAvailabilityZoneStatus;

        private VpnDetails vpnDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAvailabilityZone model) {
            customAvailabilityZoneId(model.customAvailabilityZoneId);
            customAvailabilityZoneName(model.customAvailabilityZoneName);
            customAvailabilityZoneStatus(model.customAvailabilityZoneStatus);
            vpnDetails(model.vpnDetails);
        }

        public final String getCustomAvailabilityZoneId() {
            return customAvailabilityZoneId;
        }

        public final void setCustomAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
        }

        @Override
        @Transient
        public final Builder customAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
            return this;
        }

        public final String getCustomAvailabilityZoneName() {
            return customAvailabilityZoneName;
        }

        public final void setCustomAvailabilityZoneName(String customAvailabilityZoneName) {
            this.customAvailabilityZoneName = customAvailabilityZoneName;
        }

        @Override
        @Transient
        public final Builder customAvailabilityZoneName(String customAvailabilityZoneName) {
            this.customAvailabilityZoneName = customAvailabilityZoneName;
            return this;
        }

        public final String getCustomAvailabilityZoneStatus() {
            return customAvailabilityZoneStatus;
        }

        public final void setCustomAvailabilityZoneStatus(String customAvailabilityZoneStatus) {
            this.customAvailabilityZoneStatus = customAvailabilityZoneStatus;
        }

        @Override
        @Transient
        public final Builder customAvailabilityZoneStatus(String customAvailabilityZoneStatus) {
            this.customAvailabilityZoneStatus = customAvailabilityZoneStatus;
            return this;
        }

        public final VpnDetails.Builder getVpnDetails() {
            return vpnDetails != null ? vpnDetails.toBuilder() : null;
        }

        public final void setVpnDetails(VpnDetails.BuilderImpl vpnDetails) {
            this.vpnDetails = vpnDetails != null ? vpnDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder vpnDetails(VpnDetails vpnDetails) {
            this.vpnDetails = vpnDetails;
            return this;
        }

        @Override
        public CustomAvailabilityZone build() {
            return new CustomAvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
