/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbInstanceRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteDbInstanceRequest.Builder, DeleteDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DeleteDbInstanceRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SkipFinalSnapshot").getter(getter(DeleteDbInstanceRequest::skipFinalSnapshot))
            .setter(setter(Builder::skipFinalSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalSnapshot").build()).build();

    private static final SdkField<String> FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FinalDBSnapshotIdentifier").getter(getter(DeleteDbInstanceRequest::finalDBSnapshotIdentifier))
            .setter(setter(Builder::finalDBSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalDBSnapshotIdentifier").build())
            .build();

    private static final SdkField<Boolean> DELETE_AUTOMATED_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteAutomatedBackups").getter(getter(DeleteDbInstanceRequest::deleteAutomatedBackups))
            .setter(setter(Builder::deleteAutomatedBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAutomatedBackups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            SKIP_FINAL_SNAPSHOT_FIELD, FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD, DELETE_AUTOMATED_BACKUPS_FIELD));

    private final String dbInstanceIdentifier;

    private final Boolean skipFinalSnapshot;

    private final String finalDBSnapshotIdentifier;

    private final Boolean deleteAutomatedBackups;

    private DeleteDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
        this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
    }

    /**
     * <p>
     * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the name of an existing DB instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the name of an existing DB instance.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance. If you
     * enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates a DB
     * snapshot before the DB instance is deleted. By default, skip isn't enabled, and the DB snapshot is created.
     * </p>
     * <note>
     * <p>
     * If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.
     * </p>
     * </note>
     * <p>
     * When a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance only if you
     * enable this parameter.
     * </p>
     * <p>
     * If you delete a read replica or an RDS Custom instance, you must enable this setting.
     * </p>
     * <p>
     * This setting is required for RDS Custom.
     * </p>
     * 
     * @return A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance.
     *         If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS
     *         creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled, and the DB
     *         snapshot is created.</p> <note>
     *         <p>
     *         If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code>
     *         parameter.
     *         </p>
     *         </note>
     *         <p>
     *         When a DB instance is in a failure state and has a status of <code>failed</code>,
     *         <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance only
     *         if you enable this parameter.
     *         </p>
     *         <p>
     *         If you delete a read replica or an RDS Custom instance, you must enable this setting.
     *         </p>
     *         <p>
     *         This setting is required for RDS Custom.
     */
    public final Boolean skipFinalSnapshot() {
        return skipFinalSnapshot;
    }

    /**
     * <p>
     * The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
     * <code>SkipFinalSnapshot</code> parameter is disabled.
     * </p>
     * <note>
     * <p>
     * If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.
     * </p>
     * </note>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified when deleting a read replica.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
     *         <code>SkipFinalSnapshot</code> parameter is disabled. </p> <note>
     *         <p>
     *         If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.
     *         </p>
     *         </note>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified when deleting a read replica.
     *         </p>
     *         </li>
     */
    public final String finalDBSnapshotIdentifier() {
        return finalDBSnapshotIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This
     * parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is
     * deleted.
     * </p>
     * 
     * @return A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     *         This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB
     *         instance is deleted.
     */
    public final Boolean deleteAutomatedBackups() {
        return deleteAutomatedBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(finalDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAutomatedBackups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbInstanceRequest)) {
            return false;
        }
        DeleteDbInstanceRequest other = (DeleteDbInstanceRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(skipFinalSnapshot(), other.skipFinalSnapshot())
                && Objects.equals(finalDBSnapshotIdentifier(), other.finalDBSnapshotIdentifier())
                && Objects.equals(deleteAutomatedBackups(), other.deleteAutomatedBackups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDbInstanceRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("SkipFinalSnapshot", skipFinalSnapshot()).add("FinalDBSnapshotIdentifier", finalDBSnapshotIdentifier())
                .add("DeleteAutomatedBackups", deleteAutomatedBackups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "SkipFinalSnapshot":
            return Optional.ofNullable(clazz.cast(skipFinalSnapshot()));
        case "FinalDBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(finalDBSnapshotIdentifier()));
        case "DeleteAutomatedBackups":
            return Optional.ofNullable(clazz.cast(deleteAutomatedBackups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbInstanceRequest, T> g) {
        return obj -> g.apply((DeleteDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbInstanceRequest> {
        /**
         * <p>
         * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the name of an existing DB instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the name of an existing DB instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance. If
         * you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates
         * a DB snapshot before the DB instance is deleted. By default, skip isn't enabled, and the DB snapshot is
         * created.
         * </p>
         * <note>
         * <p>
         * If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.
         * </p>
         * </note>
         * <p>
         * When a DB instance is in a failure state and has a status of <code>failed</code>,
         * <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance only if
         * you enable this parameter.
         * </p>
         * <p>
         * If you delete a read replica or an RDS Custom instance, you must enable this setting.
         * </p>
         * <p>
         * This setting is required for RDS Custom.
         * </p>
         * 
         * @param skipFinalSnapshot
         *        A value that indicates whether to skip the creation of a final DB snapshot before deleting the
         *        instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this
         *        parameter, RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't
         *        enabled, and the DB snapshot is created.</p> <note>
         *        <p>
         *        If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code>
         *        parameter.
         *        </p>
         *        </note>
         *        <p>
         *        When a DB instance is in a failure state and has a status of <code>failed</code>,
         *        <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance
         *        only if you enable this parameter.
         *        </p>
         *        <p>
         *        If you delete a read replica or an RDS Custom instance, you must enable this setting.
         *        </p>
         *        <p>
         *        This setting is required for RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalSnapshot(Boolean skipFinalSnapshot);

        /**
         * <p>
         * The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
         * <code>SkipFinalSnapshot</code> parameter is disabled.
         * </p>
         * <note>
         * <p>
         * If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.
         * </p>
         * </note>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified when deleting a read replica.
         * </p>
         * </li>
         * </ul>
         * 
         * @param finalDBSnapshotIdentifier
         *        The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
         *        <code>SkipFinalSnapshot</code> parameter is disabled. </p> <note>
         *        <p>
         *        If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.
         *        </p>
         *        </note>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified when deleting a read replica.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier);

        /**
         * <p>
         * A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This
         * parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance
         * is deleted.
         * </p>
         * 
         * @param deleteAutomatedBackups
         *        A value that indicates whether to remove automated backups immediately after the DB instance is
         *        deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately
         *        after the DB instance is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private Boolean skipFinalSnapshot;

        private String finalDBSnapshotIdentifier;

        private Boolean deleteAutomatedBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbInstanceRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            skipFinalSnapshot(model.skipFinalSnapshot);
            finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
            deleteAutomatedBackups(model.deleteAutomatedBackups);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Boolean getSkipFinalSnapshot() {
            return skipFinalSnapshot;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        @Override
        @Transient
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return finalDBSnapshotIdentifier;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final Boolean getDeleteAutomatedBackups() {
            return deleteAutomatedBackups;
        }

        public final void setDeleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
        }

        @Override
        @Transient
        public final Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbInstanceRequest build() {
            return new DeleteDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
