/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbLogFilesRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeDbLogFilesRequest.Builder, DescribeDbLogFilesRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DescribeDbLogFilesRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> FILENAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilenameContains").getter(getter(DescribeDbLogFilesRequest::filenameContains))
            .setter(setter(Builder::filenameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilenameContains").build()).build();

    private static final SdkField<Long> FILE_LAST_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FileLastWritten").getter(getter(DescribeDbLogFilesRequest::fileLastWritten))
            .setter(setter(Builder::fileLastWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileLastWritten").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("FileSize")
            .getter(getter(DescribeDbLogFilesRequest::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSize").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeDbLogFilesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDbLogFilesRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbLogFilesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            FILENAME_CONTAINS_FIELD, FILE_LAST_WRITTEN_FIELD, FILE_SIZE_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String dbInstanceIdentifier;

    private final String filenameContains;

    private final Long fileLastWritten;

    private final Long fileSize;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private DescribeDbLogFilesRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.filenameContains = builder.filenameContains;
        this.fileLastWritten = builder.fileLastWritten;
        this.fileSize = builder.fileSize;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The customer-assigned name of the DB instance that contains the log files you want to list.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DBInstance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The customer-assigned name of the DB instance that contains the log files you want to list.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DBInstance.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Filters the available log files for log file names that contain the specified string.
     * </p>
     * 
     * @return Filters the available log files for log file names that contain the specified string.
     */
    public final String filenameContains() {
        return filenameContains;
    }

    /**
     * <p>
     * Filters the available log files for files written since the specified date, in POSIX timestamp format with
     * milliseconds.
     * </p>
     * 
     * @return Filters the available log files for files written since the specified date, in POSIX timestamp format
     *         with milliseconds.
     */
    public final Long fileLastWritten() {
        return fileLastWritten;
    }

    /**
     * <p>
     * Filters the available log files for files larger than the specified size.
     * </p>
     * 
     * @return Filters the available log files for files larger than the specified size.
     */
    public final Long fileSize() {
        return fileSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter isn't currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return This parameter isn't currently supported.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified MaxRecords
     * value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the
     *         remaining results.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The pagination token provided in the previous request. If this parameter is specified the response includes only
     * records beyond the marker, up to MaxRecords.
     * </p>
     * 
     * @return The pagination token provided in the previous request. If this parameter is specified the response
     *         includes only records beyond the marker, up to MaxRecords.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(filenameContains());
        hashCode = 31 * hashCode + Objects.hashCode(fileLastWritten());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbLogFilesRequest)) {
            return false;
        }
        DescribeDbLogFilesRequest other = (DescribeDbLogFilesRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(filenameContains(), other.filenameContains())
                && Objects.equals(fileLastWritten(), other.fileLastWritten()) && Objects.equals(fileSize(), other.fileSize())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbLogFilesRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("FilenameContains", filenameContains()).add("FileLastWritten", fileLastWritten())
                .add("FileSize", fileSize()).add("Filters", hasFilters() ? filters() : null).add("MaxRecords", maxRecords())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "FilenameContains":
            return Optional.ofNullable(clazz.cast(filenameContains()));
        case "FileLastWritten":
            return Optional.ofNullable(clazz.cast(fileLastWritten()));
        case "FileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbLogFilesRequest, T> g) {
        return obj -> g.apply((DescribeDbLogFilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbLogFilesRequest> {
        /**
         * <p>
         * The customer-assigned name of the DB instance that contains the log files you want to list.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DBInstance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The customer-assigned name of the DB instance that contains the log files you want to list.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DBInstance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Filters the available log files for log file names that contain the specified string.
         * </p>
         * 
         * @param filenameContains
         *        Filters the available log files for log file names that contain the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filenameContains(String filenameContains);

        /**
         * <p>
         * Filters the available log files for files written since the specified date, in POSIX timestamp format with
         * milliseconds.
         * </p>
         * 
         * @param fileLastWritten
         *        Filters the available log files for files written since the specified date, in POSIX timestamp format
         *        with milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileLastWritten(Long fileLastWritten);

        /**
         * <p>
         * Filters the available log files for files larger than the specified size.
         * </p>
         * 
         * @param fileSize
         *        Filters the available log files for files larger than the specified size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified MaxRecords
         * value, a pagination token called a marker is included in the response so you can retrieve the remaining
         * results.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        MaxRecords value, a pagination token called a marker is included in the response so you can retrieve
         *        the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The pagination token provided in the previous request. If this parameter is specified the response includes
         * only records beyond the marker, up to MaxRecords.
         * </p>
         * 
         * @param marker
         *        The pagination token provided in the previous request. If this parameter is specified the response
         *        includes only records beyond the marker, up to MaxRecords.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String filenameContains;

        private Long fileLastWritten;

        private Long fileSize;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbLogFilesRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            filenameContains(model.filenameContains);
            fileLastWritten(model.fileLastWritten);
            fileSize(model.fileSize);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getFilenameContains() {
            return filenameContains;
        }

        public final void setFilenameContains(String filenameContains) {
            this.filenameContains = filenameContains;
        }

        @Override
        @Transient
        public final Builder filenameContains(String filenameContains) {
            this.filenameContains = filenameContains;
            return this;
        }

        public final Long getFileLastWritten() {
            return fileLastWritten;
        }

        public final void setFileLastWritten(Long fileLastWritten) {
            this.fileLastWritten = fileLastWritten;
        }

        @Override
        @Transient
        public final Builder fileLastWritten(Long fileLastWritten) {
            this.fileLastWritten = fileLastWritten;
            return this;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        @Transient
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        @Transient
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbLogFilesRequest build() {
            return new DescribeDbLogFilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
