/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of option groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOptionGroupsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeOptionGroupsResponse.Builder, DescribeOptionGroupsResponse> {
    private static final SdkField<List<OptionGroup>> OPTION_GROUPS_LIST_FIELD = SdkField
            .<List<OptionGroup>> builder(MarshallingType.LIST)
            .memberName("OptionGroupsList")
            .getter(getter(DescribeOptionGroupsResponse::optionGroupsList))
            .setter(setter(Builder::optionGroupsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionGroup")
                            .memberFieldInfo(
                                    SdkField.<OptionGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionGroup").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeOptionGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUPS_LIST_FIELD,
            MARKER_FIELD));

    private final List<OptionGroup> optionGroupsList;

    private final String marker;

    private DescribeOptionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.optionGroupsList = builder.optionGroupsList;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionGroupsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionGroupsList() {
        return optionGroupsList != null && !(optionGroupsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of option groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionGroupsList} method.
     * </p>
     * 
     * @return List of option groups.
     */
    public final List<OptionGroup> optionGroupsList() {
        return optionGroupsList;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionGroupsList() ? optionGroupsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupsResponse)) {
            return false;
        }
        DescribeOptionGroupsResponse other = (DescribeOptionGroupsResponse) obj;
        return hasOptionGroupsList() == other.hasOptionGroupsList()
                && Objects.equals(optionGroupsList(), other.optionGroupsList()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOptionGroupsResponse")
                .add("OptionGroupsList", hasOptionGroupsList() ? optionGroupsList() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionGroupsList":
            return Optional.ofNullable(clazz.cast(optionGroupsList()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptionGroupsResponse, T> g) {
        return obj -> g.apply((DescribeOptionGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeOptionGroupsResponse> {
        /**
         * <p>
         * List of option groups.
         * </p>
         * 
         * @param optionGroupsList
         *        List of option groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupsList(Collection<OptionGroup> optionGroupsList);

        /**
         * <p>
         * List of option groups.
         * </p>
         * 
         * @param optionGroupsList
         *        List of option groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupsList(OptionGroup... optionGroupsList);

        /**
         * <p>
         * List of option groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OptionGroup>.Builder} avoiding the need to
         * create one manually via {@link List<OptionGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OptionGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #optionGroupsList(List<OptionGroup>)}.
         * 
         * @param optionGroupsList
         *        a consumer that will call methods on {@link List<OptionGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionGroupsList(List<OptionGroup>)
         */
        Builder optionGroupsList(Consumer<OptionGroup.Builder>... optionGroupsList);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<OptionGroup> optionGroupsList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupsResponse model) {
            super(model);
            optionGroupsList(model.optionGroupsList);
            marker(model.marker);
        }

        public final List<OptionGroup.Builder> getOptionGroupsList() {
            List<OptionGroup.Builder> result = OptionGroupsListCopier.copyToBuilder(this.optionGroupsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionGroupsList(Collection<OptionGroup.BuilderImpl> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copyFromBuilder(optionGroupsList);
        }

        @Override
        @Transient
        public final Builder optionGroupsList(Collection<OptionGroup> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copy(optionGroupsList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionGroupsList(OptionGroup... optionGroupsList) {
            optionGroupsList(Arrays.asList(optionGroupsList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionGroupsList(Consumer<OptionGroup.Builder>... optionGroupsList) {
            optionGroupsList(Stream.of(optionGroupsList).map(c -> OptionGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeOptionGroupsResponse build() {
            return new DescribeOptionGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
