/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCurrentDbClusterCapacityRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyCurrentDbClusterCapacityRequest.Builder, ModifyCurrentDbClusterCapacityRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(ModifyCurrentDbClusterCapacityRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Capacity").getter(getter(ModifyCurrentDbClusterCapacityRequest::capacity))
            .setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<Integer> SECONDS_BEFORE_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondsBeforeTimeout").getter(getter(ModifyCurrentDbClusterCapacityRequest::secondsBeforeTimeout))
            .setter(setter(Builder::secondsBeforeTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsBeforeTimeout").build())
            .build();

    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeoutAction").getter(getter(ModifyCurrentDbClusterCapacityRequest::timeoutAction))
            .setter(setter(Builder::timeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            CAPACITY_FIELD, SECONDS_BEFORE_TIMEOUT_FIELD, TIMEOUT_ACTION_FIELD));

    private final String dbClusterIdentifier;

    private final Integer capacity;

    private final Integer secondsBeforeTimeout;

    private final String timeoutAction;

    private ModifyCurrentDbClusterCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.capacity = builder.capacity;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
        this.timeoutAction = builder.timeoutAction;
    }

    /**
     * <p>
     * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DB cluster.
     *         </p>
     *         </li>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The DB cluster capacity.
     * </p>
     * <p>
     * When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
     * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>,
     * <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB cluster capacity.</p>
     *         <p>
     *         When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
     *         <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
     *         <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     *         </p>
     *         </li>
     */
    public final Integer capacity() {
        return capacity;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless scaling
     * before enforcing the timeout action. The default is 300.
     * </p>
     * <p>
     * Specify a value between 10 and 600 seconds.
     * </p>
     * 
     * @return The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless
     *         scaling before enforcing the timeout action. The default is 300.</p>
     *         <p>
     *         Specify a value between 10 and 600 seconds.
     */
    public final Integer secondsBeforeTimeout() {
        return secondsBeforeTimeout;
    }

    /**
     * <p>
     * The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
     * <code>RollbackCapacityChange</code>.
     * </p>
     * <p>
     * <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.
     * </p>
     * <p>
     * <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout
     * period.
     * </p>
     * 
     * @return The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
     *         <code>RollbackCapacityChange</code>.</p>
     *         <p>
     *         <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as
     *         possible.
     *         </p>
     *         <p>
     *         <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the
     *         timeout period.
     */
    public final String timeoutAction() {
        return timeoutAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(secondsBeforeTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCurrentDbClusterCapacityRequest)) {
            return false;
        }
        ModifyCurrentDbClusterCapacityRequest other = (ModifyCurrentDbClusterCapacityRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(capacity(), other.capacity())
                && Objects.equals(secondsBeforeTimeout(), other.secondsBeforeTimeout())
                && Objects.equals(timeoutAction(), other.timeoutAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCurrentDbClusterCapacityRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("Capacity", capacity()).add("SecondsBeforeTimeout", secondsBeforeTimeout())
                .add("TimeoutAction", timeoutAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "SecondsBeforeTimeout":
            return Optional.ofNullable(clazz.cast(secondsBeforeTimeout()));
        case "TimeoutAction":
            return Optional.ofNullable(clazz.cast(timeoutAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCurrentDbClusterCapacityRequest, T> g) {
        return obj -> g.apply((ModifyCurrentDbClusterCapacityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCurrentDbClusterCapacityRequest> {
        /**
         * <p>
         * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The DB cluster capacity.
         * </p>
         * <p>
         * When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacity
         *        The DB cluster capacity.</p>
         *        <p>
         *        When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
         *        <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and
         *        <code>256</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         *        <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);

        /**
         * <p>
         * The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless
         * scaling before enforcing the timeout action. The default is 300.
         * </p>
         * <p>
         * Specify a value between 10 and 600 seconds.
         * </p>
         * 
         * @param secondsBeforeTimeout
         *        The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform
         *        seamless scaling before enforcing the timeout action. The default is 300.</p>
         *        <p>
         *        Specify a value between 10 and 600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsBeforeTimeout(Integer secondsBeforeTimeout);

        /**
         * <p>
         * The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
         * <code>RollbackCapacityChange</code>.
         * </p>
         * <p>
         * <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as
         * possible.
         * </p>
         * <p>
         * <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout
         * period.
         * </p>
         * 
         * @param timeoutAction
         *        The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
         *        <code>RollbackCapacityChange</code>.</p>
         *        <p>
         *        <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon
         *        as possible.
         *        </p>
         *        <p>
         *        <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the
         *        timeout period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutAction(String timeoutAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private Integer capacity;

        private Integer secondsBeforeTimeout;

        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCurrentDbClusterCapacityRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            capacity(model.capacity);
            secondsBeforeTimeout(model.secondsBeforeTimeout);
            timeoutAction(model.timeoutAction);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Integer getCapacity() {
            return capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        @Transient
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final Integer getSecondsBeforeTimeout() {
            return secondsBeforeTimeout;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        @Override
        @Transient
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        public final String getTimeoutAction() {
            return timeoutAction;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        @Transient
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCurrentDbClusterCapacityRequest build() {
            return new ModifyCurrentDbClusterCapacityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
