/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyGlobalClusterRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyGlobalClusterRequest.Builder, ModifyGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(ModifyGlobalClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> NEW_GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewGlobalClusterIdentifier")
            .getter(getter(ModifyGlobalClusterRequest::newGlobalClusterIdentifier))
            .setter(setter(Builder::newGlobalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGlobalClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(ModifyGlobalClusterRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyGlobalClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AllowMajorVersionUpgrade")
            .getter(getter(ModifyGlobalClusterRequest::allowMajorVersionUpgrade))
            .setter(setter(Builder::allowMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, NEW_GLOBAL_CLUSTER_IDENTIFIER_FIELD, DELETION_PROTECTION_FIELD,
            ENGINE_VERSION_FIELD, ALLOW_MAJOR_VERSION_UPGRADE_FIELD));

    private final String globalClusterIdentifier;

    private final String newGlobalClusterIdentifier;

    private final Boolean deletionProtection;

    private final String engineVersion;

    private final Boolean allowMajorVersionUpgrade;

    private ModifyGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.newGlobalClusterIdentifier = builder.newGlobalClusterIdentifier;
        this.deletionProtection = builder.deletionProtection;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
    }

    /**
     * <p>
     * The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing global database cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing global database cluster.
     *         </p>
     *         </li>
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * The new cluster identifier for the global database cluster when modifying a global database cluster. This value
     * is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster2</code>
     * </p>
     * 
     * @return The new cluster identifier for the global database cluster when modifying a global database cluster. This
     *         value is stored as a lowercase string. </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster2</code>
     */
    public final String newGlobalClusterIdentifier() {
        return newGlobalClusterIdentifier;
    }

    /**
     * <p>
     * Indicates if the global database cluster has deletion protection enabled. The global database cluster can't be
     * deleted when deletion protection is enabled.
     * </p>
     * 
     * @return Indicates if the global database cluster has deletion protection enabled. The global database cluster
     *         can't be deleted when deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
     * outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the
     * following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use
     * the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
     * </p>
     * 
     * @return The version number of the database engine to which you want to upgrade. Changing this parameter results
     *         in an outage. The change is applied during the next maintenance window unless
     *         <code>ApplyImmediately</code> is enabled.</p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora),
     *         use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible
     *         Aurora), use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora-postgresql</code>, use the following
     *         command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * A value that indicates whether major version upgrades are allowed.
     * </p>
     * <p>
     * Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code>
     * parameter that is a different major version than the DB cluster's current version.
     * </p>
     * <p>
     * If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to
     * the default parameter groups for the new version. Apply any custom parameter groups after completing the upgrade.
     * </p>
     * 
     * @return A value that indicates whether major version upgrades are allowed.</p>
     *         <p>
     *         Constraints: You must allow major version upgrades when specifying a value for the
     *         <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current
     *         version.
     *         </p>
     *         <p>
     *         If you upgrade the major version of a global database, the cluster and DB instance parameter groups are
     *         set to the default parameter groups for the new version. Apply any custom parameter groups after
     *         completing the upgrade.
     */
    public final Boolean allowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newGlobalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpgrade());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyGlobalClusterRequest)) {
            return false;
        }
        ModifyGlobalClusterRequest other = (ModifyGlobalClusterRequest) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(newGlobalClusterIdentifier(), other.newGlobalClusterIdentifier())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyGlobalClusterRequest").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("NewGlobalClusterIdentifier", newGlobalClusterIdentifier()).add("DeletionProtection", deletionProtection())
                .add("EngineVersion", engineVersion()).add("AllowMajorVersionUpgrade", allowMajorVersionUpgrade()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "NewGlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(newGlobalClusterIdentifier()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AllowMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpgrade()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyGlobalClusterRequest, T> g) {
        return obj -> g.apply((ModifyGlobalClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyGlobalClusterRequest> {
        /**
         * <p>
         * The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing global database cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalClusterIdentifier
         *        The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing global database cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The new cluster identifier for the global database cluster when modifying a global database cluster. This
         * value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster2</code>
         * </p>
         * 
         * @param newGlobalClusterIdentifier
         *        The new cluster identifier for the global database cluster when modifying a global database cluster.
         *        This value is stored as a lowercase string. </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newGlobalClusterIdentifier(String newGlobalClusterIdentifier);

        /**
         * <p>
         * Indicates if the global database cluster has deletion protection enabled. The global database cluster can't
         * be deleted when deletion protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        Indicates if the global database cluster has deletion protection enabled. The global database cluster
         *        can't be deleted when deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
         * outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is
         * enabled.
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use
         * the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora),
         * use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to which you want to upgrade. Changing this parameter
         *        results in an outage. The change is applied during the next maintenance window unless
         *        <code>ApplyImmediately</code> is enabled.</p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible
         *        Aurora), use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible
         *        Aurora), use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora-postgresql</code>, use the following
         *        command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * A value that indicates whether major version upgrades are allowed.
         * </p>
         * <p>
         * Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code>
         * parameter that is a different major version than the DB cluster's current version.
         * </p>
         * <p>
         * If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set
         * to the default parameter groups for the new version. Apply any custom parameter groups after completing the
         * upgrade.
         * </p>
         * 
         * @param allowMajorVersionUpgrade
         *        A value that indicates whether major version upgrades are allowed.</p>
         *        <p>
         *        Constraints: You must allow major version upgrades when specifying a value for the
         *        <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current
         *        version.
         *        </p>
         *        <p>
         *        If you upgrade the major version of a global database, the cluster and DB instance parameter groups
         *        are set to the default parameter groups for the new version. Apply any custom parameter groups after
         *        completing the upgrade.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String newGlobalClusterIdentifier;

        private Boolean deletionProtection;

        private String engineVersion;

        private Boolean allowMajorVersionUpgrade;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyGlobalClusterRequest model) {
            super(model);
            globalClusterIdentifier(model.globalClusterIdentifier);
            newGlobalClusterIdentifier(model.newGlobalClusterIdentifier);
            deletionProtection(model.deletionProtection);
            engineVersion(model.engineVersion);
            allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getNewGlobalClusterIdentifier() {
            return newGlobalClusterIdentifier;
        }

        public final void setNewGlobalClusterIdentifier(String newGlobalClusterIdentifier) {
            this.newGlobalClusterIdentifier = newGlobalClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder newGlobalClusterIdentifier(String newGlobalClusterIdentifier) {
            this.newGlobalClusterIdentifier = newGlobalClusterIdentifier;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        @Transient
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return allowMajorVersionUpgrade;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        @Override
        @Transient
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyGlobalClusterRequest build() {
            return new ModifyGlobalClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
