/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExportTaskRequest extends RdsRequest implements
        ToCopyableBuilder<StartExportTaskRequest.Builder, StartExportTaskRequest> {
    private static final SdkField<String> EXPORT_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportTaskIdentifier").getter(getter(StartExportTaskRequest::exportTaskIdentifier))
            .setter(setter(Builder::exportTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(StartExportTaskRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(StartExportTaskRequest::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(StartExportTaskRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StartExportTaskRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(StartExportTaskRequest::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<List<String>> EXPORT_ONLY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExportOnly")
            .getter(getter(StartExportTaskRequest::exportOnly))
            .setter(setter(Builder::exportOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportOnly").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_IDENTIFIER_FIELD,
            SOURCE_ARN_FIELD, S3_BUCKET_NAME_FIELD, IAM_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, S3_PREFIX_FIELD, EXPORT_ONLY_FIELD));

    private final String exportTaskIdentifier;

    private final String sourceArn;

    private final String s3BucketName;

    private final String iamRoleArn;

    private final String kmsKeyId;

    private final String s3Prefix;

    private final List<String> exportOnly;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.exportTaskIdentifier = builder.exportTaskIdentifier;
        this.sourceArn = builder.sourceArn;
        this.s3BucketName = builder.s3BucketName;
        this.iamRoleArn = builder.iamRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.s3Prefix = builder.s3Prefix;
        this.exportOnly = builder.exportOnly;
    }

    /**
     * <p>
     * A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the
     * snapshot is to be exported to.
     * </p>
     * 
     * @return A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket
     *         where the snapshot is to be exported to.
     */
    public final String exportTaskIdentifier() {
        return exportTaskIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket to export the snapshot to.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket to export the snapshot to.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot.
     * </p>
     * 
     * @return The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services KMS key to use to encrypt the snapshot exported to Amazon S3. The Amazon Web
     * Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. The caller of this
     * operation must be authorized to execute the following operations. These can be set in the Amazon Web Services KMS
     * key policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * GrantOperation.Encrypt
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.Decrypt
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.GenerateDataKey
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.GenerateDataKeyWithoutPlaintext
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.ReEncryptFrom
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.ReEncryptTo
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.CreateGrant
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.DescribeKey
     * </p>
     * </li>
     * <li>
     * <p>
     * GrantOperation.RetireGrant
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ID of the Amazon Web Services KMS key to use to encrypt the snapshot exported to Amazon S3. The
     *         Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *         The caller of this operation must be authorized to execute the following operations. These can be set in
     *         the Amazon Web Services KMS key policy: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         GrantOperation.Encrypt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.Decrypt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.GenerateDataKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.GenerateDataKeyWithoutPlaintext
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.ReEncryptFrom
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.ReEncryptTo
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.CreateGrant
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.DescribeKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GrantOperation.RetireGrant
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     * </p>
     * 
     * @return The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportOnly property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExportOnly() {
        return exportOnly != null && !(exportOnly instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported.
     * Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>database</code> - Export all the data from a specified database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS
     * for MySQL, RDS for MariaDB, and Aurora MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid
     * only for RDS for PostgreSQL and Aurora PostgreSQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is
     * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportOnly} method.
     * </p>
     * 
     * @return The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is
     *         exported. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>database</code> - Export all the data from a specified database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only
     *         for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format
     *         is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format
     *         is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     *         </p>
     *         </li>
     */
    public final List<String> exportOnly() {
        return exportOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasExportOnly() ? exportOnly() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest) obj;
        return Objects.equals(exportTaskIdentifier(), other.exportTaskIdentifier())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(s3Prefix(), other.s3Prefix()) && hasExportOnly() == other.hasExportOnly()
                && Objects.equals(exportOnly(), other.exportOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExportTaskRequest").add("ExportTaskIdentifier", exportTaskIdentifier())
                .add("SourceArn", sourceArn()).add("S3BucketName", s3BucketName()).add("IamRoleArn", iamRoleArn())
                .add("KmsKeyId", kmsKeyId()).add("S3Prefix", s3Prefix()).add("ExportOnly", hasExportOnly() ? exportOnly() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTaskIdentifier":
            return Optional.ofNullable(clazz.cast(exportTaskIdentifier()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "ExportOnly":
            return Optional.ofNullable(clazz.cast(exportOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartExportTaskRequest> {
        /**
         * <p>
         * A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where
         * the snapshot is to be exported to.
         * </p>
         * 
         * @param exportTaskIdentifier
         *        A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket
         *        where the snapshot is to be exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskIdentifier(String exportTaskIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The name of the Amazon S3 bucket to export the snapshot to.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the Amazon S3 bucket to export the snapshot to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot.
         * </p>
         * 
         * @param iamRoleArn
         *        The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The ID of the Amazon Web Services KMS key to use to encrypt the snapshot exported to Amazon S3. The Amazon
         * Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. The caller
         * of this operation must be authorized to execute the following operations. These can be set in the Amazon Web
         * Services KMS key policy:
         * </p>
         * <ul>
         * <li>
         * <p>
         * GrantOperation.Encrypt
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.Decrypt
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.GenerateDataKey
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.GenerateDataKeyWithoutPlaintext
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.ReEncryptFrom
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.ReEncryptTo
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.CreateGrant
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.DescribeKey
         * </p>
         * </li>
         * <li>
         * <p>
         * GrantOperation.RetireGrant
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        The ID of the Amazon Web Services KMS key to use to encrypt the snapshot exported to Amazon S3. The
         *        Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
         *        key. The caller of this operation must be authorized to execute the following operations. These can be
         *        set in the Amazon Web Services KMS key policy: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        GrantOperation.Encrypt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.Decrypt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.GenerateDataKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.GenerateDataKeyWithoutPlaintext
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.ReEncryptFrom
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.ReEncryptTo
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.CreateGrant
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.DescribeKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GrantOperation.RetireGrant
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
         * </p>
         * 
         * @param s3Prefix
         *        The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is
         * exported. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>database</code> - Export all the data from a specified database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for
         * RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportOnly
         *        The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is
         *        exported. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>database</code> - Export all the data from a specified database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid
         *        only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportOnly(Collection<String> exportOnly);

        /**
         * <p>
         * The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is
         * exported. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>database</code> - Export all the data from a specified database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for
         * RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportOnly
         *        The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is
         *        exported. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>database</code> - Export all the data from a specified database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid
         *        only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportOnly(String... exportOnly);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String exportTaskIdentifier;

        private String sourceArn;

        private String s3BucketName;

        private String iamRoleArn;

        private String kmsKeyId;

        private String s3Prefix;

        private List<String> exportOnly = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            exportTaskIdentifier(model.exportTaskIdentifier);
            sourceArn(model.sourceArn);
            s3BucketName(model.s3BucketName);
            iamRoleArn(model.iamRoleArn);
            kmsKeyId(model.kmsKeyId);
            s3Prefix(model.s3Prefix);
            exportOnly(model.exportOnly);
        }

        public final String getExportTaskIdentifier() {
            return exportTaskIdentifier;
        }

        public final void setExportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
        }

        @Override
        @Transient
        public final Builder exportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        @Transient
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        @Transient
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final Collection<String> getExportOnly() {
            if (exportOnly instanceof SdkAutoConstructList) {
                return null;
            }
            return exportOnly;
        }

        public final void setExportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
        }

        @Override
        @Transient
        public final Builder exportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exportOnly(String... exportOnly) {
            exportOnly(Arrays.asList(exportOnly));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
