/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopActivityStreamResponse extends RdsResponse implements
        ToCopyableBuilder<StopActivityStreamResponse.Builder, StopActivityStreamResponse> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StopActivityStreamResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> KINESIS_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KinesisStreamName").getter(getter(StopActivityStreamResponse::kinesisStreamName))
            .setter(setter(Builder::kinesisStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StopActivityStreamResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            KINESIS_STREAM_NAME_FIELD, STATUS_FIELD));

    private final String kmsKeyId;

    private final String kinesisStreamName;

    private final String status;

    private StopActivityStreamResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
        this.kinesisStreamName = builder.kinesisStreamName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier used for encrypting messages in the database activity
     *         stream.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the Amazon Kinesis data stream used for the database activity stream.
     * </p>
     * 
     * @return The name of the Amazon Kinesis data stream used for the database activity stream.
     */
    public final String kinesisStreamName() {
        return kinesisStreamName;
    }

    /**
     * <p>
     * The status of the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the database activity stream.
     * @see ActivityStreamStatus
     */
    public final ActivityStreamStatus status() {
        return ActivityStreamStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the database activity stream.
     * @see ActivityStreamStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopActivityStreamResponse)) {
            return false;
        }
        StopActivityStreamResponse other = (StopActivityStreamResponse) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(kinesisStreamName(), other.kinesisStreamName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopActivityStreamResponse").add("KmsKeyId", kmsKeyId())
                .add("KinesisStreamName", kinesisStreamName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "KinesisStreamName":
            return Optional.ofNullable(clazz.cast(kinesisStreamName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopActivityStreamResponse, T> g) {
        return obj -> g.apply((StopActivityStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopActivityStreamResponse> {
        /**
         * <p>
         * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier used for encrypting messages in the database activity
         *        stream.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the Amazon Kinesis data stream used for the database activity stream.
         * </p>
         * 
         * @param kinesisStreamName
         *        The name of the Amazon Kinesis data stream used for the database activity stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamName(String kinesisStreamName);

        /**
         * <p>
         * The status of the database activity stream.
         * </p>
         * 
         * @param status
         *        The status of the database activity stream.
         * @see ActivityStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the database activity stream.
         * </p>
         * 
         * @param status
         *        The status of the database activity stream.
         * @see ActivityStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamStatus
         */
        Builder status(ActivityStreamStatus status);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String kmsKeyId;

        private String kinesisStreamName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StopActivityStreamResponse model) {
            super(model);
            kmsKeyId(model.kmsKeyId);
            kinesisStreamName(model.kinesisStreamName);
            status(model.status);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getKinesisStreamName() {
            return kinesisStreamName;
        }

        public final void setKinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
        }

        @Override
        @Transient
        public final Builder kinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ActivityStreamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StopActivityStreamResponse build() {
            return new StopActivityStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
