/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the connection health of an RDS Proxy target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetHealth implements SdkPojo, Serializable, ToCopyableBuilder<TargetHealth.Builder, TargetHealth> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(TargetHealth::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(TargetHealth::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TargetHealth::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, REASON_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String reason;

    private final String description;

    private TargetHealth(BuilderImpl builder) {
        this.state = builder.state;
        this.reason = builder.reason;
        this.description = builder.description;
    }

    /**
     * <p>
     * The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical
     * lifecycle example for the states of an RDS Proxy target:
     * </p>
     * <p>
     * <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt; <code>unavailable</code>
     * &gt; <code>available</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TargetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical
     *         lifecycle example for the states of an RDS Proxy target: </p>
     *         <p>
     *         <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt;
     *         <code>unavailable</code> &gt; <code>available</code>
     * @see TargetState
     */
    public final TargetState state() {
        return TargetState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical
     * lifecycle example for the states of an RDS Proxy target:
     * </p>
     * <p>
     * <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt; <code>unavailable</code>
     * &gt; <code>available</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TargetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical
     *         lifecycle example for the states of an RDS Proxy target: </p>
     *         <p>
     *         <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt;
     *         <code>unavailable</code> &gt; <code>available</code>
     * @see TargetState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the current health <code>State</code> of the RDS Proxy target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link TargetHealthReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the current health <code>State</code> of the RDS Proxy target.
     * @see TargetHealthReason
     */
    public final TargetHealthReason reason() {
        return TargetHealthReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason for the current health <code>State</code> of the RDS Proxy target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link TargetHealthReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the current health <code>State</code> of the RDS Proxy target.
     * @see TargetHealthReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>, a
     * description is not included.
     * </p>
     * 
     * @return A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>,
     *         a description is not included.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealth)) {
            return false;
        }
        TargetHealth other = (TargetHealth) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetHealth").add("State", stateAsString()).add("Reason", reasonAsString())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetHealth, T> g) {
        return obj -> g.apply((TargetHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetHealth> {
        /**
         * <p>
         * The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical
         * lifecycle example for the states of an RDS Proxy target:
         * </p>
         * <p>
         * <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt;
         * <code>unavailable</code> &gt; <code>available</code>
         * </p>
         * 
         * @param state
         *        The current state of the connection health lifecycle for the RDS Proxy target. The following is a
         *        typical lifecycle example for the states of an RDS Proxy target: </p>
         *        <p>
         *        <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt;
         *        <code>unavailable</code> &gt; <code>available</code>
         * @see TargetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical
         * lifecycle example for the states of an RDS Proxy target:
         * </p>
         * <p>
         * <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt;
         * <code>unavailable</code> &gt; <code>available</code>
         * </p>
         * 
         * @param state
         *        The current state of the connection health lifecycle for the RDS Proxy target. The following is a
         *        typical lifecycle example for the states of an RDS Proxy target: </p>
         *        <p>
         *        <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt;
         *        <code>unavailable</code> &gt; <code>available</code>
         * @see TargetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetState
         */
        Builder state(TargetState state);

        /**
         * <p>
         * The reason for the current health <code>State</code> of the RDS Proxy target.
         * </p>
         * 
         * @param reason
         *        The reason for the current health <code>State</code> of the RDS Proxy target.
         * @see TargetHealthReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetHealthReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason for the current health <code>State</code> of the RDS Proxy target.
         * </p>
         * 
         * @param reason
         *        The reason for the current health <code>State</code> of the RDS Proxy target.
         * @see TargetHealthReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetHealthReason
         */
        Builder reason(TargetHealthReason reason);

        /**
         * <p>
         * A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>, a
         * description is not included.
         * </p>
         * 
         * @param description
         *        A description of the health of the RDS Proxy target. If the <code>State</code> is
         *        <code>AVAILABLE</code>, a description is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String reason;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealth model) {
            state(model.state);
            reason(model.reason);
            description(model.description);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(TargetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        @Transient
        public final Builder reason(TargetHealthReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public TargetHealth build() {
            return new TargetHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
