/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.EngineModeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpgradeTarget> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(UpgradeTarget.getter(UpgradeTarget::engine)).setter(UpgradeTarget.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(UpgradeTarget.getter(UpgradeTarget::engineVersion)).setter(UpgradeTarget.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpgradeTarget.getter(UpgradeTarget::description)).setter(UpgradeTarget.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> AUTO_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoUpgrade").getter(UpgradeTarget.getter(UpgradeTarget::autoUpgrade)).setter(UpgradeTarget.setter(Builder::autoUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpgrade").build()}).build();
    private static final SdkField<Boolean> IS_MAJOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsMajorVersionUpgrade").getter(UpgradeTarget.getter(UpgradeTarget::isMajorVersionUpgrade)).setter(UpgradeTarget.setter(Builder::isMajorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMajorVersionUpgrade").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEngineModes").getter(UpgradeTarget.getter(UpgradeTarget::supportedEngineModes)).setter(UpgradeTarget.setter(Builder::supportedEngineModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_PARALLEL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsParallelQuery").getter(UpgradeTarget.getter(UpgradeTarget::supportsParallelQuery)).setter(UpgradeTarget.setter(Builder::supportsParallelQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsParallelQuery").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_GLOBAL_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsGlobalDatabases").getter(UpgradeTarget.getter(UpgradeTarget::supportsGlobalDatabases)).setter(UpgradeTarget.setter(Builder::supportsGlobalDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsGlobalDatabases").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_BABELFISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsBabelfish").getter(UpgradeTarget.getter(UpgradeTarget::supportsBabelfish)).setter(UpgradeTarget.setter(Builder::supportsBabelfish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsBabelfish").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DESCRIPTION_FIELD, AUTO_UPGRADE_FIELD, IS_MAJOR_VERSION_UPGRADE_FIELD, SUPPORTED_ENGINE_MODES_FIELD, SUPPORTS_PARALLEL_QUERY_FIELD, SUPPORTS_GLOBAL_DATABASES_FIELD, SUPPORTS_BABELFISH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String engineVersion;
    private final String description;
    private final Boolean autoUpgrade;
    private final Boolean isMajorVersionUpgrade;
    private final List<String> supportedEngineModes;
    private final Boolean supportsParallelQuery;
    private final Boolean supportsGlobalDatabases;
    private final Boolean supportsBabelfish;

    private UpgradeTarget(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.description = builder.description;
        this.autoUpgrade = builder.autoUpgrade;
        this.isMajorVersionUpgrade = builder.isMajorVersionUpgrade;
        this.supportedEngineModes = builder.supportedEngineModes;
        this.supportsParallelQuery = builder.supportsParallelQuery;
        this.supportsGlobalDatabases = builder.supportsGlobalDatabases;
        this.supportsBabelfish = builder.supportsBabelfish;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean autoUpgrade() {
        return this.autoUpgrade;
    }

    public final Boolean isMajorVersionUpgrade() {
        return this.isMajorVersionUpgrade;
    }

    public final boolean hasSupportedEngineModes() {
        return this.supportedEngineModes != null && !(this.supportedEngineModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedEngineModes() {
        return this.supportedEngineModes;
    }

    public final Boolean supportsParallelQuery() {
        return this.supportsParallelQuery;
    }

    public final Boolean supportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public final Boolean supportsBabelfish() {
        return this.supportsBabelfish;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEngineModes() ? this.supportedEngineModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsParallelQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsGlobalDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsBabelfish());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeTarget)) {
            return false;
        }
        UpgradeTarget other = (UpgradeTarget)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.autoUpgrade(), other.autoUpgrade()) && Objects.equals(this.isMajorVersionUpgrade(), other.isMajorVersionUpgrade()) && this.hasSupportedEngineModes() == other.hasSupportedEngineModes() && Objects.equals(this.supportedEngineModes(), other.supportedEngineModes()) && Objects.equals(this.supportsParallelQuery(), other.supportsParallelQuery()) && Objects.equals(this.supportsGlobalDatabases(), other.supportsGlobalDatabases()) && Objects.equals(this.supportsBabelfish(), other.supportsBabelfish());
    }

    public final String toString() {
        return ToString.builder((String)"UpgradeTarget").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Description", (Object)this.description()).add("AutoUpgrade", (Object)this.autoUpgrade()).add("IsMajorVersionUpgrade", (Object)this.isMajorVersionUpgrade()).add("SupportedEngineModes", this.hasSupportedEngineModes() ? this.supportedEngineModes() : null).add("SupportsParallelQuery", (Object)this.supportsParallelQuery()).add("SupportsGlobalDatabases", (Object)this.supportsGlobalDatabases()).add("SupportsBabelfish", (Object)this.supportsBabelfish()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AutoUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoUpgrade()));
            }
            case "IsMajorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.isMajorVersionUpgrade()));
            }
            case "SupportedEngineModes": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineModes()));
            }
            case "SupportsParallelQuery": {
                return Optional.ofNullable(clazz.cast(this.supportsParallelQuery()));
            }
            case "SupportsGlobalDatabases": {
                return Optional.ofNullable(clazz.cast(this.supportsGlobalDatabases()));
            }
            case "SupportsBabelfish": {
                return Optional.ofNullable(clazz.cast(this.supportsBabelfish()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeTarget, T> g) {
        return obj -> g.apply((UpgradeTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String description;
        private Boolean autoUpgrade;
        private Boolean isMajorVersionUpgrade;
        private List<String> supportedEngineModes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsParallelQuery;
        private Boolean supportsGlobalDatabases;
        private Boolean supportsBabelfish;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeTarget model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.description(model.description);
            this.autoUpgrade(model.autoUpgrade);
            this.isMajorVersionUpgrade(model.isMajorVersionUpgrade);
            this.supportedEngineModes(model.supportedEngineModes);
            this.supportsParallelQuery(model.supportsParallelQuery);
            this.supportsGlobalDatabases(model.supportsGlobalDatabases);
            this.supportsBabelfish(model.supportsBabelfish);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getAutoUpgrade() {
            return this.autoUpgrade;
        }

        public final void setAutoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
        }

        @Override
        @Transient
        public final Builder autoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
            return this;
        }

        public final Boolean getIsMajorVersionUpgrade() {
            return this.isMajorVersionUpgrade;
        }

        public final void setIsMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
        }

        @Override
        @Transient
        public final Builder isMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
            return this;
        }

        public final Collection<String> getSupportedEngineModes() {
            if (this.supportedEngineModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedEngineModes;
        }

        public final void setSupportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
        }

        @Override
        @Transient
        public final Builder supportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedEngineModes(String ... supportedEngineModes) {
            this.supportedEngineModes(Arrays.asList(supportedEngineModes));
            return this;
        }

        public final Boolean getSupportsParallelQuery() {
            return this.supportsParallelQuery;
        }

        public final void setSupportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
        }

        @Override
        @Transient
        public final Builder supportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
            return this;
        }

        public final Boolean getSupportsGlobalDatabases() {
            return this.supportsGlobalDatabases;
        }

        public final void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
        }

        @Override
        @Transient
        public final Builder supportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
            return this;
        }

        public final Boolean getSupportsBabelfish() {
            return this.supportsBabelfish;
        }

        public final void setSupportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
        }

        @Override
        @Transient
        public final Builder supportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
            return this;
        }

        public UpgradeTarget build() {
            return new UpgradeTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpgradeTarget> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder description(String var1);

        public Builder autoUpgrade(Boolean var1);

        public Builder isMajorVersionUpgrade(Boolean var1);

        public Builder supportedEngineModes(Collection<String> var1);

        public Builder supportedEngineModes(String ... var1);

        public Builder supportsParallelQuery(Boolean var1);

        public Builder supportsGlobalDatabases(Boolean var1);

        public Builder supportsBabelfish(Boolean var1);
    }
}

