/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <code>DescribeDBClusterBacktracks</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClusterBacktracksResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbClusterBacktracksResponse.Builder, DescribeDbClusterBacktracksResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbClusterBacktracksResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBClusterBacktrack>> DB_CLUSTER_BACKTRACKS_FIELD = SdkField
            .<List<DBClusterBacktrack>> builder(MarshallingType.LIST)
            .memberName("DBClusterBacktracks")
            .getter(getter(DescribeDbClusterBacktracksResponse::dbClusterBacktracks))
            .setter(setter(Builder::dbClusterBacktracks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterBacktracks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterBacktrack")
                            .memberFieldInfo(
                                    SdkField.<DBClusterBacktrack> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterBacktrack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterBacktrack").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_CLUSTER_BACKTRACKS_FIELD));

    private final String marker;

    private final List<DBClusterBacktrack> dbClusterBacktracks;

    private DescribeDbClusterBacktracksResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterBacktracks = builder.dbClusterBacktracks;
    }

    /**
     * <p>
     * A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.
     * </p>
     * 
     * @return A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBClusterBacktracks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbClusterBacktracks() {
        return dbClusterBacktracks != null && !(dbClusterBacktracks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of backtracks for the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterBacktracks} method.
     * </p>
     * 
     * @return Contains a list of backtracks for the user.
     */
    public final List<DBClusterBacktrack> dbClusterBacktracks() {
        return dbClusterBacktracks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterBacktracks() ? dbClusterBacktracks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterBacktracksResponse)) {
            return false;
        }
        DescribeDbClusterBacktracksResponse other = (DescribeDbClusterBacktracksResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasDbClusterBacktracks() == other.hasDbClusterBacktracks()
                && Objects.equals(dbClusterBacktracks(), other.dbClusterBacktracks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbClusterBacktracksResponse").add("Marker", marker())
                .add("DBClusterBacktracks", hasDbClusterBacktracks() ? dbClusterBacktracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBClusterBacktracks":
            return Optional.ofNullable(clazz.cast(dbClusterBacktracks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterBacktracksResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterBacktracksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbClusterBacktracksResponse> {
        /**
         * <p>
         * A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.
         * </p>
         * 
         * @param marker
         *        A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Contains a list of backtracks for the user.
         * </p>
         * 
         * @param dbClusterBacktracks
         *        Contains a list of backtracks for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterBacktracks(Collection<DBClusterBacktrack> dbClusterBacktracks);

        /**
         * <p>
         * Contains a list of backtracks for the user.
         * </p>
         * 
         * @param dbClusterBacktracks
         *        Contains a list of backtracks for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterBacktracks(DBClusterBacktrack... dbClusterBacktracks);

        /**
         * <p>
         * Contains a list of backtracks for the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DBClusterBacktrack>.Builder}
         * avoiding the need to create one manually via {@link List<DBClusterBacktrack>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterBacktrack>.Builder#build()} is called immediately
         * and its result is passed to {@link #dbClusterBacktracks(List<DBClusterBacktrack>)}.
         * 
         * @param dbClusterBacktracks
         *        a consumer that will call methods on {@link List<DBClusterBacktrack>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterBacktracks(List<DBClusterBacktrack>)
         */
        Builder dbClusterBacktracks(Consumer<DBClusterBacktrack.Builder>... dbClusterBacktracks);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBClusterBacktrack> dbClusterBacktracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterBacktracksResponse model) {
            super(model);
            marker(model.marker);
            dbClusterBacktracks(model.dbClusterBacktracks);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBClusterBacktrack.Builder> getDbClusterBacktracks() {
            List<DBClusterBacktrack.Builder> result = DBClusterBacktrackListCopier.copyToBuilder(this.dbClusterBacktracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterBacktracks(Collection<DBClusterBacktrack.BuilderImpl> dbClusterBacktracks) {
            this.dbClusterBacktracks = DBClusterBacktrackListCopier.copyFromBuilder(dbClusterBacktracks);
        }

        @Override
        public final Builder dbClusterBacktracks(Collection<DBClusterBacktrack> dbClusterBacktracks) {
            this.dbClusterBacktracks = DBClusterBacktrackListCopier.copy(dbClusterBacktracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterBacktracks(DBClusterBacktrack... dbClusterBacktracks) {
            dbClusterBacktracks(Arrays.asList(dbClusterBacktracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterBacktracks(Consumer<DBClusterBacktrack.Builder>... dbClusterBacktracks) {
            dbClusterBacktracks(Stream.of(dbClusterBacktracks).map(c -> DBClusterBacktrack.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbClusterBacktracksResponse build() {
            return new DescribeDbClusterBacktracksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
