/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrderableDbInstanceOptionsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeOrderableDbInstanceOptionsRequest.Builder, DescribeOrderableDbInstanceOptionsRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DescribeOrderableDbInstanceOptionsRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DescribeOrderableDbInstanceOptionsRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(DescribeOrderableDbInstanceOptionsRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(DescribeOrderableDbInstanceOptionsRequest::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneGroup").getter(getter(DescribeOrderableDbInstanceOptionsRequest::availabilityZoneGroup))
            .setter(setter(Builder::availabilityZoneGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneGroup").build())
            .build();

    private static final SdkField<Boolean> VPC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Vpc")
            .getter(getter(DescribeOrderableDbInstanceOptionsRequest::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeOrderableDbInstanceOptionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeOrderableDbInstanceOptionsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeOrderableDbInstanceOptionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DB_INSTANCE_CLASS_FIELD, LICENSE_MODEL_FIELD, AVAILABILITY_ZONE_GROUP_FIELD, VPC_FIELD,
            FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String engine;

    private final String engineVersion;

    private final String dbInstanceClass;

    private final String licenseModel;

    private final String availabilityZoneGroup;

    private final Boolean vpc;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private DescribeOrderableDbInstanceOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.licenseModel = builder.licenseModel;
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.vpc = builder.vpc;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The name of the engine to retrieve DB instance options for.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aurora</code> (for MySQL 5.6-compatible Aurora)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-postgresql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mariadb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mysql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>postgres</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ex</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-web</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the engine to retrieve DB instance options for.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aurora</code> (for MySQL 5.6-compatible Aurora)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-postgresql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mariadb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mysql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>postgres</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ex</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-web</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine version filter value. Specify this parameter to show only the available offerings matching the
     * specified engine version.
     * </p>
     * 
     * @return The engine version filter value. Specify this parameter to show only the available offerings matching the
     *         specified engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The DB instance class filter value. Specify this parameter to show only the available offerings matching the
     * specified DB instance class.
     * </p>
     * 
     * @return The DB instance class filter value. Specify this parameter to show only the available offerings matching
     *         the specified DB instance class.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The license model filter value. Specify this parameter to show only the available offerings matching the
     * specified license model.
     * </p>
     * <p>
     * RDS Custom supports only the BYOL licensing model.
     * </p>
     * 
     * @return The license model filter value. Specify this parameter to show only the available offerings matching the
     *         specified license model.</p>
     *         <p>
     *         RDS Custom supports only the BYOL licensing model.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available offerings
     * for the Local Zones in the group.
     * </p>
     * <p>
     * Omit this parameter to show the available offerings in the specified Amazon Web Services Region.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available
     *         offerings for the Local Zones in the group.</p>
     *         <p>
     *         Omit this parameter to show the available offerings in the specified Amazon Web Services Region.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String availabilityZoneGroup() {
        return availabilityZoneGroup;
    }

    /**
     * <p>
     * A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC offerings.
     * </p>
     * <p>
     * RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output shows VPC
     * offerings.
     * </p>
     * 
     * @return A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC
     *         offerings.</p>
     *         <p>
     *         RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output
     *         shows VPC offerings.
     */
    public final Boolean vpc() {
        return vpc;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter isn't currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return This parameter isn't currently supported.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
     * retrieve the remaining results.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: Minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you
     *         can retrieve the remaining results.</p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: Minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter
     * is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableDbInstanceOptionsRequest)) {
            return false;
        }
        DescribeOrderableDbInstanceOptionsRequest other = (DescribeOrderableDbInstanceOptionsRequest) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(licenseModel(), other.licenseModel())
                && Objects.equals(availabilityZoneGroup(), other.availabilityZoneGroup()) && Objects.equals(vpc(), other.vpc())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrderableDbInstanceOptionsRequest").add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("DBInstanceClass", dbInstanceClass())
                .add("LicenseModel", licenseModel()).add("AvailabilityZoneGroup", availabilityZoneGroup()).add("Vpc", vpc())
                .add("Filters", hasFilters() ? filters() : null).add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "AvailabilityZoneGroup":
            return Optional.ofNullable(clazz.cast(availabilityZoneGroup()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableDbInstanceOptionsRequest, T> g) {
        return obj -> g.apply((DescribeOrderableDbInstanceOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrderableDbInstanceOptionsRequest> {
        /**
         * <p>
         * The name of the engine to retrieve DB instance options for.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aurora</code> (for MySQL 5.6-compatible Aurora)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-postgresql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mariadb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mysql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>postgres</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ex</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-web</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The name of the engine to retrieve DB instance options for.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aurora</code> (for MySQL 5.6-compatible Aurora)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-postgresql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mariadb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mysql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>postgres</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ex</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-web</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine version filter value. Specify this parameter to show only the available offerings matching the
         * specified engine version.
         * </p>
         * 
         * @param engineVersion
         *        The engine version filter value. Specify this parameter to show only the available offerings matching
         *        the specified engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The DB instance class filter value. Specify this parameter to show only the available offerings matching the
         * specified DB instance class.
         * </p>
         * 
         * @param dbInstanceClass
         *        The DB instance class filter value. Specify this parameter to show only the available offerings
         *        matching the specified DB instance class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The license model filter value. Specify this parameter to show only the available offerings matching the
         * specified license model.
         * </p>
         * <p>
         * RDS Custom supports only the BYOL licensing model.
         * </p>
         * 
         * @param licenseModel
         *        The license model filter value. Specify this parameter to show only the available offerings matching
         *        the specified license model.</p>
         *        <p>
         *        RDS Custom supports only the BYOL licensing model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available
         * offerings for the Local Zones in the group.
         * </p>
         * <p>
         * Omit this parameter to show the available offerings in the specified Amazon Web Services Region.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param availabilityZoneGroup
         *        The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available
         *        offerings for the Local Zones in the group.</p>
         *        <p>
         *        Omit this parameter to show the available offerings in the specified Amazon Web Services Region.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneGroup(String availabilityZoneGroup);

        /**
         * <p>
         * A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC offerings.
         * </p>
         * <p>
         * RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output shows
         * VPC offerings.
         * </p>
         * 
         * @param vpc
         *        A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC
         *        offerings.</p>
         *        <p>
         *        RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output
         *        shows VPC offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(Boolean vpc);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Filter>.Builder} avoiding the need
         * to create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
         * retrieve the remaining results.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: Minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
         *        you can retrieve the remaining results.</p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: Minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If
         *        this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String dbInstanceClass;

        private String licenseModel;

        private String availabilityZoneGroup;

        private Boolean vpc;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableDbInstanceOptionsRequest model) {
            super(model);
            engine(model.engine);
            engineVersion(model.engineVersion);
            dbInstanceClass(model.dbInstanceClass);
            licenseModel(model.licenseModel);
            availabilityZoneGroup(model.availabilityZoneGroup);
            vpc(model.vpc);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getAvailabilityZoneGroup() {
            return availabilityZoneGroup;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final Boolean getVpc() {
            return vpc;
        }

        public final void setVpc(Boolean vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(Boolean vpc) {
            this.vpc = vpc;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrderableDbInstanceOptionsRequest build() {
            return new DescribeOrderableDbInstanceOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
