/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from a call to <code>DescribeDBLogFiles</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbLogFilesResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbLogFilesResponse.Builder, DescribeDbLogFilesResponse> {
    private static final SdkField<List<DescribeDBLogFilesDetails>> DESCRIBE_DB_LOG_FILES_FIELD = SdkField
            .<List<DescribeDBLogFilesDetails>> builder(MarshallingType.LIST)
            .memberName("DescribeDBLogFiles")
            .getter(getter(DescribeDbLogFilesResponse::describeDBLogFiles))
            .setter(setter(Builder::describeDBLogFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescribeDBLogFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DescribeDBLogFilesDetails")
                            .memberFieldInfo(
                                    SdkField.<DescribeDBLogFilesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeDBLogFilesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DescribeDBLogFilesDetails").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbLogFilesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIBE_DB_LOG_FILES_FIELD,
            MARKER_FIELD));

    private final List<DescribeDBLogFilesDetails> describeDBLogFiles;

    private final String marker;

    private DescribeDbLogFilesResponse(BuilderImpl builder) {
        super(builder);
        this.describeDBLogFiles = builder.describeDBLogFiles;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DescribeDBLogFiles property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDescribeDBLogFiles() {
        return describeDBLogFiles != null && !(describeDBLogFiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DB log files returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDescribeDBLogFiles} method.
     * </p>
     * 
     * @return The DB log files returned.
     */
    public final List<DescribeDBLogFilesDetails> describeDBLogFiles() {
        return describeDBLogFiles;
    }

    /**
     * <p>
     * A pagination token that can be used in a later <code>DescribeDBLogFiles</code> request.
     * </p>
     * 
     * @return A pagination token that can be used in a later <code>DescribeDBLogFiles</code> request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDescribeDBLogFiles() ? describeDBLogFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbLogFilesResponse)) {
            return false;
        }
        DescribeDbLogFilesResponse other = (DescribeDbLogFilesResponse) obj;
        return hasDescribeDBLogFiles() == other.hasDescribeDBLogFiles()
                && Objects.equals(describeDBLogFiles(), other.describeDBLogFiles()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbLogFilesResponse")
                .add("DescribeDBLogFiles", hasDescribeDBLogFiles() ? describeDBLogFiles() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DescribeDBLogFiles":
            return Optional.ofNullable(clazz.cast(describeDBLogFiles()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbLogFilesResponse, T> g) {
        return obj -> g.apply((DescribeDbLogFilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbLogFilesResponse> {
        /**
         * <p>
         * The DB log files returned.
         * </p>
         * 
         * @param describeDBLogFiles
         *        The DB log files returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder describeDBLogFiles(Collection<DescribeDBLogFilesDetails> describeDBLogFiles);

        /**
         * <p>
         * The DB log files returned.
         * </p>
         * 
         * @param describeDBLogFiles
         *        The DB log files returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder describeDBLogFiles(DescribeDBLogFilesDetails... describeDBLogFiles);

        /**
         * <p>
         * The DB log files returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DescribeDBLogFilesDetails>.Builder}
         * avoiding the need to create one manually via {@link List<DescribeDBLogFilesDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DescribeDBLogFilesDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #describeDBLogFiles(List<DescribeDBLogFilesDetails>)}.
         * 
         * @param describeDBLogFiles
         *        a consumer that will call methods on {@link List<DescribeDBLogFilesDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #describeDBLogFiles(List<DescribeDBLogFilesDetails>)
         */
        Builder describeDBLogFiles(Consumer<DescribeDBLogFilesDetails.Builder>... describeDBLogFiles);

        /**
         * <p>
         * A pagination token that can be used in a later <code>DescribeDBLogFiles</code> request.
         * </p>
         * 
         * @param marker
         *        A pagination token that can be used in a later <code>DescribeDBLogFiles</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<DescribeDBLogFilesDetails> describeDBLogFiles = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbLogFilesResponse model) {
            super(model);
            describeDBLogFiles(model.describeDBLogFiles);
            marker(model.marker);
        }

        public final List<DescribeDBLogFilesDetails.Builder> getDescribeDBLogFiles() {
            List<DescribeDBLogFilesDetails.Builder> result = DescribeDBLogFilesListCopier.copyToBuilder(this.describeDBLogFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDescribeDBLogFiles(Collection<DescribeDBLogFilesDetails.BuilderImpl> describeDBLogFiles) {
            this.describeDBLogFiles = DescribeDBLogFilesListCopier.copyFromBuilder(describeDBLogFiles);
        }

        @Override
        public final Builder describeDBLogFiles(Collection<DescribeDBLogFilesDetails> describeDBLogFiles) {
            this.describeDBLogFiles = DescribeDBLogFilesListCopier.copy(describeDBLogFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder describeDBLogFiles(DescribeDBLogFilesDetails... describeDBLogFiles) {
            describeDBLogFiles(Arrays.asList(describeDBLogFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder describeDBLogFiles(Consumer<DescribeDBLogFilesDetails.Builder>... describeDBLogFiles) {
            describeDBLogFiles(Stream.of(describeDBLogFiles)
                    .map(c -> DescribeDBLogFilesDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbLogFilesResponse build() {
            return new DescribeDbLogFilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
