/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbInstanceRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbInstanceRequest.Builder, ModifyDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(ModifyDbInstanceRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(ModifyDbInstanceRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(ModifyDbInstanceRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(ModifyDbInstanceRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroups")
            .getter(getter(ModifyDbInstanceRequest::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(ModifyDbInstanceRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyDbInstanceRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(ModifyDbInstanceRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(ModifyDbInstanceRequest::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(ModifyDbInstanceRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(ModifyDbInstanceRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyDbInstanceRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ModifyDbInstanceRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyDbInstanceRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AllowMajorVersionUpgrade")
            .getter(getter(ModifyDbInstanceRequest::allowMajorVersionUpgrade)).setter(setter(Builder::allowMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ModifyDbInstanceRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(ModifyDbInstanceRequest::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(ModifyDbInstanceRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(ModifyDbInstanceRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> NEW_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewDBInstanceIdentifier").getter(getter(ModifyDbInstanceRequest::newDBInstanceIdentifier))
            .setter(setter(Builder::newDBInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(ModifyDbInstanceRequest::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(ModifyDbInstanceRequest::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialPassword").getter(getter(ModifyDbInstanceRequest::tdeCredentialPassword))
            .setter(setter(Builder::tdeCredentialPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialPassword").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(ModifyDbInstanceRequest::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(ModifyDbInstanceRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(ModifyDbInstanceRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(ModifyDbInstanceRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<Integer> DB_PORT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DBPortNumber").getter(getter(ModifyDbInstanceRequest::dbPortNumber))
            .setter(setter(Builder::dbPortNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBPortNumber").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(ModifyDbInstanceRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(ModifyDbInstanceRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(ModifyDbInstanceRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(ModifyDbInstanceRequest::promotionTier))
            .setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(ModifyDbInstanceRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(ModifyDbInstanceRequest::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(ModifyDbInstanceRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(ModifyDbInstanceRequest::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<CloudwatchLogsExportConfiguration> CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD = SdkField
            .<CloudwatchLogsExportConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudwatchLogsExportConfiguration")
            .getter(getter(ModifyDbInstanceRequest::cloudwatchLogsExportConfiguration))
            .setter(setter(Builder::cloudwatchLogsExportConfiguration))
            .constructor(CloudwatchLogsExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsExportConfiguration")
                    .build()).build();

    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<ProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(ModifyDbInstanceRequest::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProcessorFeature")
                            .memberFieldInfo(
                                    SdkField.<ProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProcessorFeature").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseDefaultProcessorFeatures")
            .getter(getter(ModifyDbInstanceRequest::useDefaultProcessorFeatures))
            .setter(setter(Builder::useDefaultProcessorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(ModifyDbInstanceRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllocatedStorage").getter(getter(ModifyDbInstanceRequest::maxAllocatedStorage))
            .setter(setter(Builder::maxAllocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build())
            .build();

    private static final SdkField<Boolean> CERTIFICATE_ROTATION_RESTART_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CertificateRotationRestart")
            .getter(getter(ModifyDbInstanceRequest::certificateRotationRestart))
            .setter(setter(Builder::certificateRotationRestart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateRotationRestart").build())
            .build();

    private static final SdkField<String> REPLICA_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaMode").getter(getter(ModifyDbInstanceRequest::replicaModeAsString))
            .setter(setter(Builder::replicaMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaMode").build()).build();

    private static final SdkField<Boolean> ENABLE_CUSTOMER_OWNED_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCustomerOwnedIp").getter(getter(ModifyDbInstanceRequest::enableCustomerOwnedIp))
            .setter(setter(Builder::enableCustomerOwnedIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCustomerOwnedIp").build())
            .build();

    private static final SdkField<String> AWS_BACKUP_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsBackupRecoveryPointArn").getter(getter(ModifyDbInstanceRequest::awsBackupRecoveryPointArn))
            .setter(setter(Builder::awsBackupRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupRecoveryPointArn").build())
            .build();

    private static final SdkField<String> AUTOMATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomationMode").getter(getter(ModifyDbInstanceRequest::automationModeAsString))
            .setter(setter(Builder::automationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationMode").build()).build();

    private static final SdkField<Integer> RESUME_FULL_AUTOMATION_MODE_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResumeFullAutomationModeMinutes")
            .getter(getter(ModifyDbInstanceRequest::resumeFullAutomationModeMinutes))
            .setter(setter(Builder::resumeFullAutomationModeMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumeFullAutomationModeMinutes")
                    .build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(ModifyDbInstanceRequest::networkType)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            ALLOCATED_STORAGE_FIELD, DB_INSTANCE_CLASS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, DB_SECURITY_GROUPS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD, APPLY_IMMEDIATELY_FIELD, MASTER_USER_PASSWORD_FIELD, DB_PARAMETER_GROUP_NAME_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, MULTI_AZ_FIELD,
            ENGINE_VERSION_FIELD, ALLOW_MAJOR_VERSION_UPGRADE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD,
            IOPS_FIELD, OPTION_GROUP_NAME_FIELD, NEW_DB_INSTANCE_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD,
            TDE_CREDENTIAL_PASSWORD_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, DOMAIN_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD,
            MONITORING_INTERVAL_FIELD, DB_PORT_NUMBER_FIELD, PUBLICLY_ACCESSIBLE_FIELD, MONITORING_ROLE_ARN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD, PROMOTION_TIER_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD,
            ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD,
            PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD, PROCESSOR_FEATURES_FIELD,
            USE_DEFAULT_PROCESSOR_FEATURES_FIELD, DELETION_PROTECTION_FIELD, MAX_ALLOCATED_STORAGE_FIELD,
            CERTIFICATE_ROTATION_RESTART_FIELD, REPLICA_MODE_FIELD, ENABLE_CUSTOMER_OWNED_IP_FIELD,
            AWS_BACKUP_RECOVERY_POINT_ARN_FIELD, AUTOMATION_MODE_FIELD, RESUME_FULL_AUTOMATION_MODE_MINUTES_FIELD,
            NETWORK_TYPE_FIELD));

    private final String dbInstanceIdentifier;

    private final Integer allocatedStorage;

    private final String dbInstanceClass;

    private final String dbSubnetGroupName;

    private final List<String> dbSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final Boolean applyImmediately;

    private final String masterUserPassword;

    private final String dbParameterGroupName;

    private final Integer backupRetentionPeriod;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean allowMajorVersionUpgrade;

    private final Boolean autoMinorVersionUpgrade;

    private final String licenseModel;

    private final Integer iops;

    private final String optionGroupName;

    private final String newDBInstanceIdentifier;

    private final String storageType;

    private final String tdeCredentialArn;

    private final String tdeCredentialPassword;

    private final String caCertificateIdentifier;

    private final String domain;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final Integer dbPortNumber;

    private final Boolean publiclyAccessible;

    private final String monitoringRoleArn;

    private final String domainIAMRoleName;

    private final Integer promotionTier;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

    private final List<ProcessorFeature> processorFeatures;

    private final Boolean useDefaultProcessorFeatures;

    private final Boolean deletionProtection;

    private final Integer maxAllocatedStorage;

    private final Boolean certificateRotationRestart;

    private final String replicaMode;

    private final Boolean enableCustomerOwnedIp;

    private final String awsBackupRecoveryPointArn;

    private final String automationMode;

    private final Integer resumeFullAutomationModeMinutes;

    private final String networkType;

    private ModifyDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.applyImmediately = builder.applyImmediately;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.newDBInstanceIdentifier = builder.newDBInstanceIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.domain = builder.domain;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.dbPortNumber = builder.dbPortNumber;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.promotionTier = builder.promotionTier;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.cloudwatchLogsExportConfiguration = builder.cloudwatchLogsExportConfiguration;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.certificateRotationRestart = builder.certificateRotationRestart;
        this.replicaMode = builder.replicaMode;
        this.enableCustomerOwnedIp = builder.enableCustomerOwnedIp;
        this.awsBackupRecoveryPointArn = builder.awsBackupRecoveryPointArn;
        this.automationMode = builder.automationMode;
        this.resumeFullAutomationModeMinutes = builder.resumeFullAutomationModeMinutes;
        this.networkType = builder.networkType;
    }

    /**
     * <p>
     * The DB instance identifier. This value is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DBInstance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB instance identifier. This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DBInstance.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The new amount of storage in gibibytes (GiB) to allocate for the DB instance.
     * </p>
     * <p>
     * For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current
     * value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10%
     * greater than the current value.
     * </p>
     * <p>
     * For the valid values for allocated storage for each engine, see <code>CreateDBInstance</code>.
     * </p>
     * 
     * @return The new amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
     *         <p>
     *         For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the
     *         current value. Values that are not at least 10% greater than the existing value are rounded up so that
     *         they are 10% greater than the current value.
     *         </p>
     *         <p>
     *         For the valid values for allocated storage for each engine, see <code>CreateDBInstance</code>.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The new compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are
     * available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance
     * classes, and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a>
     * in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * If you modify the DB instance class, an outage occurs during the change. The change is applied during the next
     * maintenance window, unless <code>ApplyImmediately</code> is enabled for this request.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom for Oracle.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * 
     * @return The new compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance
     *         classes are available in all Amazon Web Services Regions, or for all database engines. For the full list
     *         of DB instance classes, and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
     *         Class</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         If you modify the DB instance class, an outage occurs during the change. The change is applied during the
     *         next maintenance window, unless <code>ApplyImmediately</code> is enabled for this request.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom for Oracle.
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different
     * VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC"
     * >Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Changing the subnet group causes an outage during the change. The change is applied during the next maintenance
     * window, unless you enable <code>ApplyImmediately</code>.
     * </p>
     * <p>
     * This parameter doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * </p>
     * <p>
     * Example: <code>mydbsubnetgroup</code>
     * </p>
     * 
     * @return The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a
     *         different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB
     *         instance into a VPC. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC"
     *         >Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         Changing the subnet group causes an outage during the change. The change is applied during the next
     *         maintenance window, unless you enable <code>ApplyImmediately</code>.
     *         </p>
     *         <p>
     *         This parameter doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *         </p>
     *         <p>
     *         Example: <code>mydbsubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBSecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage
     * and the change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match existing DBSecurityGroups.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbSecurityGroups} method.
     * </p>
     * 
     * @return A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an
     *         outage and the change is asynchronously applied as soon as possible.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match existing DBSecurityGroups.
     *         </p>
     *         </li>
     */
    public final List<String> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied
     * as soon as possible.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
     * information, see <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match existing VpcSecurityGroupIds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is asynchronously
     *         applied as soon as possible.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
     *         information, see <code>ModifyDBCluster</code>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match existing VpcSecurityGroupIds.
     *         </p>
     *         </li>
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * A value that indicates whether the modifications in this request and any pending modifications are asynchronously
     * applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB
     * instance. By default, this parameter is disabled.
     * </p>
     * <p>
     * If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some
     * parameter changes can cause an outage and are applied on the next call to <a>RebootDBInstance</a>, or the next
     * failure reboot. Review the table of parameters in <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB
     * Instance</a> in the <i>Amazon RDS User Guide</i> to see the impact of enabling or disabling
     * <code>ApplyImmediately</code> for each modified parameter and to determine when the changes are applied.
     * </p>
     * 
     * @return A value that indicates whether the modifications in this request and any pending modifications are
     *         asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
     *         setting for the DB instance. By default, this parameter is disabled.</p>
     *         <p>
     *         If this parameter is disabled, changes to the DB instance are applied during the next maintenance window.
     *         Some parameter changes can cause an outage and are applied on the next call to <a>RebootDBInstance</a>,
     *         or the next failure reboot. Review the table of parameters in <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html"
     *         >Modifying a DB Instance</a> in the <i>Amazon RDS User Guide</i> to see the impact of enabling or
     *         disabling <code>ApplyImmediately</code> for each modified parameter and to determine when the changes are
     *         applied.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The new password for the master user. The password can include any printable ASCII character except "/",
     * """, or "@".
     * </p>
     * <p>
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     * Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element
     * exists in the <code>PendingModifiedValues</code> element of the operation response.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The password for the master user is managed by the DB cluster. For more information, see
     * <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>Microsoft SQL Server</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 30 characters.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * <note>
     * <p>
     * Amazon RDS API actions never return the password, so this action provides a way to regain access to a primary
     * instance user if the password is lost. This includes restoring privileges that might have been accidentally
     * revoked.
     * </p>
     * </note>
     * 
     * @return The new password for the master user. The password can include any printable ASCII character except "/",
     *         """, or "@".</p>
     *         <p>
     *         Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as
     *         possible. Between the time of the request and the completion of the request, the
     *         <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the
     *         operation response.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The password for the master user is managed by the DB cluster. For more information, see
     *         <code>ModifyDBCluster</code>.
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     *         </p>
     *         <p>
     *         <b>Microsoft SQL Server</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 128 characters.
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 30 characters.
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 128 characters.
     *         </p>
     *         <note>
     *         <p>
     *         Amazon RDS API actions never return the password, so this action provides a way to regain access to a
     *         primary instance user if the password is lost. This includes restoring privileges that might have been
     *         accidentally revoked.
     *         </p>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The name of the DB parameter group to apply to the DB instance.
     * </p>
     * <p>
     * Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but
     * the actual parameter changes are not applied until you reboot the instance without failover. In this case, the DB
     * instance isn't rebooted automatically, and the parameter changes aren't applied during the next maintenance
     * window. However, if you modify dynamic parameters in the newly associated DB parameter group, these changes are
     * applied immediately without a reboot.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * Constraints: The DB parameter group must be in the same DB parameter group family as the DB instance.
     * </p>
     * 
     * @return The name of the DB parameter group to apply to the DB instance.</p>
     *         <p>
     *         Changing this setting doesn't result in an outage. The parameter group name itself is changed
     *         immediately, but the actual parameter changes are not applied until you reboot the instance without
     *         failover. In this case, the DB instance isn't rebooted automatically, and the parameter changes aren't
     *         applied during the next maintenance window. However, if you modify dynamic parameters in the newly
     *         associated DB parameter group, these changes are applied immediately without a reboot.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         Constraints: The DB parameter group must be in the same DB parameter group family as the DB instance.
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * The number of days to retain automated backups. Setting this parameter to a positive number enables backups.
     * Setting this parameter to 0 disables automated backups.
     * </p>
     * <note>
     * <p>
     * Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few
     * minutes, depending on the size and class of your DB instance.
     * </p>
     * </note>
     * <p>
     * These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter
     * is enabled for this request. If you change the parameter from one non-zero value to another non-zero value, the
     * change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The retention period for automated backups is managed by the DB cluster. For more information,
     * see <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must be a value from 0 to 35. It can't be set to 0 if the DB instance is a source to read replicas. It can't
     * be set to 0 or 35 for an RDS Custom for Oracle DB instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * It can be specified for a MySQL read replica only if the source is running MySQL 5.6 or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * It can be specified for a PostgreSQL read replica only if the source is running PostgreSQL 9.3.5.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days to retain automated backups. Setting this parameter to a positive number enables
     *         backups. Setting this parameter to 0 disables automated backups.</p> <note>
     *         <p>
     *         Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a
     *         few minutes, depending on the size and class of your DB instance.
     *         </p>
     *         </note>
     *         <p>
     *         These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code>
     *         parameter is enabled for this request. If you change the parameter from one non-zero value to another
     *         non-zero value, the change is asynchronously applied as soon as possible.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The retention period for automated backups is managed by the DB cluster. For more
     *         information, see <code>ModifyDBCluster</code>.
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must be a value from 0 to 35. It can't be set to 0 if the DB instance is a source to read replicas. It
     *         can't be set to 0 or 35 for an RDS Custom for Oracle DB instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can be specified for a MySQL read replica only if the source is running MySQL 5.6 or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can be specified for a PostgreSQL read replica only if the source is running PostgreSQL 9.3.5.
     *         </p>
     *         </li>
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, as determined
     * by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter doesn't result in an outage and the
     * change is asynchronously applied as soon as possible. The default is a 30-minute window selected at random from
     * an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     * >Backup window</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more
     * information, see <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format hh24:mi-hh24:mi
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Time Coordinated (UTC)
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, as
     *         determined by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter doesn't result in
     *         an outage and the change is asynchronously applied as soon as possible. The default is a 30-minute window
     *         selected at random from an 8-hour block of time for each Amazon Web Services Region. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     *         >Backup window</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For
     *         more information, see <code>ModifyDBCluster</code>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format hh24:mi-hh24:mi
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Time Coordinated (UTC)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
     * Changing this parameter doesn't result in an outage, except in the following situation, and the change is
     * asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance
     * window is changed to include the current time, then changing this parameter will cause a reboot of the DB
     * instance. If moving this window to the current time, there must be at least 30 minutes between the current time
     * and end of the window to ensure pending changes are applied.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     * >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * </p>
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * </p>
     * <p>
     * Constraints: Must be at least 30 minutes
     * </p>
     * 
     * @return The weekly time range (in UTC) during which system maintenance can occur, which might result in an
     *         outage. Changing this parameter doesn't result in an outage, except in the following situation, and the
     *         change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot,
     *         and the maintenance window is changed to include the current time, then changing this parameter will
     *         cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30
     *         minutes between the current time and end of the window to ensure pending changes are applied.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     *         >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         Format: ddd:hh24:mi-ddd:hh24:mi
     *         </p>
     *         <p>
     *         Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *         </p>
     *         <p>
     *         Constraints: Must be at least 30 minutes
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result
     * in an outage. The change is applied during the next maintenance window unless the <code>ApplyImmediately</code>
     * parameter is enabled for this request.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't
     *         result in an outage. The change is applied during the next maintenance window unless the
     *         <code>ApplyImmediately</code> parameter is enabled for this request.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The version number of the database engine to upgrade to. Changing this parameter results in an outage and the
     * change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is
     * enabled for this request.
     * </p>
     * <p>
     * For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group in
     * the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the
     * default for that DB parameter group family.
     * </p>
     * <p>
     * If you specify only a major version, Amazon RDS will update the DB instance to the default minor version if the
     * current minor version is lower. For information about valid engine versions, see <code>CreateDBInstance</code>,
     * or call <code>DescribeDBEngineVersions</code>.
     * </p>
     * <p>
     * In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the
     * <code>PATCH_DB_FAILURE</code> lifecycle.
     * </p>
     * 
     * @return The version number of the database engine to upgrade to. Changing this parameter results in an outage and
     *         the change is applied during the next maintenance window unless the <code>ApplyImmediately</code>
     *         parameter is enabled for this request.</p>
     *         <p>
     *         For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter
     *         group in the DB parameter group family for the new engine version must be specified. The new DB parameter
     *         group can be the default for that DB parameter group family.
     *         </p>
     *         <p>
     *         If you specify only a major version, Amazon RDS will update the DB instance to the default minor version
     *         if the current minor version is lower. For information about valid engine versions, see
     *         <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.
     *         </p>
     *         <p>
     *         In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the
     *         <code>PATCH_DB_FAILURE</code> lifecycle.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an
     * outage and the change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Constraints: Major version upgrades must be allowed when specifying a value for the EngineVersion parameter that
     * is a different major version than the DB instance's current version.
     * </p>
     * 
     * @return A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result
     *         in an outage and the change is asynchronously applied as soon as possible.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Constraints: Major version upgrades must be allowed when specifying a value for the EngineVersion
     *         parameter that is a different major version than the DB instance's current version.
     */
    public final Boolean allowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    /**
     * <p>
     * A value that indicates whether minor version upgrades are applied automatically to the DB instance during the
     * maintenance window. An outage occurs when all the following conditions are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The automatic upgrade is enabled for the maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * A newer minor version is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS has enabled automatic patching for the engine version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, RDS applies the change as soon as possible and doesn't cause an
     * outage.
     * </p>
     * <p>
     * For an RDS Custom DB instance, set <code>AutoMinorVersionUpgrade</code> to <code>false</code>. Otherwise, the
     * operation returns an error.
     * </p>
     * 
     * @return A value that indicates whether minor version upgrades are applied automatically to the DB instance during
     *         the maintenance window. An outage occurs when all the following conditions are met:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The automatic upgrade is enabled for the maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A newer minor version is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS has enabled automatic patching for the engine version.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If any of the preceding conditions isn't met, RDS applies the change as soon as possible and doesn't
     *         cause an outage.
     *         </p>
     *         <p>
     *         For an RDS Custom DB instance, set <code>AutoMinorVersionUpgrade</code> to <code>false</code>. Otherwise,
     *         the operation returns an error.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The license model for the DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     * 
     * @return The license model for the DB instance.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     *         <code>general-public-license</code>
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
     * </p>
     * <p>
     * Changing this setting doesn't result in an outage and the change is applied during the next maintenance window
     * unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you are migrating from
     * Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change
     * in storage type to take effect.
     * </p>
     * <p>
     * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using
     * Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on
     * several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS
     * provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24
     * hours, but the process can take up to several days in some cases. During the migration, the DB instance is
     * available for use, but might experience performance degradation. While the migration takes place, nightly backups
     * for the instance are suspended. No other Amazon RDS operations can take place for the instance, including
     * modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance,
     * and creating a DB snapshot of the instance.
     * </p>
     * <p>
     * Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the
     * current value. Values that are not at least 10% greater than the existing value are rounded up so that they are
     * 10% greater than the current value.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * 
     * @return The new Provisioned IOPS (I/O operations per second) value for the RDS instance.</p>
     *         <p>
     *         Changing this setting doesn't result in an outage and the change is applied during the next maintenance
     *         window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you are
     *         migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a
     *         reboot for the change in storage type to take effect.
     *         </p>
     *         <p>
     *         If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from
     *         using Provisioned IOPS to using standard storage, the process can take time. The duration of the
     *         migration depends on several factors such as database load, storage size, storage type (standard or
     *         Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations.
     *         Typical migration times are under 24 hours, but the process can take up to several days in some cases.
     *         During the migration, the DB instance is available for use, but might experience performance degradation.
     *         While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS
     *         operations can take place for the instance, including modifying the instance, rebooting the instance,
     *         deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the
     *         instance.
     *         </p>
     *         <p>
     *         Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater
     *         than the current value. Values that are not at least 10% greater than the existing value are rounded up
     *         so that they are 10% greater than the current value.
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * A value that indicates the DB instance should be associated with the specified option group.
     * </p>
     * <p>
     * Changing this parameter doesn't result in an outage, with one exception. If the parameter change results in an
     * option group that enables OEM, it can cause a brief period, lasting less than a second, during which new
     * connections are rejected but existing connections aren't interrupted.
     * </p>
     * <p>
     * The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is
     * enabled for this request.
     * </p>
     * <p>
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
     * group, and that option group can't be removed from a DB instance after it is associated with a DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return A value that indicates the DB instance should be associated with the specified option group.</p>
     *         <p>
     *         Changing this parameter doesn't result in an outage, with one exception. If the parameter change results
     *         in an option group that enables OEM, it can cause a brief period, lasting less than a second, during
     *         which new connections are rejected but existing connections aren't interrupted.
     *         </p>
     *         <p>
     *         The change is applied during the next maintenance window unless the <code>ApplyImmediately</code>
     *         parameter is enabled for this request.
     *         </p>
     *         <p>
     *         Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
     *         option group, and that option group can't be removed from a DB instance after it is associated with a DB
     *         instance.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance
     * identifier, an instance reboot occurs immediately if you enable <code>ApplyImmediately</code>, or will occur
     * during the next maintenance window if you disable Apply Immediately. This value is stored as a lowercase string.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbinstance</code>
     * </p>
     * 
     * @return The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB
     *         instance identifier, an instance reboot occurs immediately if you enable <code>ApplyImmediately</code>,
     *         or will occur during the next maintenance window if you disable Apply Immediately. This value is stored
     *         as a lowercase string.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbinstance</code>
     */
    public final String newDBInstanceIdentifier() {
        return newDBInstanceIdentifier;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     * <p>
     * If you specify Provisioned IOPS (<code>io1</code>), you must also include a value for the <code>Iops</code>
     * parameter.
     * </p>
     * <p>
     * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using
     * Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on
     * several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS
     * provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24
     * hours, but the process can take up to several days in some cases. During the migration, the DB instance is
     * available for use, but might experience performance degradation. While the migration takes place, nightly backups
     * for the instance are suspended. No other Amazon RDS operations can take place for the instance, including
     * modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance,
     * and creating a DB snapshot of the instance.
     * </p>
     * <p>
     * Valid values: <code>standard | gp2 | io1</code>
     * </p>
     * <p>
     * Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
     * </p>
     * 
     * @return Specifies the storage type to be associated with the DB instance.</p>
     *         <p>
     *         If you specify Provisioned IOPS (<code>io1</code>), you must also include a value for the
     *         <code>Iops</code> parameter.
     *         </p>
     *         <p>
     *         If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from
     *         using Provisioned IOPS to using standard storage, the process can take time. The duration of the
     *         migration depends on several factors such as database load, storage size, storage type (standard or
     *         Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations.
     *         Typical migration times are under 24 hours, but the process can take up to several days in some cases.
     *         During the migration, the DB instance is available for use, but might experience performance degradation.
     *         While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS
     *         operations can take place for the instance, including modifying the instance, rebooting the instance,
     *         deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the
     *         instance.
     *         </p>
     *         <p>
     *         Valid values: <code>standard | gp2 | io1</code>
     *         </p>
     *         <p>
     *         Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The ARN from the key store with which to associate the instance for TDE encryption.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * The password for the given ARN from the key store in order to access the device.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The password for the given ARN from the key store in order to access the device.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String tdeCredentialPassword() {
        return tdeCredentialPassword;
    }

    /**
     * <p>
     * Specifies the certificate to associate with the DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return Specifies the certificate to associate with the DB instance.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * The Active Directory directory ID to move the DB instance to. Specify <code>none</code> to remove the instance
     * from its current domain. You must create the domain before this operation. Currently, you can create only MySQL,
     * Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     * Authentication</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The Active Directory directory ID to move the DB instance to. Specify <code>none</code> to remove the
     *         instance from its current domain. You must create the domain before this operation. Currently, you can
     *         create only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory
     *         Domain.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     *         Authentication</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default,
     * tags are not copied.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB
     * instance has no effect on the DB cluster setting. For more information, see <code>ModifyDBCluster</code>.
     * </p>
     * 
     * @return A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By
     *         default, tags are not copied.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora
     *         DB instance has no effect on the DB cluster setting. For more information, see
     *         <code>ModifyDBCluster</code>.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To
     * disable collecting Enhanced Monitoring metrics, specify 0, which is the default.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, set <code>MonitoringInterval</code> to a value other than 0.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         instance. To disable collecting Enhanced Monitoring metrics, specify 0, which is the default.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, set <code>MonitoringInterval</code> to a value other than
     *         0.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The port number on which the database accepts connections.
     * </p>
     * <p>
     * The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options
     * in the option group for the DB instance.
     * </p>
     * <p>
     * If you change the <code>DBPortNumber</code> value, your database restarts regardless of the value of the
     * <code>ApplyImmediately</code> parameter.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Default: <code>5432</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * Type: Integer
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Default: <code>1521</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * <b>SQL Server</b>
     * </p>
     * <p>
     * Default: <code>1433</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
     * <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * 
     * @return The port number on which the database accepts connections.</p>
     *         <p>
     *         The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for
     *         options in the option group for the DB instance.
     *         </p>
     *         <p>
     *         If you change the <code>DBPortNumber</code> value, your database restarts regardless of the value of the
     *         <code>ApplyImmediately</code> parameter.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         Default: <code>3306</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         Default: <code>3306</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Default: <code>5432</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Type: Integer
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Default: <code>1521</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         <b>SQL Server</b>
     *         </p>
     *         <p>
     *         Default: <code>1433</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
     *         <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Default: <code>3306</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     */
    public final Integer dbPortNumber() {
        return dbPortNumber;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance is publicly accessible.
     * </p>
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses.
     * That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     * </p>
     * <p>
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * <code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of a public
     * subnet and <code>PubliclyAccessible</code> must be enabled for it to be publicly accessible.
     * </p>
     * <p>
     * Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the value of the
     * <code>ApplyImmediately</code> parameter.
     * </p>
     * 
     * @return A value that indicates whether the DB instance is publicly accessible.</p>
     *         <p>
     *         When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private
     *         IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address
     *         from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security
     *         group it uses. That public access isn't permitted if the security group assigned to the DB cluster
     *         doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
     *         resolves to a private IP address.
     *         </p>
     *         <p>
     *         <code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of a
     *         public subnet and <code>PubliclyAccessible</code> must be enabled for it to be publicly accessible.
     *         </p>
     *         <p>
     *         Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the value
     *         of the <code>ApplyImmediately</code> parameter.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
     * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">
     * To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     *         For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
     *         monitoring role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole"
     *         >To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than 0, supply a
     *         <code>MonitoringRoleArn</code> value.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * The name of the IAM role to use when making API calls to the Directory Service.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The name of the IAM role to use when making API calls to the Directory Service.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure
     * of the existing primary instance. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
     * > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Valid Values: 0 - 15
     * </p>
     * 
     * @return A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a
     *         failure of the existing primary instance. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
     *         > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     *         </p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Valid Values: 0 - 15
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
     * accounts to database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is
     * managed by the DB cluster.
     * </p>
     * <p>
     * For more information about IAM database authentication, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
     *         (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database
     *         accounts is managed by the DB cluster.
     *         </p>
     *         <p>
     *         For more information about IAM database authentication, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     *         Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * A value that indicates whether to enable Performance Insights for the DB instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
     * Insights</a> in the <i>Amazon RDS User Guide.</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return A value that indicates whether to enable Performance Insights for the DB instance.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
     *         Performance Insights</a> in the <i>Amazon RDS User Guide.</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS
     * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
     *         Services account has a different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2
     *         years).</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * <p>
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     * instance.
     * </p>
     * <p>
     * A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB instance
     * immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     *         instance.</p>
     *         <p>
     *         A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB
     *         instance immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration() {
        return cloudwatchLogsExportConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessorFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessorFeatures} method.
     * </p>
     * 
     * @return The number of CPU cores and the number of threads per core for the DB instance class of the DB
     *         instance.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final List<ProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return A value that indicates whether the DB instance class of the DB instance uses its default processor
     *         features.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Boolean useDefaultProcessorFeatures() {
        return useDefaultProcessorFeatures;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted
     * when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     * Instance</a>.
     * </p>
     * 
     * @return A value that indicates whether the DB instance has deletion protection enabled. The database can't be
     *         deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     *         Instance</a>.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * </p>
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
     * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
     *         instance.</p>
     *         <p>
     *         For more information about this setting, including limitations that apply to it, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
     *         > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Integer maxAllocatedStorage() {
        return maxAllocatedStorage;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance is restarted when you rotate your SSL/TLS certificate.
     * </p>
     * <p>
     * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated
     * until the DB instance is restarted.
     * </p>
     * <important>
     * <p>
     * Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.
     * </p>
     * </important>
     * <p>
     * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to
     * rotate your SSL/TLS certificate:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate.</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return A value that indicates whether the DB instance is restarted when you rotate your SSL/TLS certificate.</p>
     *         <p>
     *         By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not
     *         updated until the DB instance is restarted.
     *         </p>
     *         <important>
     *         <p>
     *         Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.
     *         </p>
     *         </important>
     *         <p>
     *         If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB
     *         engine to rotate your SSL/TLS certificate:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     *         Rotating Your SSL/TLS Certificate.</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html"
     *         > Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Boolean certificateRotationRestart() {
        return certificateRotationRestart;
    }

    /**
     * <p>
     * A value that sets the open mode of a replica database to either mounted or read-only.
     * </p>
     * <note>
     * <p>
     * Currently, this parameter is only supported for Oracle DB instances.
     * </p>
     * </note>
     * <p>
     * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is
     * cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the
     * mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read
     * Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaMode} will
     * return {@link ReplicaMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaModeAsString}.
     * </p>
     * 
     * @return A value that sets the open mode of a replica database to either mounted or read-only.</p> <note>
     *         <p>
     *         Currently, this parameter is only supported for Oracle DB instances.
     *         </p>
     *         </note>
     *         <p>
     *         Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is
     *         cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit
     *         information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't
     *         serve a read-only workload. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with
     *         Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     * @see ReplicaMode
     */
    public final ReplicaMode replicaMode() {
        return ReplicaMode.fromValue(replicaMode);
    }

    /**
     * <p>
     * A value that sets the open mode of a replica database to either mounted or read-only.
     * </p>
     * <note>
     * <p>
     * Currently, this parameter is only supported for Oracle DB instances.
     * </p>
     * </note>
     * <p>
     * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is
     * cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the
     * mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read
     * Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaMode} will
     * return {@link ReplicaMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaModeAsString}.
     * </p>
     * 
     * @return A value that sets the open mode of a replica database to either mounted or read-only.</p> <note>
     *         <p>
     *         Currently, this parameter is only supported for Oracle DB instances.
     *         </p>
     *         </note>
     *         <p>
     *         Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is
     *         cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit
     *         information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't
     *         serve a read-only workload. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with
     *         Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     * @see ReplicaMode
     */
    public final String replicaModeAsString() {
        return replicaMode;
    }

    /**
     * <p>
     * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
     * </p>
     * <p>
     * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from
     * outside of its virtual private cloud (VPC) on your local network.
     * </p>
     * <p>
     * For more information about RDS on Outposts, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
     * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about CoIPs, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
     * >Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
     * </p>
     * 
     * @return A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB
     *         instance.</p>
     *         <p>
     *         A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     *         on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB
     *         instance from outside of its virtual private cloud (VPC) on your local network.
     *         </p>
     *         <p>
     *         For more information about RDS on Outposts, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
     *         RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about CoIPs, see <a href=
     *         "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
     *         >Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
     */
    public final Boolean enableCustomerOwnedIp() {
        return enableCustomerOwnedIp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String awsBackupRecoveryPointArn() {
        return awsBackupRecoveryPointArn;
    }

    /**
     * <p>
     * The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
     * <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the
     * instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automationMode}
     * will return {@link AutomationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #automationModeAsString}.
     * </p>
     * 
     * @return The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
     *         <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>
     *         , the instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.
     * @see AutomationMode
     */
    public final AutomationMode automationMode() {
        return AutomationMode.fromValue(automationMode);
    }

    /**
     * <p>
     * The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
     * <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the
     * instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automationMode}
     * will return {@link AutomationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #automationModeAsString}.
     * </p>
     * 
     * @return The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
     *         <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>
     *         , the instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.
     * @see AutomationMode
     */
    public final String automationModeAsString() {
        return automationMode;
    }

    /**
     * <p>
     * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The
     * minimum value is <code>60</code> (default). The maximum value is <code>1,440</code>.
     * </p>
     * 
     * @return The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full
     *         automation. The minimum value is <code>60</code> (default). The maximum value is <code>1,440</code>.
     */
    public final Integer resumeFullAutomationModeMinutes() {
        return resumeFullAutomationModeMinutes;
    }

    /**
     * <p>
     * The network type of the DB instance.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DUAL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
     * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     * <code>DUAL</code>).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working
     * with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The network type of the DB instance.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DUAL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
     *         <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     *         <code>DUAL</code>).
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
     *         Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String networkType() {
        return networkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(newDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialPassword());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(dbPortNumber());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogsExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(certificateRotationRestart());
        hashCode = 31 * hashCode + Objects.hashCode(replicaModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableCustomerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(awsBackupRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(automationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resumeFullAutomationModeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbInstanceRequest)) {
            return false;
        }
        ModifyDbInstanceRequest other = (ModifyDbInstanceRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(newDBInstanceIdentifier(), other.newDBInstanceIdentifier())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn())
                && Objects.equals(tdeCredentialPassword(), other.tdeCredentialPassword())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(domain(), other.domain()) && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(dbPortNumber(), other.dbPortNumber())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(promotionTier(), other.promotionTier())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && Objects.equals(cloudwatchLogsExportConfiguration(), other.cloudwatchLogsExportConfiguration())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures())
                && Objects.equals(useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(maxAllocatedStorage(), other.maxAllocatedStorage())
                && Objects.equals(certificateRotationRestart(), other.certificateRotationRestart())
                && Objects.equals(replicaModeAsString(), other.replicaModeAsString())
                && Objects.equals(enableCustomerOwnedIp(), other.enableCustomerOwnedIp())
                && Objects.equals(awsBackupRecoveryPointArn(), other.awsBackupRecoveryPointArn())
                && Objects.equals(automationModeAsString(), other.automationModeAsString())
                && Objects.equals(resumeFullAutomationModeMinutes(), other.resumeFullAutomationModeMinutes())
                && Objects.equals(networkType(), other.networkType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbInstanceRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("AllocatedStorage", allocatedStorage()).add("DBInstanceClass", dbInstanceClass())
                .add("DBSubnetGroupName", dbSubnetGroupName())
                .add("DBSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("ApplyImmediately", applyImmediately()).add("MasterUserPassword", masterUserPassword())
                .add("DBParameterGroupName", dbParameterGroupName()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("AllowMajorVersionUpgrade", allowMajorVersionUpgrade())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("LicenseModel", licenseModel())
                .add("Iops", iops()).add("OptionGroupName", optionGroupName())
                .add("NewDBInstanceIdentifier", newDBInstanceIdentifier()).add("StorageType", storageType())
                .add("TdeCredentialArn", tdeCredentialArn()).add("TdeCredentialPassword", tdeCredentialPassword())
                .add("CACertificateIdentifier", caCertificateIdentifier()).add("Domain", domain())
                .add("CopyTagsToSnapshot", copyTagsToSnapshot()).add("MonitoringInterval", monitoringInterval())
                .add("DBPortNumber", dbPortNumber()).add("PubliclyAccessible", publiclyAccessible())
                .add("MonitoringRoleArn", monitoringRoleArn()).add("DomainIAMRoleName", domainIAMRoleName())
                .add("PromotionTier", promotionTier()).add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("CloudwatchLogsExportConfiguration", cloudwatchLogsExportConfiguration())
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null)
                .add("UseDefaultProcessorFeatures", useDefaultProcessorFeatures())
                .add("DeletionProtection", deletionProtection()).add("MaxAllocatedStorage", maxAllocatedStorage())
                .add("CertificateRotationRestart", certificateRotationRestart()).add("ReplicaMode", replicaModeAsString())
                .add("EnableCustomerOwnedIp", enableCustomerOwnedIp())
                .add("AwsBackupRecoveryPointArn", awsBackupRecoveryPointArn()).add("AutomationMode", automationModeAsString())
                .add("ResumeFullAutomationModeMinutes", resumeFullAutomationModeMinutes()).add("NetworkType", networkType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "DBSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AllowMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpgrade()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "NewDBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(newDBInstanceIdentifier()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "TdeCredentialPassword":
            return Optional.ofNullable(clazz.cast(tdeCredentialPassword()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "DBPortNumber":
            return Optional.ofNullable(clazz.cast(dbPortNumber()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "CloudwatchLogsExportConfiguration":
            return Optional.ofNullable(clazz.cast(cloudwatchLogsExportConfiguration()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        case "UseDefaultProcessorFeatures":
            return Optional.ofNullable(clazz.cast(useDefaultProcessorFeatures()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "MaxAllocatedStorage":
            return Optional.ofNullable(clazz.cast(maxAllocatedStorage()));
        case "CertificateRotationRestart":
            return Optional.ofNullable(clazz.cast(certificateRotationRestart()));
        case "ReplicaMode":
            return Optional.ofNullable(clazz.cast(replicaModeAsString()));
        case "EnableCustomerOwnedIp":
            return Optional.ofNullable(clazz.cast(enableCustomerOwnedIp()));
        case "AwsBackupRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(awsBackupRecoveryPointArn()));
        case "AutomationMode":
            return Optional.ofNullable(clazz.cast(automationModeAsString()));
        case "ResumeFullAutomationModeMinutes":
            return Optional.ofNullable(clazz.cast(resumeFullAutomationModeMinutes()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbInstanceRequest, T> g) {
        return obj -> g.apply((ModifyDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbInstanceRequest> {
        /**
         * <p>
         * The DB instance identifier. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DBInstance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DBInstance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The new amount of storage in gibibytes (GiB) to allocate for the DB instance.
         * </p>
         * <p>
         * For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current
         * value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10%
         * greater than the current value.
         * </p>
         * <p>
         * For the valid values for allocated storage for each engine, see <code>CreateDBInstance</code>.
         * </p>
         * 
         * @param allocatedStorage
         *        The new amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
         *        <p>
         *        For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the
         *        current value. Values that are not at least 10% greater than the existing value are rounded up so that
         *        they are 10% greater than the current value.
         *        </p>
         *        <p>
         *        For the valid values for allocated storage for each engine, see <code>CreateDBInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The new compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes
         * are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB
         * instance classes, and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
         * Class</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * If you modify the DB instance class, an outage occurs during the change. The change is applied during the
         * next maintenance window, unless <code>ApplyImmediately</code> is enabled for this request.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom for Oracle.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * 
         * @param dbInstanceClass
         *        The new compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance
         *        classes are available in all Amazon Web Services Regions, or for all database engines. For the full
         *        list of DB instance classes, and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        If you modify the DB instance class, an outage occurs during the change. The change is applied during
         *        the next maintenance window, unless <code>ApplyImmediately</code> is enabled for this request.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom for Oracle.
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a
         * different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance
         * into a VPC. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC"
         * >Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Changing the subnet group causes an outage during the change. The change is applied during the next
         * maintenance window, unless you enable <code>ApplyImmediately</code>.
         * </p>
         * <p>
         * This parameter doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * </p>
         * <p>
         * Example: <code>mydbsubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a
         *        different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB
         *        instance into a VPC. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC"
         *        >Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        Changing the subnet group causes an outage during the change. The change is applied during the next
         *        maintenance window, unless you enable <code>ApplyImmediately</code>.
         *        </p>
         *        <p>
         *        This parameter doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *        </p>
         *        <p>
         *        Example: <code>mydbsubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an
         * outage and the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing DBSecurityGroups.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in
         *        an outage and the change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing DBSecurityGroups.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<String> dbSecurityGroups);

        /**
         * <p>
         * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an
         * outage and the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing DBSecurityGroups.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in
         *        an outage and the change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing DBSecurityGroups.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(String... dbSecurityGroups);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is asynchronously
         * applied as soon as possible.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         * information, see <code>ModifyDBCluster</code>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing VpcSecurityGroupIds.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is
         *        asynchronously applied as soon as possible.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         *        information, see <code>ModifyDBCluster</code>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing VpcSecurityGroupIds.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is asynchronously
         * applied as soon as possible.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         * information, see <code>ModifyDBCluster</code>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing VpcSecurityGroupIds.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is
         *        asynchronously applied as soon as possible.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         *        information, see <code>ModifyDBCluster</code>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing VpcSecurityGroupIds.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * A value that indicates whether the modifications in this request and any pending modifications are
         * asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting
         * for the DB instance. By default, this parameter is disabled.
         * </p>
         * <p>
         * If this parameter is disabled, changes to the DB instance are applied during the next maintenance window.
         * Some parameter changes can cause an outage and are applied on the next call to <a>RebootDBInstance</a>, or
         * the next failure reboot. Review the table of parameters in <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a
         * DB Instance</a> in the <i>Amazon RDS User Guide</i> to see the impact of enabling or disabling
         * <code>ApplyImmediately</code> for each modified parameter and to determine when the changes are applied.
         * </p>
         * 
         * @param applyImmediately
         *        A value that indicates whether the modifications in this request and any pending modifications are
         *        asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
         *        setting for the DB instance. By default, this parameter is disabled.</p>
         *        <p>
         *        If this parameter is disabled, changes to the DB instance are applied during the next maintenance
         *        window. Some parameter changes can cause an outage and are applied on the next call to
         *        <a>RebootDBInstance</a>, or the next failure reboot. Review the table of parameters in <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html"
         *        >Modifying a DB Instance</a> in the <i>Amazon RDS User Guide</i> to see the impact of enabling or
         *        disabling <code>ApplyImmediately</code> for each modified parameter and to determine when the changes
         *        are applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The new password for the master user. The password can include any printable ASCII character except "/",
         * """, or "@".
         * </p>
         * <p>
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as
         * possible. Between the time of the request and the completion of the request, the
         * <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the
         * operation response.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The password for the master user is managed by the DB cluster. For more information, see
         * <code>ModifyDBCluster</code>.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * <p>
         * <b>Microsoft SQL Server</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 30 characters.
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * </p>
         * <note>
         * <p>
         * Amazon RDS API actions never return the password, so this action provides a way to regain access to a primary
         * instance user if the password is lost. This includes restoring privileges that might have been accidentally
         * revoked.
         * </p>
         * </note>
         * 
         * @param masterUserPassword
         *        The new password for the master user. The password can include any printable ASCII character except
         *        "/", """, or "@".</p>
         *        <p>
         *        Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon
         *        as possible. Between the time of the request and the completion of the request, the
         *        <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of
         *        the operation response.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The password for the master user is managed by the DB cluster. For more information,
         *        see <code>ModifyDBCluster</code>.
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         *        </p>
         *        <p>
         *        <b>Microsoft SQL Server</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 128 characters.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 30 characters.
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 128 characters.
         *        </p>
         *        <note>
         *        <p>
         *        Amazon RDS API actions never return the password, so this action provides a way to regain access to a
         *        primary instance user if the password is lost. This includes restoring privileges that might have been
         *        accidentally revoked.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The name of the DB parameter group to apply to the DB instance.
         * </p>
         * <p>
         * Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately,
         * but the actual parameter changes are not applied until you reboot the instance without failover. In this
         * case, the DB instance isn't rebooted automatically, and the parameter changes aren't applied during the next
         * maintenance window. However, if you modify dynamic parameters in the newly associated DB parameter group,
         * these changes are applied immediately without a reboot.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * Constraints: The DB parameter group must be in the same DB parameter group family as the DB instance.
         * </p>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group to apply to the DB instance.</p>
         *        <p>
         *        Changing this setting doesn't result in an outage. The parameter group name itself is changed
         *        immediately, but the actual parameter changes are not applied until you reboot the instance without
         *        failover. In this case, the DB instance isn't rebooted automatically, and the parameter changes aren't
         *        applied during the next maintenance window. However, if you modify dynamic parameters in the newly
         *        associated DB parameter group, these changes are applied immediately without a reboot.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        Constraints: The DB parameter group must be in the same DB parameter group family as the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * The number of days to retain automated backups. Setting this parameter to a positive number enables backups.
         * Setting this parameter to 0 disables automated backups.
         * </p>
         * <note>
         * <p>
         * Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few
         * minutes, depending on the size and class of your DB instance.
         * </p>
         * </note>
         * <p>
         * These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code>
         * parameter is enabled for this request. If you change the parameter from one non-zero value to another
         * non-zero value, the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The retention period for automated backups is managed by the DB cluster. For more
         * information, see <code>ModifyDBCluster</code>.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must be a value from 0 to 35. It can't be set to 0 if the DB instance is a source to read replicas. It
         * can't be set to 0 or 35 for an RDS Custom for Oracle DB instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * It can be specified for a MySQL read replica only if the source is running MySQL 5.6 or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * It can be specified for a PostgreSQL read replica only if the source is running PostgreSQL 9.3.5.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days to retain automated backups. Setting this parameter to a positive number enables
         *        backups. Setting this parameter to 0 disables automated backups.</p> <note>
         *        <p>
         *        Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a
         *        few minutes, depending on the size and class of your DB instance.
         *        </p>
         *        </note>
         *        <p>
         *        These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code>
         *        parameter is enabled for this request. If you change the parameter from one non-zero value to another
         *        non-zero value, the change is asynchronously applied as soon as possible.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The retention period for automated backups is managed by the DB cluster. For more
         *        information, see <code>ModifyDBCluster</code>.
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must be a value from 0 to 35. It can't be set to 0 if the DB instance is a source to read replicas.
         *        It can't be set to 0 or 35 for an RDS Custom for Oracle DB instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can be specified for a MySQL read replica only if the source is running MySQL 5.6 or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can be specified for a PostgreSQL read replica only if the source is running PostgreSQL 9.3.5.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, as
         * determined by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter doesn't result in an
         * outage and the change is asynchronously applied as soon as possible. The default is a 30-minute window
         * selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         * >Backup window</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more
         * information, see <code>ModifyDBCluster</code>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format hh24:mi-hh24:mi
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Time Coordinated (UTC)
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled, as
         *        determined by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter doesn't result
         *        in an outage and the change is asynchronously applied as soon as possible. The default is a 30-minute
         *        window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         *        >Backup window</a> in the <i>Amazon RDS User Guide.</i> </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For
         *        more information, see <code>ModifyDBCluster</code>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format hh24:mi-hh24:mi
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Time Coordinated (UTC)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
         * Changing this parameter doesn't result in an outage, except in the following situation, and the change is
         * asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the
         * maintenance window is changed to include the current time, then changing this parameter will cause a reboot
         * of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the
         * current time and end of the window to ensure pending changes are applied.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         * >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * </p>
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * </p>
         * <p>
         * Constraints: Must be at least 30 minutes
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which system maintenance can occur, which might result in an
         *        outage. Changing this parameter doesn't result in an outage, except in the following situation, and
         *        the change is asynchronously applied as soon as possible. If there are pending actions that cause a
         *        reboot, and the maintenance window is changed to include the current time, then changing this
         *        parameter will cause a reboot of the DB instance. If moving this window to the current time, there
         *        must be at least 30 minutes between the current time and end of the window to ensure pending changes
         *        are applied.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         *        >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        Format: ddd:hh24:mi-ddd:hh24:mi
         *        </p>
         *        <p>
         *        Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *        </p>
         *        <p>
         *        Constraints: Must be at least 30 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't
         * result in an outage. The change is applied during the next maintenance window unless the
         * <code>ApplyImmediately</code> parameter is enabled for this request.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param multiAZ
         *        A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter
         *        doesn't result in an outage. The change is applied during the next maintenance window unless the
         *        <code>ApplyImmediately</code> parameter is enabled for this request.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The version number of the database engine to upgrade to. Changing this parameter results in an outage and the
         * change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is
         * enabled for this request.
         * </p>
         * <p>
         * For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group
         * in the DB parameter group family for the new engine version must be specified. The new DB parameter group can
         * be the default for that DB parameter group family.
         * </p>
         * <p>
         * If you specify only a major version, Amazon RDS will update the DB instance to the default minor version if
         * the current minor version is lower. For information about valid engine versions, see
         * <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.
         * </p>
         * <p>
         * In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the
         * <code>PATCH_DB_FAILURE</code> lifecycle.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to upgrade to. Changing this parameter results in an outage
         *        and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code>
         *        parameter is enabled for this request.</p>
         *        <p>
         *        For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter
         *        group in the DB parameter group family for the new engine version must be specified. The new DB
         *        parameter group can be the default for that DB parameter group family.
         *        </p>
         *        <p>
         *        If you specify only a major version, Amazon RDS will update the DB instance to the default minor
         *        version if the current minor version is lower. For information about valid engine versions, see
         *        <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.
         *        </p>
         *        <p>
         *        In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the
         *        <code>PATCH_DB_FAILURE</code> lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in
         * an outage and the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Constraints: Major version upgrades must be allowed when specifying a value for the EngineVersion parameter
         * that is a different major version than the DB instance's current version.
         * </p>
         * 
         * @param allowMajorVersionUpgrade
         *        A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't
         *        result in an outage and the change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Constraints: Major version upgrades must be allowed when specifying a value for the EngineVersion
         *        parameter that is a different major version than the DB instance's current version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade);

        /**
         * <p>
         * A value that indicates whether minor version upgrades are applied automatically to the DB instance during the
         * maintenance window. An outage occurs when all the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The automatic upgrade is enabled for the maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * A newer minor version is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS has enabled automatic patching for the engine version.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, RDS applies the change as soon as possible and doesn't cause an
         * outage.
         * </p>
         * <p>
         * For an RDS Custom DB instance, set <code>AutoMinorVersionUpgrade</code> to <code>false</code>. Otherwise, the
         * operation returns an error.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        A value that indicates whether minor version upgrades are applied automatically to the DB instance
         *        during the maintenance window. An outage occurs when all the following conditions are met:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The automatic upgrade is enabled for the maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A newer minor version is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS has enabled automatic patching for the engine version.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If any of the preceding conditions isn't met, RDS applies the change as soon as possible and doesn't
         *        cause an outage.
         *        </p>
         *        <p>
         *        For an RDS Custom DB instance, set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.
         *        Otherwise, the operation returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The license model for the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
         * <code>general-public-license</code>
         * </p>
         * 
         * @param licenseModel
         *        The license model for the DB instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
         *        <code>general-public-license</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
         * </p>
         * <p>
         * Changing this setting doesn't result in an outage and the change is applied during the next maintenance
         * window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you are migrating
         * from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the
         * change in storage type to take effect.
         * </p>
         * <p>
         * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from
         * using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration
         * depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS),
         * amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration
         * times are under 24 hours, but the process can take up to several days in some cases. During the migration,
         * the DB instance is available for use, but might experience performance degradation. While the migration takes
         * place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the
         * instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read
         * replica for the instance, and creating a DB snapshot of the instance.
         * </p>
         * <p>
         * Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than
         * the current value. Values that are not at least 10% greater than the existing value are rounded up so that
         * they are 10% greater than the current value.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * 
         * @param iops
         *        The new Provisioned IOPS (I/O operations per second) value for the RDS instance.</p>
         *        <p>
         *        Changing this setting doesn't result in an outage and the change is applied during the next
         *        maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If
         *        you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will
         *        require a reboot for the change in storage type to take effect.
         *        </p>
         *        <p>
         *        If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or
         *        from using Provisioned IOPS to using standard storage, the process can take time. The duration of the
         *        migration depends on several factors such as database load, storage size, storage type (standard or
         *        Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage
         *        operations. Typical migration times are under 24 hours, but the process can take up to several days in
         *        some cases. During the migration, the DB instance is available for use, but might experience
         *        performance degradation. While the migration takes place, nightly backups for the instance are
         *        suspended. No other Amazon RDS operations can take place for the instance, including modifying the
         *        instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and
         *        creating a DB snapshot of the instance.
         *        </p>
         *        <p>
         *        Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10%
         *        greater than the current value. Values that are not at least 10% greater than the existing value are
         *        rounded up so that they are 10% greater than the current value.
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * A value that indicates the DB instance should be associated with the specified option group.
         * </p>
         * <p>
         * Changing this parameter doesn't result in an outage, with one exception. If the parameter change results in
         * an option group that enables OEM, it can cause a brief period, lasting less than a second, during which new
         * connections are rejected but existing connections aren't interrupted.
         * </p>
         * <p>
         * The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter
         * is enabled for this request.
         * </p>
         * <p>
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
         * group, and that option group can't be removed from a DB instance after it is associated with a DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param optionGroupName
         *        A value that indicates the DB instance should be associated with the specified option group.</p>
         *        <p>
         *        Changing this parameter doesn't result in an outage, with one exception. If the parameter change
         *        results in an option group that enables OEM, it can cause a brief period, lasting less than a second,
         *        during which new connections are rejected but existing connections aren't interrupted.
         *        </p>
         *        <p>
         *        The change is applied during the next maintenance window unless the <code>ApplyImmediately</code>
         *        parameter is enabled for this request.
         *        </p>
         *        <p>
         *        Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
         *        option group, and that option group can't be removed from a DB instance after it is associated with a
         *        DB instance.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB
         * instance identifier, an instance reboot occurs immediately if you enable <code>ApplyImmediately</code>, or
         * will occur during the next maintenance window if you disable Apply Immediately. This value is stored as a
         * lowercase string.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbinstance</code>
         * </p>
         * 
         * @param newDBInstanceIdentifier
         *        The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB
         *        instance identifier, an instance reboot occurs immediately if you enable <code>ApplyImmediately</code>
         *        , or will occur during the next maintenance window if you disable Apply Immediately. This value is
         *        stored as a lowercase string.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbinstance</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBInstanceIdentifier(String newDBInstanceIdentifier);

        /**
         * <p>
         * Specifies the storage type to be associated with the DB instance.
         * </p>
         * <p>
         * If you specify Provisioned IOPS (<code>io1</code>), you must also include a value for the <code>Iops</code>
         * parameter.
         * </p>
         * <p>
         * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from
         * using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration
         * depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS),
         * amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration
         * times are under 24 hours, but the process can take up to several days in some cases. During the migration,
         * the DB instance is available for use, but might experience performance degradation. While the migration takes
         * place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the
         * instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read
         * replica for the instance, and creating a DB snapshot of the instance.
         * </p>
         * <p>
         * Valid values: <code>standard | gp2 | io1</code>
         * </p>
         * <p>
         * Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type to be associated with the DB instance.</p>
         *        <p>
         *        If you specify Provisioned IOPS (<code>io1</code>), you must also include a value for the
         *        <code>Iops</code> parameter.
         *        </p>
         *        <p>
         *        If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or
         *        from using Provisioned IOPS to using standard storage, the process can take time. The duration of the
         *        migration depends on several factors such as database load, storage size, storage type (standard or
         *        Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage
         *        operations. Typical migration times are under 24 hours, but the process can take up to several days in
         *        some cases. During the migration, the DB instance is available for use, but might experience
         *        performance degradation. While the migration takes place, nightly backups for the instance are
         *        suspended. No other Amazon RDS operations can take place for the instance, including modifying the
         *        instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and
         *        creating a DB snapshot of the instance.
         *        </p>
         *        <p>
         *        Valid values: <code>standard | gp2 | io1</code>
         *        </p>
         *        <p>
         *        Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The ARN from the key store with which to associate the instance for TDE encryption.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which to associate the instance for TDE encryption.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * The password for the given ARN from the key store in order to access the device.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param tdeCredentialPassword
         *        The password for the given ARN from the key store in order to access the device.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialPassword(String tdeCredentialPassword);

        /**
         * <p>
         * Specifies the certificate to associate with the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        Specifies the certificate to associate with the DB instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * The Active Directory directory ID to move the DB instance to. Specify <code>none</code> to remove the
         * instance from its current domain. You must create the domain before this operation. Currently, you can create
         * only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         * Authentication</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param domain
         *        The Active Directory directory ID to move the DB instance to. Specify <code>none</code> to remove the
         *        instance from its current domain. You must create the domain before this operation. Currently, you can
         *        create only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory
         *        Domain.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         *        Authentication</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By
         * default, tags are not copied.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB
         * instance has no effect on the DB cluster setting. For more information, see <code>ModifyDBCluster</code>.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance.
         *        By default, tags are not copied.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an
         *        Aurora DB instance has no effect on the DB cluster setting. For more information, see
         *        <code>ModifyDBCluster</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * To disable collecting Enhanced Monitoring metrics, specify 0, which is the default.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, set <code>MonitoringInterval</code> to a value other than 0.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        instance. To disable collecting Enhanced Monitoring metrics, specify 0, which is the default.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, set <code>MonitoringInterval</code> to a value other
         *        than 0.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The port number on which the database accepts connections.
         * </p>
         * <p>
         * The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for
         * options in the option group for the DB instance.
         * </p>
         * <p>
         * If you change the <code>DBPortNumber</code> value, your database restarts regardless of the value of the
         * <code>ApplyImmediately</code> parameter.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Default: <code>5432</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * Type: Integer
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Default: <code>1521</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * <b>SQL Server</b>
         * </p>
         * <p>
         * Default: <code>1433</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
         * <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * 
         * @param dbPortNumber
         *        The port number on which the database accepts connections.</p>
         *        <p>
         *        The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified
         *        for options in the option group for the DB instance.
         *        </p>
         *        <p>
         *        If you change the <code>DBPortNumber</code> value, your database restarts regardless of the value of
         *        the <code>ApplyImmediately</code> parameter.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Default: <code>3306</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Default: <code>3306</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Default: <code>5432</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Type: Integer
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Default: <code>1521</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        <b>SQL Server</b>
         *        </p>
         *        <p>
         *        Default: <code>1433</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
         *        <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Default: <code>3306</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPortNumber(Integer dbPortNumber);

        /**
         * <p>
         * A value that indicates whether the DB instance is publicly accessible.
         * </p>
         * <p>
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
         * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
         * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it
         * uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         * </p>
         * <p>
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves
         * to a private IP address.
         * </p>
         * <p>
         * <code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of a
         * public subnet and <code>PubliclyAccessible</code> must be enabled for it to be publicly accessible.
         * </p>
         * <p>
         * Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the value of
         * the <code>ApplyImmediately</code> parameter.
         * </p>
         * 
         * @param publiclyAccessible
         *        A value that indicates whether the DB instance is publicly accessible.</p>
         *        <p>
         *        When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public
         *        IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by
         *        the security group it uses. That public access isn't permitted if the security group assigned to the
         *        DB cluster doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        <code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of
         *        a public subnet and <code>PubliclyAccessible</code> must be enabled for it to be publicly accessible.
         *        </p>
         *        <p>
         *        Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the
         *        value of the <code>ApplyImmediately</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
         * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
         * see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
         * create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code>
         * value.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch
         *        Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
         *        monitoring role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole"
         *        >To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than 0, supply a
         *        <code>MonitoringRoleArn</code> value.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * The name of the IAM role to use when making API calls to the Directory Service.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param domainIAMRoleName
         *        The name of the IAM role to use when making API calls to the Directory Service.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a
         * failure of the existing primary instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
         * > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Valid Values: 0 - 15
         * </p>
         * 
         * @param promotionTier
         *        A value that specifies the order in which an Aurora Replica is promoted to the primary instance after
         *        a failure of the existing primary instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
         *        > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         *        </p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Valid Values: 0 - 15
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         * accounts to database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is
         * managed by the DB cluster.
         * </p>
         * <p>
         * For more information about IAM database authentication, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
         *        (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database
         *        accounts is managed by the DB cluster.
         *        </p>
         *        <p>
         *        For more information about IAM database authentication, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * A value that indicates whether to enable Performance Insights for the DB instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
         * Insights</a> in the <i>Amazon RDS User Guide.</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param enablePerformanceInsights
         *        A value that indicates whether to enable Performance Insights for the DB instance.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
         *        Performance Insights</a> in the <i>Amazon RDS User Guide.</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2
         *        years).</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * instance.
         * </p>
         * <p>
         * A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB instance
         * immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param cloudwatchLogsExportConfiguration
         *        The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific
         *        DB instance.</p>
         *        <p>
         *        A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB
         *        instance immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * instance.
         * </p>
         * <p>
         * A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB instance
         * immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CloudwatchLogsExportConfiguration.Builder} avoiding the need to create one manually via
         * {@link CloudwatchLogsExportConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchLogsExportConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)}.
         * 
         * @param cloudwatchLogsExportConfiguration
         *        a consumer that will call methods on {@link CloudwatchLogsExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)
         */
        default Builder cloudwatchLogsExportConfiguration(
                Consumer<CloudwatchLogsExportConfiguration.Builder> cloudwatchLogsExportConfiguration) {
            return cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration.builder()
                    .applyMutation(cloudwatchLogsExportConfiguration).build());
        }

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<ProcessorFeature> processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(ProcessorFeature... processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProcessorFeature>.Builder} avoiding
         * the need to create one manually via {@link List<ProcessorFeature>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessorFeature>.Builder#build()} is called immediately and
         * its result is passed to {@link #processorFeatures(List<ProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on {@link List<ProcessorFeature>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(List<ProcessorFeature>)
         */
        Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures);

        /**
         * <p>
         * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param useDefaultProcessorFeatures
         *        A value that indicates whether the DB instance class of the DB instance uses its default processor
         *        features.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures);

        /**
         * <p>
         * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted
         * when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         * Instance</a>.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the DB instance has deletion protection enabled. The database can't be
         *        deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         *        Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         * instance.
         * </p>
         * <p>
         * For more information about this setting, including limitations that apply to it, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
         * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param maxAllocatedStorage
         *        The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         *        instance.</p>
         *        <p>
         *        For more information about this setting, including limitations that apply to it, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
         *        > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllocatedStorage(Integer maxAllocatedStorage);

        /**
         * <p>
         * A value that indicates whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         * </p>
         * <p>
         * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not
         * updated until the DB instance is restarted.
         * </p>
         * <important>
         * <p>
         * Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.
         * </p>
         * </important>
         * <p>
         * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB
         * engine to rotate your SSL/TLS certificate:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
         * Rotating Your SSL/TLS Certificate.</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
         * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param certificateRotationRestart
         *        A value that indicates whether the DB instance is restarted when you rotate your SSL/TLS
         *        certificate.</p>
         *        <p>
         *        By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is
         *        not updated until the DB instance is restarted.
         *        </p>
         *        <important>
         *        <p>
         *        Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.
         *        </p>
         *        </important>
         *        <p>
         *        If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your
         *        DB engine to rotate your SSL/TLS certificate:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
         *        Rotating Your SSL/TLS Certificate.</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html"
         *        > Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateRotationRestart(Boolean certificateRotationRestart);

        /**
         * <p>
         * A value that sets the open mode of a replica database to either mounted or read-only.
         * </p>
         * <note>
         * <p>
         * Currently, this parameter is only supported for Oracle DB instances.
         * </p>
         * </note>
         * <p>
         * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is
         * cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to
         * the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only
         * workload. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle
         * Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param replicaMode
         *        A value that sets the open mode of a replica database to either mounted or read-only.</p> <note>
         *        <p>
         *        Currently, this parameter is only supported for Oracle DB instances.
         *        </p>
         *        </note>
         *        <p>
         *        Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas
         *        is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit
         *        information to the mounted replica. Because it doesn't accept user connections, a mounted replica
         *        can't serve a read-only workload. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with
         *        Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @see ReplicaMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaMode
         */
        Builder replicaMode(String replicaMode);

        /**
         * <p>
         * A value that sets the open mode of a replica database to either mounted or read-only.
         * </p>
         * <note>
         * <p>
         * Currently, this parameter is only supported for Oracle DB instances.
         * </p>
         * </note>
         * <p>
         * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is
         * cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to
         * the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only
         * workload. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle
         * Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param replicaMode
         *        A value that sets the open mode of a replica database to either mounted or read-only.</p> <note>
         *        <p>
         *        Currently, this parameter is only supported for Oracle DB instances.
         *        </p>
         *        </note>
         *        <p>
         *        Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas
         *        is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit
         *        information to the mounted replica. Because it doesn't accept user connections, a mounted replica
         *        can't serve a read-only workload. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with
         *        Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @see ReplicaMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaMode
         */
        Builder replicaMode(ReplicaMode replicaMode);

        /**
         * <p>
         * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB
         * instance.
         * </p>
         * <p>
         * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
         * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance
         * from outside of its virtual private cloud (VPC) on your local network.
         * </p>
         * <p>
         * For more information about RDS on Outposts, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
         * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about CoIPs, see <a href=
         * "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
         * >Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
         * </p>
         * 
         * @param enableCustomerOwnedIp
         *        A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB
         *        instance.</p>
         *        <p>
         *        A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through
         *        your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the
         *        DB instance from outside of its virtual private cloud (VPC) on your local network.
         *        </p>
         *        <p>
         *        For more information about RDS on Outposts, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
         *        RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about CoIPs, see <a href=
         *        "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
         *        >Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param awsBackupRecoveryPointArn
         *        The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn);

        /**
         * <p>
         * The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
         * <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>,
         * the instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.
         * </p>
         * 
         * @param automationMode
         *        The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
         *        <code>full</code>, the DB instance automates monitoring and instance recovery. If
         *        <code>all paused</code>, the instance pauses automation for the duration set by
         *        <code>ResumeFullAutomationModeMinutes</code>.
         * @see AutomationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationMode
         */
        Builder automationMode(String automationMode);

        /**
         * <p>
         * The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
         * <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>,
         * the instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.
         * </p>
         * 
         * @param automationMode
         *        The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If
         *        <code>full</code>, the DB instance automates monitoring and instance recovery. If
         *        <code>all paused</code>, the instance pauses automation for the duration set by
         *        <code>ResumeFullAutomationModeMinutes</code>.
         * @see AutomationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationMode
         */
        Builder automationMode(AutomationMode automationMode);

        /**
         * <p>
         * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation.
         * The minimum value is <code>60</code> (default). The maximum value is <code>1,440</code>.
         * </p>
         * 
         * @param resumeFullAutomationModeMinutes
         *        The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full
         *        automation. The minimum value is <code>60</code> (default). The maximum value is <code>1,440</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeFullAutomationModeMinutes(Integer resumeFullAutomationModeMinutes);

        /**
         * <p>
         * The network type of the DB instance.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DUAL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
         * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         * <code>DUAL</code>).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         * Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param networkType
         *        The network type of the DB instance.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DUAL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
         *        <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         *        <code>DUAL</code>).
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         *        Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private Integer allocatedStorage;

        private String dbInstanceClass;

        private String dbSubnetGroupName;

        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyImmediately;

        private String masterUserPassword;

        private String dbParameterGroupName;

        private Integer backupRetentionPeriod;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean allowMajorVersionUpgrade;

        private Boolean autoMinorVersionUpgrade;

        private String licenseModel;

        private Integer iops;

        private String optionGroupName;

        private String newDBInstanceIdentifier;

        private String storageType;

        private String tdeCredentialArn;

        private String tdeCredentialPassword;

        private String caCertificateIdentifier;

        private String domain;

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private Integer dbPortNumber;

        private Boolean publiclyAccessible;

        private String monitoringRoleArn;

        private String domainIAMRoleName;

        private Integer promotionTier;

        private Boolean enableIAMDatabaseAuthentication;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private Boolean useDefaultProcessorFeatures;

        private Boolean deletionProtection;

        private Integer maxAllocatedStorage;

        private Boolean certificateRotationRestart;

        private String replicaMode;

        private Boolean enableCustomerOwnedIp;

        private String awsBackupRecoveryPointArn;

        private String automationMode;

        private Integer resumeFullAutomationModeMinutes;

        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbInstanceRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            allocatedStorage(model.allocatedStorage);
            dbInstanceClass(model.dbInstanceClass);
            dbSubnetGroupName(model.dbSubnetGroupName);
            dbSecurityGroups(model.dbSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            applyImmediately(model.applyImmediately);
            masterUserPassword(model.masterUserPassword);
            dbParameterGroupName(model.dbParameterGroupName);
            backupRetentionPeriod(model.backupRetentionPeriod);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            newDBInstanceIdentifier(model.newDBInstanceIdentifier);
            storageType(model.storageType);
            tdeCredentialArn(model.tdeCredentialArn);
            tdeCredentialPassword(model.tdeCredentialPassword);
            caCertificateIdentifier(model.caCertificateIdentifier);
            domain(model.domain);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            dbPortNumber(model.dbPortNumber);
            publiclyAccessible(model.publiclyAccessible);
            monitoringRoleArn(model.monitoringRoleArn);
            domainIAMRoleName(model.domainIAMRoleName);
            promotionTier(model.promotionTier);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            cloudwatchLogsExportConfiguration(model.cloudwatchLogsExportConfiguration);
            processorFeatures(model.processorFeatures);
            useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            deletionProtection(model.deletionProtection);
            maxAllocatedStorage(model.maxAllocatedStorage);
            certificateRotationRestart(model.certificateRotationRestart);
            replicaMode(model.replicaMode);
            enableCustomerOwnedIp(model.enableCustomerOwnedIp);
            awsBackupRecoveryPointArn(model.awsBackupRecoveryPointArn);
            automationMode(model.automationMode);
            resumeFullAutomationModeMinutes(model.resumeFullAutomationModeMinutes);
            networkType(model.networkType);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroups;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return allowMajorVersionUpgrade;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getNewDBInstanceIdentifier() {
            return newDBInstanceIdentifier;
        }

        public final void setNewDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
        }

        @Override
        public final Builder newDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final String getTdeCredentialPassword() {
            return tdeCredentialPassword;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        @Override
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final Integer getDbPortNumber() {
            return dbPortNumber;
        }

        public final void setDbPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
        }

        @Override
        public final Builder dbPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final CloudwatchLogsExportConfiguration.Builder getCloudwatchLogsExportConfiguration() {
            return cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration.toBuilder() : null;
        }

        public final void setCloudwatchLogsExportConfiguration(
                CloudwatchLogsExportConfiguration.BuilderImpl cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration;
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> ProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return useDefaultProcessorFeatures;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        @Override
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final Boolean getCertificateRotationRestart() {
            return certificateRotationRestart;
        }

        public final void setCertificateRotationRestart(Boolean certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
        }

        @Override
        public final Builder certificateRotationRestart(Boolean certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
            return this;
        }

        public final String getReplicaMode() {
            return replicaMode;
        }

        public final void setReplicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
        }

        @Override
        public final Builder replicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        @Override
        public final Builder replicaMode(ReplicaMode replicaMode) {
            this.replicaMode(replicaMode == null ? null : replicaMode.toString());
            return this;
        }

        public final Boolean getEnableCustomerOwnedIp() {
            return enableCustomerOwnedIp;
        }

        public final void setEnableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
        }

        @Override
        public final Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
            return this;
        }

        public final String getAwsBackupRecoveryPointArn() {
            return awsBackupRecoveryPointArn;
        }

        public final void setAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
        }

        @Override
        public final Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
            return this;
        }

        public final String getAutomationMode() {
            return automationMode;
        }

        public final void setAutomationMode(String automationMode) {
            this.automationMode = automationMode;
        }

        @Override
        public final Builder automationMode(String automationMode) {
            this.automationMode = automationMode;
            return this;
        }

        @Override
        public final Builder automationMode(AutomationMode automationMode) {
            this.automationMode(automationMode == null ? null : automationMode.toString());
            return this;
        }

        public final Integer getResumeFullAutomationModeMinutes() {
            return resumeFullAutomationModeMinutes;
        }

        public final void setResumeFullAutomationModeMinutes(Integer resumeFullAutomationModeMinutes) {
            this.resumeFullAutomationModeMinutes = resumeFullAutomationModeMinutes;
        }

        @Override
        public final Builder resumeFullAutomationModeMinutes(Integer resumeFullAutomationModeMinutes) {
            this.resumeFullAutomationModeMinutes = resumeFullAutomationModeMinutes;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbInstanceRequest build() {
            return new ModifyDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
