/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbClusterToPointInTimeRequest extends RdsRequest implements
        ToCopyableBuilder<RestoreDbClusterToPointInTimeRequest.Builder, RestoreDbClusterToPointInTimeRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(RestoreDbClusterToPointInTimeRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> RESTORE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreType").getter(getter(RestoreDbClusterToPointInTimeRequest::restoreType))
            .setter(setter(Builder::restoreType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreType").build()).build();

    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBClusterIdentifier")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::sourceDBClusterIdentifier))
            .setter(setter(Builder::sourceDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build())
            .build();

    private static final SdkField<Instant> RESTORE_TO_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RestoreToTime").getter(getter(RestoreDbClusterToPointInTimeRequest::restoreToTime))
            .setter(setter(Builder::restoreToTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreToTime").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLatestRestorableTime").getter(getter(RestoreDbClusterToPointInTimeRequest::useLatestRestorableTime))
            .setter(setter(Builder::useLatestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(RestoreDbClusterToPointInTimeRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(RestoreDbClusterToPointInTimeRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreDbClusterToPointInTimeRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BacktrackWindow").getter(getter(RestoreDbClusterToPointInTimeRequest::backtrackWindow))
            .setter(setter(Builder::backtrackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(RestoreDbClusterToPointInTimeRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(RestoreDbClusterToPointInTimeRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(RestoreDbClusterToPointInTimeRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScalingConfiguration")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::scalingConfiguration))
            .setter(setter(Builder::scalingConfiguration)).constructor(ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build())
            .build();

    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineMode").getter(getter(RestoreDbClusterToPointInTimeRequest::engineMode))
            .setter(setter(Builder::engineMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()).build();

    private static final SdkField<String> DB_CLUSTER_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterInstanceClass").getter(getter(RestoreDbClusterToPointInTimeRequest::dbClusterInstanceClass))
            .setter(setter(Builder::dbClusterInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterInstanceClass").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(RestoreDbClusterToPointInTimeRequest::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(RestoreDbClusterToPointInTimeRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField
            .<ServerlessV2ScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerlessV2ScalingConfiguration")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::serverlessV2ScalingConfiguration))
            .setter(setter(Builder::serverlessV2ScalingConfiguration))
            .constructor(ServerlessV2ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            RESTORE_TYPE_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, RESTORE_TO_TIME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD,
            PORT_FIELD, DB_SUBNET_GROUP_NAME_FIELD, OPTION_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD,
            KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD,
            ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, DELETION_PROTECTION_FIELD,
            COPY_TAGS_TO_SNAPSHOT_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, SCALING_CONFIGURATION_FIELD,
            ENGINE_MODE_FIELD, DB_CLUSTER_INSTANCE_CLASS_FIELD, STORAGE_TYPE_FIELD, PUBLICLY_ACCESSIBLE_FIELD, IOPS_FIELD,
            SERVERLESS_V2_SCALING_CONFIGURATION_FIELD));

    private final String dbClusterIdentifier;

    private final String restoreType;

    private final String sourceDBClusterIdentifier;

    private final Instant restoreToTime;

    private final Boolean useLatestRestorableTime;

    private final Integer port;

    private final String dbSubnetGroupName;

    private final String optionGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Long backtrackWindow;

    private final List<String> enableCloudwatchLogsExports;

    private final String dbClusterParameterGroupName;

    private final Boolean deletionProtection;

    private final Boolean copyTagsToSnapshot;

    private final String domain;

    private final String domainIAMRoleName;

    private final ScalingConfiguration scalingConfiguration;

    private final String engineMode;

    private final String dbClusterInstanceClass;

    private final String storageType;

    private final Boolean publiclyAccessible;

    private final Integer iops;

    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

    private RestoreDbClusterToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.restoreType = builder.restoreType;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.restoreToTime = builder.restoreToTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.deletionProtection = builder.deletionProtection;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.engineMode = builder.engineMode;
        this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
        this.storageType = builder.storageType;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.iops = builder.iops;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
    }

    /**
     * <p>
     * The name of the new DB cluster to be created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The name of the new DB cluster to be created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The type of restore to be performed. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is
     * earlier than 1.11.
     * </p>
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the
     * source DB cluster.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The type of restore to be performed. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster
     *         is earlier than 1.11.
     *         </p>
     *         <p>
     *         If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy
     *         of the source DB cluster.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String restoreType() {
        return restoreType;
    }

    /**
     * <p>
     * The identifier of the source DB cluster from which to restore.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DBCluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The identifier of the source DB cluster from which to restore.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DBCluster.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String sourceDBClusterIdentifier() {
        return sourceDBClusterIdentifier;
    }

    /**
     * <p>
     * The date and time to restore the DB cluster to.
     * </p>
     * <p>
     * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be before the latest restorable time for the DB instance
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>2015-03-07T23:45:00Z</code>
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The date and time to restore the DB cluster to.</p>
     *         <p>
     *         Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be before the latest restorable time for the DB instance
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>2015-03-07T23:45:00Z</code>
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Instant restoreToTime() {
        return restoreToTime;
    }

    /**
     * <p>
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB
     * cluster isn't restored to the latest restorable backup time.
     * </p>
     * <p>
     * Constraints: Can't be specified if <code>RestoreToTime</code> parameter is provided.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return A value that indicates whether to restore the DB cluster to the latest restorable backup time. By
     *         default, the DB cluster isn't restored to the latest restorable backup time.</p>
     *         <p>
     *         Constraints: Can't be specified if <code>RestoreToTime</code> parameter is provided.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean useLatestRestorableTime() {
        return useLatestRestorableTime;
    }

    /**
     * <p>
     * The port number on which the new DB cluster accepts connections.
     * </p>
     * <p>
     * Constraints: A value from <code>1150-65535</code>.
     * </p>
     * <p>
     * Default: The default port for the engine.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The port number on which the new DB cluster accepts connections.</p>
     *         <p>
     *         Constraints: A value from <code>1150-65535</code>.
     *         </p>
     *         <p>
     *         Default: The default port for the engine.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The DB subnet group name to use for the new DB cluster.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * </p>
     * <p>
     * Example: <code>mydbsubnetgroup</code>
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The DB subnet group name to use for the new DB cluster.</p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *         </p>
     *         <p>
     *         Example: <code>mydbsubnetgroup</code>
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The name of the option group for the new DB cluster.
     * </p>
     * <p>
     * DB clusters are associated with a default option group that can't be modified.
     * </p>
     * 
     * @return The name of the option group for the new DB cluster.</p>
     *         <p>
     *         DB clusters are associated with a default option group that can't be modified.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the new DB cluster belongs to.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security groups that the new DB cluster belongs to.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB
     * cluster.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the KMS
     * key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the
     * <code>KmsKeyId</code> parameter.
     * </p>
     * <p>
     * If you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
     * encrypt the source DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBClusterIdentifier</code> refers to a DB cluster that isn't encrypted, then the restore request is
     * rejected.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an
     *         encrypted DB cluster.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from
     *         the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key
     *         identified by the <code>KmsKeyId</code> parameter.
     *         </p>
     *         <p>
     *         If you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used
     *         to encrypt the source DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBClusterIdentifier</code> refers to a DB cluster that isn't encrypted, then the restore request
     *         is rejected.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
     * accounts to database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
     *         (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
     *         Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora MySQL DB clusters only
     * </p>
     * 
     * @return The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
     *         <p>
     *         Default: 0
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora MySQL DB clusters only
     */
    public final Long backtrackWindow() {
        return backtrackWindow;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on
     * the DB engine being used.
     * </p>
     * <p>
     * <b>RDS for MySQL</b>
     * </p>
     * <p>
     * Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     * </p>
     * <p>
     * <b>RDS for PostgreSQL</b>
     * </p>
     * <p>
     * Possible values are <code>postgresql</code> and <code>upgrade</code>.
     * </p>
     * <p>
     * <b>Aurora MySQL</b>
     * </p>
     * <p>
     * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     * </p>
     * <p>
     * <b>Aurora PostgreSQL</b>
     * </p>
     * <p>
     * Possible value is <code>postgresql</code>.
     * </p>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.
     * </p>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list
     *         depend on the DB engine being used.</p>
     *         <p>
     *         <b>RDS for MySQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     *         </p>
     *         <p>
     *         <b>RDS for PostgreSQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>postgresql</code> and <code>upgrade</code>.
     *         </p>
     *         <p>
     *         <b>Aurora MySQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
     *         <code>slowquery</code>.
     *         </p>
     *         <p>
     *         <b>Aurora PostgreSQL</b>
     *         </p>
     *         <p>
     *         Possible value is <code>postgresql</code>.
     *         </p>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.
     *         </p>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the
     * default DB cluster parameter group for the specified engine is used.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing DB cluster parameter group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be 1 to 255 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The name of the DB cluster parameter group to associate with this DB cluster. If this argument is
     *         omitted, the default DB cluster parameter group for the specified engine is used.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing DB cluster parameter group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * <p>
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when
     * deletion protection is enabled. By default, deletion protection isn't enabled.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
     *         deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB
     * cluster. The default is not to copy them.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored
     *         DB cluster. The default is not to copy them.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this
     * operation.
     * </p>
     * <p>
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to
     * the DB cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior
     *         to this operation.</p>
     *         <p>
     *         For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that
     *         connect to the DB cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     *         Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final ScalingConfiguration scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * <p>
     * The engine mode of the new cluster. Specify <code>provisioned</code> or <code>serverless</code>, depending on the
     * type of the cluster you are creating. You can create an Aurora Serverless v1 clone from a provisioned cluster, or
     * a provisioned clone from an Aurora Serverless v1 cluster. To create a clone that is an Aurora Serverless v1
     * cluster, the original cluster must be an Aurora Serverless v1 cluster or an encrypted provisioned cluster.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return The engine mode of the new cluster. Specify <code>provisioned</code> or <code>serverless</code>,
     *         depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone from
     *         a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone
     *         that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or
     *         an encrypted provisioned cluster.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final String engineMode() {
        return engineMode;
    }

    /**
     * <p>
     * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge.
     * Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     * </p>
     * <p>
     * For the full list of DB instance classes, and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a>
     * in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example
     *         db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all
     *         database engines.</p>
     *         <p>
     *         For the full list of DB instance classes, and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance
     *         class</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for: Multi-AZ DB clusters only
     */
    public final String dbClusterInstanceClass() {
        return dbClusterInstanceClass;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.
     * </p>
     * <p>
     * Valid values: <code>io1</code>
     * </p>
     * <p>
     * When specified, a value for the <code>Iops</code> parameter is required.
     * </p>
     * <p>
     * Default: <code>io1</code>
     * </p>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     * </p>
     * 
     * @return Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.</p>
     *         <p>
     *         Valid values: <code>io1</code>
     *         </p>
     *         <p>
     *         When specified, a value for the <code>Iops</code> parameter is required.
     *         </p>
     *         <p>
     *         Default: <code>io1</code>
     *         </p>
     *         <p>
     *         Valid for: Multi-AZ DB clusters only
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * A value that indicates whether the DB cluster is publicly accessible.
     * </p>
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses.
     * That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
     * </p>
     * <p>
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * </p>
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     * </p>
     * 
     * @return A value that indicates whether the DB cluster is publicly accessible.</p>
     *         <p>
     *         When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private
     *         IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address
     *         from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security
     *         group it uses. That public access is not permitted if the security group assigned to the DB cluster
     *         doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves
     *         to a private IP address.
     *         </p>
     *         <p>
     *         Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     *         </p>
     *         <p>
     *         If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified,
     *         the following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster
     *         is private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     *         following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is
     *         private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Multi-AZ DB clusters only
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     * instance in the Multi-AZ DB cluster.
     * </p>
     * <p>
     * For information about valid <code>Iops</code> values, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned
     * IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
     * </p>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     *         instance in the Multi-AZ DB cluster.</p>
     *         <p>
     *         For information about valid <code>Iops</code> values, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
     *         Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
     *         </p>
     *         <p>
     *         Valid for: Multi-AZ DB clusters only
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * Returns the value of the ServerlessV2ScalingConfiguration property for this object.
     * 
     * @return The value of the ServerlessV2ScalingConfiguration property for this object.
     */
    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return serverlessV2ScalingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreToTime());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessV2ScalingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterToPointInTimeRequest)) {
            return false;
        }
        RestoreDbClusterToPointInTimeRequest other = (RestoreDbClusterToPointInTimeRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(restoreType(), other.restoreType())
                && Objects.equals(sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier())
                && Objects.equals(restoreToTime(), other.restoreToTime())
                && Objects.equals(useLatestRestorableTime(), other.useLatestRestorableTime())
                && Objects.equals(port(), other.port()) && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(backtrackWindow(), other.backtrackWindow())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(domain(), other.domain())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && Objects.equals(engineMode(), other.engineMode())
                && Objects.equals(dbClusterInstanceClass(), other.dbClusterInstanceClass())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(iops(), other.iops())
                && Objects.equals(serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreDbClusterToPointInTimeRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("RestoreType", restoreType()).add("SourceDBClusterIdentifier", sourceDBClusterIdentifier())
                .add("RestoreToTime", restoreToTime()).add("UseLatestRestorableTime", useLatestRestorableTime())
                .add("Port", port()).add("DBSubnetGroupName", dbSubnetGroupName()).add("OptionGroupName", optionGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("KmsKeyId", kmsKeyId())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("BacktrackWindow", backtrackWindow())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("DeletionProtection", deletionProtection()).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("Domain", domain()).add("DomainIAMRoleName", domainIAMRoleName())
                .add("ScalingConfiguration", scalingConfiguration()).add("EngineMode", engineMode())
                .add("DBClusterInstanceClass", dbClusterInstanceClass()).add("StorageType", storageType())
                .add("PubliclyAccessible", publiclyAccessible()).add("Iops", iops())
                .add("ServerlessV2ScalingConfiguration", serverlessV2ScalingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "RestoreType":
            return Optional.ofNullable(clazz.cast(restoreType()));
        case "SourceDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterIdentifier()));
        case "RestoreToTime":
            return Optional.ofNullable(clazz.cast(restoreToTime()));
        case "UseLatestRestorableTime":
            return Optional.ofNullable(clazz.cast(useLatestRestorableTime()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "BacktrackWindow":
            return Optional.ofNullable(clazz.cast(backtrackWindow()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "EngineMode":
            return Optional.ofNullable(clazz.cast(engineMode()));
        case "DBClusterInstanceClass":
            return Optional.ofNullable(clazz.cast(dbClusterInstanceClass()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "ServerlessV2ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(serverlessV2ScalingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterToPointInTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreDbClusterToPointInTimeRequest> {
        /**
         * <p>
         * The name of the new DB cluster to be created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the new DB cluster to be created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The type of restore to be performed. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is
         * earlier than 1.11.
         * </p>
         * <p>
         * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of
         * the source DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param restoreType
         *        The type of restore to be performed. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB
         *        cluster is earlier than 1.11.
         *        </p>
         *        <p>
         *        If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full
         *        copy of the source DB cluster.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreType(String restoreType);

        /**
         * <p>
         * The identifier of the source DB cluster from which to restore.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DBCluster.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param sourceDBClusterIdentifier
         *        The identifier of the source DB cluster from which to restore.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DBCluster.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier);

        /**
         * <p>
         * The date and time to restore the DB cluster to.
         * </p>
         * <p>
         * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be before the latest restorable time for the DB instance
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>2015-03-07T23:45:00Z</code>
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param restoreToTime
         *        The date and time to restore the DB cluster to.</p>
         *        <p>
         *        Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be before the latest restorable time for the DB instance
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>2015-03-07T23:45:00Z</code>
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreToTime(Instant restoreToTime);

        /**
         * <p>
         * A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default,
         * the DB cluster isn't restored to the latest restorable backup time.
         * </p>
         * <p>
         * Constraints: Can't be specified if <code>RestoreToTime</code> parameter is provided.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param useLatestRestorableTime
         *        A value that indicates whether to restore the DB cluster to the latest restorable backup time. By
         *        default, the DB cluster isn't restored to the latest restorable backup time.</p>
         *        <p>
         *        Constraints: Can't be specified if <code>RestoreToTime</code> parameter is provided.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableTime(Boolean useLatestRestorableTime);

        /**
         * <p>
         * The port number on which the new DB cluster accepts connections.
         * </p>
         * <p>
         * Constraints: A value from <code>1150-65535</code>.
         * </p>
         * <p>
         * Default: The default port for the engine.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param port
         *        The port number on which the new DB cluster accepts connections.</p>
         *        <p>
         *        Constraints: A value from <code>1150-65535</code>.
         *        </p>
         *        <p>
         *        Default: The default port for the engine.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The DB subnet group name to use for the new DB cluster.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * </p>
         * <p>
         * Example: <code>mydbsubnetgroup</code>
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The DB subnet group name to use for the new DB cluster.</p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *        </p>
         *        <p>
         *        Example: <code>mydbsubnetgroup</code>
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The name of the option group for the new DB cluster.
         * </p>
         * <p>
         * DB clusters are associated with a default option group that can't be modified.
         * </p>
         * 
         * @param optionGroupName
         *        The name of the option group for the new DB cluster.</p>
         *        <p>
         *        DB clusters are associated with a default option group that can't be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster belongs to.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster belongs to.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster belongs to.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster belongs to.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB
         * cluster.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the
         * KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by
         * the <code>KmsKeyId</code> parameter.
         * </p>
         * <p>
         * If you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
         * encrypt the source DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBClusterIdentifier</code> refers to a DB cluster that isn't encrypted, then the restore request is
         * rejected.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an
         *        encrypted DB cluster.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different
         *        from the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS
         *        key identified by the <code>KmsKeyId</code> parameter.
         *        </p>
         *        <p>
         *        If you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was
         *        used to encrypt the source DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBClusterIdentifier</code> refers to a DB cluster that isn't encrypted, then the restore
         *        request is rejected.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         * accounts to database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
         *        (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora MySQL DB clusters only
         * </p>
         * 
         * @param backtrackWindow
         *        The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
         *        <p>
         *        Default: 0
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora MySQL DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackWindow(Long backtrackWindow);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend
         * on the DB engine being used.
         * </p>
         * <p>
         * <b>RDS for MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>RDS for PostgreSQL</b>
         * </p>
         * <p>
         * Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * </p>
         * <p>
         * <b>Aurora MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Aurora PostgreSQL</b>
         * </p>
         * <p>
         * Possible value is <code>postgresql</code>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used.</p>
         *        <p>
         *        <b>RDS for MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>RDS for PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>postgresql</code> and <code>upgrade</code>.
         *        </p>
         *        <p>
         *        <b>Aurora MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Aurora PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible value is <code>postgresql</code>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend
         * on the DB engine being used.
         * </p>
         * <p>
         * <b>RDS for MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>RDS for PostgreSQL</b>
         * </p>
         * <p>
         * Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * </p>
         * <p>
         * <b>Aurora MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Aurora PostgreSQL</b>
         * </p>
         * <p>
         * Possible value is <code>postgresql</code>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used.</p>
         *        <p>
         *        <b>RDS for MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>RDS for PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>postgresql</code> and <code>upgrade</code>.
         *        </p>
         *        <p>
         *        <b>Aurora MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Aurora PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible value is <code>postgresql</code>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted,
         * the default DB cluster parameter group for the specified engine is used.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing DB cluster parameter group.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be 1 to 255 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to associate with this DB cluster. If this argument is
         *        omitted, the default DB cluster parameter group for the specified engine is used.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing DB cluster parameter group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted
         * when deletion protection is enabled. By default, deletion protection isn't enabled.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
         *        deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB
         * cluster. The default is not to copy them.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the
         *        restored DB cluster. The default is not to copy them.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to
         * this operation.
         * </p>
         * <p>
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect
         * to the DB cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
         * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param domain
         *        Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created
         *        prior to this operation.</p>
         *        <p>
         *        For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that
         *        connect to the DB cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html"
         *        >Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param domainIAMRoleName
         *        Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param scalingConfiguration
         *        For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB
         *        cluster.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfiguration scalingConfiguration);

        /**
         * <p>
         * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScalingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScalingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfiguration(ScalingConfiguration)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfiguration)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfiguration.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * The engine mode of the new cluster. Specify <code>provisioned</code> or <code>serverless</code>, depending on
         * the type of the cluster you are creating. You can create an Aurora Serverless v1 clone from a provisioned
         * cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone that is an Aurora
         * Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or an encrypted
         * provisioned cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param engineMode
         *        The engine mode of the new cluster. Specify <code>provisioned</code> or <code>serverless</code>,
         *        depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone
         *        from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a
         *        clone that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1
         *        cluster or an encrypted provisioned cluster.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineMode(String engineMode);

        /**
         * <p>
         * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example
         * db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all
         * database engines.
         * </p>
         * <p>
         * For the full list of DB instance classes, and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance
         * class</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * </p>
         * 
         * @param dbClusterInstanceClass
         *        The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example
         *        db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for
         *        all database engines.</p>
         *        <p>
         *        For the full list of DB instance classes, and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        instance class</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterInstanceClass(String dbClusterInstanceClass);

        /**
         * <p>
         * Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.
         * </p>
         * <p>
         * Valid values: <code>io1</code>
         * </p>
         * <p>
         * When specified, a value for the <code>Iops</code> parameter is required.
         * </p>
         * <p>
         * Default: <code>io1</code>
         * </p>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.</p>
         *        <p>
         *        Valid values: <code>io1</code>
         *        </p>
         *        <p>
         *        When specified, a value for the <code>Iops</code> parameter is required.
         *        </p>
         *        <p>
         *        Default: <code>io1</code>
         *        </p>
         *        <p>
         *        Valid for: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * A value that indicates whether the DB cluster is publicly accessible.
         * </p>
         * <p>
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
         * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
         * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it
         * uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
         * </p>
         * <p>
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to
         * a private IP address.
         * </p>
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * </p>
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * </p>
         * 
         * @param publiclyAccessible
         *        A value that indicates whether the DB cluster is publicly accessible.</p>
         *        <p>
         *        When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public
         *        IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by
         *        the security group it uses. That public access is not permitted if the security group assigned to the
         *        DB cluster doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *        </p>
         *        <p>
         *        If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't
         *        specified, the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB
         *        cluster is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified,
         *        the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster
         *        is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
         * instance in the Multi-AZ DB cluster.
         * </p>
         * <p>
         * For information about valid <code>Iops</code> values, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         * Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
         * </p>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * </p>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each
         *        DB instance in the Multi-AZ DB cluster.</p>
         *        <p>
         *        For information about valid <code>Iops</code> values, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         *        Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
         *        </p>
         *        <p>
         *        Valid for: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * @param serverlessV2ScalingConfiguration
         *        The new value for the ServerlessV2ScalingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServerlessV2ScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServerlessV2ScalingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerlessV2ScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)}.
         * 
         * @param serverlessV2ScalingConfiguration
         *        a consumer that will call methods on {@link ServerlessV2ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)
         */
        default Builder serverlessV2ScalingConfiguration(
                Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.builder()
                    .applyMutation(serverlessV2ScalingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String restoreType;

        private String sourceDBClusterIdentifier;

        private Instant restoreToTime;

        private Boolean useLatestRestorableTime;

        private Integer port;

        private String dbSubnetGroupName;

        private String optionGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private Boolean enableIAMDatabaseAuthentication;

        private Long backtrackWindow;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterParameterGroupName;

        private Boolean deletionProtection;

        private Boolean copyTagsToSnapshot;

        private String domain;

        private String domainIAMRoleName;

        private ScalingConfiguration scalingConfiguration;

        private String engineMode;

        private String dbClusterInstanceClass;

        private String storageType;

        private Boolean publiclyAccessible;

        private Integer iops;

        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterToPointInTimeRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            restoreType(model.restoreType);
            sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            restoreToTime(model.restoreToTime);
            useLatestRestorableTime(model.useLatestRestorableTime);
            port(model.port);
            dbSubnetGroupName(model.dbSubnetGroupName);
            optionGroupName(model.optionGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            backtrackWindow(model.backtrackWindow);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            deletionProtection(model.deletionProtection);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            domain(model.domain);
            domainIAMRoleName(model.domainIAMRoleName);
            scalingConfiguration(model.scalingConfiguration);
            engineMode(model.engineMode);
            dbClusterInstanceClass(model.dbClusterInstanceClass);
            storageType(model.storageType);
            publiclyAccessible(model.publiclyAccessible);
            iops(model.iops);
            serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getRestoreType() {
            return restoreType;
        }

        public final void setRestoreType(String restoreType) {
            this.restoreType = restoreType;
        }

        @Override
        public final Builder restoreType(String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        public final String getSourceDBClusterIdentifier() {
            return sourceDBClusterIdentifier;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final Instant getRestoreToTime() {
            return restoreToTime;
        }

        public final void setRestoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
        }

        @Override
        public final Builder restoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        public final Boolean getUseLatestRestorableTime() {
            return useLatestRestorableTime;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Long getBacktrackWindow() {
            return backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final String getEngineMode() {
            return engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final String getDbClusterInstanceClass() {
            return dbClusterInstanceClass;
        }

        public final void setDbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
        }

        @Override
        public final Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(
                ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterToPointInTimeRequest build() {
            return new RestoreDbClusterToPointInTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
