/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse;

public class DescribeDBClusterAutomatedBackupsPublisher
implements SdkPublisher<DescribeDbClusterAutomatedBackupsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbClusterAutomatedBackupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBClusterAutomatedBackupsPublisher(RdsAsyncClient client, DescribeDbClusterAutomatedBackupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBClusterAutomatedBackupsPublisher(RdsAsyncClient client, DescribeDbClusterAutomatedBackupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbClusterAutomatedBackupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbClusterAutomatedBackupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBClusterAutomatedBackup> dbClusterAutomatedBackups() {
        Function<DescribeDbClusterAutomatedBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterAutomatedBackups() != null) {
                return response.dbClusterAutomatedBackups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbClusterAutomatedBackupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbClusterAutomatedBackupsResponseFetcher
    implements AsyncPageFetcher<DescribeDbClusterAutomatedBackupsResponse> {
        private DescribeDbClusterAutomatedBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterAutomatedBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbClusterAutomatedBackupsResponse> nextPage(DescribeDbClusterAutomatedBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterAutomatedBackupsPublisher.this.client.describeDBClusterAutomatedBackups(DescribeDBClusterAutomatedBackupsPublisher.this.firstRequest);
            }
            return DescribeDBClusterAutomatedBackupsPublisher.this.client.describeDBClusterAutomatedBackups((DescribeDbClusterAutomatedBackupsRequest)((Object)DescribeDBClusterAutomatedBackupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

