/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details about a blue/green deployment.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green
 * Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
 * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlueGreenDeployment implements SdkPojo, Serializable,
        ToCopyableBuilder<BlueGreenDeployment.Builder, BlueGreenDeployment> {
    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BlueGreenDeploymentIdentifier")
            .getter(getter(BlueGreenDeployment::blueGreenDeploymentIdentifier))
            .setter(setter(Builder::blueGreenDeploymentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentIdentifier")
                    .build()).build();

    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueGreenDeploymentName").getter(getter(BlueGreenDeployment::blueGreenDeploymentName))
            .setter(setter(Builder::blueGreenDeploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentName").build())
            .build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(BlueGreenDeployment::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(BlueGreenDeployment::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<List<SwitchoverDetail>> SWITCHOVER_DETAILS_FIELD = SdkField
            .<List<SwitchoverDetail>> builder(MarshallingType.LIST)
            .memberName("SwitchoverDetails")
            .getter(getter(BlueGreenDeployment::switchoverDetails))
            .setter(setter(Builder::switchoverDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SwitchoverDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SwitchoverDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(SwitchoverDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BlueGreenDeploymentTask>> TASKS_FIELD = SdkField
            .<List<BlueGreenDeploymentTask>> builder(MarshallingType.LIST)
            .memberName("Tasks")
            .getter(getter(BlueGreenDeployment::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlueGreenDeploymentTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlueGreenDeploymentTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(BlueGreenDeployment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetails").getter(getter(BlueGreenDeployment::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(BlueGreenDeployment::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> DELETE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeleteTime").getter(getter(BlueGreenDeployment::deleteTime)).setter(setter(Builder::deleteTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTime").build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagList")
            .getter(getter(BlueGreenDeployment::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD, BLUE_GREEN_DEPLOYMENT_NAME_FIELD, SOURCE_FIELD, TARGET_FIELD,
            SWITCHOVER_DETAILS_FIELD, TASKS_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, CREATE_TIME_FIELD, DELETE_TIME_FIELD,
            TAG_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String blueGreenDeploymentIdentifier;

    private final String blueGreenDeploymentName;

    private final String source;

    private final String target;

    private final List<SwitchoverDetail> switchoverDetails;

    private final List<BlueGreenDeploymentTask> tasks;

    private final String status;

    private final String statusDetails;

    private final Instant createTime;

    private final Instant deleteTime;

    private final List<Tag> tagList;

    private BlueGreenDeployment(BuilderImpl builder) {
        this.blueGreenDeploymentIdentifier = builder.blueGreenDeploymentIdentifier;
        this.blueGreenDeploymentName = builder.blueGreenDeploymentName;
        this.source = builder.source;
        this.target = builder.target;
        this.switchoverDetails = builder.switchoverDetails;
        this.tasks = builder.tasks;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.tagList = builder.tagList;
    }

    /**
     * <p>
     * The system-generated identifier of the blue/green deployment.
     * </p>
     * 
     * @return The system-generated identifier of the blue/green deployment.
     */
    public final String blueGreenDeploymentIdentifier() {
        return blueGreenDeploymentIdentifier;
    }

    /**
     * <p>
     * The user-supplied name of the blue/green deployment.
     * </p>
     * 
     * @return The user-supplied name of the blue/green deployment.
     */
    public final String blueGreenDeploymentName() {
        return blueGreenDeploymentName;
    }

    /**
     * <p>
     * The source database for the blue/green deployment.
     * </p>
     * <p>
     * Before switchover, the source database is the production database in the blue environment.
     * </p>
     * 
     * @return The source database for the blue/green deployment.</p>
     *         <p>
     *         Before switchover, the source database is the production database in the blue environment.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The target database for the blue/green deployment.
     * </p>
     * <p>
     * Before switchover, the target database is the clone database in the green environment.
     * </p>
     * 
     * @return The target database for the blue/green deployment.</p>
     *         <p>
     *         Before switchover, the target database is the clone database in the green environment.
     */
    public final String target() {
        return target;
    }

    /**
     * For responses, this returns true if the service returned a value for the SwitchoverDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSwitchoverDetails() {
        return switchoverDetails != null && !(switchoverDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details about each source and target resource in the blue/green deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSwitchoverDetails} method.
     * </p>
     * 
     * @return The details about each source and target resource in the blue/green deployment.
     */
    public final List<SwitchoverDetail> switchoverDetails() {
        return switchoverDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tasks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Either tasks to be performed or tasks that have been completed on the target database before switchover.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTasks} method.
     * </p>
     * 
     * @return Either tasks to be performed or tasks that have been completed on the target database before switchover.
     */
    public final List<BlueGreenDeploymentTask> tasks() {
        return tasks;
    }

    /**
     * <p>
     * The status of the blue/green deployment.
     * </p>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONING</code> - Resources are being created in the green environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Resources are available in the green environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SWITCHOVER_IN_PROGRESS</code> - The deployment is being switched from the blue environment to the green
     * environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SWITCHOVER_COMPLETED</code> - Switchover from the blue environment to the green environment is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID_CONFIGURATION</code> - Resources in the green environment are invalid, so switchover isn't
     * possible.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SWITCHOVER_FAILED</code> - Switchover was attempted but failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The blue/green deployment is being deleted.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the blue/green deployment.</p>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code> - Resources are being created in the green environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Resources are available in the green environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SWITCHOVER_IN_PROGRESS</code> - The deployment is being switched from the blue environment to the
     *         green environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SWITCHOVER_COMPLETED</code> - Switchover from the blue environment to the green environment is
     *         complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID_CONFIGURATION</code> - Resources in the green environment are invalid, so switchover isn't
     *         possible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SWITCHOVER_FAILED</code> - Switchover was attempted but failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The blue/green deployment is being deleted.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the blue/green deployment.
     * </p>
     * 
     * @return Additional information about the status of the blue/green deployment.
     */
    public final String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * Specifies the time when the blue/green deployment was created, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the time when the blue/green deployment was created, in Universal Coordinated Time (UTC).
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Specifies the time when the blue/green deployment was deleted, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the time when the blue/green deployment was deleted, in Universal Coordinated Time (UTC).
     */
    public final Instant deleteTime() {
        return deleteTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(hasSwitchoverDetails() ? switchoverDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueGreenDeployment)) {
            return false;
        }
        BlueGreenDeployment other = (BlueGreenDeployment) obj;
        return Objects.equals(blueGreenDeploymentIdentifier(), other.blueGreenDeploymentIdentifier())
                && Objects.equals(blueGreenDeploymentName(), other.blueGreenDeploymentName())
                && Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && hasSwitchoverDetails() == other.hasSwitchoverDetails()
                && Objects.equals(switchoverDetails(), other.switchoverDetails()) && hasTasks() == other.hasTasks()
                && Objects.equals(tasks(), other.tasks()) && Objects.equals(status(), other.status())
                && Objects.equals(statusDetails(), other.statusDetails()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(deleteTime(), other.deleteTime()) && hasTagList() == other.hasTagList()
                && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlueGreenDeployment").add("BlueGreenDeploymentIdentifier", blueGreenDeploymentIdentifier())
                .add("BlueGreenDeploymentName", blueGreenDeploymentName()).add("Source", source()).add("Target", target())
                .add("SwitchoverDetails", hasSwitchoverDetails() ? switchoverDetails() : null)
                .add("Tasks", hasTasks() ? tasks() : null).add("Status", status()).add("StatusDetails", statusDetails())
                .add("CreateTime", createTime()).add("DeleteTime", deleteTime()).add("TagList", hasTagList() ? tagList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueGreenDeploymentIdentifier":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentIdentifier()));
        case "BlueGreenDeploymentName":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "SwitchoverDetails":
            return Optional.ofNullable(clazz.cast(switchoverDetails()));
        case "Tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "DeleteTime":
            return Optional.ofNullable(clazz.cast(deleteTime()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlueGreenDeployment, T> g) {
        return obj -> g.apply((BlueGreenDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlueGreenDeployment> {
        /**
         * <p>
         * The system-generated identifier of the blue/green deployment.
         * </p>
         * 
         * @param blueGreenDeploymentIdentifier
         *        The system-generated identifier of the blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier);

        /**
         * <p>
         * The user-supplied name of the blue/green deployment.
         * </p>
         * 
         * @param blueGreenDeploymentName
         *        The user-supplied name of the blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentName(String blueGreenDeploymentName);

        /**
         * <p>
         * The source database for the blue/green deployment.
         * </p>
         * <p>
         * Before switchover, the source database is the production database in the blue environment.
         * </p>
         * 
         * @param source
         *        The source database for the blue/green deployment.</p>
         *        <p>
         *        Before switchover, the source database is the production database in the blue environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The target database for the blue/green deployment.
         * </p>
         * <p>
         * Before switchover, the target database is the clone database in the green environment.
         * </p>
         * 
         * @param target
         *        The target database for the blue/green deployment.</p>
         *        <p>
         *        Before switchover, the target database is the clone database in the green environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The details about each source and target resource in the blue/green deployment.
         * </p>
         * 
         * @param switchoverDetails
         *        The details about each source and target resource in the blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder switchoverDetails(Collection<SwitchoverDetail> switchoverDetails);

        /**
         * <p>
         * The details about each source and target resource in the blue/green deployment.
         * </p>
         * 
         * @param switchoverDetails
         *        The details about each source and target resource in the blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder switchoverDetails(SwitchoverDetail... switchoverDetails);

        /**
         * <p>
         * The details about each source and target resource in the blue/green deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.SwitchoverDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.SwitchoverDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.SwitchoverDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #switchoverDetails(List<SwitchoverDetail>)}.
         * 
         * @param switchoverDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.SwitchoverDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #switchoverDetails(java.util.Collection<SwitchoverDetail>)
         */
        Builder switchoverDetails(Consumer<SwitchoverDetail.Builder>... switchoverDetails);

        /**
         * <p>
         * Either tasks to be performed or tasks that have been completed on the target database before switchover.
         * </p>
         * 
         * @param tasks
         *        Either tasks to be performed or tasks that have been completed on the target database before
         *        switchover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<BlueGreenDeploymentTask> tasks);

        /**
         * <p>
         * Either tasks to be performed or tasks that have been completed on the target database before switchover.
         * </p>
         * 
         * @param tasks
         *        Either tasks to be performed or tasks that have been completed on the target database before
         *        switchover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(BlueGreenDeploymentTask... tasks);

        /**
         * <p>
         * Either tasks to be performed or tasks that have been completed on the target database before switchover.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask.Builder#build()} is called
         * immediately and its result is passed to {@link #tasks(List<BlueGreenDeploymentTask>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(java.util.Collection<BlueGreenDeploymentTask>)
         */
        Builder tasks(Consumer<BlueGreenDeploymentTask.Builder>... tasks);

        /**
         * <p>
         * The status of the blue/green deployment.
         * </p>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONING</code> - Resources are being created in the green environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Resources are available in the green environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SWITCHOVER_IN_PROGRESS</code> - The deployment is being switched from the blue environment to the green
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SWITCHOVER_COMPLETED</code> - Switchover from the blue environment to the green environment is
         * complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_CONFIGURATION</code> - Resources in the green environment are invalid, so switchover isn't
         * possible.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SWITCHOVER_FAILED</code> - Switchover was attempted but failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The blue/green deployment is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the blue/green deployment.</p>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code> - Resources are being created in the green environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Resources are available in the green environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SWITCHOVER_IN_PROGRESS</code> - The deployment is being switched from the blue environment to
         *        the green environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SWITCHOVER_COMPLETED</code> - Switchover from the blue environment to the green environment is
         *        complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID_CONFIGURATION</code> - Resources in the green environment are invalid, so switchover
         *        isn't possible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SWITCHOVER_FAILED</code> - Switchover was attempted but failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The blue/green deployment is being deleted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Additional information about the status of the blue/green deployment.
         * </p>
         * 
         * @param statusDetails
         *        Additional information about the status of the blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * Specifies the time when the blue/green deployment was created, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param createTime
         *        Specifies the time when the blue/green deployment was created, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Specifies the time when the blue/green deployment was deleted, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param deleteTime
         *        Specifies the time when the blue/green deployment was deleted, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteTime(Instant deleteTime);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);
    }

    static final class BuilderImpl implements Builder {
        private String blueGreenDeploymentIdentifier;

        private String blueGreenDeploymentName;

        private String source;

        private String target;

        private List<SwitchoverDetail> switchoverDetails = DefaultSdkAutoConstructList.getInstance();

        private List<BlueGreenDeploymentTask> tasks = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusDetails;

        private Instant createTime;

        private Instant deleteTime;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BlueGreenDeployment model) {
            blueGreenDeploymentIdentifier(model.blueGreenDeploymentIdentifier);
            blueGreenDeploymentName(model.blueGreenDeploymentName);
            source(model.source);
            target(model.target);
            switchoverDetails(model.switchoverDetails);
            tasks(model.tasks);
            status(model.status);
            statusDetails(model.statusDetails);
            createTime(model.createTime);
            deleteTime(model.deleteTime);
            tagList(model.tagList);
        }

        public final String getBlueGreenDeploymentIdentifier() {
            return blueGreenDeploymentIdentifier;
        }

        public final void setBlueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
        }

        @Override
        public final Builder blueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
            return this;
        }

        public final String getBlueGreenDeploymentName() {
            return blueGreenDeploymentName;
        }

        public final void setBlueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
        }

        @Override
        public final Builder blueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final List<SwitchoverDetail.Builder> getSwitchoverDetails() {
            List<SwitchoverDetail.Builder> result = SwitchoverDetailListCopier.copyToBuilder(this.switchoverDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSwitchoverDetails(Collection<SwitchoverDetail.BuilderImpl> switchoverDetails) {
            this.switchoverDetails = SwitchoverDetailListCopier.copyFromBuilder(switchoverDetails);
        }

        @Override
        public final Builder switchoverDetails(Collection<SwitchoverDetail> switchoverDetails) {
            this.switchoverDetails = SwitchoverDetailListCopier.copy(switchoverDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder switchoverDetails(SwitchoverDetail... switchoverDetails) {
            switchoverDetails(Arrays.asList(switchoverDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder switchoverDetails(Consumer<SwitchoverDetail.Builder>... switchoverDetails) {
            switchoverDetails(Stream.of(switchoverDetails).map(c -> SwitchoverDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BlueGreenDeploymentTask.Builder> getTasks() {
            List<BlueGreenDeploymentTask.Builder> result = BlueGreenDeploymentTaskListCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<BlueGreenDeploymentTask.BuilderImpl> tasks) {
            this.tasks = BlueGreenDeploymentTaskListCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<BlueGreenDeploymentTask> tasks) {
            this.tasks = BlueGreenDeploymentTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(BlueGreenDeploymentTask... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<BlueGreenDeploymentTask.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> BlueGreenDeploymentTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getDeleteTime() {
            return deleteTime;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BlueGreenDeployment build() {
            return new BlueGreenDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
