/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.BlueGreenDeployment;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBlueGreenDeploymentsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeBlueGreenDeploymentsResponse> {
    private static final SdkField<List<BlueGreenDeployment>> BLUE_GREEN_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlueGreenDeployments").getter(DescribeBlueGreenDeploymentsResponse.getter(DescribeBlueGreenDeploymentsResponse::blueGreenDeployments)).setter(DescribeBlueGreenDeploymentsResponse.setter(Builder::blueGreenDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlueGreenDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeBlueGreenDeploymentsResponse.getter(DescribeBlueGreenDeploymentsResponse::marker)).setter(DescribeBlueGreenDeploymentsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUE_GREEN_DEPLOYMENTS_FIELD, MARKER_FIELD));
    private final List<BlueGreenDeployment> blueGreenDeployments;
    private final String marker;

    private DescribeBlueGreenDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.blueGreenDeployments = builder.blueGreenDeployments;
        this.marker = builder.marker;
    }

    public final boolean hasBlueGreenDeployments() {
        return this.blueGreenDeployments != null && !(this.blueGreenDeployments instanceof SdkAutoConstructList);
    }

    public final List<BlueGreenDeployment> blueGreenDeployments() {
        return this.blueGreenDeployments;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueGreenDeployments() ? this.blueGreenDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBlueGreenDeploymentsResponse)) {
            return false;
        }
        DescribeBlueGreenDeploymentsResponse other = (DescribeBlueGreenDeploymentsResponse)((Object)obj);
        return this.hasBlueGreenDeployments() == other.hasBlueGreenDeployments() && Objects.equals(this.blueGreenDeployments(), other.blueGreenDeployments()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBlueGreenDeploymentsResponse").add("BlueGreenDeployments", this.hasBlueGreenDeployments() ? this.blueGreenDeployments() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueGreenDeployments": {
                return Optional.ofNullable(clazz.cast(this.blueGreenDeployments()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBlueGreenDeploymentsResponse, T> g) {
        return obj -> g.apply((DescribeBlueGreenDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<BlueGreenDeployment> blueGreenDeployments = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBlueGreenDeploymentsResponse model) {
            super(model);
            this.blueGreenDeployments(model.blueGreenDeployments);
            this.marker(model.marker);
        }

        public final List<BlueGreenDeployment.Builder> getBlueGreenDeployments() {
            List<BlueGreenDeployment.Builder> result = BlueGreenDeploymentListCopier.copyToBuilder(this.blueGreenDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueGreenDeployments(Collection<BlueGreenDeployment.BuilderImpl> blueGreenDeployments) {
            this.blueGreenDeployments = BlueGreenDeploymentListCopier.copyFromBuilder(blueGreenDeployments);
        }

        @Override
        public final Builder blueGreenDeployments(Collection<BlueGreenDeployment> blueGreenDeployments) {
            this.blueGreenDeployments = BlueGreenDeploymentListCopier.copy(blueGreenDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueGreenDeployments(BlueGreenDeployment ... blueGreenDeployments) {
            this.blueGreenDeployments(Arrays.asList(blueGreenDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueGreenDeployments(Consumer<BlueGreenDeployment.Builder> ... blueGreenDeployments) {
            this.blueGreenDeployments(Stream.of(blueGreenDeployments).map(c -> (BlueGreenDeployment)((BlueGreenDeployment.Builder)BlueGreenDeployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeBlueGreenDeploymentsResponse build() {
            return new DescribeBlueGreenDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBlueGreenDeploymentsResponse> {
        public Builder blueGreenDeployments(Collection<BlueGreenDeployment> var1);

        public Builder blueGreenDeployments(BlueGreenDeployment ... var1);

        public Builder blueGreenDeployments(Consumer<BlueGreenDeployment.Builder> ... var1);

        public Builder marker(String var1);
    }
}

