/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbShardGroupResponse extends RdsResponse implements
        ToCopyableBuilder<DeleteDbShardGroupResponse.Builder, DeleteDbShardGroupResponse> {
    private static final SdkField<String> DB_SHARD_GROUP_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBShardGroupResourceId").getter(getter(DeleteDbShardGroupResponse::dbShardGroupResourceId))
            .setter(setter(Builder::dbShardGroupResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupResourceId").build())
            .build();

    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBShardGroupIdentifier").getter(getter(DeleteDbShardGroupResponse::dbShardGroupIdentifier))
            .setter(setter(Builder::dbShardGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DeleteDbShardGroupResponse::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Double> MAX_ACU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MaxACU")
            .getter(getter(DeleteDbShardGroupResponse::maxACU)).setter(setter(Builder::maxACU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxACU").build()).build();

    private static final SdkField<Double> MIN_ACU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MinACU")
            .getter(getter(DeleteDbShardGroupResponse::minACU)).setter(setter(Builder::minACU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinACU").build()).build();

    private static final SdkField<Integer> COMPUTE_REDUNDANCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ComputeRedundancy").getter(getter(DeleteDbShardGroupResponse::computeRedundancy))
            .setter(setter(Builder::computeRedundancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeRedundancy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeleteDbShardGroupResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(DeleteDbShardGroupResponse::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(DeleteDbShardGroupResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_SHARD_GROUP_RESOURCE_ID_FIELD, DB_SHARD_GROUP_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, MAX_ACU_FIELD,
            MIN_ACU_FIELD, COMPUTE_REDUNDANCY_FIELD, STATUS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, ENDPOINT_FIELD));

    private final String dbShardGroupResourceId;

    private final String dbShardGroupIdentifier;

    private final String dbClusterIdentifier;

    private final Double maxACU;

    private final Double minACU;

    private final Integer computeRedundancy;

    private final String status;

    private final Boolean publiclyAccessible;

    private final String endpoint;

    private DeleteDbShardGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbShardGroupResourceId = builder.dbShardGroupResourceId;
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.maxACU = builder.maxACU;
        this.minACU = builder.minACU;
        this.computeRedundancy = builder.computeRedundancy;
        this.status = builder.status;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
     * </p>
     * 
     * @return The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
     */
    public final String dbShardGroupResourceId() {
        return dbShardGroupResourceId;
    }

    /**
     * <p>
     * The name of the DB shard group.
     * </p>
     * 
     * @return The name of the DB shard group.
     */
    public final String dbShardGroupIdentifier() {
        return dbShardGroupIdentifier;
    }

    /**
     * <p>
     * The name of the primary DB cluster for the DB shard group.
     * </p>
     * 
     * @return The name of the primary DB cluster for the DB shard group.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     * </p>
     * 
     * @return The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public final Double maxACU() {
        return maxACU;
    }

    /**
     * <p>
     * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     * </p>
     * 
     * @return The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public final Double minACU() {
        return minACU;
    }

    /**
     * <p>
     * Specifies whether to create standby instances for the DB shard group. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only one
     * supported for the preview.
     * </p>
     * </li>
     * <li>
     * <p>
     * 1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each physical
     * shard.
     * </p>
     * </li>
     * <li>
     * <p>
     * 2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to create standby instances for the DB shard group. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the
     *         only one supported for the preview.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each
     *         physical shard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
     *         </p>
     *         </li>
     */
    public final Integer computeRedundancy() {
        return computeRedundancy;
    }

    /**
     * <p>
     * The status of the DB shard group.
     * </p>
     * 
     * @return The status of the DB shard group.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Indicates whether the DB shard group is publicly accessible.
     * </p>
     * <p>
     * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group
     * it uses. That public access isn't permitted if the security group assigned to the DB shard group doesn't permit
     * it.
     * </p>
     * <p>
     * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves
     * to a private IP address.
     * </p>
     * <p>
     * For more information, see <a>CreateDBShardGroup</a>.
     * </p>
     * <p>
     * This setting is only for Aurora Limitless Database.
     * </p>
     * 
     * @return Indicates whether the DB shard group is publicly accessible.</p>
     *         <p>
     *         When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
     *         private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the
     *         public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately
     *         controlled by the security group it uses. That public access isn't permitted if the security group
     *         assigned to the DB shard group doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that
     *         resolves to a private IP address.
     *         </p>
     *         <p>
     *         For more information, see <a>CreateDBShardGroup</a>.
     *         </p>
     *         <p>
     *         This setting is only for Aurora Limitless Database.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The connection endpoint for the DB shard group.
     * </p>
     * 
     * @return The connection endpoint for the DB shard group.
     */
    public final String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbShardGroupResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxACU());
        hashCode = 31 * hashCode + Objects.hashCode(minACU());
        hashCode = 31 * hashCode + Objects.hashCode(computeRedundancy());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbShardGroupResponse)) {
            return false;
        }
        DeleteDbShardGroupResponse other = (DeleteDbShardGroupResponse) obj;
        return Objects.equals(dbShardGroupResourceId(), other.dbShardGroupResourceId())
                && Objects.equals(dbShardGroupIdentifier(), other.dbShardGroupIdentifier())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(maxACU(), other.maxACU())
                && Objects.equals(minACU(), other.minACU()) && Objects.equals(computeRedundancy(), other.computeRedundancy())
                && Objects.equals(status(), other.status()) && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDbShardGroupResponse").add("DBShardGroupResourceId", dbShardGroupResourceId())
                .add("DBShardGroupIdentifier", dbShardGroupIdentifier()).add("DBClusterIdentifier", dbClusterIdentifier())
                .add("MaxACU", maxACU()).add("MinACU", minACU()).add("ComputeRedundancy", computeRedundancy())
                .add("Status", status()).add("PubliclyAccessible", publiclyAccessible()).add("Endpoint", endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBShardGroupResourceId":
            return Optional.ofNullable(clazz.cast(dbShardGroupResourceId()));
        case "DBShardGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbShardGroupIdentifier()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "MaxACU":
            return Optional.ofNullable(clazz.cast(maxACU()));
        case "MinACU":
            return Optional.ofNullable(clazz.cast(minACU()));
        case "ComputeRedundancy":
            return Optional.ofNullable(clazz.cast(computeRedundancy()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbShardGroupResponse, T> g) {
        return obj -> g.apply((DeleteDbShardGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbShardGroupResponse> {
        /**
         * <p>
         * The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
         * </p>
         * 
         * @param dbShardGroupResourceId
         *        The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbShardGroupResourceId(String dbShardGroupResourceId);

        /**
         * <p>
         * The name of the DB shard group.
         * </p>
         * 
         * @param dbShardGroupIdentifier
         *        The name of the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbShardGroupIdentifier(String dbShardGroupIdentifier);

        /**
         * <p>
         * The name of the primary DB cluster for the DB shard group.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the primary DB cluster for the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         * </p>
         * 
         * @param maxACU
         *        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxACU(Double maxACU);

        /**
         * <p>
         * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * </p>
         * 
         * @param minACU
         *        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minACU(Double minACU);

        /**
         * <p>
         * Specifies whether to create standby instances for the DB shard group. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only
         * one supported for the preview.
         * </p>
         * </li>
         * <li>
         * <p>
         * 1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each
         * physical shard.
         * </p>
         * </li>
         * <li>
         * <p>
         * 2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param computeRedundancy
         *        Specifies whether to create standby instances for the DB shard group. Valid values are the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the
         *        only one supported for the preview.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for
         *        each physical shard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeRedundancy(Integer computeRedundancy);

        /**
         * <p>
         * The status of the DB shard group.
         * </p>
         * 
         * @param status
         *        The status of the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether the DB shard group is publicly accessible.
         * </p>
         * <p>
         * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private
         * IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address
         * from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the
         * security group it uses. That public access isn't permitted if the security group assigned to the DB shard
         * group doesn't permit it.
         * </p>
         * <p>
         * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that
         * resolves to a private IP address.
         * </p>
         * <p>
         * For more information, see <a>CreateDBShardGroup</a>.
         * </p>
         * <p>
         * This setting is only for Aurora Limitless Database.
         * </p>
         * 
         * @param publiclyAccessible
         *        Indicates whether the DB shard group is publicly accessible.</p>
         *        <p>
         *        When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the
         *        public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately
         *        controlled by the security group it uses. That public access isn't permitted if the security group
         *        assigned to the DB shard group doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name
         *        that resolves to a private IP address.
         *        </p>
         *        <p>
         *        For more information, see <a>CreateDBShardGroup</a>.
         *        </p>
         *        <p>
         *        This setting is only for Aurora Limitless Database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The connection endpoint for the DB shard group.
         * </p>
         * 
         * @param endpoint
         *        The connection endpoint for the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String dbShardGroupResourceId;

        private String dbShardGroupIdentifier;

        private String dbClusterIdentifier;

        private Double maxACU;

        private Double minACU;

        private Integer computeRedundancy;

        private String status;

        private Boolean publiclyAccessible;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbShardGroupResponse model) {
            super(model);
            dbShardGroupResourceId(model.dbShardGroupResourceId);
            dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            dbClusterIdentifier(model.dbClusterIdentifier);
            maxACU(model.maxACU);
            minACU(model.minACU);
            computeRedundancy(model.computeRedundancy);
            status(model.status);
            publiclyAccessible(model.publiclyAccessible);
            endpoint(model.endpoint);
        }

        public final String getDbShardGroupResourceId() {
            return dbShardGroupResourceId;
        }

        public final void setDbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
        }

        @Override
        public final Builder dbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
            return this;
        }

        public final String getDbShardGroupIdentifier() {
            return dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Double getMaxACU() {
            return maxACU;
        }

        public final void setMaxACU(Double maxACU) {
            this.maxACU = maxACU;
        }

        @Override
        public final Builder maxACU(Double maxACU) {
            this.maxACU = maxACU;
            return this;
        }

        public final Double getMinACU() {
            return minACU;
        }

        public final void setMinACU(Double minACU) {
            this.minACU = minACU;
        }

        @Override
        public final Builder minACU(Double minACU) {
            this.minACU = minACU;
            return this;
        }

        public final Integer getComputeRedundancy() {
            return computeRedundancy;
        }

        public final void setComputeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
        }

        @Override
        public final Builder computeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public DeleteDbShardGroupResponse build() {
            return new DeleteDbShardGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
