/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbShardGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbShardGroupRequest> {
    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBShardGroupIdentifier").getter(CreateDbShardGroupRequest.getter(CreateDbShardGroupRequest::dbShardGroupIdentifier)).setter(CreateDbShardGroupRequest.setter(Builder::dbShardGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(CreateDbShardGroupRequest.getter(CreateDbShardGroupRequest::dbClusterIdentifier)).setter(CreateDbShardGroupRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Integer> COMPUTE_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ComputeRedundancy").getter(CreateDbShardGroupRequest.getter(CreateDbShardGroupRequest::computeRedundancy)).setter(CreateDbShardGroupRequest.setter(Builder::computeRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeRedundancy").build()}).build();
    private static final SdkField<Double> MAX_ACU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxACU").getter(CreateDbShardGroupRequest.getter(CreateDbShardGroupRequest::maxACU)).setter(CreateDbShardGroupRequest.setter(Builder::maxACU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxACU").build()}).build();
    private static final SdkField<Double> MIN_ACU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinACU").getter(CreateDbShardGroupRequest.getter(CreateDbShardGroupRequest::minACU)).setter(CreateDbShardGroupRequest.setter(Builder::minACU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinACU").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(CreateDbShardGroupRequest.getter(CreateDbShardGroupRequest::publiclyAccessible)).setter(CreateDbShardGroupRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SHARD_GROUP_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, COMPUTE_REDUNDANCY_FIELD, MAX_ACU_FIELD, MIN_ACU_FIELD, PUBLICLY_ACCESSIBLE_FIELD));
    private final String dbShardGroupIdentifier;
    private final String dbClusterIdentifier;
    private final Integer computeRedundancy;
    private final Double maxACU;
    private final Double minACU;
    private final Boolean publiclyAccessible;

    private CreateDbShardGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.computeRedundancy = builder.computeRedundancy;
        this.maxACU = builder.maxACU;
        this.minACU = builder.minACU;
        this.publiclyAccessible = builder.publiclyAccessible;
    }

    public final String dbShardGroupIdentifier() {
        return this.dbShardGroupIdentifier;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final Integer computeRedundancy() {
        return this.computeRedundancy;
    }

    public final Double maxACU() {
        return this.maxACU;
    }

    public final Double minACU() {
        return this.minACU;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeRedundancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxACU());
        hashCode = 31 * hashCode + Objects.hashCode(this.minACU());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbShardGroupRequest)) {
            return false;
        }
        CreateDbShardGroupRequest other = (CreateDbShardGroupRequest)((Object)obj);
        return Objects.equals(this.dbShardGroupIdentifier(), other.dbShardGroupIdentifier()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.computeRedundancy(), other.computeRedundancy()) && Objects.equals(this.maxACU(), other.maxACU()) && Objects.equals(this.minACU(), other.minACU()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDbShardGroupRequest").add("DBShardGroupIdentifier", (Object)this.dbShardGroupIdentifier()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("ComputeRedundancy", (Object)this.computeRedundancy()).add("MaxACU", (Object)this.maxACU()).add("MinACU", (Object)this.minACU()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBShardGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupIdentifier()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "ComputeRedundancy": {
                return Optional.ofNullable(clazz.cast(this.computeRedundancy()));
            }
            case "MaxACU": {
                return Optional.ofNullable(clazz.cast(this.maxACU()));
            }
            case "MinACU": {
                return Optional.ofNullable(clazz.cast(this.minACU()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbShardGroupRequest, T> g) {
        return obj -> g.apply((CreateDbShardGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbShardGroupIdentifier;
        private String dbClusterIdentifier;
        private Integer computeRedundancy;
        private Double maxACU;
        private Double minACU;
        private Boolean publiclyAccessible;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbShardGroupRequest model) {
            super(model);
            this.dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.computeRedundancy(model.computeRedundancy);
            this.maxACU(model.maxACU);
            this.minACU(model.minACU);
            this.publiclyAccessible(model.publiclyAccessible);
        }

        public final String getDbShardGroupIdentifier() {
            return this.dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Integer getComputeRedundancy() {
            return this.computeRedundancy;
        }

        public final void setComputeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
        }

        @Override
        public final Builder computeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
            return this;
        }

        public final Double getMaxACU() {
            return this.maxACU;
        }

        public final void setMaxACU(Double maxACU) {
            this.maxACU = maxACU;
        }

        @Override
        public final Builder maxACU(Double maxACU) {
            this.maxACU = maxACU;
            return this;
        }

        public final Double getMinACU() {
            return this.minACU;
        }

        public final void setMinACU(Double minACU) {
            this.minACU = minACU;
        }

        @Override
        public final Builder minACU(Double minACU) {
            this.minACU = minACU;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbShardGroupRequest build() {
            return new CreateDbShardGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbShardGroupRequest> {
        public Builder dbShardGroupIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder computeRedundancy(Integer var1);

        public Builder maxACU(Double var1);

        public Builder minACU(Double var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

