/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.rds.internal.RdsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.rds.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.rds.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentNotFoundException;
import software.amazon.awssdk.services.rds.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.rds.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.rds.model.CertificateNotFoundException;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionException;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.rds.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateTenantDatabaseRequest;
import software.amazon.awssdk.services.rds.model.CreateTenantDatabaseResponse;
import software.amazon.awssdk.services.rds.model.CustomAvailabilityZoneNotFoundException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionNotFoundException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterAutomatedBackupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterAutomatedBackupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterBacktrackNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbInstanceAutomatedBackupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceAutomatedBackupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbLogFileNotFoundException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetAlreadyRegisteredException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupNotSupportedException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbShardGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbShardGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSnapshotTenantDatabaseNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupNotAllowedException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.rds.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteTenantDatabaseRequest;
import software.amazon.awssdk.services.rds.model.DeleteTenantDatabaseResponse;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbShardGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbShardGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventsResponse;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.rds.model.DisableHttpEndpointRequest;
import software.amazon.awssdk.services.rds.model.DisableHttpEndpointResponse;
import software.amazon.awssdk.services.rds.model.DomainNotFoundException;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse;
import software.amazon.awssdk.services.rds.model.Ec2ImagePropertiesNotSupportedException;
import software.amazon.awssdk.services.rds.model.EnableHttpEndpointRequest;
import software.amazon.awssdk.services.rds.model.EnableHttpEndpointResponse;
import software.amazon.awssdk.services.rds.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.rds.model.ExportTaskAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.ExportTaskNotFoundException;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.GlobalClusterAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.GlobalClusterNotFoundException;
import software.amazon.awssdk.services.rds.model.GlobalClusterQuotaExceededException;
import software.amazon.awssdk.services.rds.model.IamRoleMissingPermissionsException;
import software.amazon.awssdk.services.rds.model.IamRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.rds.model.InsufficientAvailableIPsInSubnetException;
import software.amazon.awssdk.services.rds.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.rds.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.rds.model.IntegrationAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.IntegrationConflictOperationException;
import software.amazon.awssdk.services.rds.model.IntegrationNotFoundException;
import software.amazon.awssdk.services.rds.model.IntegrationQuotaExceededException;
import software.amazon.awssdk.services.rds.model.InvalidBlueGreenDeploymentStateException;
import software.amazon.awssdk.services.rds.model.InvalidCustomDbEngineVersionStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterAutomatedBackupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterEndpointStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbInstanceAutomatedBackupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbProxyEndpointStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbProxyStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbShardGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetGroupException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.rds.model.InvalidEventSubscriptionStateException;
import software.amazon.awssdk.services.rds.model.InvalidExportOnlyException;
import software.amazon.awssdk.services.rds.model.InvalidExportSourceStateException;
import software.amazon.awssdk.services.rds.model.InvalidExportTaskStateException;
import software.amazon.awssdk.services.rds.model.InvalidGlobalClusterStateException;
import software.amazon.awssdk.services.rds.model.InvalidIntegrationStateException;
import software.amazon.awssdk.services.rds.model.InvalidOptionGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidResourceStateException;
import software.amazon.awssdk.services.rds.model.InvalidRestoreException;
import software.amazon.awssdk.services.rds.model.InvalidS3BucketException;
import software.amazon.awssdk.services.rds.model.InvalidSubnetException;
import software.amazon.awssdk.services.rds.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.rds.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rds.model.MaxDbShardGroupLimitReachedException;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbRecommendationRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbRecommendationResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyIntegrationRequest;
import software.amazon.awssdk.services.rds.model.ModifyIntegrationResponse;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyTenantDatabaseRequest;
import software.amazon.awssdk.services.rds.model.ModifyTenantDatabaseResponse;
import software.amazon.awssdk.services.rds.model.NetworkTypeNotSupportedException;
import software.amazon.awssdk.services.rds.model.OptionGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.OptionGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.OptionGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.PointInTimeRestoreNotEnabledException;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.ProvisionedIopsNotAvailableInAzException;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse;
import software.amazon.awssdk.services.rds.model.RdsException;
import software.amazon.awssdk.services.rds.model.RebootDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RebootDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RebootDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.RebootDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceNotFoundException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceQuotaExceededException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstancesOfferingNotFoundException;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.rds.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.rds.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.rds.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.rds.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.rds.model.SourceClusterNotSupportedException;
import software.amazon.awssdk.services.rds.model.SourceDatabaseNotSupportedException;
import software.amazon.awssdk.services.rds.model.SourceNotFoundException;
import software.amazon.awssdk.services.rds.model.StartActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StartActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StartDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StartDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.StartExportTaskRequest;
import software.amazon.awssdk.services.rds.model.StartExportTaskResponse;
import software.amazon.awssdk.services.rds.model.StopActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StopActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StopDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StopDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.rds.model.StorageTypeNotAvailableException;
import software.amazon.awssdk.services.rds.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.rds.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.rds.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.rds.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.rds.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.TenantDatabaseAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.TenantDatabaseNotFoundException;
import software.amazon.awssdk.services.rds.model.TenantDatabaseQuotaExceededException;
import software.amazon.awssdk.services.rds.model.UnsupportedDbEngineVersionException;
import software.amazon.awssdk.services.rds.transform.AddRoleToDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AddRoleToDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AddSourceIdentifierToSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AuthorizeDbSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.BacktrackDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateBlueGreenDeploymentRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateCustomDbEngineVersionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbInstanceReadReplicaRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbProxyEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbProxyRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbShardGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateTenantDatabaseRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteBlueGreenDeploymentRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteCustomDbEngineVersionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterAutomatedBackupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbInstanceAutomatedBackupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbProxyEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbProxyRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbShardGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteTenantDatabaseRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeregisterDbProxyTargetsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeBlueGreenDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterAutomatedBackupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterBacktracksRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterEndpointsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbInstanceAutomatedBackupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbLogFilesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxiesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxyEndpointsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxyTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxyTargetsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbShardGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSnapshotTenantDatabasesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeGlobalClustersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeOptionGroupOptionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeOptionGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeReservedDbInstancesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeReservedDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeSourceRegionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeTenantDatabasesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeValidDbInstanceModificationsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DisableHttpEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DownloadDbLogFilePortionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.EnableHttpEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.FailoverGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyActivityStreamRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyCertificatesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyCurrentDbClusterCapacityRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyCustomDbEngineVersionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbProxyEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbProxyRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbProxyTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbRecommendationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbShardGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyIntegrationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyTenantDatabaseRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.PromoteReadReplicaDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.PromoteReadReplicaRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.PurchaseReservedDbInstancesOfferingRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RebootDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RebootDbShardGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RegisterDbProxyTargetsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveFromGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveRoleFromDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveRoleFromDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveSourceIdentifierFromSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ResetDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbClusterFromS3RequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbInstanceFromDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbInstanceFromS3RequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbInstanceToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RevokeDbSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartActivityStreamRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartDbInstanceAutomatedBackupsReplicationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartExportTaskRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopActivityStreamRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopDbInstanceAutomatedBackupsReplicationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.SwitchoverBlueGreenDeploymentRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.SwitchoverGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.SwitchoverReadReplicaRequestMarshaller;
import software.amazon.awssdk.services.rds.waiters.RdsWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link RdsClient}.
 *
 * @see RdsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRdsClient implements RdsClient {
    private static final Logger log = Logger.loggerFor(DefaultRdsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.QUERY).build();

    private final SyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRdsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     * </p>
     *
     * @param addRoleToDbClusterRequest
     * @return Result of the AddRoleToDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterRoleAlreadyExistsException
     *         The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterRoleQuotaExceededException
     *         You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddRoleToDbClusterResponse addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest)
            throws DbClusterNotFoundException, DbClusterRoleAlreadyExistsException, InvalidDbClusterStateException,
            DbClusterRoleQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<AddRoleToDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(AddRoleToDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addRoleToDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRoleToDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRoleToDBCluster");

            return clientHandler.execute(new ClientExecutionParams<AddRoleToDbClusterRequest, AddRoleToDbClusterResponse>()
                    .withOperationName("AddRoleToDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addRoleToDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddRoleToDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     * </p>
     * <note>
     * <p>
     * To add a role to a DB instance, the status of the DB instance must be <code>available</code>.
     * </p>
     * </note>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param addRoleToDbInstanceRequest
     * @return Result of the AddRoleToDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbInstanceRoleAlreadyExistsException
     *         The specified <code>RoleArn</code> or <code>FeatureName</code> value is already associated with the DB
     *         instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceRoleQuotaExceededException
     *         You can't associate any more Amazon Web Services Identity and Access Management (IAM) roles with the DB
     *         instance because the quota has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddRoleToDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddRoleToDbInstanceResponse addRoleToDBInstance(AddRoleToDbInstanceRequest addRoleToDbInstanceRequest)
            throws DbInstanceNotFoundException, DbInstanceRoleAlreadyExistsException, InvalidDbInstanceStateException,
            DbInstanceRoleQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<AddRoleToDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(AddRoleToDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addRoleToDbInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRoleToDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRoleToDBInstance");

            return clientHandler.execute(new ClientExecutionParams<AddRoleToDbInstanceRequest, AddRoleToDbInstanceResponse>()
                    .withOperationName("AddRoleToDBInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addRoleToDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddRoleToDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a source identifier to an existing RDS event notification subscription.
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     * @return Result of the AddSourceIdentifierToSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SourceNotFoundException
     *         The requested source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddSourceIdentifierToSubscriptionResponse addSourceIdentifierToSubscription(
            AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest)
            throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<AddSourceIdentifierToSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(AddSourceIdentifierToSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addSourceIdentifierToSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addSourceIdentifierToSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddSourceIdentifierToSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<AddSourceIdentifierToSubscriptionRequest, AddSourceIdentifierToSubscriptionResponse>()
                            .withOperationName("AddSourceIdentifierToSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(addSourceIdentifierToSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddSourceIdentifierToSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track
     * cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * </p>
     * <p>
     * For an overview on tagging your relational database resources, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a>
     * or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora
     * and Amazon RDS Resources</a>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws IntegrationNotFoundException
     *         The specified integration could not be found.
     * @throws TenantDatabaseNotFoundException
     *         The specified tenant database wasn't found in the DB instance.
     * @throws DbSnapshotTenantDatabaseNotFoundException
     *         The specified snapshot tenant database wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws DbInstanceNotFoundException, DbClusterNotFoundException, DbSnapshotNotFoundException,
            DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, BlueGreenDeploymentNotFoundException,
            IntegrationNotFoundException, TenantDatabaseNotFoundException, DbSnapshotTenantDatabaseNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(AddTagsToResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                    .withOperationName("AddTagsToResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addTagsToResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<ApplyPendingMaintenanceActionResponse> responseHandler = protocolFactory
                .createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(applyPendingMaintenanceActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplyPendingMaintenanceAction");

            return clientHandler
                    .execute(new ClientExecutionParams<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse>()
                            .withOperationName("ApplyPendingMaintenanceAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(applyPendingMaintenanceActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ApplyPendingMaintenanceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups
     * can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances.
     * Second, IP ranges are available if the application accessing your database is running on the internet. Required
     * parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
     * EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     * </p>
     * <p>
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB
     * instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB
     * instance in another.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param authorizeDbSecurityGroupIngressRequest
     * @return Result of the AuthorizeDBSecurityGroupIngress operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws AuthorizationAlreadyExistsException
     *         The specified CIDR IP range or Amazon EC2 security group is already authorized for the specified DB
     *         security group.
     * @throws AuthorizationQuotaExceededException
     *         The DB security group authorization quota has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AuthorizeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AuthorizeDbSecurityGroupIngressResponse authorizeDBSecurityGroupIngress(
            AuthorizeDbSecurityGroupIngressRequest authorizeDbSecurityGroupIngressRequest)
            throws DbSecurityGroupNotFoundException, InvalidDbSecurityGroupStateException, AuthorizationAlreadyExistsException,
            AuthorizationQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<AuthorizeDbSecurityGroupIngressResponse> responseHandler = protocolFactory
                .createResponseHandler(AuthorizeDbSecurityGroupIngressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeDbSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                authorizeDbSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeDBSecurityGroupIngress");

            return clientHandler
                    .execute(new ClientExecutionParams<AuthorizeDbSecurityGroupIngressRequest, AuthorizeDbSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeDBSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(authorizeDbSecurityGroupIngressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AuthorizeDbSecurityGroupIngressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * </p>
     * <p>
     * For more information on backtracking, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param backtrackDbClusterRequest
     * @return Result of the BacktrackDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.BacktrackDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BacktrackDbClusterResponse backtrackDBCluster(BacktrackDbClusterRequest backtrackDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<BacktrackDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(BacktrackDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(backtrackDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, backtrackDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BacktrackDBCluster");

            return clientHandler.execute(new ClientExecutionParams<BacktrackDbClusterRequest, BacktrackDbClusterResponse>()
                    .withOperationName("BacktrackDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(backtrackDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BacktrackDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has
     * already been written to the S3 bucket isn't removed.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return Result of the CancelExportTask operation returned by the service.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws InvalidExportTaskStateException
     *         You can't cancel an export task that has completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelExportTaskResponse cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest)
            throws ExportTaskNotFoundException, InvalidExportTaskStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<CancelExportTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelExportTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelExportTask");

            return clientHandler.execute(new ClientExecutionParams<CancelExportTaskRequest, CancelExportTaskResponse>()
                    .withOperationName("CancelExportTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelExportTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelExportTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     * <note>
     * <p>
     * You can't copy a default DB cluster parameter group. Instead, create a new custom DB cluster parameter group,
     * which copies the default parameters and values for the specified DB cluster parameter group family.
     * </p>
     * </note>
     *
     * @param copyDbClusterParameterGroupRequest
     * @return Result of the CopyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<CopyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyDbClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CopyDbClusterParameterGroupRequest, CopyDbClusterParameterGroupResponse>()
                            .withOperationName("CopyDBClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(copyDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CopyDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon
     * Web Services Region where you call the <code>CopyDBClusterSnapshot</code> operation is the destination Amazon Web
     * Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot
     * from another Amazon Web Services Region, you must provide the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier
     * for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is
     * the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the presigned URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     * <p>
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region
     * to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     * @return Result of the CopyDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException,
            InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CopyDbClusterSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyDbClusterSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyDbClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBClusterSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CopyDbClusterSnapshotRequest, CopyDbClusterSnapshotResponse>()
                    .withOperationName("CopyDBClusterSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copyDbClusterSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyDbClusterSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     * <note>
     * <p>
     * You can't copy a default DB parameter group. Instead, create a new custom DB parameter group, which copies the
     * default parameters and values for the specified DB parameter group family.
     * </p>
     * </note>
     *
     * @param copyDbParameterGroupRequest
     * @return Result of the CopyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyDbParameterGroupResponse copyDBParameterGroup(CopyDbParameterGroupRequest copyDbParameterGroupRequest)
            throws DbParameterGroupNotFoundException, DbParameterGroupAlreadyExistsException,
            DbParameterGroupQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CopyDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyDbParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<CopyDbParameterGroupRequest, CopyDbParameterGroupResponse>()
                    .withOperationName("CopyDBParameterGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copyDbParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.
     * </p>
     * <p>
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services
     * Region where you call the <code>CopyDBSnapshot</code> operation is the destination Amazon Web Services Region for
     * the DB snapshot copy.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information about copying snapshots, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying
     * a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbSnapshotRequest
     * @return Result of the CopyDBSnapshot operation returned by the service.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws CustomAvailabilityZoneNotFoundException
     *         <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom Availability Zone identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyDbSnapshotResponse copyDBSnapshot(CopyDbSnapshotRequest copyDbSnapshotRequest)
            throws DbSnapshotAlreadyExistsException, DbSnapshotNotFoundException, InvalidDbSnapshotStateException,
            SnapshotQuotaExceededException, KmsKeyNotAccessibleException, CustomAvailabilityZoneNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CopyDbSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyDbSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyDbSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CopyDbSnapshotRequest, CopyDbSnapshotResponse>()
                    .withOperationName("CopyDBSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copyDbSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyDbSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified option group.
     * </p>
     *
     * @param copyOptionGroupRequest
     * @return Result of the CopyOptionGroup operation returned by the service.
     * @throws OptionGroupAlreadyExistsException
     *         The option group you are trying to create already exists.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws OptionGroupQuotaExceededException
     *         The quota of 20 option groups was exceeded for this Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyOptionGroupResponse copyOptionGroup(CopyOptionGroupRequest copyOptionGroupRequest)
            throws OptionGroupAlreadyExistsException, OptionGroupNotFoundException, OptionGroupQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CopyOptionGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyOptionGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyOptionGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyOptionGroup");

            return clientHandler.execute(new ClientExecutionParams<CopyOptionGroupRequest, CopyOptionGroupResponse>()
                    .withOperationName("CopyOptionGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copyOptionGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyOptionGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a blue/green deployment.
     * </p>
     * <p>
     * A blue/green deployment creates a staging environment that copies the production environment. In a blue/green
     * deployment, the blue environment is the current production environment. The green environment is the staging
     * environment. The staging environment stays in sync with the current production environment using logical
     * replication.
     * </p>
     * <p>
     * You can make changes to the databases in the green environment without affecting production workloads. For
     * example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes
     * in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch
     * over the environments to promote the green environment to be the new production environment. The switchover
     * typically takes under a minute.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createBlueGreenDeploymentRequest
     * @return Result of the CreateBlueGreenDeployment operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SourceDatabaseNotSupportedException
     *         The source DB instance isn't supported for a blue/green deployment.
     * @throws SourceClusterNotSupportedException
     *         The source DB cluster isn't supported for a blue/green deployment.
     * @throws BlueGreenDeploymentAlreadyExistsException
     *         A blue/green deployment with the specified name already exists.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBlueGreenDeploymentResponse createBlueGreenDeployment(
            CreateBlueGreenDeploymentRequest createBlueGreenDeploymentRequest) throws DbInstanceNotFoundException,
            DbClusterNotFoundException, SourceDatabaseNotSupportedException, SourceClusterNotSupportedException,
            BlueGreenDeploymentAlreadyExistsException, DbParameterGroupNotFoundException,
            DbClusterParameterGroupNotFoundException, InstanceQuotaExceededException, DbClusterQuotaExceededException,
            InvalidDbInstanceStateException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<CreateBlueGreenDeploymentResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateBlueGreenDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBlueGreenDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBlueGreenDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBlueGreenDeployment");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateBlueGreenDeploymentRequest, CreateBlueGreenDeploymentResponse>()
                            .withOperationName("CreateBlueGreenDeployment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createBlueGreenDeploymentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateBlueGreenDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom DB engine version (CEV).
     * </p>
     *
     * @param createCustomDbEngineVersionRequest
     * @return Result of the CreateCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionAlreadyExistsException
     *         A CEV with the specified name already exists.
     * @throws CustomDbEngineVersionQuotaExceededException
     *         You have exceeded your CEV quota.
     * @throws Ec2ImagePropertiesNotSupportedException
     *         The AMI configuration prerequisite has not been met.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws CreateCustomDbEngineVersionException
     *         An error occurred while trying to create the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCustomDbEngineVersionResponse createCustomDBEngineVersion(
            CreateCustomDbEngineVersionRequest createCustomDbEngineVersionRequest)
            throws CustomDbEngineVersionAlreadyExistsException, CustomDbEngineVersionQuotaExceededException,
            Ec2ImagePropertiesNotSupportedException, KmsKeyNotAccessibleException, CreateCustomDbEngineVersionException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateCustomDbEngineVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCustomDbEngineVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomDbEngineVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomDbEngineVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomDBEngineVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCustomDbEngineVersionRequest, CreateCustomDbEngineVersionResponse>()
                            .withOperationName("CreateCustomDBEngineVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCustomDbEngineVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCustomDbEngineVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * </p>
     * <p>
     * If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer
     * instance for your DB cluster using the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a>
     * operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you,
     * each in a different Availability Zone.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a
     * read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about
     * Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * You can also use the <code>ReplicationSourceIdentifier</code> parameter to create a Multi-AZ DB cluster read
     * replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB
     * clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterRequest
     * @return Result of the CreateDBCluster operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You might be able to resolve this error
     *         by updating your subnet group to use different Availability Zones that have more storage available.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbSubnetGroupException
     *         The DBSubnetGroup doesn't belong to the same VPC as that of an existing cross-region read replica of the
     *         same source instance.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest)
            throws DbClusterAlreadyExistsException, InsufficientDbInstanceCapacityException,
            InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbClusterStateException,
            InvalidDbSubnetGroupException, InvalidDbSubnetGroupStateException, InvalidSubnetException,
            InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException,
            DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            GlobalClusterNotFoundException, InvalidGlobalClusterStateException, DomainNotFoundException,
            OptionGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateDbClusterRequest, CreateDbClusterResponse>()
                    .withOperationName("CreateDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createDbClusterEndpointRequest
     * @return Result of the CreateDBClusterEndpoint operation returned by the service.
     * @throws DbClusterEndpointQuotaExceededException
     *         The cluster already has the maximum number of custom endpoints.
     * @throws DbClusterEndpointAlreadyExistsException
     *         The specified custom endpoint can't be created because it already exists.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDbClusterEndpointResponse createDBClusterEndpoint(CreateDbClusterEndpointRequest createDbClusterEndpointRequest)
            throws DbClusterEndpointQuotaExceededException, DbClusterEndpointAlreadyExistsException, DbClusterNotFoundException,
            InvalidDbClusterStateException, DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<CreateDbClusterEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbClusterEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterEndpointRequest, CreateDbClusterEndpointResponse>()
                            .withOperationName("CreateDBClusterEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDbClusterEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbClusterEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group,
     * you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in
     * the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster
     * without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the DB cluster parameter group is used as the default for a new DB cluster.
     * This is especially important for parameters that are critical when creating the default database for a DB
     * cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code>
     * operation to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     * @return Result of the CreateDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<CreateDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterParameterGroupRequest, CreateDbClusterParameterGroupResponse>()
                            .withOperationName("CreateDBClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     * @return Result of the CreateDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<CreateDbClusterSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterSnapshotRequest, CreateDbClusterSnapshotResponse>()
                            .withOperationName("CreateDBClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDbClusterSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbClusterSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <p>
     * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora
     * DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.
     * </p>
     * <p>
     * For more information about creating an RDS DB instance, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html"> Creating an Amazon RDS
     * DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a DB instance in an Aurora DB cluster, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html"> Creating an
     * Amazon Aurora DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return Result of the CreateDBInstance operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws TenantDatabaseQuotaExceededException
     *         You attempted to create more tenant databases than are permitted in your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException,
            InvalidSubnetException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, DbClusterNotFoundException, StorageTypeNotSupportedException,
            AuthorizationNotFoundException, KmsKeyNotAccessibleException, DomainNotFoundException,
            NetworkTypeNotSupportedException, CertificateNotFoundException, TenantDatabaseQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBInstance");

            return clientHandler.execute(new ClientExecutionParams<CreateDbInstanceRequest, CreateDbInstanceResponse>()
                    .withOperationName("CreateDBInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster.
     * You can create a read replica for a DB instance running Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server.
     * You can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with read replicas</a>
     * and <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica"
     * >Migrating from a Multi-AZ DB cluster to a DB instance using a read replica</a> in the <i>Amazon RDS User
     * Guide</i>.
     * </p>
     * <p>
     * Amazon Aurora doesn't support this operation. To create a DB instance for an Aurora DB cluster, use the
     * <code>CreateDBInstance</code> operation.
     * </p>
     * <p>
     * All read replica DB instances are created with backups disabled. All other attributes (including DB security
     * groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.
     * </p>
     * <important>
     * <p>
     * Your source DB instance or cluster must have backup retention enabled.
     * </p>
     * </important>
     *
     * @param createDbInstanceReadReplicaRequest
     * @return Result of the CreateDBInstanceReadReplica operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbSubnetGroupNotAllowedException
     *         The DBSubnetGroup shouldn't be specified while creating read replicas that lie in the same region as the
     *         source instance.
     * @throws InvalidDbSubnetGroupException
     *         The DBSubnetGroup doesn't belong to the same VPC as that of an existing cross-region read replica of the
     *         same source instance.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws TenantDatabaseQuotaExceededException
     *         You attempted to create more tenant databases than are permitted in your Amazon Web Services account.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBInstanceReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDbInstanceReadReplicaResponse createDBInstanceReadReplica(
            CreateDbInstanceReadReplicaRequest createDbInstanceReadReplicaRequest) throws DbInstanceAlreadyExistsException,
            InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException, DbSecurityGroupNotFoundException,
            InstanceQuotaExceededException, StorageQuotaExceededException, DbInstanceNotFoundException,
            DbClusterNotFoundException, InvalidDbInstanceStateException, InvalidDbClusterStateException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException,
            InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException,
            DbSubnetGroupNotAllowedException, InvalidDbSubnetGroupException, StorageTypeNotSupportedException,
            KmsKeyNotAccessibleException, DomainNotFoundException, NetworkTypeNotSupportedException,
            TenantDatabaseQuotaExceededException, CertificateNotFoundException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<CreateDbInstanceReadReplicaResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbInstanceReadReplicaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbInstanceReadReplicaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbInstanceReadReplicaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBInstanceReadReplica");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbInstanceReadReplicaRequest, CreateDbInstanceReadReplicaResponse>()
                            .withOperationName("CreateDBInstanceReadReplica").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDbInstanceReadReplicaRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbInstanceReadReplicaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <code>ModifyDBParameterGroup</code>. Once you've created a DB parameter group, you need to associate it with your
     * DB instance using <code>ModifyDBInstance</code>. When you associate a new DB parameter group with a running DB
     * instance, you need to reboot the DB instance without failover for the new DB parameter group and associated
     * settings to take effect.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbParameterGroupRequest
     * @return Result of the CreateDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDbParameterGroupResponse createDBParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<CreateDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbParameterGroupRequest, CreateDbParameterGroupResponse>()
                            .withOperationName("CreateDBParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDbParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB proxy.
     * </p>
     *
     * @param createDbProxyRequest
     * @return Result of the CreateDBProxy operation returned by the service.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbProxyAlreadyExistsException
     *         The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyQuotaExceededException
     *         Your Amazon Web Services account already has the maximum number of proxies in the specified Amazon Web
     *         Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbProxyResponse createDBProxy(CreateDbProxyRequest createDbProxyRequest) throws InvalidSubnetException,
            DbProxyAlreadyExistsException, DbProxyQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateDbProxyResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbProxyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbProxyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBProxy");

            return clientHandler.execute(new ClientExecutionParams<CreateDbProxyRequest, CreateDbProxyResponse>()
                    .withOperationName("CreateDBProxy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbProxyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbProxyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters. You
     * can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy
     * endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     * </p>
     *
     * @param createDbProxyEndpointRequest
     * @return Result of the CreateDBProxyEndpoint operation returned by the service.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointAlreadyExistsException
     *         The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyEndpointQuotaExceededException
     *         The DB proxy already has the maximum number of endpoints.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbProxyEndpointResponse createDBProxyEndpoint(CreateDbProxyEndpointRequest createDbProxyEndpointRequest)
            throws InvalidSubnetException, DbProxyNotFoundException, DbProxyEndpointAlreadyExistsException,
            DbProxyEndpointQuotaExceededException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<CreateDbProxyEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbProxyEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbProxyEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbProxyEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBProxyEndpoint");

            return clientHandler.execute(new ClientExecutionParams<CreateDbProxyEndpointRequest, CreateDbProxyEndpointResponse>()
                    .withOperationName("CreateDBProxyEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbProxyEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbProxyEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB security group. DB security groups control access to a DB instance.
     * </p>
     * <p>
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param createDbSecurityGroupRequest
     * @return Result of the CreateDBSecurityGroup operation returned by the service.
     * @throws DbSecurityGroupAlreadyExistsException
     *         A DB security group with the name specified in <code>DBSecurityGroupName</code> already exists.
     * @throws DbSecurityGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB security groups.
     * @throws DbSecurityGroupNotSupportedException
     *         A DB security group isn't allowed for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbSecurityGroupResponse createDBSecurityGroup(CreateDbSecurityGroupRequest createDbSecurityGroupRequest)
            throws DbSecurityGroupAlreadyExistsException, DbSecurityGroupQuotaExceededException,
            DbSecurityGroupNotSupportedException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateDbSecurityGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBSecurityGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateDbSecurityGroupRequest, CreateDbSecurityGroupResponse>()
                    .withOperationName("CreateDBSecurityGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbSecurityGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a
     * DB shard group.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     *
     * @param createDbShardGroupRequest
     * @return Result of the CreateDBShardGroup operation returned by the service.
     * @throws DbShardGroupAlreadyExistsException
     *         The specified DB shard group name must be unique in your Amazon Web Services account in the specified
     *         Amazon Web Services Region.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws MaxDbShardGroupLimitReachedException
     *         The maximum number of DB shard groups for your Amazon Web Services account in the specified Amazon Web
     *         Services Region has been reached.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws UnsupportedDbEngineVersionException
     *         The specified DB engine version isn't supported for Aurora Limitless Database.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbShardGroupResponse createDBShardGroup(CreateDbShardGroupRequest createDbShardGroupRequest)
            throws DbShardGroupAlreadyExistsException, DbClusterNotFoundException, MaxDbShardGroupLimitReachedException,
            InvalidDbClusterStateException, UnsupportedDbEngineVersionException, InvalidVpcNetworkStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateDbShardGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbShardGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbShardGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbShardGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBShardGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateDbShardGroupRequest, CreateDbShardGroupResponse>()
                    .withOperationName("CreateDBShardGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbShardGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbShardGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or
     * <code>storage-optimization</code> state.
     * </p>
     *
     * @param createDbSnapshotRequest
     * @return Result of the CreateDBSnapshot operation returned by the service.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbSnapshotResponse createDBSnapshot(CreateDbSnapshotRequest createDbSnapshotRequest)
            throws DbSnapshotAlreadyExistsException, InvalidDbInstanceStateException, DbInstanceNotFoundException,
            SnapshotQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateDbSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CreateDbSnapshotRequest, CreateDbSnapshotResponse>()
                    .withOperationName("CreateDBSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Web Services Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     * @return Result of the CreateDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupAlreadyExistsException
     *         <code>DBSubnetGroupName</code> is already used by an existing DB subnet group.
     * @throws DbSubnetGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB subnet groups.
     * @throws DbSubnetQuotaExceededException
     *         The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest)
            throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<CreateDbSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDbSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateDbSubnetGroupRequest, CreateDbSubnetGroupResponse>()
                    .withOperationName("CreateDBSubnetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDbSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN)
     * created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a
     * topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) that you want to be notified of and provide a list
     * of RDS sources (<code>SourceIds</code>) that triggers the events. You can also provide a list of event categories
     * (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify
     * <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> = <code>mydbinstance1</code>,
     * <code>mydbinstance2</code> and <code>EventCategories</code> = <code>Availability</code>, <code>Backup</code>.
     * </p>
     * <p>
     * If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> =
     * <code>db-instance</code> and <code>SourceIds</code> = <code>myDBInstance1</code>, you are notified of all the
     * <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not
     * specify <code>SourceIds</code>, you receive notice of the events for that source type for all your RDS sources.
     * If you don't specify either the SourceType or the <code>SourceIds</code>, you are notified of events generated
     * from all RDS sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about subscribing to an event for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon
     * RDS event notification</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about subscribing to an event for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html"> Subscribing to
     * Amazon RDS event notification</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         You have reached the maximum number of event subscriptions.
     * @throws SubscriptionAlreadyExistException
     *         The supplied subscription name already exists.
     * @throws SnsInvalidTopicException
     *         SNS has responded that there is a problem with the SNS topic specified.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the SNS topic ARN.
     * @throws SnsTopicArnNotFoundException
     *         The SNS topic ARN does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The supplied category does not exist.
     * @throws SourceNotFoundException
     *         The requested source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException,
            SourceNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateEventSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse>()
                            .withOperationName("CreateEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then create the primary and secondary DB clusters
     * in the global database. Or you can specify an existing Aurora cluster during the create operation, and this
     * cluster becomes the primary cluster of the global database.
     * </p>
     * <note>
     * <p>
     * This operation applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createGlobalClusterRequest
     * @return Result of the CreateGlobalCluster operation returned by the service.
     * @throws GlobalClusterAlreadyExistsException
     *         The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique
     *         name) to create a new global database cluster.
     * @throws GlobalClusterQuotaExceededException
     *         The number of global database clusters for this account is already at the maximum allowed.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGlobalClusterResponse createGlobalCluster(CreateGlobalClusterRequest createGlobalClusterRequest)
            throws GlobalClusterAlreadyExistsException, GlobalClusterQuotaExceededException, InvalidDbClusterStateException,
            DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGlobalClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateGlobalClusterRequest, CreateGlobalClusterResponse>()
                    .withOperationName("CreateGlobalCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a zero-ETL integration with Amazon Redshift.
     * </p>
     *
     * @param createIntegrationRequest
     * @return Result of the CreateIntegration operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws IntegrationAlreadyExistsException
     *         The integration you are trying to create already exists.
     * @throws IntegrationQuotaExceededException
     *         You can't crate any more zero-ETL integrations because the quota has been reached.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws IntegrationConflictOperationException
     *         A conflicting conditional operation is currently in progress against this resource. Typically occurs when
     *         there are multiple requests being made to the same resource at the same time, and these requests conflict
     *         with each other.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIntegrationResponse createIntegration(CreateIntegrationRequest createIntegrationRequest)
            throws DbClusterNotFoundException, DbInstanceNotFoundException, IntegrationAlreadyExistsException,
            IntegrationQuotaExceededException, KmsKeyNotAccessibleException, IntegrationConflictOperationException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateIntegrationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegration");

            return clientHandler.execute(new ClientExecutionParams<CreateIntegrationRequest, CreateIntegrationResponse>()
                    .withOperationName("CreateIntegration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new option group. You can create up to 20 option groups.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param createOptionGroupRequest
     * @return Result of the CreateOptionGroup operation returned by the service.
     * @throws OptionGroupAlreadyExistsException
     *         The option group you are trying to create already exists.
     * @throws OptionGroupQuotaExceededException
     *         The quota of 20 option groups was exceeded for this Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateOptionGroupResponse createOptionGroup(CreateOptionGroupRequest createOptionGroupRequest)
            throws OptionGroupAlreadyExistsException, OptionGroupQuotaExceededException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<CreateOptionGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateOptionGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOptionGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOptionGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateOptionGroupRequest, CreateOptionGroupResponse>()
                    .withOperationName("CreateOptionGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOptionGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOptionGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a tenant database in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle
     * container database (CDB) instances are supported.
     * </p>
     *
     * @param createTenantDatabaseRequest
     * @return Result of the CreateTenantDatabase operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws TenantDatabaseAlreadyExistsException
     *         You attempted to either create a tenant database that already exists or modify a tenant database to use
     *         the name of an existing tenant database.
     * @throws TenantDatabaseQuotaExceededException
     *         You attempted to create more tenant databases than are permitted in your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateTenantDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateTenantDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTenantDatabaseResponse createTenantDatabase(CreateTenantDatabaseRequest createTenantDatabaseRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, TenantDatabaseAlreadyExistsException,
            TenantDatabaseQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<CreateTenantDatabaseResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTenantDatabaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTenantDatabaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTenantDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTenantDatabase");

            return clientHandler.execute(new ClientExecutionParams<CreateTenantDatabaseRequest, CreateTenantDatabaseResponse>()
                    .withOperationName("CreateTenantDatabase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTenantDatabaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTenantDatabaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a blue/green deployment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param deleteBlueGreenDeploymentRequest
     * @return Result of the DeleteBlueGreenDeployment operation returned by the service.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws InvalidBlueGreenDeploymentStateException
     *         The blue/green deployment can't be switched over or deleted because there is an invalid configuration in
     *         the green environment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBlueGreenDeploymentResponse deleteBlueGreenDeployment(
            DeleteBlueGreenDeploymentRequest deleteBlueGreenDeploymentRequest) throws BlueGreenDeploymentNotFoundException,
            InvalidBlueGreenDeploymentStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteBlueGreenDeploymentResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteBlueGreenDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBlueGreenDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBlueGreenDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBlueGreenDeployment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBlueGreenDeploymentRequest, DeleteBlueGreenDeploymentResponse>()
                            .withOperationName("DeleteBlueGreenDeployment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteBlueGreenDeploymentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteBlueGreenDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The CEV must not be the default for RDS Custom. If it is, change the default before running this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup
     * of your RDS Custom instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Typically, deletion takes a few minutes.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>DeleteCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>DeleteCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">Deleting a
     * CEV</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteCustomDbEngineVersionRequest
     * @return Result of the DeleteCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionNotFoundException
     *         The specified CEV was not found.
     * @throws InvalidCustomDbEngineVersionStateException
     *         You can't delete the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCustomDbEngineVersionResponse deleteCustomDBEngineVersion(
            DeleteCustomDbEngineVersionRequest deleteCustomDbEngineVersionRequest) throws CustomDbEngineVersionNotFoundException,
            InvalidCustomDbEngineVersionStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteCustomDbEngineVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCustomDbEngineVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomDbEngineVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomDbEngineVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomDBEngineVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomDbEngineVersionRequest, DeleteCustomDbEngineVersionResponse>()
                            .withOperationName("DeleteCustomDBEngineVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCustomDbEngineVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCustomDbEngineVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * If you're deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas
     * are promoted to standalone instances.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterRequest
     * @return Result of the DeleteDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws DbClusterAutomatedBackupQuotaExceededException
     *         The quota for retained automated backups was exceeded. This prevents you from retaining any additional
     *         automated backups. The retained automated backups quota is the same as your DB cluster quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException,
            DbClusterAutomatedBackupQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbClusterRequest, DeleteDbClusterResponse>()
                    .withOperationName("DeleteDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbClusterResourceId</code> value of the source DB cluster or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     *
     * @param deleteDbClusterAutomatedBackupRequest
     * @return Result of the DeleteDBClusterAutomatedBackup operation returned by the service.
     * @throws InvalidDbClusterAutomatedBackupStateException
     *         The automated backup is in an invalid state. For example, this automated backup is associated with an
     *         active cluster.
     * @throws DbClusterAutomatedBackupNotFoundException
     *         No automated backup for this DB cluster was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDbClusterAutomatedBackupResponse deleteDBClusterAutomatedBackup(
            DeleteDbClusterAutomatedBackupRequest deleteDbClusterAutomatedBackupRequest)
            throws InvalidDbClusterAutomatedBackupStateException, DbClusterAutomatedBackupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbClusterAutomatedBackupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterAutomatedBackupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbClusterAutomatedBackupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDbClusterAutomatedBackupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterAutomatedBackup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterAutomatedBackupRequest, DeleteDbClusterAutomatedBackupResponse>()
                            .withOperationName("DeleteDBClusterAutomatedBackup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDbClusterAutomatedBackupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbClusterAutomatedBackupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteDbClusterEndpointRequest
     * @return Result of the DeleteDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation can't be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDbClusterEndpointResponse deleteDBClusterEndpoint(DeleteDbClusterEndpointRequest deleteDbClusterEndpointRequest)
            throws InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException, InvalidDbClusterStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbClusterEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbClusterEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterEndpointRequest, DeleteDbClusterEndpointResponse>()
                            .withOperationName("DeleteDBClusterEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDbClusterEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbClusterEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     * @return Result of the DeleteDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterParameterGroupRequest, DeleteDbClusterParameterGroupResponse>()
                            .withOperationName("DeleteDBClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     * @return Result of the DeleteDBClusterSnapshot operation returned by the service.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest)
            throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbClusterSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterSnapshotRequest, DeleteDbClusterSnapshotResponse>()
                            .withOperationName("DeleteDBClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDbClusterSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbClusterSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that
     * instance are deleted and can't be recovered. However, manual DB snapshots of the DB instance aren't deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot, the status of the Amazon RDS DB instance is <code>deleting</code> until the
     * DB snapshot is created. This operation can't be canceled or reverted after it begins. To monitor the status of
     * this operation, use <code>DescribeDBInstance</code>.
     * </p>
     * <p>
     * When a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when you skip
     * creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.
     * </p>
     * <p>
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of
     * the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first use the <code>PromoteReadReplicaDBCluster</code> operation to promote
     * the DB cluster so that it's no longer a read replica. After the promotion completes, use the
     * <code>DeleteDBInstance</code> operation to delete the final instance in the DB cluster.
     * </p>
     * <important>
     * <p>
     * For RDS Custom DB instances, deleting the DB instance permanently deletes the EC2 instance and the associated EBS
     * volumes. Make sure that you don't terminate or delete these resources before you delete the DB instance.
     * Otherwise, deleting the DB instance and creation of the final snapshot might fail.
     * </p>
     * </important>
     *
     * @param deleteDbInstanceRequest
     * @return Result of the DeleteDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbInstanceAutomatedBackupQuotaExceededException
     *         The quota for retained automated backups was exceeded. This prevents you from retaining any additional
     *         automated backups. The retained automated backups quota is the same as your DB instance quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterStateException, DbInstanceAutomatedBackupQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBInstance");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbInstanceRequest, DeleteDbInstanceResponse>()
                    .withOperationName("DeleteDBInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     *
     * @param deleteDbInstanceAutomatedBackupRequest
     *        Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.
     * @return Result of the DeleteDBInstanceAutomatedBackup operation returned by the service.
     * @throws InvalidDbInstanceAutomatedBackupStateException
     *         The automated backup is in an invalid state. For example, this automated backup is associated with an
     *         active instance.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBInstanceAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDbInstanceAutomatedBackupResponse deleteDBInstanceAutomatedBackup(
            DeleteDbInstanceAutomatedBackupRequest deleteDbInstanceAutomatedBackupRequest)
            throws InvalidDbInstanceAutomatedBackupStateException, DbInstanceAutomatedBackupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbInstanceAutomatedBackupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbInstanceAutomatedBackupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbInstanceAutomatedBackupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDbInstanceAutomatedBackupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBInstanceAutomatedBackup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbInstanceAutomatedBackupRequest, DeleteDbInstanceAutomatedBackupResponse>()
                            .withOperationName("DeleteDBInstanceAutomatedBackup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDbInstanceAutomatedBackupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbInstanceAutomatedBackupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB
     * instances.
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     * @return Result of the DeleteDBParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDbParameterGroupResponse deleteDBParameterGroup(DeleteDbParameterGroupRequest deleteDbParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbParameterGroupRequest, DeleteDbParameterGroupResponse>()
                            .withOperationName("DeleteDBParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDbParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing DB proxy.
     * </p>
     *
     * @param deleteDbProxyRequest
     * @return Result of the DeleteDBProxy operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbProxyResponse deleteDBProxy(DeleteDbProxyRequest deleteDbProxyRequest) throws DbProxyNotFoundException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbProxyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbProxyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbProxyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBProxy");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbProxyRequest, DeleteDbProxyResponse>()
                    .withOperationName("DeleteDBProxy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbProxyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbProxyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the endpoint
     * that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only
     * operations, or using a different VPC than the DB proxy's default VPC.
     * </p>
     *
     * @param deleteDbProxyEndpointRequest
     * @return Result of the DeleteDBProxyEndpoint operation returned by the service.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws InvalidDbProxyEndpointStateException
     *         You can't perform this operation while the DB proxy endpoint is in a particular state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbProxyEndpointResponse deleteDBProxyEndpoint(DeleteDbProxyEndpointRequest deleteDbProxyEndpointRequest)
            throws DbProxyEndpointNotFoundException, InvalidDbProxyEndpointStateException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbProxyEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbProxyEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbProxyEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbProxyEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBProxyEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbProxyEndpointRequest, DeleteDbProxyEndpointResponse>()
                    .withOperationName("DeleteDBProxyEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbProxyEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbProxyEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DB security group.
     * </p>
     * <p>
     * The specified DB security group must not be associated with any DB instances.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param deleteDbSecurityGroupRequest
     * @return Result of the DeleteDBSecurityGroup operation returned by the service.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbSecurityGroupResponse deleteDBSecurityGroup(DeleteDbSecurityGroupRequest deleteDbSecurityGroupRequest)
            throws InvalidDbSecurityGroupStateException, DbSecurityGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbSecurityGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBSecurityGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbSecurityGroupRequest, DeleteDbSecurityGroupResponse>()
                    .withOperationName("DeleteDBSecurityGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbSecurityGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Aurora Limitless Database DB shard group.
     * </p>
     *
     * @param deleteDbShardGroupRequest
     * @return Result of the DeleteDBShardGroup operation returned by the service.
     * @throws DbShardGroupNotFoundException
     *         The specified DB shard group name wasn't found.
     * @throws InvalidDbShardGroupStateException
     *         The DB shard group must be in the available state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbShardGroupResponse deleteDBShardGroup(DeleteDbShardGroupRequest deleteDbShardGroupRequest)
            throws DbShardGroupNotFoundException, InvalidDbShardGroupStateException, InvalidDbClusterStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbShardGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbShardGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbShardGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbShardGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBShardGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbShardGroupRequest, DeleteDbShardGroupResponse>()
                    .withOperationName("DeleteDBShardGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbShardGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbShardGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbSnapshotRequest
     * @return Result of the DeleteDBSnapshot operation returned by the service.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbSnapshotResponse deleteDBSnapshot(DeleteDbSnapshotRequest deleteDbSnapshotRequest)
            throws InvalidDbSnapshotStateException, DbSnapshotNotFoundException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DeleteDbSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBSnapshot");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbSnapshotRequest, DeleteDbSnapshotResponse>()
                    .withOperationName("DeleteDBSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     * @return Result of the DeleteDBSubnetGroup operation returned by the service.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidDbSubnetStateException
     *         The DB subnet isn't in the <i>available</i> state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest)
            throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteDbSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDbSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbSubnetGroupRequest, DeleteDbSubnetGroupResponse>()
                    .withOperationName("DeleteDBSubnetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDbSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an RDS event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws InvalidEventSubscriptionStateException
     *         This error can occur if someone else is modifying a subscription. You should retry the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest)
            throws SubscriptionNotFoundException, InvalidEventSubscriptionStateException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeleteEventSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse>()
                            .withOperationName("DeleteEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed
     * first.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteGlobalClusterRequest
     * @return Result of the DeleteGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGlobalClusterResponse deleteGlobalCluster(DeleteGlobalClusterRequest deleteGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DeleteGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGlobalClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteGlobalClusterRequest, DeleteGlobalClusterResponse>()
                    .withOperationName("DeleteGlobalCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a zero-ETL integration with Amazon Redshift.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws IntegrationNotFoundException
     *         The specified integration could not be found.
     * @throws IntegrationConflictOperationException
     *         A conflicting conditional operation is currently in progress against this resource. Typically occurs when
     *         there are multiple requests being made to the same resource at the same time, and these requests conflict
     *         with each other.
     * @throws InvalidIntegrationStateException
     *         The integration is in an invalid state and can't perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws IntegrationNotFoundException, IntegrationConflictOperationException, InvalidIntegrationStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegration");

            return clientHandler.execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                    .withOperationName("DeleteIntegration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing option group.
     * </p>
     *
     * @param deleteOptionGroupRequest
     * @return Result of the DeleteOptionGroup operation returned by the service.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws InvalidOptionGroupStateException
     *         The option group isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteOptionGroupResponse deleteOptionGroup(DeleteOptionGroupRequest deleteOptionGroupRequest)
            throws OptionGroupNotFoundException, InvalidOptionGroupStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DeleteOptionGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteOptionGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOptionGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOptionGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteOptionGroupRequest, DeleteOptionGroupResponse>()
                    .withOperationName("DeleteOptionGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOptionGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOptionGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a tenant database from your DB instance. This command only applies to RDS for Oracle container database
     * (CDB) instances.
     * </p>
     * <p>
     * You can't delete a tenant database when it is the only tenant in the DB instance.
     * </p>
     *
     * @param deleteTenantDatabaseRequest
     * @return Result of the DeleteTenantDatabase operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws TenantDatabaseNotFoundException
     *         The specified tenant database wasn't found in the DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteTenantDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteTenantDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTenantDatabaseResponse deleteTenantDatabase(DeleteTenantDatabaseRequest deleteTenantDatabaseRequest)
            throws DbInstanceNotFoundException, TenantDatabaseNotFoundException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DeleteTenantDatabaseResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTenantDatabaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTenantDatabaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTenantDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTenantDatabase");

            return clientHandler.execute(new ClientExecutionParams<DeleteTenantDatabaseRequest, DeleteTenantDatabaseResponse>()
                    .withOperationName("DeleteTenantDatabase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTenantDatabaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTenantDatabaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove the association between one or more <code>DBProxyTarget</code> data structures and a
     * <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param deregisterDbProxyTargetsRequest
     * @return Result of the DeregisterDBProxyTargets operation returned by the service.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeregisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeregisterDbProxyTargetsResponse deregisterDBProxyTargets(
            DeregisterDbProxyTargetsRequest deregisterDbProxyTargetsRequest) throws DbProxyTargetNotFoundException,
            DbProxyTargetGroupNotFoundException, DbProxyNotFoundException, InvalidDbProxyStateException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DeregisterDbProxyTargetsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeregisterDbProxyTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterDbProxyTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterDbProxyTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterDBProxyTargets");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterDbProxyTargetsRequest, DeregisterDbProxyTargetsResponse>()
                            .withOperationName("DeregisterDBProxyTargets").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deregisterDbProxyTargetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterDbProxyTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeAccountAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes one or more blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     * @return Result of the DescribeBlueGreenDeployments operation returned by the service.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBlueGreenDeploymentsResponse describeBlueGreenDeployments(
            DescribeBlueGreenDeploymentsRequest describeBlueGreenDeploymentsRequest) throws BlueGreenDeploymentNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeBlueGreenDeploymentsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeBlueGreenDeploymentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBlueGreenDeploymentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBlueGreenDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBlueGreenDeployments");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeBlueGreenDeploymentsRequest, DescribeBlueGreenDeploymentsResponse>()
                            .withOperationName("DescribeBlueGreenDeployments").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeBlueGreenDeploymentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeBlueGreenDeploymentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this Amazon Web Services
     * account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest)
            throws CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeCertificatesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificates");

            return clientHandler.execute(new ClientExecutionParams<DescribeCertificatesRequest, DescribeCertificatesResponse>()
                    .withOperationName("DescribeCertificates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCertificatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays backups for both current and deleted DB clusters. For example, use this operation to find details about
     * automated backups for previously deleted clusters. Current clusters are returned for both the
     * <code>DescribeDBClusterAutomatedBackups</code> and <code>DescribeDBClusters</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @param describeDbClusterAutomatedBackupsRequest
     * @return Result of the DescribeDBClusterAutomatedBackups operation returned by the service.
     * @throws DbClusterAutomatedBackupNotFoundException
     *         No automated backup for this DB cluster was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterAutomatedBackupsResponse describeDBClusterAutomatedBackups(
            DescribeDbClusterAutomatedBackupsRequest describeDbClusterAutomatedBackupsRequest)
            throws DbClusterAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClusterAutomatedBackupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterAutomatedBackupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClusterAutomatedBackupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterAutomatedBackupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterAutomatedBackups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterAutomatedBackupsRequest, DescribeDbClusterAutomatedBackupsResponse>()
                            .withOperationName("DescribeDBClusterAutomatedBackups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbClusterAutomatedBackupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterAutomatedBackupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterBacktracksRequest
     * @return Result of the DescribeDBClusterBacktracks operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterBacktrackNotFoundException
     *         <code>BacktrackIdentifier</code> doesn't refer to an existing backtrack.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterBacktracksResponse describeDBClusterBacktracks(
            DescribeDbClusterBacktracksRequest describeDbClusterBacktracksRequest) throws DbClusterNotFoundException,
            DbClusterBacktrackNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClusterBacktracksResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterBacktracksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClusterBacktracksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterBacktracksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterBacktracks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterBacktracksRequest, DescribeDbClusterBacktracksResponse>()
                            .withOperationName("DescribeDBClusterBacktracks").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbClusterBacktracksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterBacktracksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterEndpointsRequest
     * @return Result of the DescribeDBClusterEndpoints operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterEndpointsResponse describeDBClusterEndpoints(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClusterEndpointsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClusterEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterEndpoints");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterEndpointsRequest, DescribeDbClusterEndpointsResponse>()
                            .withOperationName("DescribeDBClusterEndpoints").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbClusterEndpointsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClusterParameterGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClusterParameterGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterParameterGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParameterGroupsRequest, DescribeDbClusterParameterGroupsResponse>()
                            .withOperationName("DescribeDBClusterParameterGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbClusterParameterGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterParameterGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return Result of the DescribeDBClusterParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterParametersResponse describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClusterParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClusterParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParametersRequest, DescribeDbClusterParametersResponse>()
                            .withOperationName("DescribeDBClusterParameters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbClusterParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code>
     * returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of
     * values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or
     * restored by all Amazon Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to
     * make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API
     * action.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     * @return Result of the DescribeDBClusterSnapshotAttributes operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClusterSnapshotAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClusterSnapshotAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterSnapshotAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotAttributesRequest, DescribeDbClusterSnapshotAttributesResponse>()
                            .withOperationName("DescribeDBClusterSnapshotAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbClusterSnapshotAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterSnapshotAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClusterSnapshotsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClusterSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterSnapshots");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>()
                            .withOperationName("DescribeDBClusterSnapshots").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbClusterSnapshotsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     *
     * @param describeDbClustersRequest
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbClustersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClustersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusters");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbClustersRequest, DescribeDbClustersResponse>()
                    .withOperationName("DescribeDBClusters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDbClustersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the properties of specific versions of DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbEngineVersionsResponse describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DescribeDbEngineVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbEngineVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbEngineVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBEngineVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbEngineVersionsRequest, DescribeDbEngineVersionsResponse>()
                            .withOperationName("DescribeDBEngineVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbEngineVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbEngineVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return Result of the DescribeDBInstanceAutomatedBackups operation returned by the service.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbInstanceAutomatedBackupsResponse describeDBInstanceAutomatedBackups(
            DescribeDbInstanceAutomatedBackupsRequest describeDbInstanceAutomatedBackupsRequest)
            throws DbInstanceAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbInstanceAutomatedBackupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbInstanceAutomatedBackupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbInstanceAutomatedBackupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbInstanceAutomatedBackupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBInstanceAutomatedBackups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbInstanceAutomatedBackupsRequest, DescribeDbInstanceAutomatedBackupsResponse>()
                            .withOperationName("DescribeDBInstanceAutomatedBackups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbInstanceAutomatedBackupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbInstanceAutomatedBackupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note>
     *
     * @param describeDbInstancesRequest
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBInstances");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbInstancesRequest, DescribeDbInstancesResponse>()
                    .withOperationName("DescribeDBInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDbInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param describeDbLogFilesRequest
     * @return Result of the DescribeDBLogFiles operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDbLogFilesResponse describeDBLogFiles(DescribeDbLogFilesRequest describeDbLogFilesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbLogFilesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbLogFilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbLogFilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbLogFilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBLogFiles");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbLogFilesRequest, DescribeDbLogFilesResponse>()
                    .withOperationName("DescribeDBLogFiles").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDbLogFilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbLogFilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return Result of the DescribeDBParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbParameterGroupsResponse describeDBParameterGroups(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbParameterGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbParameterGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbParameterGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbParameterGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBParameterGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbParameterGroupsRequest, DescribeDbParameterGroupsResponse>()
                            .withOperationName("DescribeDBParameterGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbParameterGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbParameterGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     *
     * @param describeDbParametersRequest
     * @return Result of the DescribeDBParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDbParametersResponse describeDBParameters(DescribeDbParametersRequest describeDbParametersRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBParameters");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbParametersRequest, DescribeDbParametersResponse>()
                    .withOperationName("DescribeDBParameters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDbParametersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     *
     * @param describeDbProxiesRequest
     * @return Result of the DescribeDBProxies operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDbProxiesResponse describeDBProxies(DescribeDbProxiesRequest describeDbProxiesRequest)
            throws DbProxyNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbProxiesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbProxiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbProxiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxies");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbProxiesRequest, DescribeDbProxiesResponse>()
                    .withOperationName("DescribeDBProxies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDbProxiesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbProxiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     * @return Result of the DescribeDBProxyEndpoints operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbProxyEndpointsResponse describeDBProxyEndpoints(
            DescribeDbProxyEndpointsRequest describeDbProxyEndpointsRequest) throws DbProxyNotFoundException,
            DbProxyEndpointNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbProxyEndpointsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbProxyEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbProxyEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxyEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxyEndpoints");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbProxyEndpointsRequest, DescribeDbProxyEndpointsResponse>()
                            .withOperationName("DescribeDBProxyEndpoints").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbProxyEndpointsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbProxyEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     * @return Result of the DescribeDBProxyTargetGroups operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbProxyTargetGroupsResponse describeDBProxyTargetGroups(
            DescribeDbProxyTargetGroupsRequest describeDbProxyTargetGroupsRequest) throws DbProxyNotFoundException,
            DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DescribeDbProxyTargetGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbProxyTargetGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbProxyTargetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxyTargetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxyTargetGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbProxyTargetGroupsRequest, DescribeDbProxyTargetGroupsResponse>()
                            .withOperationName("DescribeDBProxyTargetGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbProxyTargetGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbProxyTargetGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     * @return Result of the DescribeDBProxyTargets operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbProxyTargetsResponse describeDBProxyTargets(DescribeDbProxyTargetsRequest describeDbProxyTargetsRequest)
            throws DbProxyNotFoundException, DbProxyTargetNotFoundException, DbProxyTargetGroupNotFoundException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbProxyTargetsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbProxyTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbProxyTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxyTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxyTargets");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbProxyTargetsRequest, DescribeDbProxyTargetsResponse>()
                            .withOperationName("DescribeDBProxyTargets").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbProxyTargetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbProxyTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the recommendations to resolve the issues for your DB instances, DB clusters, and DB parameter groups.
     * </p>
     *
     * @param describeDbRecommendationsRequest
     * @return Result of the DescribeDBRecommendations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbRecommendationsResponse describeDBRecommendations(
            DescribeDbRecommendationsRequest describeDbRecommendationsRequest) throws AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DescribeDbRecommendationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbRecommendationsRequest, DescribeDbRecommendationsResponse>()
                            .withOperationName("DescribeDBRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param describeDbSecurityGroupsRequest
     * @return Result of the DescribeDBSecurityGroups operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbSecurityGroupsResponse describeDBSecurityGroups(
            DescribeDbSecurityGroupsRequest describeDbSecurityGroupsRequest) throws DbSecurityGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbSecurityGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbSecurityGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbSecurityGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSecurityGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSecurityGroupsRequest, DescribeDbSecurityGroupsResponse>()
                            .withOperationName("DescribeDBSecurityGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbSecurityGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbSecurityGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes existing Aurora Limitless Database DB shard groups.
     * </p>
     *
     * @param describeDbShardGroupsRequest
     * @return Result of the DescribeDBShardGroups operation returned by the service.
     * @throws DbShardGroupNotFoundException
     *         The specified DB shard group name wasn't found.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBShardGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBShardGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDbShardGroupsResponse describeDBShardGroups(DescribeDbShardGroupsRequest describeDbShardGroupsRequest)
            throws DbShardGroupNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DescribeDbShardGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbShardGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbShardGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbShardGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBShardGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbShardGroupsRequest, DescribeDbShardGroupsResponse>()
                    .withOperationName("DescribeDBShardGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDbShardGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbShardGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code> returns
     * the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to
     * copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon
     * Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make
     * the manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.
     * </p>
     *
     * @param describeDbSnapshotAttributesRequest
     * @return Result of the DescribeDBSnapshotAttributes operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbSnapshotAttributesResponse describeDBSnapshotAttributes(
            DescribeDbSnapshotAttributesRequest describeDbSnapshotAttributesRequest) throws DbSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbSnapshotAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbSnapshotAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbSnapshotAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSnapshotAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSnapshotAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSnapshotAttributesRequest, DescribeDbSnapshotAttributesResponse>()
                            .withOperationName("DescribeDBSnapshotAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbSnapshotAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbSnapshotAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the tenant databases that exist in a DB snapshot. This command only applies to RDS for Oracle DB
     * instances in the multi-tenant configuration.
     * </p>
     * <p>
     * You can use this command to inspect the tenant databases within a snapshot before restoring it. You can't
     * directly interact with the tenant databases in a DB snapshot. If you restore a snapshot that was taken from DB
     * instance using the multi-tenant configuration, you restore all its tenant databases.
     * </p>
     *
     * @param describeDbSnapshotTenantDatabasesRequest
     * @return Result of the DescribeDBSnapshotTenantDatabases operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshotTenantDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotTenantDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbSnapshotTenantDatabasesResponse describeDBSnapshotTenantDatabases(
            DescribeDbSnapshotTenantDatabasesRequest describeDbSnapshotTenantDatabasesRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbSnapshotTenantDatabasesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbSnapshotTenantDatabasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbSnapshotTenantDatabasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbSnapshotTenantDatabasesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSnapshotTenantDatabases");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSnapshotTenantDatabasesRequest, DescribeDbSnapshotTenantDatabasesResponse>()
                            .withOperationName("DescribeDBSnapshotTenantDatabases").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbSnapshotTenantDatabasesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbSnapshotTenantDatabasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     *
     * @param describeDbSnapshotsRequest
     * @return Result of the DescribeDBSnapshots operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDbSnapshotsResponse describeDBSnapshots(DescribeDbSnapshotsRequest describeDbSnapshotsRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbSnapshotsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSnapshots");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbSnapshotsRequest, DescribeDbSnapshotsResponse>()
                    .withOperationName("DescribeDBSnapshots").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDbSnapshotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest)
            throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeDbSubnetGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbSubnetGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDbSubnetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSubnetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSubnetGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSubnetGroupsRequest, DescribeDbSubnetGroupsResponse>()
                            .withOperationName("DescribeDBSubnetGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDbSubnetGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbSubnetGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     * @return Result of the DescribeEngineDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeEngineDefaultClusterParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEngineDefaultClusterParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultClusterParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultClusterParametersRequest, DescribeEngineDefaultClusterParametersResponse>()
                            .withOperationName("DescribeEngineDefaultClusterParameters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(describeEngineDefaultClusterParametersRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEngineDefaultClusterParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return Result of the DescribeEngineDefaultParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DescribeEngineDefaultParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEngineDefaultParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEngineDefaultParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultParametersRequest, DescribeEngineDefaultParametersResponse>()
                            .withOperationName("DescribeEngineDefaultParameters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeEngineDefaultParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEngineDefaultParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeEventCategoriesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventCategoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventCategoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventCategories");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse>()
                            .withOperationName("DescribeEventCategories").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeEventCategoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEventCategoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeEventSubscriptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventSubscriptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventSubscriptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventSubscriptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse>()
                            .withOperationName("DescribeEventSubscriptions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeEventSubscriptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEventSubscriptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            return clientHandler.execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                    .withOperationName("DescribeEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return Result of the DescribeExportTasks operation returned by the service.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeExportTasksResponse describeExportTasks(DescribeExportTasksRequest describeExportTasksRequest)
            throws ExportTaskNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeExportTasksResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeExportTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeExportTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExportTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExportTasks");

            return clientHandler.execute(new ClientExecutionParams<DescribeExportTasksRequest, DescribeExportTasksResponse>()
                    .withOperationName("DescribeExportTasks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeExportTasksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeExportTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeGlobalClustersRequest
     * @return Result of the DescribeGlobalClusters operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeGlobalClustersResponse describeGlobalClusters(DescribeGlobalClustersRequest describeGlobalClustersRequest)
            throws GlobalClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeGlobalClustersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeGlobalClustersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGlobalClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGlobalClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGlobalClusters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGlobalClustersRequest, DescribeGlobalClustersResponse>()
                            .withOperationName("DescribeGlobalClusters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeGlobalClustersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGlobalClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe one or more zero-ETL integrations with Amazon Redshift.
     * </p>
     *
     * @param describeIntegrationsRequest
     * @return Result of the DescribeIntegrations operation returned by the service.
     * @throws IntegrationNotFoundException
     *         The specified integration could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeIntegrationsResponse describeIntegrations(DescribeIntegrationsRequest describeIntegrationsRequest)
            throws IntegrationNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeIntegrationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeIntegrationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIntegrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIntegrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIntegrations");

            return clientHandler.execute(new ClientExecutionParams<DescribeIntegrationsRequest, DescribeIntegrationsResponse>()
                    .withOperationName("DescribeIntegrations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeIntegrationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIntegrationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes all available options for the specified engine.
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     * @return Result of the DescribeOptionGroupOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOptionGroupOptionsResponse describeOptionGroupOptions(
            DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) throws AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DescribeOptionGroupOptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeOptionGroupOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOptionGroupOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptionGroupOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptionGroupOptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOptionGroupOptionsRequest, DescribeOptionGroupOptionsResponse>()
                            .withOperationName("DescribeOptionGroupOptions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeOptionGroupOptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOptionGroupOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     *
     * @param describeOptionGroupsRequest
     * @return Result of the DescribeOptionGroups operation returned by the service.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeOptionGroupsResponse describeOptionGroups(DescribeOptionGroupsRequest describeOptionGroupsRequest)
            throws OptionGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeOptionGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeOptionGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOptionGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptionGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptionGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeOptionGroupsRequest, DescribeOptionGroupsResponse>()
                    .withOperationName("DescribeOptionGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeOptionGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeOptionGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the orderable DB instance options for a specified DB engine.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return Result of the DescribeOrderableDBInstanceOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<DescribeOrderableDbInstanceOptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrderableDbInstanceOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrderableDBInstanceOptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrderableDbInstanceOptionsRequest, DescribeOrderableDbInstanceOptionsResponse>()
                            .withOperationName("DescribeOrderableDBInstanceOptions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeOrderableDbInstanceOptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrderableDbInstanceOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <p>
     * This API follows an eventual consistency model. This means that the result of the
     * <code>DescribePendingMaintenanceActions</code> command might not be immediately visible to all subsequent RDS
     * commands. Keep this in mind when you use <code>DescribePendingMaintenanceActions</code> immediately after using a
     * previous API command such as <code>ApplyPendingMaintenanceActions</code>.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribePendingMaintenanceActionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePendingMaintenanceActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePendingMaintenanceActions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse>()
                            .withOperationName("DescribePendingMaintenanceActions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describePendingMaintenanceActionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePendingMaintenanceActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     * @return Result of the DescribeReservedDBInstances operation returned by the service.
     * @throws ReservedDbInstanceNotFoundException
     *         The specified reserved DB Instance not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReservedDbInstancesResponse describeReservedDBInstances(
            DescribeReservedDbInstancesRequest describeReservedDbInstancesRequest) throws ReservedDbInstanceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeReservedDbInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeReservedDbInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedDbInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservedDbInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedDBInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedDbInstancesRequest, DescribeReservedDbInstancesResponse>()
                            .withOperationName("DescribeReservedDBInstances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReservedDbInstancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReservedDbInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     * @return Result of the DescribeReservedDBInstancesOfferings operation returned by the service.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReservedDbInstancesOfferingsResponse describeReservedDBInstancesOfferings(
            DescribeReservedDbInstancesOfferingsRequest describeReservedDbInstancesOfferingsRequest)
            throws ReservedDbInstancesOfferingNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeReservedDbInstancesOfferingsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeReservedDbInstancesOfferingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedDbInstancesOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedDbInstancesOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedDBInstancesOfferings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedDbInstancesOfferingsRequest, DescribeReservedDbInstancesOfferingsResponse>()
                            .withOperationName("DescribeReservedDBInstancesOfferings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReservedDbInstancesOfferingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReservedDbInstancesOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     *
     * @param describeSourceRegionsRequest
     * @return Result of the DescribeSourceRegions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeSourceRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSourceRegionsResponse describeSourceRegions(DescribeSourceRegionsRequest describeSourceRegionsRequest)
            throws AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeSourceRegionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeSourceRegionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSourceRegionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSourceRegionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSourceRegions");

            return clientHandler.execute(new ClientExecutionParams<DescribeSourceRegionsRequest, DescribeSourceRegionsResponse>()
                    .withOperationName("DescribeSourceRegions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSourceRegionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSourceRegionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the tenant databases in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle CDB
     * instances are supported.
     * </p>
     *
     * @param describeTenantDatabasesRequest
     * @return Result of the DescribeTenantDatabases operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeTenantDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeTenantDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTenantDatabasesResponse describeTenantDatabases(DescribeTenantDatabasesRequest describeTenantDatabasesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DescribeTenantDatabasesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTenantDatabasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTenantDatabasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTenantDatabasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTenantDatabases");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTenantDatabasesRequest, DescribeTenantDatabasesResponse>()
                            .withOperationName("DescribeTenantDatabases").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTenantDatabasesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTenantDatabasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * You can call <code>DescribeValidDBInstanceModifications</code> to learn what modifications you can make to your
     * DB instance. You can use this information when you call <code>ModifyDBInstance</code>.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     * @return Result of the DescribeValidDBInstanceModifications operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeValidDBInstanceModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeValidDbInstanceModificationsResponse describeValidDBInstanceModifications(
            DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DescribeValidDbInstanceModificationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeValidDbInstanceModificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeValidDbInstanceModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeValidDbInstanceModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeValidDBInstanceModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeValidDbInstanceModificationsRequest, DescribeValidDbInstanceModificationsResponse>()
                            .withOperationName("DescribeValidDBInstanceModifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeValidDbInstanceModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeValidDbInstanceModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the HTTP endpoint for the specified DB cluster. Disabling this endpoint disables RDS Data API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the
     * <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation applies only to Aurora PostgreSQL Serverless v2 and provisioned DB clusters. To disable the HTTP
     * endpoint for Aurora Serverless v1 DB clusters, use the <code>EnableHttpEndpoint</code> parameter of the
     * <code>ModifyDBCluster</code> operation.
     * </p>
     * </note>
     *
     * @param disableHttpEndpointRequest
     * @return Result of the DisableHttpEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws InvalidResourceStateException
     *         The operation can't be performed because another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DisableHttpEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DisableHttpEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisableHttpEndpointResponse disableHttpEndpoint(DisableHttpEndpointRequest disableHttpEndpointRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<DisableHttpEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DisableHttpEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableHttpEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableHttpEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableHttpEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DisableHttpEndpointRequest, DisableHttpEndpointResponse>()
                    .withOperationName("DisableHttpEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disableHttpEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableHttpEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param downloadDbLogFilePortionRequest
     * @return Result of the DownloadDBLogFilePortion operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbLogFileNotFoundException
     *         <code>LogFileName</code> doesn't refer to an existing DB log file.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DownloadDBLogFilePortion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DownloadDbLogFilePortionResponse downloadDBLogFilePortion(
            DownloadDbLogFilePortionRequest downloadDbLogFilePortionRequest) throws DbInstanceNotFoundException,
            DbLogFileNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<DownloadDbLogFilePortionResponse> responseHandler = protocolFactory
                .createResponseHandler(DownloadDbLogFilePortionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(downloadDbLogFilePortionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, downloadDbLogFilePortionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DownloadDBLogFilePortion");

            return clientHandler
                    .execute(new ClientExecutionParams<DownloadDbLogFilePortionRequest, DownloadDbLogFilePortionResponse>()
                            .withOperationName("DownloadDBLogFilePortion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(downloadDbLogFilePortionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DownloadDbLogFilePortionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
     * </p>
     * <p>
     * When enabled, this endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on
     * the Aurora DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the
     * <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation applies only to Aurora PostgreSQL Serverless v2 and provisioned DB clusters. To enable the HTTP
     * endpoint for Aurora Serverless v1 DB clusters, use the <code>EnableHttpEndpoint</code> parameter of the
     * <code>ModifyDBCluster</code> operation.
     * </p>
     * </note>
     *
     * @param enableHttpEndpointRequest
     * @return Result of the EnableHttpEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws InvalidResourceStateException
     *         The operation can't be performed because another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.EnableHttpEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EnableHttpEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public EnableHttpEndpointResponse enableHttpEndpoint(EnableHttpEndpointRequest enableHttpEndpointRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<EnableHttpEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(EnableHttpEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableHttpEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableHttpEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableHttpEndpoint");

            return clientHandler.execute(new ClientExecutionParams<EnableHttpEndpointRequest, EnableHttpEndpointResponse>()
                    .withOperationName("EnableHttpEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(enableHttpEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableHttpEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in
     * the DB cluster to be the primary DB instance (the cluster writer).
     * </p>
     * <p>
     * For a Multi-AZ DB cluster, after RDS terminates the primary DB instance, the internal monitoring system detects
     * that the primary DB instance is unhealthy and promotes a readable standby (read-only instances) in the DB cluster
     * to be the primary DB instance (the cluster writer). Failover times are typically less than 35 seconds.
     * </p>
     * <p>
     * An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists, when the primary DB
     * instance fails. A Multi-AZ DB cluster automatically fails over to a readable standby DB instance when the primary
     * DB instance fails.
     * </p>
     * <p>
     * To simulate a failure of a primary instance for testing, you can force a failover. Because each instance in a DB
     * cluster has its own endpoint address, make sure to clean up and re-establish any existing connections that use
     * those endpoint addresses when the failover is complete.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param failoverDbClusterRequest
     * @return Result of the FailoverDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.FailoverDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<FailoverDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(FailoverDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(failoverDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverDBCluster");

            return clientHandler.execute(new ClientExecutionParams<FailoverDbClusterRequest, FailoverDbClusterResponse>()
                    .withOperationName("FailoverDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(failoverDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FailoverDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Promotes the specified secondary DB cluster to be the primary DB cluster in the global database cluster to fail
     * over or switch over a global database. Switchover operations were previously called "managed planned failovers."
     * </p>
     * <note>
     * <p>
     * Although this operation can be used either to fail over or to switch over a global database cluster, its intended
     * use is for global database failover. To switch over a global database cluster, we recommend that you use the
     * <a>SwitchoverGlobalCluster</a> operation instead.
     * </p>
     * </note>
     * <p>
     * How you use this operation depends on whether you are failing over or switching over your global database
     * cluster:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Failing over - Specify the <code>AllowDataLoss</code> parameter and don't specify the <code>Switchover</code>
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Switching over - Specify the <code>Switchover</code> parameter or omit it, but don't specify the
     * <code>AllowDataLoss</code> parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>About failing over and switching over</b>
     * </p>
     * <p>
     * While failing over and switching over a global database cluster both change the primary DB cluster, you use these
     * operations for different reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Failing over</i> - Use this operation to respond to an unplanned event, such as a Regional disaster in the
     * primary Region. Failing over can result in a loss of write transaction data that wasn't replicated to the chosen
     * secondary before the failover event occurred. However, the recovery process that promotes a DB instance on the
     * chosen seconday DB cluster to be the primary writer DB instance guarantees that the data is in a transactionally
     * consistent state.
     * </p>
     * <p>
     * For more information about failing over an Amazon Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-failover.managed-unplanned"
     * >Performing managed failovers for Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Switching over</i> - Use this operation on a healthy global database cluster for planned events, such as
     * Regional rotation or to fail back to the original primary DB cluster after a failover operation. With this
     * operation, there is no data loss.
     * </p>
     * <p>
     * For more information about switching over an Amazon Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover"
     * >Performing switchovers for Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param failoverGlobalClusterRequest
     * @return Result of the FailoverGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.FailoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FailoverGlobalClusterResponse failoverGlobalCluster(FailoverGlobalClusterRequest failoverGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, InvalidDbClusterStateException,
            DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<FailoverGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(FailoverGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(failoverGlobalClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<FailoverGlobalClusterRequest, FailoverGlobalClusterResponse>()
                    .withOperationName("FailoverGlobalCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(failoverGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FailoverGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags on an Amazon RDS resource.
     * </p>
     * <p>
     * For an overview on tagging an Amazon RDS resource, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a>
     * in the <i>Amazon RDS User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora and
     * Amazon RDS Resources</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws IntegrationNotFoundException
     *         The specified integration could not be found.
     * @throws TenantDatabaseNotFoundException
     *         The specified tenant database wasn't found in the DB instance.
     * @throws DbSnapshotTenantDatabaseNotFoundException
     *         The specified snapshot tenant database wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException,
            DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, BlueGreenDeploymentNotFoundException,
            IntegrationNotFoundException, TenantDatabaseNotFoundException, DbSnapshotTenantDatabaseNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked
     * policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you
     * can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream
     * isn't required. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html"> Modifying a
     * database activity stream</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation is supported for RDS for Oracle and Microsoft SQL Server.
     * </p>
     *
     * @param modifyActivityStreamRequest
     * @return Result of the ModifyActivityStream operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyActivityStreamResponse modifyActivityStream(ModifyActivityStreamRequest modifyActivityStreamRequest)
            throws InvalidDbInstanceStateException, ResourceNotFoundException, DbInstanceNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<ModifyActivityStreamResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyActivityStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyActivityStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyActivityStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyActivityStream");

            return clientHandler.execute(new ClientExecutionParams<ModifyActivityStreamRequest, ModifyActivityStreamResponse>()
                    .withOperationName("ModifyActivityStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyActivityStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyActivityStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS
     * for new DB instances, or remove the override.
     * </p>
     * <p>
     * By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB instances that is
     * different from the default certificate provided by RDS. You can also use this operation to remove the override,
     * so that new DB instances use the default certificate provided by RDS.
     * </p>
     * <p>
     * You might need to override the default certificate in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You already migrated your applications to support the latest certificate authority (CA) certificate, but the new
     * CA certificate is not yet the RDS default CA certificate for the specified Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS has already moved to a new default CA certificate for the specified Amazon Web Services Region, but you are
     * still in the process of supporting the new CA certificate. In this case, you temporarily need additional time to
     * finish your application changes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param modifyCertificatesRequest
     * @return Result of the ModifyCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyCertificatesResponse modifyCertificates(ModifyCertificatesRequest modifyCertificatesRequest)
            throws CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyCertificatesResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCertificates");

            return clientHandler.execute(new ClientExecutionParams<ModifyCertificatesRequest, ModifyCertificatesResponse>()
                    .withOperationName("ModifyCertificates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyCertificatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
     * </p>
     * <p>
     * Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might
     * not scale fast enough to meet a sudden change in workload, such as a large number of new transactions. Call
     * <code>ModifyCurrentDBClusterCapacity</code> to set the capacity explicitly.
     * </p>
     * <p>
     * After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale the DB cluster based
     * on the cooldown period for scaling up and the cooldown period for scaling down.
     * </p>
     * <p>
     * For more information about Aurora Serverless v1, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
     * Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you call <code>ModifyCurrentDBClusterCapacity</code> with the default <code>TimeoutAction</code>, connections
     * that prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about
     * scaling points, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     * > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * This operation only applies to Aurora Serverless v1 DB clusters.
     * </p>
     * </note>
     *
     * @param modifyCurrentDbClusterCapacityRequest
     * @return Result of the ModifyCurrentDBClusterCapacity operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterCapacityException
     *         <code>Capacity</code> isn't a valid Aurora Serverless DB cluster capacity. Valid capacity values are
     *         <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>,
     *         <code>128</code>, and <code>256</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCurrentDBClusterCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCurrentDbClusterCapacityResponse modifyCurrentDBClusterCapacity(
            ModifyCurrentDbClusterCapacityRequest modifyCurrentDbClusterCapacityRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbClusterCapacityException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<ModifyCurrentDbClusterCapacityResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyCurrentDbClusterCapacityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCurrentDbClusterCapacityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyCurrentDbClusterCapacityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCurrentDBClusterCapacity");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyCurrentDbClusterCapacityRequest, ModifyCurrentDbClusterCapacityResponse>()
                            .withOperationName("ModifyCurrentDBClusterCapacity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyCurrentDbClusterCapacityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyCurrentDbClusterCapacityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling
     * <code>DescribeDBEngineVersions</code>.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>ModifyCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>ModifyCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify">Modifying CEV
     * status</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param modifyCustomDbEngineVersionRequest
     * @return Result of the ModifyCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionNotFoundException
     *         The specified CEV was not found.
     * @throws InvalidCustomDbEngineVersionStateException
     *         You can't delete the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCustomDbEngineVersionResponse modifyCustomDBEngineVersion(
            ModifyCustomDbEngineVersionRequest modifyCustomDbEngineVersionRequest) throws CustomDbEngineVersionNotFoundException,
            InvalidCustomDbEngineVersionStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyCustomDbEngineVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyCustomDbEngineVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCustomDbEngineVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCustomDbEngineVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCustomDBEngineVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyCustomDbEngineVersionRequest, ModifyCustomDbEngineVersionResponse>()
                            .withOperationName("ModifyCustomDBEngineVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyCustomDbEngineVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyCustomDbEngineVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more
     * settings by specifying these parameters and the new values in the request.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param modifyDbClusterRequest
     * @return Result of the ModifyDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws StorageTypeNotAvailableException
     *         The <code>aurora-iopt1</code> storage type isn't available, because you modified the DB cluster to use
     *         this storage type less than one month ago.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException,
            InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException,
            InvalidDbInstanceStateException, DbClusterAlreadyExistsException, DbInstanceAlreadyExistsException,
            DomainNotFoundException, StorageTypeNotAvailableException, OptionGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBCluster");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbClusterRequest, ModifyDbClusterResponse>()
                    .withOperationName("ModifyDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This operation only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param modifyDbClusterEndpointRequest
     * @return Result of the ModifyDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation can't be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDbClusterEndpointResponse modifyDBClusterEndpoint(ModifyDbClusterEndpointRequest modifyDbClusterEndpointRequest)
            throws InvalidDbClusterStateException, InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException,
            DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbClusterEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbClusterEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterEndpointRequest, ModifyDbClusterEndpointResponse>()
                            .withOperationName("ModifyDBClusterEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyDbClusterEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbClusterEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create operation before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS
     * console</a> or the <code>DescribeDBClusterParameters</code> operation to verify that your DB cluster parameter
     * group has been created or modified.
     * </p>
     * <p>
     * If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora applies the update
     * immediately. The cluster restart might interrupt your workload. In that case, your application must reopen any
     * connections and retry any transactions that were active when the parameter changes took effect.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param modifyDbClusterParameterGroupRequest
     * @return Result of the ModifyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterParameterGroupRequest, ModifyDbClusterParameterGroupResponse>()
                            .withOperationName("ModifyDBClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify <code>restore</code> as
     * the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon
     * Web Services accounts that are authorized to restore the manual DB cluster snapshot. Use the value
     * <code>all</code> to make the manual DB cluster snapshot public, which means that it can be copied or restored by
     * all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB cluster snapshots that contain private information that
     * you don't want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized
     * Amazon Web Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a
     * value for that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster snapshot, or
     * whether a manual DB cluster snapshot is public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API
     * operation. The accounts are returned as values for the <code>restore</code> attribute.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     * @return Result of the ModifyDBClusterSnapshotAttribute operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest)
            throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException,
            SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbClusterSnapshotAttributeResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbClusterSnapshotAttributeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterSnapshotAttribute");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterSnapshotAttributeRequest, ModifyDbClusterSnapshotAttributeResponse>()
                            .withOperationName("ModifyDBClusterSnapshotAttribute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyDbClusterSnapshotAttributeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbClusterSnapshotAttributeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <code>DescribeValidDBInstanceModifications</code> before you call <code>ModifyDBInstance</code>.
     * </p>
     *
     * @param modifyDbInstanceRequest
     * @return Result of the ModifyDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbUpgradeDependencyFailureException
     *         The DB upgrade failed because a resource the DB depends on can't be modified.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws TenantDatabaseQuotaExceededException
     *         You attempted to create more tenant databases than are permitted in your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest)
            throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException,
            DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException,
            InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException,
            ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbUpgradeDependencyFailureException,
            StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException,
            DomainNotFoundException, KmsKeyNotAccessibleException, InvalidDbClusterStateException,
            NetworkTypeNotSupportedException, TenantDatabaseQuotaExceededException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<ModifyDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBInstance");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbInstanceRequest, ModifyDbInstanceResponse>()
                    .withOperationName("ModifyDBInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * modify operation before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param modifyDbParameterGroupRequest
     * @return Result of the ModifyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDbParameterGroupResponse modifyDBParameterGroup(ModifyDbParameterGroupRequest modifyDbParameterGroupRequest)
            throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbParameterGroupRequest, ModifyDbParameterGroupResponse>()
                            .withOperationName("ModifyDBParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyDbParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy.
     * </p>
     *
     * @param modifyDbProxyRequest
     * @return Result of the ModifyDBProxy operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyAlreadyExistsException
     *         The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbProxyResponse modifyDBProxy(ModifyDbProxyRequest modifyDbProxyRequest) throws DbProxyNotFoundException,
            DbProxyAlreadyExistsException, InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbProxyResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbProxyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbProxyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBProxy");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbProxyRequest, ModifyDbProxyResponse>()
                    .withOperationName("ModifyDBProxy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyDbProxyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbProxyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy endpoint.
     * </p>
     *
     * @param modifyDbProxyEndpointRequest
     * @return Result of the ModifyDBProxyEndpoint operation returned by the service.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws DbProxyEndpointAlreadyExistsException
     *         The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws InvalidDbProxyEndpointStateException
     *         You can't perform this operation while the DB proxy endpoint is in a particular state.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbProxyEndpointResponse modifyDBProxyEndpoint(ModifyDbProxyEndpointRequest modifyDbProxyEndpointRequest)
            throws DbProxyEndpointNotFoundException, DbProxyEndpointAlreadyExistsException, InvalidDbProxyEndpointStateException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbProxyEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbProxyEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbProxyEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbProxyEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBProxyEndpoint");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbProxyEndpointRequest, ModifyDbProxyEndpointResponse>()
                    .withOperationName("ModifyDBProxyEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyDbProxyEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbProxyEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the properties of a <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param modifyDbProxyTargetGroupRequest
     * @return Result of the ModifyDBProxyTargetGroup operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDbProxyTargetGroupResponse modifyDBProxyTargetGroup(
            ModifyDbProxyTargetGroupRequest modifyDbProxyTargetGroupRequest) throws DbProxyNotFoundException,
            DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<ModifyDbProxyTargetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbProxyTargetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbProxyTargetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbProxyTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBProxyTargetGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbProxyTargetGroupRequest, ModifyDbProxyTargetGroupResponse>()
                            .withOperationName("ModifyDBProxyTargetGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyDbProxyTargetGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbProxyTargetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the recommendation status and recommended action status for the specified recommendation.
     * </p>
     *
     * @param modifyDbRecommendationRequest
     * @return Result of the ModifyDBRecommendation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBRecommendation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDbRecommendationResponse modifyDBRecommendation(ModifyDbRecommendationRequest modifyDbRecommendationRequest)
            throws AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbRecommendationResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbRecommendationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbRecommendationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBRecommendation");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbRecommendationRequest, ModifyDbRecommendationResponse>()
                            .withOperationName("ModifyDBRecommendation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyDbRecommendationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbRecommendationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings of an Aurora Limitless Database DB shard group. You can change one or more settings by
     * specifying these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbShardGroupRequest
     * @return Result of the ModifyDBShardGroup operation returned by the service.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbShardGroupAlreadyExistsException
     *         The specified DB shard group name must be unique in your Amazon Web Services account in the specified
     *         Amazon Web Services Region.
     * @throws DbShardGroupNotFoundException
     *         The specified DB shard group name wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbShardGroupResponse modifyDBShardGroup(ModifyDbShardGroupRequest modifyDbShardGroupRequest)
            throws InvalidDbClusterStateException, DbShardGroupAlreadyExistsException, DbShardGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbShardGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbShardGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbShardGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbShardGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBShardGroup");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbShardGroupRequest, ModifyDbShardGroupResponse>()
                    .withOperationName("ModifyDBShardGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyDbShardGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbShardGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not
     * shared or public.
     * </p>
     * <p>
     * Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This operation doesn't apply to RDS
     * Custom or RDS for Db2.
     * </p>
     *
     * @param modifyDbSnapshotRequest
     * @return Result of the ModifyDBSnapshot operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbSnapshotResponse modifyDBSnapshot(ModifyDbSnapshotRequest modifyDbSnapshotRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyDbSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBSnapshot");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbSnapshotRequest, ModifyDbSnapshotResponse>()
                    .withOperationName("ModifyDBSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyDbSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
     * </p>
     * <p>
     * To share a manual DB snapshot with other Amazon Web Services accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon Web
     * Services accounts that are authorized to restore the manual DB snapshot. Uses the value <code>all</code> to make
     * the manual DB snapshot public, which means it can be copied or restored by all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB snapshots that contain private information that you don't
     * want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If the manual DB snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web
     * Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a value for
     * that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or whether a
     * manual DB snapshot public or private, use the <a>DescribeDBSnapshotAttributes</a> API operation. The accounts are
     * returned as values for the <code>restore</code> attribute.
     * </p>
     *
     * @param modifyDbSnapshotAttributeRequest
     * @return Result of the ModifyDBSnapshotAttribute operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDbSnapshotAttributeResponse modifyDBSnapshotAttribute(
            ModifyDbSnapshotAttributeRequest modifyDbSnapshotAttributeRequest) throws DbSnapshotNotFoundException,
            InvalidDbSnapshotStateException, SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<ModifyDbSnapshotAttributeResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbSnapshotAttributeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbSnapshotAttributeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbSnapshotAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBSnapshotAttribute");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbSnapshotAttributeRequest, ModifyDbSnapshotAttributeResponse>()
                            .withOperationName("ModifyDBSnapshotAttribute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyDbSnapshotAttributeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbSnapshotAttributeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the Amazon Web Services Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     * @return Result of the ModifyDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetQuotaExceededException
     *         The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws SubnetAlreadyInUseException
     *         The DB subnet is already in use in the Availability Zone.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest)
            throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<ModifyDbSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyDbSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbSubnetGroupRequest, ModifyDbSubnetGroupResponse>()
                    .withOperationName("ModifyDBSubnetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyDbSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this
     * call. To change source identifiers for a subscription, use the <code>AddSourceIdentifierToSubscription</code> and
     * <code>RemoveSourceIdentifierFromSubscription</code> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given source type (<code>SourceType</code>) in <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS
     * User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         You have reached the maximum number of event subscriptions.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SnsInvalidTopicException
     *         SNS has responded that there is a problem with the SNS topic specified.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the SNS topic ARN.
     * @throws SnsTopicArnNotFoundException
     *         The SNS topic ARN does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The supplied category does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyEventSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse>()
                            .withOperationName("ModifyEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies a setting for an Amazon Aurora global database cluster. You can change one or more database
     * configuration parameters by specifying these parameters and the new values in the request. For more information
     * on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation only applies to Aurora global database clusters.
     * </p>
     * </note>
     *
     * @param modifyGlobalClusterRequest
     * @return Result of the ModifyGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyGlobalClusterResponse modifyGlobalCluster(ModifyGlobalClusterRequest modifyGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, InvalidDbClusterStateException,
            InvalidDbInstanceStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyGlobalClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<ModifyGlobalClusterRequest, ModifyGlobalClusterResponse>()
                    .withOperationName("ModifyGlobalCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies a zero-ETL integration with Amazon Redshift.
     * </p>
     * <note>
     * <p>
     * Currently, you can only modify integrations that have Aurora MySQL source DB clusters. Integrations with Aurora
     * PostgreSQL and RDS sources currently don't support modifying the integration.
     * </p>
     * </note>
     *
     * @param modifyIntegrationRequest
     * @return Result of the ModifyIntegration operation returned by the service.
     * @throws IntegrationNotFoundException
     *         The specified integration could not be found.
     * @throws InvalidIntegrationStateException
     *         The integration is in an invalid state and can't perform the requested operation.
     * @throws IntegrationConflictOperationException
     *         A conflicting conditional operation is currently in progress against this resource. Typically occurs when
     *         there are multiple requests being made to the same resource at the same time, and these requests conflict
     *         with each other.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyIntegrationResponse modifyIntegration(ModifyIntegrationRequest modifyIntegrationRequest)
            throws IntegrationNotFoundException, InvalidIntegrationStateException, IntegrationConflictOperationException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyIntegrationResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyIntegration");

            return clientHandler.execute(new ClientExecutionParams<ModifyIntegrationRequest, ModifyIntegrationResponse>()
                    .withOperationName("ModifyIntegration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing option group.
     * </p>
     *
     * @param modifyOptionGroupRequest
     * @return Result of the ModifyOptionGroup operation returned by the service.
     * @throws InvalidOptionGroupStateException
     *         The option group isn't in the <i>available</i> state.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyOptionGroupResponse modifyOptionGroup(ModifyOptionGroupRequest modifyOptionGroupRequest)
            throws InvalidOptionGroupStateException, OptionGroupNotFoundException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<ModifyOptionGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyOptionGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyOptionGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyOptionGroup");

            return clientHandler.execute(new ClientExecutionParams<ModifyOptionGroupRequest, ModifyOptionGroupResponse>()
                    .withOperationName("ModifyOptionGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyOptionGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyOptionGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing tenant database in a DB instance. You can change the tenant database name or the master user
     * password. This operation is supported only for RDS for Oracle CDB instances using the multi-tenant configuration.
     * </p>
     *
     * @param modifyTenantDatabaseRequest
     * @return Result of the ModifyTenantDatabase operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws TenantDatabaseNotFoundException
     *         The specified tenant database wasn't found in the DB instance.
     * @throws TenantDatabaseAlreadyExistsException
     *         You attempted to either create a tenant database that already exists or modify a tenant database to use
     *         the name of an existing tenant database.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyTenantDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyTenantDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyTenantDatabaseResponse modifyTenantDatabase(ModifyTenantDatabaseRequest modifyTenantDatabaseRequest)
            throws DbInstanceNotFoundException, TenantDatabaseNotFoundException, TenantDatabaseAlreadyExistsException,
            InvalidDbInstanceStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<ModifyTenantDatabaseResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyTenantDatabaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyTenantDatabaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyTenantDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyTenantDatabase");

            return clientHandler.execute(new ClientExecutionParams<ModifyTenantDatabaseRequest, ModifyTenantDatabaseResponse>()
                    .withOperationName("ModifyTenantDatabase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyTenantDatabaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyTenantDatabaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Promotes a read replica DB instance to a standalone DB instance.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Backup duration is a function of the amount of changes to the database since the previous backup. If you plan to
     * promote a read replica to a standalone instance, we recommend that you enable backups and complete at least one
     * backup prior to promotion. In addition, a read replica cannot be promoted to a standalone instance when it is in
     * the <code>backing-up</code> status. If you have enabled backups on your read replica, configure the automated
     * backup window so that daily backups do not interfere with read replica promotion.
     * </p>
     * </li>
     * <li>
     * <p>
     * This command doesn't apply to Aurora MySQL, Aurora PostgreSQL, or RDS Custom.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param promoteReadReplicaRequest
     * @return Result of the PromoteReadReplica operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.PromoteReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplica" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PromoteReadReplicaResponse promoteReadReplica(PromoteReadReplicaRequest promoteReadReplicaRequest)
            throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<PromoteReadReplicaResponse> responseHandler = protocolFactory
                .createResponseHandler(PromoteReadReplicaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(promoteReadReplicaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, promoteReadReplicaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PromoteReadReplica");

            return clientHandler.execute(new ClientExecutionParams<PromoteReadReplicaRequest, PromoteReadReplicaResponse>()
                    .withOperationName("PromoteReadReplica").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(promoteReadReplicaRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PromoteReadReplicaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Promotes a read replica DB cluster to a standalone DB cluster.
     * </p>
     *
     * @param promoteReadReplicaDbClusterRequest
     * @return Result of the PromoteReadReplicaDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.PromoteReadReplicaDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PromoteReadReplicaDbClusterResponse promoteReadReplicaDBCluster(
            PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<PromoteReadReplicaDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(PromoteReadReplicaDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(promoteReadReplicaDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, promoteReadReplicaDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PromoteReadReplicaDBCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<PromoteReadReplicaDbClusterRequest, PromoteReadReplicaDbClusterResponse>()
                            .withOperationName("PromoteReadReplicaDBCluster").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(promoteReadReplicaDbClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PromoteReadReplicaDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Purchases a reserved DB instance offering.
     * </p>
     *
     * @param purchaseReservedDbInstancesOfferingRequest
     * @return Result of the PurchaseReservedDBInstancesOffering operation returned by the service.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws ReservedDbInstanceAlreadyExistsException
     *         User already has a reservation with the given identifier.
     * @throws ReservedDbInstanceQuotaExceededException
     *         Request would exceed the user's DB Instance quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.PurchaseReservedDBInstancesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PurchaseReservedDbInstancesOfferingResponse purchaseReservedDBInstancesOffering(
            PurchaseReservedDbInstancesOfferingRequest purchaseReservedDbInstancesOfferingRequest)
            throws ReservedDbInstancesOfferingNotFoundException, ReservedDbInstanceAlreadyExistsException,
            ReservedDbInstanceQuotaExceededException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<PurchaseReservedDbInstancesOfferingResponse> responseHandler = protocolFactory
                .createResponseHandler(PurchaseReservedDbInstancesOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseReservedDbInstancesOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedDbInstancesOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedDBInstancesOffering");

            return clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedDbInstancesOfferingRequest, PurchaseReservedDbInstancesOfferingResponse>()
                            .withOperationName("PurchaseReservedDBInstancesOffering").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(purchaseReservedDbInstancesOfferingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PurchaseReservedDbInstancesOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * You might need to reboot your DB cluster, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB cluster parameter group associated with the DB cluster, reboot the DB
     * cluster for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB cluster restarts the database engine service. Rebooting a DB cluster results in a momentary
     * outage, during which the DB cluster status is set to rebooting.
     * </p>
     * <p>
     * Use this operation only for a non-Aurora Multi-AZ DB cluster.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param rebootDbClusterRequest
     * @return Result of the RebootDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RebootDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RebootDbClusterResponse rebootDBCluster(RebootDbClusterRequest rebootDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RebootDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(RebootDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDBCluster");

            return clientHandler.execute(new ClientExecutionParams<RebootDbClusterRequest, RebootDbClusterResponse>()
                    .withOperationName("RebootDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebootDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to rebooting.
     * </p>
     * <p>
     * For more information about rebooting, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html">Rebooting a DB
     * Instance</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * If your DB instance is part of a Multi-AZ DB cluster, you can reboot the DB cluster with the
     * <code>RebootDBCluster</code> operation.
     * </p>
     *
     * @param rebootDbInstanceRequest
     * @return Result of the RebootDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RebootDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RebootDbInstanceResponse rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest)
            throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<RebootDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(RebootDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootDbInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDBInstance");

            return clientHandler.execute(new ClientExecutionParams<RebootDbInstanceRequest, RebootDbInstanceResponse>()
                    .withOperationName("RebootDBInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebootDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * You might need to reboot your DB shard group, usually for maintenance reasons. For example, if you make certain
     * modifications, reboot the DB shard group for the changes to take effect.
     * </p>
     * <p>
     * This operation applies only to Aurora Limitless Database DBb shard groups.
     * </p>
     *
     * @param rebootDbShardGroupRequest
     * @return Result of the RebootDBShardGroup operation returned by the service.
     * @throws DbShardGroupNotFoundException
     *         The specified DB shard group name wasn't found.
     * @throws InvalidDbShardGroupStateException
     *         The DB shard group must be in the available state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RebootDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RebootDbShardGroupResponse rebootDBShardGroup(RebootDbShardGroupRequest rebootDbShardGroupRequest)
            throws DbShardGroupNotFoundException, InvalidDbShardGroupStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<RebootDbShardGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(RebootDbShardGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootDbShardGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbShardGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDBShardGroup");

            return clientHandler.execute(new ClientExecutionParams<RebootDbShardGroupRequest, RebootDbShardGroupResponse>()
                    .withOperationName("RebootDBShardGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebootDbShardGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootDbShardGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associate one or more <code>DBProxyTarget</code> data structures with a <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param registerDbProxyTargetsRequest
     * @return Result of the RegisterDBProxyTargets operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbProxyTargetAlreadyRegisteredException
     *         The proxy is already associated with the specified RDS DB instance or Aurora DB cluster.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws InsufficientAvailableIPsInSubnetException
     *         The requested operation can't be performed because there aren't enough available IP addresses in the
     *         proxy's subnets. Add more CIDR blocks to the VPC or remove IP address that aren't required from the
     *         subnets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RegisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RegisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RegisterDbProxyTargetsResponse registerDBProxyTargets(RegisterDbProxyTargetsRequest registerDbProxyTargetsRequest)
            throws DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, DbClusterNotFoundException,
            DbInstanceNotFoundException, DbProxyTargetAlreadyRegisteredException, InvalidDbInstanceStateException,
            InvalidDbClusterStateException, InvalidDbProxyStateException, InsufficientAvailableIPsInSubnetException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RegisterDbProxyTargetsResponse> responseHandler = protocolFactory
                .createResponseHandler(RegisterDbProxyTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerDbProxyTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerDbProxyTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterDBProxyTargets");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterDbProxyTargetsRequest, RegisterDbProxyTargetsResponse>()
                            .withOperationName("RegisterDBProxyTargets").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(registerDbProxyTargetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterDbProxyTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a standalone
     * cluster with read-write capability instead of being read-only and receiving data from a primary cluster in a
     * different Region.
     * </p>
     * <note>
     * <p>
     * This operation only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param removeFromGlobalClusterRequest
     * @return Result of the RemoveFromGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RemoveFromGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveFromGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveFromGlobalClusterResponse removeFromGlobalCluster(RemoveFromGlobalClusterRequest removeFromGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, DbClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RemoveFromGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveFromGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFromGlobalClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFromGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFromGlobalCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveFromGlobalClusterRequest, RemoveFromGlobalClusterResponse>()
                            .withOperationName("RemoveFromGlobalCluster").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeFromGlobalClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveFromGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param removeRoleFromDbClusterRequest
     * @return Result of the RemoveRoleFromDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterRoleNotFoundException
     *         The specified IAM role Amazon Resource Name (ARN) isn't associated with the specified DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RemoveRoleFromDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveRoleFromDbClusterResponse removeRoleFromDBCluster(RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest)
            throws DbClusterNotFoundException, DbClusterRoleNotFoundException, InvalidDbClusterStateException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RemoveRoleFromDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveRoleFromDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeRoleFromDbClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeRoleFromDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRoleFromDBCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveRoleFromDbClusterRequest, RemoveRoleFromDbClusterResponse>()
                            .withOperationName("RemoveRoleFromDBCluster").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeRoleFromDbClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveRoleFromDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.
     * </p>
     *
     * @param removeRoleFromDbInstanceRequest
     * @return Result of the RemoveRoleFromDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbInstanceRoleNotFoundException
     *         The specified <code>RoleArn</code> value doesn't match the specified feature for the DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RemoveRoleFromDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveRoleFromDbInstanceResponse removeRoleFromDBInstance(
            RemoveRoleFromDbInstanceRequest removeRoleFromDbInstanceRequest) throws DbInstanceNotFoundException,
            DbInstanceRoleNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<RemoveRoleFromDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveRoleFromDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeRoleFromDbInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeRoleFromDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRoleFromDBInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveRoleFromDbInstanceRequest, RemoveRoleFromDbInstanceResponse>()
                            .withOperationName("RemoveRoleFromDBInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeRoleFromDbInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveRoleFromDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a source identifier from an existing RDS event notification subscription.
     * </p>
     *
     * @param removeSourceIdentifierFromSubscriptionRequest
     * @return Result of the RemoveSourceIdentifierFromSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SourceNotFoundException
     *         The requested source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RemoveSourceIdentifierFromSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveSourceIdentifierFromSubscriptionResponse removeSourceIdentifierFromSubscription(
            RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest)
            throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RemoveSourceIdentifierFromSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveSourceIdentifierFromSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeSourceIdentifierFromSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeSourceIdentifierFromSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveSourceIdentifierFromSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveSourceIdentifierFromSubscriptionRequest, RemoveSourceIdentifierFromSubscriptionResponse>()
                            .withOperationName("RemoveSourceIdentifierFromSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(removeSourceIdentifierFromSubscriptionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveSourceIdentifierFromSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon RDS resource.
     * </p>
     * <p>
     * For an overview on tagging an Amazon RDS resource, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a>
     * in the <i>Amazon RDS User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora and
     * Amazon RDS Resources</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws IntegrationNotFoundException
     *         The specified integration could not be found.
     * @throws TenantDatabaseNotFoundException
     *         The specified tenant database wasn't found in the DB instance.
     * @throws DbSnapshotTenantDatabaseNotFoundException
     *         The specified snapshot tenant database wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException,
            DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, BlueGreenDeploymentNotFoundException,
            IntegrationNotFoundException, TenantDatabaseNotFoundException, DbSnapshotTenantDatabaseNotFoundException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveTagsFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsFromResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeTagsFromResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit
     * a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request. You must call <code>RebootDBInstance</code> for every DB instance in your DB cluster that you want the
     * updated static parameter to apply to.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     * @return Result of the ResetDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ResetDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(
            ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<ResetDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ResetDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetDbClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDbClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ResetDbClusterParameterGroupRequest, ResetDbClusterParameterGroupResponse>()
                            .withOperationName("ResetDBClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(resetDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ResetDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters,
     * provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request.
     * </p>
     *
     * @param resetDbParameterGroupRequest
     * @return Result of the ResetDBParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ResetDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ResetDbParameterGroupResponse resetDBParameterGroup(ResetDbParameterGroupRequest resetDbParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<ResetDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ResetDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetDbParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDBParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<ResetDbParameterGroupRequest, ResetDbParameterGroupResponse>()
                    .withOperationName("ResetDBParameterGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(resetDbParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResetDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon RDS must be authorized
     * to access the Amazon S3 bucket and the data must be created using the Percona XtraBackup utility as described in
     * <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3"
     * > Migrating Data from MySQL by Using an Amazon S3 Bucket</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <code>CreateDBInstance</code> operation to create DB instances for the restored DB cluster, specifying the
     * identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after
     * the <code>RestoreDBClusterFromS3</code> operation has completed and the DB cluster is available.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation only applies to Aurora DB clusters. The source DB engine must be MySQL.
     * </p>
     * </note>
     *
     * @param restoreDbClusterFromS3Request
     * @return Result of the RestoreDBClusterFromS3 operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidS3BucketException
     *         The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized to access the specified
     *         Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try
     *         again.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You might be able to resolve this error
     *         by updating your subnet group to use different Availability Zones that have more storage available.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RestoreDBClusterFromS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RestoreDbClusterFromS3Response restoreDBClusterFromS3(RestoreDbClusterFromS3Request restoreDbClusterFromS3Request)
            throws DbClusterAlreadyExistsException, DbClusterQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbClusterStateException,
            InvalidDbSubnetGroupStateException, InvalidSubnetException, InvalidS3BucketException,
            DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException, DbClusterNotFoundException,
            DomainNotFoundException, InsufficientStorageClusterCapacityException, StorageTypeNotSupportedException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RestoreDbClusterFromS3Response> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbClusterFromS3Response::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreDbClusterFromS3Request,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreDbClusterFromS3Request
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterFromS3");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterFromS3Request, RestoreDbClusterFromS3Response>()
                            .withOperationName("RestoreDBClusterFromS3").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(restoreDbClusterFromS3Request)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbClusterFromS3RequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * The target DB cluster is created from the source snapshot with a default configuration. If you don't specify a
     * security group, the new DB cluster is associated with the default security group.
     * </p>
     * <note>
     * <p>
     * This operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <code>CreateDBInstance</code> operation to create DB instances for the restored DB cluster, specifying the
     * identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after
     * the <code>RestoreDBClusterFromSnapshot</code> operation has completed and the DB cluster is available.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     * @return Result of the RestoreDBClusterFromSnapshot operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws InsufficientDbClusterCapacityException
     *         The DB cluster doesn't have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You might be able to resolve this error
     *         by updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidRestoreException
     *         Cannot restore from VPC backup to non-VPC DB instance.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RestoreDBClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(
            RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) throws DbClusterAlreadyExistsException,
            DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException,
            DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, InsufficientDbClusterCapacityException,
            InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException, InvalidDbClusterSnapshotStateException,
            InvalidVpcNetworkStateException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidRestoreException,
            InvalidSubnetException, OptionGroupNotFoundException, KmsKeyNotAccessibleException, DomainNotFoundException,
            DbClusterParameterGroupNotFoundException, InvalidDbInstanceStateException, InsufficientDbInstanceCapacityException,
            AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RestoreDbClusterFromSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreDbClusterFromSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreDbClusterFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterFromSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterFromSnapshotRequest, RestoreDbClusterFromSnapshotResponse>()
                            .withOperationName("RestoreDBClusterFromSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(restoreDbClusterFromSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbClusterFromSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     * <note>
     * <p>
     * For Aurora, this operation only restores the DB cluster, not the DB instances for that DB cluster. You must
     * invoke the <code>CreateDBInstance</code> operation to create DB instances for the restored DB cluster, specifying
     * the identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only
     * after the <code>RestoreDBClusterToPointInTime</code> operation has completed and the DB cluster is available.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param restoreDbClusterToPointInTimeRequest
     * @return Result of the RestoreDBClusterToPointInTime operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InsufficientDbClusterCapacityException
     *         The DB cluster doesn't have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You might be able to resolve this error
     *         by updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws InvalidRestoreException
     *         Cannot restore from VPC backup to non-VPC DB instance.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws DbClusterAutomatedBackupNotFoundException
     *         No automated backup for this DB cluster was found.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RestoreDBClusterToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(
            RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) throws DbClusterAlreadyExistsException,
            DbClusterNotFoundException, DbClusterQuotaExceededException, DbClusterSnapshotNotFoundException,
            DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException,
            InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException, InvalidDbSnapshotStateException,
            InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException, KmsKeyNotAccessibleException,
            OptionGroupNotFoundException, StorageQuotaExceededException, DomainNotFoundException,
            DbClusterParameterGroupNotFoundException, DbClusterAutomatedBackupNotFoundException,
            InsufficientDbInstanceCapacityException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<RestoreDbClusterToPointInTimeResponse> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreDbClusterToPointInTimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterToPointInTime");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterToPointInTimeRequest, RestoreDbClusterToPointInTimeResponse>()
                            .withOperationName("RestoreDBClusterToPointInTime").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(restoreDbClusterToPointInTimeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbClusterToPointInTimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB instance from a DB snapshot. The target database is created from the source database restore
     * point with most of the source's original configuration, including the default security group and DB parameter
     * group. By default, the new DB instance is created as a Single-AZ deployment, except when the instance is a SQL
     * Server instance that has an option group associated with mirroring. In this case, the instance becomes a Multi-AZ
     * deployment, not a Single-AZ deployment.
     * </p>
     * <p>
     * If you want to replace your original DB instance with the new, restored DB instance, then rename your original DB
     * instance before you call the <code>RestoreDBInstanceFromDBSnapshot</code> operation. RDS doesn't allow two DB
     * instances with the same name. After you have renamed your original DB instance with a different identifier, then
     * you can pass the original name of the DB instance as the <code>DBInstanceIdentifier</code> in the call to the
     * <code>RestoreDBInstanceFromDBSnapshot</code> operation. The result is that you replace the original DB instance
     * with the DB instance created from the snapshot.
     * </p>
     * <p>
     * If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of
     * the shared DB snapshot.
     * </p>
     * <p>
     * To restore from a DB snapshot with an unsupported engine version, you must first upgrade the engine version of
     * the snapshot. For more information about upgrading a RDS for MySQL DB snapshot engine version, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html">Upgrading a MySQL DB
     * snapshot engine version</a>. For more information about upgrading a RDS for PostgreSQL DB snapshot engine
     * version, <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html">Upgrading a
     * PostgreSQL DB snapshot engine version</a>.
     * </p>
     * <note>
     * <p>
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use
     * <code>RestoreDBClusterFromSnapshot</code>.
     * </p>
     * </note>
     *
     * @param restoreDbInstanceFromDbSnapshotRequest
     * @return Result of the RestoreDBInstanceFromDBSnapshot operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidRestoreException
     *         Cannot restore from VPC backup to non-VPC DB instance.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws TenantDatabaseQuotaExceededException
     *         You attempted to create more tenant databases than are permitted in your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RestoreDBInstanceFromDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreDbInstanceFromDbSnapshotResponse restoreDBInstanceFromDBSnapshot(
            RestoreDbInstanceFromDbSnapshotRequest restoreDbInstanceFromDbSnapshotRequest)
            throws DbInstanceAlreadyExistsException, DbSnapshotNotFoundException, InstanceQuotaExceededException,
            InsufficientDbInstanceCapacityException, InvalidDbSnapshotStateException, StorageQuotaExceededException,
            InvalidVpcNetworkStateException, InvalidRestoreException, DbSubnetGroupNotFoundException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, StorageTypeNotSupportedException, AuthorizationNotFoundException,
            KmsKeyNotAccessibleException, DbSecurityGroupNotFoundException, DomainNotFoundException,
            DbParameterGroupNotFoundException, NetworkTypeNotSupportedException, DbClusterSnapshotNotFoundException,
            CertificateNotFoundException, TenantDatabaseQuotaExceededException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<RestoreDbInstanceFromDbSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbInstanceFromDbSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreDbInstanceFromDbSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreDbInstanceFromDbSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBInstanceFromDBSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbInstanceFromDbSnapshotRequest, RestoreDbInstanceFromDbSnapshotResponse>()
                            .withOperationName("RestoreDBInstanceFromDBSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(restoreDbInstanceFromDbSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbInstanceFromDbSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using backup files. You can
     * create a backup of your on-premises database, store it on Amazon Simple Storage Service (Amazon S3), and then
     * restore the backup file onto a new Amazon RDS DB instance running MySQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html">Importing Data into
     * an Amazon RDS MySQL DB Instance</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * This operation doesn't apply to RDS Custom.
     * </p>
     *
     * @param restoreDbInstanceFromS3Request
     * @return Result of the RestoreDBInstanceFromS3 operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidS3BucketException
     *         The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized to access the specified
     *         Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try
     *         again.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RestoreDBInstanceFromS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromS3" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RestoreDbInstanceFromS3Response restoreDBInstanceFromS3(RestoreDbInstanceFromS3Request restoreDbInstanceFromS3Request)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException,
            InvalidVpcNetworkStateException, InvalidS3BucketException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, StorageTypeNotSupportedException, AuthorizationNotFoundException,
            KmsKeyNotAccessibleException, NetworkTypeNotSupportedException, CertificateNotFoundException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<RestoreDbInstanceFromS3Response> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbInstanceFromS3Response::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreDbInstanceFromS3Request,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreDbInstanceFromS3Request
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBInstanceFromS3");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbInstanceFromS3Request, RestoreDbInstanceFromS3Response>()
                            .withOperationName("RestoreDBInstanceFromS3").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(restoreDbInstanceFromS3Request)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbInstanceFromS3RequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time
     * identified by the <code>LatestRestorableTime</code> property. You can restore to a point up to the number of days
     * specified by the <code>BackupRetentionPeriod</code> property.
     * </p>
     * <p>
     * The target database is created with most of the original configuration, but in a system-selected Availability
     * Zone, with the default security group, the default subnet group, and the default DB parameter group. By default,
     * the new DB instance is created as a single-AZ deployment except when the instance is a SQL Server instance that
     * has an option group that is associated with mirroring; in this case, the instance becomes a mirrored deployment
     * and not a single-AZ deployment.
     * </p>
     * <note>
     * <p>
     * This operation doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use
     * <code>RestoreDBClusterToPointInTime</code>.
     * </p>
     * </note>
     *
     * @param restoreDbInstanceToPointInTimeRequest
     * @return Result of the RestoreDBInstanceToPointInTime operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws PointInTimeRestoreNotEnabledException
     *         <code>SourceDBInstanceIdentifier</code> refers to a DB instance with <code>BackupRetentionPeriod</code>
     *         equal to 0.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidRestoreException
     *         Cannot restore from VPC backup to non-VPC DB instance.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws TenantDatabaseQuotaExceededException
     *         You attempted to create more tenant databases than are permitted in your Amazon Web Services account.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RestoreDBInstanceToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreDbInstanceToPointInTimeResponse restoreDBInstanceToPointInTime(
            RestoreDbInstanceToPointInTimeRequest restoreDbInstanceToPointInTimeRequest) throws DbInstanceAlreadyExistsException,
            DbInstanceNotFoundException, InstanceQuotaExceededException, InsufficientDbInstanceCapacityException,
            InvalidDbInstanceStateException, PointInTimeRestoreNotEnabledException, StorageQuotaExceededException,
            InvalidVpcNetworkStateException, InvalidRestoreException, DbSubnetGroupNotFoundException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, StorageTypeNotSupportedException, AuthorizationNotFoundException,
            KmsKeyNotAccessibleException, DbSecurityGroupNotFoundException, DomainNotFoundException,
            DbParameterGroupNotFoundException, DbInstanceAutomatedBackupNotFoundException, NetworkTypeNotSupportedException,
            TenantDatabaseQuotaExceededException, CertificateNotFoundException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<RestoreDbInstanceToPointInTimeResponse> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbInstanceToPointInTimeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreDbInstanceToPointInTimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreDbInstanceToPointInTimeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBInstanceToPointInTime");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbInstanceToPointInTimeRequest, RestoreDbInstanceToPointInTimeResponse>()
                            .withOperationName("RestoreDBInstanceToPointInTime").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(restoreDbInstanceToPointInTimeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbInstanceToPointInTimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups.
     * Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and
     * either EC2SecurityGroupName or EC2SecurityGroupId).
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param revokeDbSecurityGroupIngressRequest
     * @return Result of the RevokeDBSecurityGroupIngress operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.RevokeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RevokeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RevokeDbSecurityGroupIngressResponse revokeDBSecurityGroupIngress(
            RevokeDbSecurityGroupIngressRequest revokeDbSecurityGroupIngressRequest) throws DbSecurityGroupNotFoundException,
            AuthorizationNotFoundException, InvalidDbSecurityGroupStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<RevokeDbSecurityGroupIngressResponse> responseHandler = protocolFactory
                .createResponseHandler(RevokeDbSecurityGroupIngressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeDbSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeDbSecurityGroupIngressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeDBSecurityGroupIngress");

            return clientHandler
                    .execute(new ClientExecutionParams<RevokeDbSecurityGroupIngressRequest, RevokeDbSecurityGroupIngressResponse>()
                            .withOperationName("RevokeDBSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(revokeDbSecurityGroupIngressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RevokeDbSecurityGroupIngressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a database activity stream to monitor activity on the database. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html"> Monitoring Amazon
     * Aurora with Database Activity Streams</a> in the <i>Amazon Aurora User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html"> Monitoring Amazon RDS with
     * Database Activity Streams</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param startActivityStreamRequest
     * @return Result of the StartActivityStream operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StartActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartActivityStreamResponse startActivityStream(StartActivityStreamRequest startActivityStreamRequest)
            throws InvalidDbInstanceStateException, InvalidDbClusterStateException, ResourceNotFoundException,
            DbClusterNotFoundException, DbInstanceNotFoundException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<StartActivityStreamResponse> responseHandler = protocolFactory
                .createResponseHandler(StartActivityStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startActivityStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startActivityStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartActivityStream");

            return clientHandler.execute(new ClientExecutionParams<StartActivityStreamRequest, StartActivityStreamResponse>()
                    .withOperationName("StartActivityStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startActivityStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartActivityStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster
     * CLI command, or the <code>StopDBCluster</code> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html"> Stopping and
     * Starting an Aurora Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param startDbClusterRequest
     * @return Result of the StartDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StartDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartDbClusterResponse startDBCluster(StartDbClusterRequest startDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<StartDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(StartDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDbClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDBCluster");

            return clientHandler.execute(new ClientExecutionParams<StartDbClusterRequest, StartDbClusterResponse>()
                    .withOperationName("StartDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console, the stop-db-instance CLI
     * command, or the <code>StopDBInstance</code> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html"> Starting an Amazon RDS DB
     * instance That Was Previously Stopped</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <note>
     * <p>
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora DB clusters, use
     * <code>StartDBCluster</code> instead.
     * </p>
     * </note>
     *
     * @param startDbInstanceRequest
     * @return Result of the StartDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StartDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartDbInstanceResponse startDBInstance(StartDbInstanceRequest startDbInstanceRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, InsufficientDbInstanceCapacityException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException,
            InvalidSubnetException, InvalidVpcNetworkStateException, DbClusterNotFoundException, AuthorizationNotFoundException,
            KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<StartDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(StartDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDbInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDBInstance");

            return clientHandler.execute(new ClientExecutionParams<StartDbInstanceRequest, StartDbInstanceResponse>()
                    .withOperationName("StartDBInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables replication of automated backups to a different Amazon Web Services Region.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html"> Replicating Automated
     * Backups to Another Amazon Web Services Region</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param startDbInstanceAutomatedBackupsReplicationRequest
     * @return Result of the StartDBInstanceAutomatedBackupsReplication operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DbInstanceAutomatedBackupQuotaExceededException
     *         The quota for retained automated backups was exceeded. This prevents you from retaining any additional
     *         automated backups. The retained automated backups quota is the same as your DB instance quota.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StartDBInstanceAutomatedBackupsReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstanceAutomatedBackupsReplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartDbInstanceAutomatedBackupsReplicationResponse startDBInstanceAutomatedBackupsReplication(
            StartDbInstanceAutomatedBackupsReplicationRequest startDbInstanceAutomatedBackupsReplicationRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, KmsKeyNotAccessibleException,
            DbInstanceAutomatedBackupQuotaExceededException, StorageTypeNotSupportedException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<StartDbInstanceAutomatedBackupsReplicationResponse> responseHandler = protocolFactory
                .createResponseHandler(StartDbInstanceAutomatedBackupsReplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                startDbInstanceAutomatedBackupsReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startDbInstanceAutomatedBackupsReplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDBInstanceAutomatedBackupsReplication");

            return clientHandler
                    .execute(new ClientExecutionParams<StartDbInstanceAutomatedBackupsReplicationRequest, StartDbInstanceAutomatedBackupsReplicationResponse>()
                            .withOperationName("StartDBInstanceAutomatedBackupsReplication")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(startDbInstanceAutomatedBackupsReplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartDbInstanceAutomatedBackupsReplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an export of DB snapshot or DB cluster data to Amazon S3. The provided IAM role must have access to the S3
     * bucket.
     * </p>
     * <p>
     * You can't export snapshot data from Db2 or RDS Custom DB instances.
     * </p>
     * <p>
     * For more information on exporting DB snapshot data, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ExportSnapshot.html">Exporting DB snapshot data
     * to Amazon S3</a> in the <i>Amazon RDS User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-export-snapshot.html">Exporting DB
     * cluster snapshot data to Amazon S3</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on exporting DB cluster data, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/export-cluster-data.html">Exporting DB cluster
     * data to Amazon S3</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param startExportTaskRequest
     * @return Result of the StartExportTask operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws ExportTaskAlreadyExistsException
     *         You can't start an export task that's already running.
     * @throws InvalidS3BucketException
     *         The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized to access the specified
     *         Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try
     *         again.
     * @throws IamRoleNotFoundException
     *         The IAM role is missing for exporting to an Amazon S3 bucket.
     * @throws IamRoleMissingPermissionsException
     *         The IAM role requires additional permissions to export to an Amazon S3 bucket.
     * @throws InvalidExportOnlyException
     *         The export is invalid for exporting to an Amazon S3 bucket.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws InvalidExportSourceStateException
     *         The state of the export snapshot is invalid for exporting to an Amazon S3 bucket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StartExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartExportTaskResponse startExportTask(StartExportTaskRequest startExportTaskRequest)
            throws DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, DbClusterNotFoundException,
            ExportTaskAlreadyExistsException, InvalidS3BucketException, IamRoleNotFoundException,
            IamRoleMissingPermissionsException, InvalidExportOnlyException, KmsKeyNotAccessibleException,
            InvalidExportSourceStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<StartExportTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(StartExportTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartExportTask");

            return clientHandler.execute(new ClientExecutionParams<StartExportTaskRequest, StartExportTaskResponse>()
                    .withOperationName("StartExportTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startExportTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartExportTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a database activity stream that was started using the Amazon Web Services console, the
     * <code>start-activity-stream</code> CLI command, or the <code>StartActivityStream</code> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html"> Monitoring Amazon
     * Aurora with Database Activity Streams</a> in the <i>Amazon Aurora User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html"> Monitoring Amazon RDS with
     * Database Activity Streams</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param stopActivityStreamRequest
     * @return Result of the StopActivityStream operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StopActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopActivityStreamResponse stopActivityStream(StopActivityStreamRequest stopActivityStreamRequest)
            throws InvalidDbInstanceStateException, InvalidDbClusterStateException, ResourceNotFoundException,
            DbClusterNotFoundException, DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<StopActivityStreamResponse> responseHandler = protocolFactory
                .createResponseHandler(StopActivityStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopActivityStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopActivityStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopActivityStream");

            return clientHandler.execute(new ClientExecutionParams<StopActivityStreamRequest, StopActivityStreamResponse>()
                    .withOperationName("StopActivityStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopActivityStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopActivityStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster's metadata,
     * including its endpoints and DB parameter groups. Aurora also retains the transaction logs so you can do a
     * point-in-time restore if necessary.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html"> Stopping and
     * Starting an Aurora Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param stopDbClusterRequest
     * @return Result of the StopDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StopDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopDbClusterResponse stopDBCluster(StopDbClusterRequest stopDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<StopDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(StopDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDbClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDBCluster");

            return clientHandler.execute(new ClientExecutionParams<StopDbClusterRequest, StopDbClusterResponse>()
                    .withOperationName("StopDBCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB instance's metadata,
     * including its endpoint, DB parameter group, and option group membership. Amazon RDS also retains the transaction
     * logs so you can do a point-in-time restore if necessary.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html"> Stopping an Amazon RDS DB
     * Instance Temporarily</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <note>
     * <p>
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora clusters, use
     * <code>StopDBCluster</code> instead.
     * </p>
     * </note>
     *
     * @param stopDbInstanceRequest
     * @return Result of the StopDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StopDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopDbInstanceResponse stopDBInstance(StopDbInstanceRequest stopDbInstanceRequest) throws DbInstanceNotFoundException,
            InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException, SnapshotQuotaExceededException,
            InvalidDbClusterStateException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<StopDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(StopDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDbInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDBInstance");

            return clientHandler.execute(new ClientExecutionParams<StopDbInstanceRequest, StopDbInstanceResponse>()
                    .withOperationName("StopDBInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops automated backup replication for a DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html"> Replicating Automated
     * Backups to Another Amazon Web Services Region</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param stopDbInstanceAutomatedBackupsReplicationRequest
     * @return Result of the StopDBInstanceAutomatedBackupsReplication operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.StopDBInstanceAutomatedBackupsReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstanceAutomatedBackupsReplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopDbInstanceAutomatedBackupsReplicationResponse stopDBInstanceAutomatedBackupsReplication(
            StopDbInstanceAutomatedBackupsReplicationRequest stopDbInstanceAutomatedBackupsReplicationRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<StopDbInstanceAutomatedBackupsReplicationResponse> responseHandler = protocolFactory
                .createResponseHandler(StopDbInstanceAutomatedBackupsReplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                stopDbInstanceAutomatedBackupsReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopDbInstanceAutomatedBackupsReplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDBInstanceAutomatedBackupsReplication");

            return clientHandler
                    .execute(new ClientExecutionParams<StopDbInstanceAutomatedBackupsReplicationRequest, StopDbInstanceAutomatedBackupsReplicationResponse>()
                            .withOperationName("StopDBInstanceAutomatedBackupsReplication")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(stopDbInstanceAutomatedBackupsReplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopDbInstanceAutomatedBackupsReplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Switches over a blue/green deployment.
     * </p>
     * <p>
     * Before you switch over, production traffic is routed to the databases in the blue environment. After you switch
     * over, production traffic is routed to the databases in the green environment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param switchoverBlueGreenDeploymentRequest
     * @return Result of the SwitchoverBlueGreenDeployment operation returned by the service.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws InvalidBlueGreenDeploymentStateException
     *         The blue/green deployment can't be switched over or deleted because there is an invalid configuration in
     *         the green environment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.SwitchoverBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/SwitchoverBlueGreenDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SwitchoverBlueGreenDeploymentResponse switchoverBlueGreenDeployment(
            SwitchoverBlueGreenDeploymentRequest switchoverBlueGreenDeploymentRequest)
            throws BlueGreenDeploymentNotFoundException, InvalidBlueGreenDeploymentStateException, AwsServiceException,
            SdkClientException, RdsException {

        HttpResponseHandler<SwitchoverBlueGreenDeploymentResponse> responseHandler = protocolFactory
                .createResponseHandler(SwitchoverBlueGreenDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(switchoverBlueGreenDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                switchoverBlueGreenDeploymentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SwitchoverBlueGreenDeployment");

            return clientHandler
                    .execute(new ClientExecutionParams<SwitchoverBlueGreenDeploymentRequest, SwitchoverBlueGreenDeploymentResponse>()
                            .withOperationName("SwitchoverBlueGreenDeployment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(switchoverBlueGreenDeploymentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SwitchoverBlueGreenDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Switches over the specified secondary DB cluster to be the new primary DB cluster in the global database cluster.
     * Switchover operations were previously called "managed planned failovers."
     * </p>
     * <p>
     * Aurora promotes the specified secondary cluster to assume full read/write capabilities and demotes the current
     * primary cluster to a secondary (read-only) cluster, maintaining the orginal replication topology. All secondary
     * clusters are synchronized with the primary at the beginning of the process so the new primary continues
     * operations for the Aurora global database without losing any data. Your database is unavailable for a short time
     * while the primary and selected secondary clusters are assuming their new roles. For more information about
     * switching over an Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover"
     * >Performing switchovers for Amazon Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation is intended for controlled environments, for operations such as "regional rotation" or to fall
     * back to the original primary after a global database failover.
     * </p>
     * </note>
     *
     * @param switchoverGlobalClusterRequest
     * @return Result of the SwitchoverGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.SwitchoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/SwitchoverGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SwitchoverGlobalClusterResponse switchoverGlobalCluster(SwitchoverGlobalClusterRequest switchoverGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, InvalidDbClusterStateException,
            DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {

        HttpResponseHandler<SwitchoverGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(SwitchoverGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(switchoverGlobalClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, switchoverGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SwitchoverGlobalCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<SwitchoverGlobalClusterRequest, SwitchoverGlobalClusterResponse>()
                            .withOperationName("SwitchoverGlobalCluster").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(switchoverGlobalClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SwitchoverGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Switches over an Oracle standby database in an Oracle Data Guard environment, making it the new primary database.
     * Issue this command in the Region that hosts the current standby database.
     * </p>
     *
     * @param switchoverReadReplicaRequest
     * @return Result of the SwitchoverReadReplica operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.SwitchoverReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/SwitchoverReadReplica" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SwitchoverReadReplicaResponse switchoverReadReplica(SwitchoverReadReplicaRequest switchoverReadReplicaRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {

        HttpResponseHandler<SwitchoverReadReplicaResponse> responseHandler = protocolFactory
                .createResponseHandler(SwitchoverReadReplicaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(switchoverReadReplicaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, switchoverReadReplicaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SwitchoverReadReplica");

            return clientHandler.execute(new ClientExecutionParams<SwitchoverReadReplicaRequest, SwitchoverReadReplicaResponse>()
                    .withOperationName("SwitchoverReadReplica").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(switchoverReadReplicaRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SwitchoverReadReplicaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates an instance of {@link RdsUtilities} object with the configuration set on this client.
     */
    @Override
    public RdsUtilities utilities() {
        return DefaultRdsUtilities.create(clientConfiguration);
    }

    /**
     * Create an instance of {@link RdsWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link RdsWaiter}
     */
    @Override
    public RdsWaiter waiter() {
        return RdsWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        RdsServiceClientConfigurationBuilder serviceConfigBuilder = new RdsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBProxyEndpointStateFault")
                                .exceptionBuilderSupplier(InvalidDbProxyEndpointStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentStateFault")
                                .exceptionBuilderSupplier(InvalidBlueGreenDeploymentStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamRoleNotFound")
                                .exceptionBuilderSupplier(IamRoleNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExportTaskNotFound")
                                .exceptionBuilderSupplier(ExportTaskNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault")
                                .exceptionBuilderSupplier(IntegrationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAutomatedBackupQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterAutomatedBackupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRestoreFault")
                                .exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExportOnly")
                                .exceptionBuilderSupplier(InvalidExportOnlyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceRoleQuotaExceeded")
                                .exceptionBuilderSupplier(DbInstanceRoleQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterBacktrackNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterBacktrackNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault")
                                .exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs")
                                .exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedDBEngineVersion")
                                .exceptionBuilderSupplier(UnsupportedDbEngineVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault")
                                .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOptionGroupStateFault")
                                .exceptionBuilderSupplier(InvalidOptionGroupStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceRoleNotFound")
                                .exceptionBuilderSupplier(DbInstanceRoleNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlueGreenDeploymentAlreadyExistsFault")
                                .exceptionBuilderSupplier(BlueGreenDeploymentAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault")
                                .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageTypeNotAvailableFault")
                                .exceptionBuilderSupplier(StorageTypeNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceRoleAlreadyExists")
                                .exceptionBuilderSupplier(DbInstanceRoleAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity")
                                .exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists")
                                .exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyEndpointNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyEndpointNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstancesOfferingNotFound")
                                .exceptionBuilderSupplier(ReservedDbInstancesOfferingNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PointInTimeRestoreNotEnabled")
                                .exceptionBuilderSupplier(PointInTimeRestoreNotEnabledException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState")
                                .exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterCapacityFault")
                                .exceptionBuilderSupplier(InvalidDbClusterCapacityException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomAvailabilityZoneNotFound")
                                .exceptionBuilderSupplier(CustomAvailabilityZoneNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound")
                                .exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyEndpointAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbProxyEndpointAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomDBEngineVersionAlreadyExistsFault")
                                .exceptionBuilderSupplier(CustomDbEngineVersionAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NetworkTypeNotSupported")
                                .exceptionBuilderSupplier(NetworkTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationQuotaExceeded")
                                .exceptionBuilderSupplier(AuthorizationQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded")
                                .exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(GlobalClusterQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CreateCustomDBEngineVersionFault")
                                .exceptionBuilderSupplier(CreateCustomDbEngineVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TenantDatabaseQuotaExceeded")
                                .exceptionBuilderSupplier(TenantDatabaseQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlueGreenDeploymentNotFoundFault")
                                .exceptionBuilderSupplier(BlueGreenDeploymentNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAutomatedBackupNotFound")
                                .exceptionBuilderSupplier(DbInstanceAutomatedBackupNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists")
                                .exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBShardGroupState")
                                .exceptionBuilderSupplier(InvalidDbShardGroupStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QuotaExceeded.DBSecurityGroup")
                                .exceptionBuilderSupplier(DbSecurityGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceDatabaseNotSupportedFault")
                                .exceptionBuilderSupplier(SourceDatabaseNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure")
                                .exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ProvisionedIopsNotAvailableInAZFault")
                                .exceptionBuilderSupplier(ProvisionedIopsNotAvailableInAzException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceStateFault")
                                .exceptionBuilderSupplier(InvalidResourceStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity")
                                .exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterEndpointAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyQuotaExceededFault")
                                .exceptionBuilderSupplier(DbProxyQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotNotFound")
                                .exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstanceAlreadyExists")
                                .exceptionBuilderSupplier(ReservedDbInstanceAlreadyExistsException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyTargetNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyTargetNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OptionGroupNotFoundFault")
                                .exceptionBuilderSupplier(OptionGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBShardGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbShardGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomDBEngineVersionNotFoundFault")
                                .exceptionBuilderSupplier(CustomDbEngineVersionNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBShardGroupNotFound")
                                .exceptionBuilderSupplier(DbShardGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DomainNotFoundFault")
                                .exceptionBuilderSupplier(DomainNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterEndpointNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAutomatedBackupNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterAutomatedBackupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageQuotaExceeded")
                                .exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterEndpointStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterEndpointStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationNotFound")
                                .exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OptionGroupAlreadyExistsFault")
                                .exceptionBuilderSupplier(OptionGroupAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OptionGroupQuotaExceededFault")
                                .exceptionBuilderSupplier(OptionGroupQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExportSourceState")
                                .exceptionBuilderSupplier(InvalidExportSourceStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBInstanceAutomatedBackupState")
                                .exceptionBuilderSupplier(InvalidDbInstanceAutomatedBackupStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBLogFileNotFoundFault")
                                .exceptionBuilderSupplier(DbLogFileNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleNotFound")
                                .exceptionBuilderSupplier(DbClusterRoleNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound")
                                .exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("Ec2ImagePropertiesNotSupportedFault")
                                .exceptionBuilderSupplier(Ec2ImagePropertiesNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceNotFound")
                                .exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault")
                                .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyTargetAlreadyRegisteredFault")
                                .exceptionBuilderSupplier(DbProxyTargetAlreadyRegisteredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstanceNotFound")
                                .exceptionBuilderSupplier(ReservedDbInstanceNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleQuotaExceeded")
                                .exceptionBuilderSupplier(DbClusterRoleQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateNotFound")
                                .exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState")
                                .exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAutomatedBackupQuotaExceeded")
                                .exceptionBuilderSupplier(DbInstanceAutomatedBackupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExportTaskStateFault")
                                .exceptionBuilderSupplier(InvalidExportTaskStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotTenantDatabaseNotFoundFault")
                                .exceptionBuilderSupplier(DbSnapshotTenantDatabaseNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3BucketFault")
                                .exceptionBuilderSupplier(InvalidS3BucketException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundFault")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageTypeNotSupported")
                                .exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionNotFound")
                                .exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse")
                                .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyTargetGroupNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyTargetGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterNotFoundFault")
                                .exceptionBuilderSupplier(GlobalClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationAlreadyExistsFault")
                                .exceptionBuilderSupplier(IntegrationAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleAlreadyExists")
                                .exceptionBuilderSupplier(DbClusterRoleAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEventSubscriptionState")
                                .exceptionBuilderSupplier(InvalidEventSubscriptionStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientAvailableIPsInSubnetFault")
                                .exceptionBuilderSupplier(InsufficientAvailableIPsInSubnetException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxDBShardGroupLimitReached")
                                .exceptionBuilderSupplier(MaxDbShardGroupLimitReachedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyEndpointQuotaExceededFault")
                                .exceptionBuilderSupplier(DbProxyEndpointQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomDBEngineVersionQuotaExceededFault")
                                .exceptionBuilderSupplier(CustomDbEngineVersionQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TenantDatabaseNotFound")
                                .exceptionBuilderSupplier(TenantDatabaseNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupNotSupported")
                                .exceptionBuilderSupplier(DbSecurityGroupNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TenantDatabaseAlreadyExists")
                                .exceptionBuilderSupplier(TenantDatabaseAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExportTaskAlreadyExists")
                                .exceptionBuilderSupplier(ExportTaskAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(GlobalClusterAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupNotAllowedFault")
                                .exceptionBuilderSupplier(DbSubnetGroupNotAllowedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGlobalClusterStateFault")
                                .exceptionBuilderSupplier(InvalidGlobalClusterStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSInvalidTopic")
                                .exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBProxyStateFault")
                                .exceptionBuilderSupplier(InvalidDbProxyStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceClusterNotSupportedFault")
                                .exceptionBuilderSupplier(SourceClusterNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamRoleMissingPermissions")
                                .exceptionBuilderSupplier(IamRoleMissingPermissionsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault")
                                .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound")
                                .exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSNoAuthorization")
                                .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterEndpointQuotaExceededException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstanceQuotaExceeded")
                                .exceptionBuilderSupplier(ReservedDbInstanceQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist")
                                .exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbProxyAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbSecurityGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceNotFound")
                                .exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBInstanceState")
                                .exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded")
                                .exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists")
                                .exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCustomDBEngineVersionStateFault")
                                .exceptionBuilderSupplier(InvalidCustomDbEngineVersionStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterAutomatedBackupStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterAutomatedBackupStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState")
                                .exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(400)
                                .build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(RdsException::builder).build();
    }

    @Override
    public final RdsServiceClientConfiguration serviceClientConfiguration() {
        return new RdsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
