/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyPendingMaintenanceActionRequest extends RdsRequest implements
        ToCopyableBuilder<ApplyPendingMaintenanceActionRequest.Builder, ApplyPendingMaintenanceActionRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(ApplyPendingMaintenanceActionRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<String> APPLY_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplyAction").getter(getter(ApplyPendingMaintenanceActionRequest::applyAction))
            .setter(setter(Builder::applyAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyAction").build()).build();

    private static final SdkField<String> OPT_IN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptInType").getter(getter(ApplyPendingMaintenanceActionRequest::optInType))
            .setter(setter(Builder::optInType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            APPLY_ACTION_FIELD, OPT_IN_TYPE_FIELD));

    private final String resourceIdentifier;

    private final String applyAction;

    private final String optInType;

    private ApplyPendingMaintenanceActionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.applyAction = builder.applyAction;
        this.optInType = builder.optInType;
    }

    /**
     * <p>
     * The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For
     * information about creating an ARN, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
     * Constructing an RDS Amazon Resource Name (ARN)</a>.
     * </p>
     * 
     * @return The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For
     *         information about creating an ARN, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"
     *         > Constructing an RDS Amazon Resource Name (ARN)</a>.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The pending maintenance action to apply to this resource.
     * </p>
     * <p>
     * Valid Values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>,
     * <code>ca-certificate-rotation</code>
     * </p>
     * 
     * @return The pending maintenance action to apply to this resource.</p>
     *         <p>
     *         Valid Values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>,
     *         <code>ca-certificate-rotation</code>
     */
    public final String applyAction() {
        return applyAction;
    }

    /**
     * <p>
     * A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
     * <code>immediate</code> can't be undone.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>immediate</code> - Apply the maintenance action immediately.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
     *         <code>immediate</code> can't be undone.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>immediate</code> - Apply the maintenance action immediately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the
     *         resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.
     *         </p>
     *         </li>
     */
    public final String optInType() {
        return optInType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(applyAction());
        hashCode = 31 * hashCode + Objects.hashCode(optInType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyPendingMaintenanceActionRequest)) {
            return false;
        }
        ApplyPendingMaintenanceActionRequest other = (ApplyPendingMaintenanceActionRequest) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(applyAction(), other.applyAction()) && Objects.equals(optInType(), other.optInType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplyPendingMaintenanceActionRequest").add("ResourceIdentifier", resourceIdentifier())
                .add("ApplyAction", applyAction()).add("OptInType", optInType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ApplyAction":
            return Optional.ofNullable(clazz.cast(applyAction()));
        case "OptInType":
            return Optional.ofNullable(clazz.cast(optInType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyPendingMaintenanceActionRequest, T> g) {
        return obj -> g.apply((ApplyPendingMaintenanceActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ApplyPendingMaintenanceActionRequest> {
        /**
         * <p>
         * The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For
         * information about creating an ARN, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
         * Constructing an RDS Amazon Resource Name (ARN)</a>.
         * </p>
         * 
         * @param resourceIdentifier
         *        The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For
         *        information about creating an ARN, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"
         *        > Constructing an RDS Amazon Resource Name (ARN)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The pending maintenance action to apply to this resource.
         * </p>
         * <p>
         * Valid Values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>,
         * <code>ca-certificate-rotation</code>
         * </p>
         * 
         * @param applyAction
         *        The pending maintenance action to apply to this resource.</p>
         *        <p>
         *        Valid Values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>,
         *        <code>ca-certificate-rotation</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyAction(String applyAction);

        /**
         * <p>
         * A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
         * <code>immediate</code> can't be undone.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>immediate</code> - Apply the maintenance action immediately.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the
         * resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.
         * </p>
         * </li>
         * </ul>
         * 
         * @param optInType
         *        A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of
         *        type <code>immediate</code> can't be undone.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>immediate</code> - Apply the maintenance action immediately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for
         *        the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInType(String optInType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String resourceIdentifier;

        private String applyAction;

        private String optInType;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyPendingMaintenanceActionRequest model) {
            super(model);
            resourceIdentifier(model.resourceIdentifier);
            applyAction(model.applyAction);
            optInType(model.optInType);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getApplyAction() {
            return applyAction;
        }

        public final void setApplyAction(String applyAction) {
            this.applyAction = applyAction;
        }

        @Override
        public final Builder applyAction(String applyAction) {
            this.applyAction = applyAction;
            return this;
        }

        public final String getOptInType() {
            return optInType;
        }

        public final void setOptInType(String optInType) {
            this.optInType = optInType;
        }

        @Override
        public final Builder optInType(String optInType) {
            this.optInType = optInType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyPendingMaintenanceActionRequest build() {
            return new ApplyPendingMaintenanceActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
