/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DBSnapshotAttributeListCopier {
    static List<DBSnapshotAttribute> copy(Collection<? extends DBSnapshotAttribute> dbSnapshotAttributeListParam) {
        List<DBSnapshotAttribute> list;
        if (dbSnapshotAttributeListParam == null || dbSnapshotAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DBSnapshotAttribute> modifiableList = new ArrayList<>(dbSnapshotAttributeListParam.size());
            dbSnapshotAttributeListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DBSnapshotAttribute> copyFromBuilder(
            Collection<? extends DBSnapshotAttribute.Builder> dbSnapshotAttributeListParam) {
        List<DBSnapshotAttribute> list;
        if (dbSnapshotAttributeListParam == null || dbSnapshotAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DBSnapshotAttribute> modifiableList = new ArrayList<>(dbSnapshotAttributeListParam.size());
            dbSnapshotAttributeListParam.forEach(entry -> {
                DBSnapshotAttribute member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DBSnapshotAttribute.Builder> copyToBuilder(Collection<? extends DBSnapshotAttribute> dbSnapshotAttributeListParam) {
        List<DBSnapshotAttribute.Builder> list;
        if (dbSnapshotAttributeListParam == null || dbSnapshotAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DBSnapshotAttribute.Builder> modifiableList = new ArrayList<>(dbSnapshotAttributeListParam.size());
            dbSnapshotAttributeListParam.forEach(entry -> {
                DBSnapshotAttribute.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
