/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Option implements SdkPojo, Serializable, ToCopyableBuilder<Option.Builder, Option> {
    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionName").getter(getter(Option::optionName)).setter(setter(Builder::optionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()).build();

    private static final SdkField<String> OPTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionDescription").getter(getter(Option::optionDescription)).setter(setter(Builder::optionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionDescription").build()).build();

    private static final SdkField<Boolean> PERSISTENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Persistent").getter(getter(Option::persistent)).setter(setter(Builder::persistent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persistent").build()).build();

    private static final SdkField<Boolean> PERMANENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Permanent").getter(getter(Option::permanent)).setter(setter(Builder::permanent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permanent").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(Option::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> OPTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionVersion").getter(getter(Option::optionVersion)).setter(setter(Builder::optionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionVersion").build()).build();

    private static final SdkField<List<OptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<OptionSetting>> builder(MarshallingType.LIST)
            .memberName("OptionSettings")
            .getter(getter(Option::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionSetting")
                            .memberFieldInfo(
                                    SdkField.<OptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionSetting").build()).build()).build()).build();

    private static final SdkField<List<DBSecurityGroupMembership>> DB_SECURITY_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<DBSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroupMemberships")
            .getter(getter(Option::dbSecurityGroupMemberships))
            .setter(setter(Builder::dbSecurityGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<DBSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroup").build()).build()).build()).build();

    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<VpcSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupMemberships")
            .getter(getter(Option::vpcSecurityGroupMemberships))
            .setter(setter(Builder::vpcSecurityGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMemberships")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupMembership")
                            .memberFieldInfo(
                                    SdkField.<VpcSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupMembership").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_NAME_FIELD,
            OPTION_DESCRIPTION_FIELD, PERSISTENT_FIELD, PERMANENT_FIELD, PORT_FIELD, OPTION_VERSION_FIELD, OPTION_SETTINGS_FIELD,
            DB_SECURITY_GROUP_MEMBERSHIPS_FIELD, VPC_SECURITY_GROUP_MEMBERSHIPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String optionName;

    private final String optionDescription;

    private final Boolean persistent;

    private final Boolean permanent;

    private final Integer port;

    private final String optionVersion;

    private final List<OptionSetting> optionSettings;

    private final List<DBSecurityGroupMembership> dbSecurityGroupMemberships;

    private final List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships;

    private Option(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.optionDescription = builder.optionDescription;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.port = builder.port;
        this.optionVersion = builder.optionVersion;
        this.optionSettings = builder.optionSettings;
        this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
        this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
    }

    /**
     * <p>
     * The name of the option.
     * </p>
     * 
     * @return The name of the option.
     */
    public final String optionName() {
        return optionName;
    }

    /**
     * <p>
     * The description of the option.
     * </p>
     * 
     * @return The description of the option.
     */
    public final String optionDescription() {
        return optionDescription;
    }

    /**
     * <p>
     * Indicates whether this option is persistent.
     * </p>
     * 
     * @return Indicates whether this option is persistent.
     */
    public final Boolean persistent() {
        return persistent;
    }

    /**
     * <p>
     * Indicates whether this option is permanent.
     * </p>
     * 
     * @return Indicates whether this option is permanent.
     */
    public final Boolean permanent() {
        return permanent;
    }

    /**
     * <p>
     * If required, the port configured for this option to use.
     * </p>
     * 
     * @return If required, the port configured for this option to use.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The version of the option.
     * </p>
     * 
     * @return The version of the option.
     */
    public final String optionVersion() {
        return optionVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionSettings() {
        return optionSettings != null && !(optionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The option settings for this option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionSettings} method.
     * </p>
     * 
     * @return The option settings for this option.
     */
    public final List<OptionSetting> optionSettings() {
        return optionSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBSecurityGroupMemberships property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDbSecurityGroupMemberships() {
        return dbSecurityGroupMemberships != null && !(dbSecurityGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the option requires access to a port, then this DB security group allows access to the port.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbSecurityGroupMemberships} method.
     * </p>
     * 
     * @return If the option requires access to a port, then this DB security group allows access to the port.
     */
    public final List<DBSecurityGroupMembership> dbSecurityGroupMemberships() {
        return dbSecurityGroupMemberships;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupMemberships property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcSecurityGroupMemberships() {
        return vpcSecurityGroupMemberships != null && !(vpcSecurityGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the option requires access to a port, then this VPC security group allows access to the port.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupMemberships} method.
     * </p>
     * 
     * @return If the option requires access to a port, then this VPC security group allows access to the port.
     */
    public final List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships() {
        return vpcSecurityGroupMemberships;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optionName());
        hashCode = 31 * hashCode + Objects.hashCode(optionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(persistent());
        hashCode = 31 * hashCode + Objects.hashCode(permanent());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(optionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionSettings() ? optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroupMemberships() ? dbSecurityGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupMemberships() ? vpcSecurityGroupMemberships() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option) obj;
        return Objects.equals(optionName(), other.optionName()) && Objects.equals(optionDescription(), other.optionDescription())
                && Objects.equals(persistent(), other.persistent()) && Objects.equals(permanent(), other.permanent())
                && Objects.equals(port(), other.port()) && Objects.equals(optionVersion(), other.optionVersion())
                && hasOptionSettings() == other.hasOptionSettings() && Objects.equals(optionSettings(), other.optionSettings())
                && hasDbSecurityGroupMemberships() == other.hasDbSecurityGroupMemberships()
                && Objects.equals(dbSecurityGroupMemberships(), other.dbSecurityGroupMemberships())
                && hasVpcSecurityGroupMemberships() == other.hasVpcSecurityGroupMemberships()
                && Objects.equals(vpcSecurityGroupMemberships(), other.vpcSecurityGroupMemberships());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Option").add("OptionName", optionName()).add("OptionDescription", optionDescription())
                .add("Persistent", persistent()).add("Permanent", permanent()).add("Port", port())
                .add("OptionVersion", optionVersion()).add("OptionSettings", hasOptionSettings() ? optionSettings() : null)
                .add("DBSecurityGroupMemberships", hasDbSecurityGroupMemberships() ? dbSecurityGroupMemberships() : null)
                .add("VpcSecurityGroupMemberships", hasVpcSecurityGroupMemberships() ? vpcSecurityGroupMemberships() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionName":
            return Optional.ofNullable(clazz.cast(optionName()));
        case "OptionDescription":
            return Optional.ofNullable(clazz.cast(optionDescription()));
        case "Persistent":
            return Optional.ofNullable(clazz.cast(persistent()));
        case "Permanent":
            return Optional.ofNullable(clazz.cast(permanent()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "OptionVersion":
            return Optional.ofNullable(clazz.cast(optionVersion()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        case "DBSecurityGroupMemberships":
            return Optional.ofNullable(clazz.cast(dbSecurityGroupMemberships()));
        case "VpcSecurityGroupMemberships":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupMemberships()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Option, T> g) {
        return obj -> g.apply((Option) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Option> {
        /**
         * <p>
         * The name of the option.
         * </p>
         * 
         * @param optionName
         *        The name of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionName(String optionName);

        /**
         * <p>
         * The description of the option.
         * </p>
         * 
         * @param optionDescription
         *        The description of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionDescription(String optionDescription);

        /**
         * <p>
         * Indicates whether this option is persistent.
         * </p>
         * 
         * @param persistent
         *        Indicates whether this option is persistent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistent(Boolean persistent);

        /**
         * <p>
         * Indicates whether this option is permanent.
         * </p>
         * 
         * @param permanent
         *        Indicates whether this option is permanent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permanent(Boolean permanent);

        /**
         * <p>
         * If required, the port configured for this option to use.
         * </p>
         * 
         * @param port
         *        If required, the port configured for this option to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The version of the option.
         * </p>
         * 
         * @param optionVersion
         *        The version of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionVersion(String optionVersion);

        /**
         * <p>
         * The option settings for this option.
         * </p>
         * 
         * @param optionSettings
         *        The option settings for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<OptionSetting> optionSettings);

        /**
         * <p>
         * The option settings for this option.
         * </p>
         * 
         * @param optionSettings
         *        The option settings for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(OptionSetting... optionSettings);

        /**
         * <p>
         * The option settings for this option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.OptionSetting.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.OptionSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.OptionSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #optionSettings(List<OptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.OptionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(java.util.Collection<OptionSetting>)
         */
        Builder optionSettings(Consumer<OptionSetting.Builder>... optionSettings);

        /**
         * <p>
         * If the option requires access to a port, then this DB security group allows access to the port.
         * </p>
         * 
         * @param dbSecurityGroupMemberships
         *        If the option requires access to a port, then this DB security group allows access to the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dbSecurityGroupMemberships);

        /**
         * <p>
         * If the option requires access to a port, then this DB security group allows access to the port.
         * </p>
         * 
         * @param dbSecurityGroupMemberships
         *        If the option requires access to a port, then this DB security group allows access to the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupMemberships(DBSecurityGroupMembership... dbSecurityGroupMemberships);

        /**
         * <p>
         * If the option requires access to a port, then this DB security group allows access to the port.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership.Builder#build()} is called
         * immediately and its result is passed to {@link #dbSecurityGroupMemberships(List<DBSecurityGroupMembership>)}.
         * 
         * @param dbSecurityGroupMemberships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSecurityGroupMemberships(java.util.Collection<DBSecurityGroupMembership>)
         */
        Builder dbSecurityGroupMemberships(Consumer<DBSecurityGroupMembership.Builder>... dbSecurityGroupMemberships);

        /**
         * <p>
         * If the option requires access to a port, then this VPC security group allows access to the port.
         * </p>
         * 
         * @param vpcSecurityGroupMemberships
         *        If the option requires access to a port, then this VPC security group allows access to the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships);

        /**
         * <p>
         * If the option requires access to a port, then this VPC security group allows access to the port.
         * </p>
         * 
         * @param vpcSecurityGroupMemberships
         *        If the option requires access to a port, then this VPC security group allows access to the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership... vpcSecurityGroupMemberships);

        /**
         * <p>
         * If the option requires access to a port, then this VPC security group allows access to the port.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #vpcSecurityGroupMemberships(List<VpcSecurityGroupMembership>)}.
         * 
         * @param vpcSecurityGroupMemberships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroupMemberships(java.util.Collection<VpcSecurityGroupMembership>)
         */
        Builder vpcSecurityGroupMemberships(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroupMemberships);
    }

    static final class BuilderImpl implements Builder {
        private String optionName;

        private String optionDescription;

        private Boolean persistent;

        private Boolean permanent;

        private Integer port;

        private String optionVersion;

        private List<OptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private List<DBSecurityGroupMembership> dbSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Option model) {
            optionName(model.optionName);
            optionDescription(model.optionDescription);
            persistent(model.persistent);
            permanent(model.permanent);
            port(model.port);
            optionVersion(model.optionVersion);
            optionSettings(model.optionSettings);
            dbSecurityGroupMemberships(model.dbSecurityGroupMemberships);
            vpcSecurityGroupMemberships(model.vpcSecurityGroupMemberships);
        }

        public final String getOptionName() {
            return optionName;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final String getOptionDescription() {
            return optionDescription;
        }

        public final void setOptionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
        }

        @Override
        public final Builder optionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
            return this;
        }

        public final Boolean getPersistent() {
            return persistent;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final Boolean getPermanent() {
            return permanent;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getOptionVersion() {
            return optionVersion;
        }

        public final void setOptionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
        }

        @Override
        public final Builder optionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
            return this;
        }

        public final List<OptionSetting.Builder> getOptionSettings() {
            List<OptionSetting.Builder> result = OptionSettingConfigurationListCopier.copyToBuilder(this.optionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionSettings(Collection<OptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        public final Builder optionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(OptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<OptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings).map(c -> OptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DBSecurityGroupMembership.Builder> getDbSecurityGroupMemberships() {
            List<DBSecurityGroupMembership.Builder> result = DBSecurityGroupMembershipListCopier
                    .copyToBuilder(this.dbSecurityGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbSecurityGroupMemberships(
                Collection<DBSecurityGroupMembership.BuilderImpl> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copyFromBuilder(dbSecurityGroupMemberships);
        }

        @Override
        public final Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(DBSecurityGroupMembership... dbSecurityGroupMemberships) {
            dbSecurityGroupMemberships(Arrays.asList(dbSecurityGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(Consumer<DBSecurityGroupMembership.Builder>... dbSecurityGroupMemberships) {
            dbSecurityGroupMemberships(Stream.of(dbSecurityGroupMemberships)
                    .map(c -> DBSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroupMemberships() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier
                    .copyToBuilder(this.vpcSecurityGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroupMemberships(
                Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroupMemberships);
        }

        @Override
        public final Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership... vpcSecurityGroupMemberships) {
            vpcSecurityGroupMemberships(Arrays.asList(vpcSecurityGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(
                Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroupMemberships) {
            vpcSecurityGroupMemberships(Stream.of(vpcSecurityGroupMemberships)
                    .map(c -> VpcSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Option build() {
            return new Option(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
