/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single Performance Insights metric query to process. You must provide the metric to the query. If other parameters
 * aren't specified, Performance Insights returns all data points for the specified metric. Optionally, you can request
 * the data points to be aggregated by dimension group (<code>GroupBy</code>) and return only those data points that
 * match your criteria (<code>Filter</code>).
 * </p>
 * <p>
 * Constraints:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Must be a valid Performance Insights query.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceInsightsMetricQuery implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceInsightsMetricQuery.Builder, PerformanceInsightsMetricQuery> {
    private static final SdkField<PerformanceInsightsMetricDimensionGroup> GROUP_BY_FIELD = SdkField
            .<PerformanceInsightsMetricDimensionGroup> builder(MarshallingType.SDK_POJO).memberName("GroupBy")
            .getter(getter(PerformanceInsightsMetricQuery::groupBy)).setter(setter(Builder::groupBy))
            .constructor(PerformanceInsightsMetricDimensionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Metric")
            .getter(getter(PerformanceInsightsMetricQuery::metric)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD, METRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final PerformanceInsightsMetricDimensionGroup groupBy;

    private final String metric;

    private PerformanceInsightsMetricQuery(BuilderImpl builder) {
        this.groupBy = builder.groupBy;
        this.metric = builder.metric;
    }

    /**
     * <p>
     * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
     * group. Performance Insights will return all of the dimensions within that group, unless you provide the names of
     * specific dimensions within that group. You can also request that Performance Insights return a limited number of
     * values for a dimension.
     * </p>
     * 
     * @return A specification for how to aggregate the data points from a query result. You must specify a valid
     *         dimension group. Performance Insights will return all of the dimensions within that group, unless you
     *         provide the names of specific dimensions within that group. You can also request that Performance
     *         Insights return a limited number of values for a dimension.
     */
    public final PerformanceInsightsMetricDimensionGroup groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * The name of a Performance Insights metric to be measured.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
     * </p>
     * </li>
     * <li>
     * <p>
     * The counter metrics listed in <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS"
     * >Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the number of active sessions is less than an internal Performance Insights threshold,
     * <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions
     * is greater than the internal threshold, Performance Insights samples the active sessions, with
     * <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and
     * <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query
     * <code>db.load.avg</code> only.
     * </p>
     * 
     * @return The name of a Performance Insights metric to be measured.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database
     *         engine.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The counter metrics listed in <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS"
     *         >Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the number of active sessions is less than an internal Performance Insights threshold,
     *         <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active
     *         sessions is greater than the internal threshold, Performance Insights samples the active sessions, with
     *         <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw
     *         values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you
     *         can query <code>db.load.avg</code> only.
     */
    public final String metric() {
        return metric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsMetricQuery)) {
            return false;
        }
        PerformanceInsightsMetricQuery other = (PerformanceInsightsMetricQuery) obj;
        return Objects.equals(groupBy(), other.groupBy()) && Objects.equals(metric(), other.metric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceInsightsMetricQuery").add("GroupBy", groupBy()).add("Metric", metric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsMetricQuery, T> g) {
        return obj -> g.apply((PerformanceInsightsMetricQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceInsightsMetricQuery> {
        /**
         * <p>
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
         * group. Performance Insights will return all of the dimensions within that group, unless you provide the names
         * of specific dimensions within that group. You can also request that Performance Insights return a limited
         * number of values for a dimension.
         * </p>
         * 
         * @param groupBy
         *        A specification for how to aggregate the data points from a query result. You must specify a valid
         *        dimension group. Performance Insights will return all of the dimensions within that group, unless you
         *        provide the names of specific dimensions within that group. You can also request that Performance
         *        Insights return a limited number of values for a dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(PerformanceInsightsMetricDimensionGroup groupBy);

        /**
         * <p>
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
         * group. Performance Insights will return all of the dimensions within that group, unless you provide the names
         * of specific dimensions within that group. You can also request that Performance Insights return a limited
         * number of values for a dimension.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PerformanceInsightsMetricDimensionGroup.Builder} avoiding the need to create one manually via
         * {@link PerformanceInsightsMetricDimensionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceInsightsMetricDimensionGroup.Builder#build()} is
         * called immediately and its result is passed to {@link #groupBy(PerformanceInsightsMetricDimensionGroup)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on {@link PerformanceInsightsMetricDimensionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(PerformanceInsightsMetricDimensionGroup)
         */
        default Builder groupBy(Consumer<PerformanceInsightsMetricDimensionGroup.Builder> groupBy) {
            return groupBy(PerformanceInsightsMetricDimensionGroup.builder().applyMutation(groupBy).build());
        }

        /**
         * <p>
         * The name of a Performance Insights metric to be measured.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
         * </p>
         * </li>
         * <li>
         * <p>
         * The counter metrics listed in <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS"
         * >Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the number of active sessions is less than an internal Performance Insights threshold,
         * <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active
         * sessions is greater than the internal threshold, Performance Insights samples the active sessions, with
         * <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values,
         * and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query
         * <code>db.load.avg</code> only.
         * </p>
         * 
         * @param metric
         *        The name of a Performance Insights metric to be measured.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database
         *        engine.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The counter metrics listed in <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS"
         *        >Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the number of active sessions is less than an internal Performance Insights threshold,
         *        <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of
         *        active sessions is greater than the internal threshold, Performance Insights samples the active
         *        sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code>
         *        showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For
         *        most use cases, you can query <code>db.load.avg</code> only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);
    }

    static final class BuilderImpl implements Builder {
        private PerformanceInsightsMetricDimensionGroup groupBy;

        private String metric;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsMetricQuery model) {
            groupBy(model.groupBy);
            metric(model.metric);
        }

        public final PerformanceInsightsMetricDimensionGroup.Builder getGroupBy() {
            return groupBy != null ? groupBy.toBuilder() : null;
        }

        public final void setGroupBy(PerformanceInsightsMetricDimensionGroup.BuilderImpl groupBy) {
            this.groupBy = groupBy != null ? groupBy.build() : null;
        }

        @Override
        public final Builder groupBy(PerformanceInsightsMetricDimensionGroup groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public PerformanceInsightsMetricQuery build() {
            return new PerformanceInsightsMetricQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
