/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCustomDbEngineVersionRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyCustomDbEngineVersionRequest.Builder, ModifyCustomDbEngineVersionRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ModifyCustomDbEngineVersionRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyCustomDbEngineVersionRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ModifyCustomDbEngineVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModifyCustomDbEngineVersionRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DESCRIPTION_FIELD, STATUS_FIELD));

    private final String engine;

    private final String engineVersion;

    private final String description;

    private final String status;

    private ModifyCustomDbEngineVersionRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.description = builder.description;
        this.status = builder.status;
    }

    /**
     * <p>
     * The database engine. RDS Custom for Oracle supports the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>custom-oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-ee-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2-cdb</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine. RDS Custom for Oracle supports the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2-cdb</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The custom engine version (CEV) that you want to modify. This option is required for RDS Custom for Oracle, but
     * optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per
     * customer per Amazon Web Services Region.
     * </p>
     * 
     * @return The custom engine version (CEV) that you want to modify. This option is required for RDS Custom for
     *         Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and
     *         <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * An optional description of your CEV.
     * </p>
     * 
     * @return An optional description of your CEV.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The availability status to be assigned to the CEV. Valid values are as follows:
     * </p>
     * <dl>
     * <dt>available</dt>
     * <dd>
     * <p>
     * You can use this CEV to create a new RDS Custom DB instance.
     * </p>
     * </dd>
     * <dt>inactive</dt>
     * <dd>
     * <p>
     * You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or create new
     * instances with this CEV.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * You can change any status to any status. A typical reason to change status is to prevent the accidental use of a
     * CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status of your CEV
     * from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to
     * <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an RDS
     * Custom instance, snapshot, or automated backup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomEngineVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The availability status to be assigned to the CEV. Valid values are as follows:</p>
     *         <dl>
     *         <dt>available</dt>
     *         <dd>
     *         <p>
     *         You can use this CEV to create a new RDS Custom DB instance.
     *         </p>
     *         </dd>
     *         <dt>inactive</dt>
     *         <dd>
     *         <p>
     *         You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or
     *         create new instances with this CEV.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         You can change any status to any status. A typical reason to change status is to prevent the accidental
     *         use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the
     *         status of your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code>
     *         back to <code>available</code>. To change the availability status of the CEV, it must not currently be in
     *         use by an RDS Custom instance, snapshot, or automated backup.
     * @see CustomEngineVersionStatus
     */
    public final CustomEngineVersionStatus status() {
        return CustomEngineVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The availability status to be assigned to the CEV. Valid values are as follows:
     * </p>
     * <dl>
     * <dt>available</dt>
     * <dd>
     * <p>
     * You can use this CEV to create a new RDS Custom DB instance.
     * </p>
     * </dd>
     * <dt>inactive</dt>
     * <dd>
     * <p>
     * You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or create new
     * instances with this CEV.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * You can change any status to any status. A typical reason to change status is to prevent the accidental use of a
     * CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status of your CEV
     * from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to
     * <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an RDS
     * Custom instance, snapshot, or automated backup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomEngineVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The availability status to be assigned to the CEV. Valid values are as follows:</p>
     *         <dl>
     *         <dt>available</dt>
     *         <dd>
     *         <p>
     *         You can use this CEV to create a new RDS Custom DB instance.
     *         </p>
     *         </dd>
     *         <dt>inactive</dt>
     *         <dd>
     *         <p>
     *         You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or
     *         create new instances with this CEV.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         You can change any status to any status. A typical reason to change status is to prevent the accidental
     *         use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the
     *         status of your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code>
     *         back to <code>available</code>. To change the availability status of the CEV, it must not currently be in
     *         use by an RDS Custom instance, snapshot, or automated backup.
     * @see CustomEngineVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCustomDbEngineVersionRequest)) {
            return false;
        }
        ModifyCustomDbEngineVersionRequest other = (ModifyCustomDbEngineVersionRequest) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCustomDbEngineVersionRequest").add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("Description", description()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCustomDbEngineVersionRequest, T> g) {
        return obj -> g.apply((ModifyCustomDbEngineVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCustomDbEngineVersionRequest> {
        /**
         * <p>
         * The database engine. RDS Custom for Oracle supports the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>custom-oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-ee-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2-cdb</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The database engine. RDS Custom for Oracle supports the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2-cdb</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The custom engine version (CEV) that you want to modify. This option is required for RDS Custom for Oracle,
         * but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique
         * per customer per Amazon Web Services Region.
         * </p>
         * 
         * @param engineVersion
         *        The custom engine version (CEV) that you want to modify. This option is required for RDS Custom for
         *        Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and
         *        <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * An optional description of your CEV.
         * </p>
         * 
         * @param description
         *        An optional description of your CEV.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The availability status to be assigned to the CEV. Valid values are as follows:
         * </p>
         * <dl>
         * <dt>available</dt>
         * <dd>
         * <p>
         * You can use this CEV to create a new RDS Custom DB instance.
         * </p>
         * </dd>
         * <dt>inactive</dt>
         * <dd>
         * <p>
         * You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or create
         * new instances with this CEV.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * You can change any status to any status. A typical reason to change status is to prevent the accidental use
         * of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status of
         * your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to
         * <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an
         * RDS Custom instance, snapshot, or automated backup.
         * </p>
         * 
         * @param status
         *        The availability status to be assigned to the CEV. Valid values are as follows:</p>
         *        <dl>
         *        <dt>available</dt>
         *        <dd>
         *        <p>
         *        You can use this CEV to create a new RDS Custom DB instance.
         *        </p>
         *        </dd>
         *        <dt>inactive</dt>
         *        <dd>
         *        <p>
         *        You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or
         *        create new instances with this CEV.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        You can change any status to any status. A typical reason to change status is to prevent the
         *        accidental use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might
         *        change the status of your CEV from <code>available</code> to <code>inactive</code>, and from
         *        <code>inactive</code> back to <code>available</code>. To change the availability status of the CEV, it
         *        must not currently be in use by an RDS Custom instance, snapshot, or automated backup.
         * @see CustomEngineVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomEngineVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The availability status to be assigned to the CEV. Valid values are as follows:
         * </p>
         * <dl>
         * <dt>available</dt>
         * <dd>
         * <p>
         * You can use this CEV to create a new RDS Custom DB instance.
         * </p>
         * </dd>
         * <dt>inactive</dt>
         * <dd>
         * <p>
         * You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or create
         * new instances with this CEV.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * You can change any status to any status. A typical reason to change status is to prevent the accidental use
         * of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status of
         * your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to
         * <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an
         * RDS Custom instance, snapshot, or automated backup.
         * </p>
         * 
         * @param status
         *        The availability status to be assigned to the CEV. Valid values are as follows:</p>
         *        <dl>
         *        <dt>available</dt>
         *        <dd>
         *        <p>
         *        You can use this CEV to create a new RDS Custom DB instance.
         *        </p>
         *        </dd>
         *        <dt>inactive</dt>
         *        <dd>
         *        <p>
         *        You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or
         *        create new instances with this CEV.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        You can change any status to any status. A typical reason to change status is to prevent the
         *        accidental use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might
         *        change the status of your CEV from <code>available</code> to <code>inactive</code>, and from
         *        <code>inactive</code> back to <code>available</code>. To change the availability status of the CEV, it
         *        must not currently be in use by an RDS Custom instance, snapshot, or automated backup.
         * @see CustomEngineVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomEngineVersionStatus
         */
        Builder status(CustomEngineVersionStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String description;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCustomDbEngineVersionRequest model) {
            super(model);
            engine(model.engine);
            engineVersion(model.engineVersion);
            description(model.description);
            status(model.status);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomEngineVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCustomDbEngineVersionRequest build() {
            return new ModifyCustomDbEngineVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
