/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Integration;
import software.amazon.awssdk.services.rds.model.IntegrationListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIntegrationsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeIntegrationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeIntegrationsResponse.getter(DescribeIntegrationsResponse::marker)).setter(DescribeIntegrationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<Integration>> INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Integrations").getter(DescribeIntegrationsResponse.getter(DescribeIntegrationsResponse::integrations)).setter(DescribeIntegrationsResponse.setter(Builder::integrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Integrations").build(), ListTrait.builder().memberLocationName("Integration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Integration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Integration").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, INTEGRATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Marker", MARKER_FIELD);
            this.put("Integrations", INTEGRATIONS_FIELD);
        }
    });
    private final String marker;
    private final List<Integration> integrations;

    private DescribeIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.integrations = builder.integrations;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasIntegrations() {
        return this.integrations != null && !(this.integrations instanceof SdkAutoConstructList);
    }

    public final List<Integration> integrations() {
        return this.integrations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrations() ? this.integrations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIntegrationsResponse)) {
            return false;
        }
        DescribeIntegrationsResponse other = (DescribeIntegrationsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasIntegrations() == other.hasIntegrations() && Objects.equals(this.integrations(), other.integrations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIntegrationsResponse").add("Marker", (Object)this.marker()).add("Integrations", this.hasIntegrations() ? this.integrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Integrations": {
                return Optional.ofNullable(clazz.cast(this.integrations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIntegrationsResponse, T> g) {
        return obj -> g.apply((DescribeIntegrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Integration> integrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIntegrationsResponse model) {
            super(model);
            this.marker(model.marker);
            this.integrations(model.integrations);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<Integration.Builder> getIntegrations() {
            List<Integration.Builder> result = IntegrationListCopier.copyToBuilder(this.integrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrations(Collection<Integration.BuilderImpl> integrations) {
            this.integrations = IntegrationListCopier.copyFromBuilder(integrations);
        }

        @Override
        public final Builder integrations(Collection<Integration> integrations) {
            this.integrations = IntegrationListCopier.copy(integrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Integration ... integrations) {
            this.integrations(Arrays.asList(integrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Consumer<Integration.Builder> ... integrations) {
            this.integrations(Stream.of(integrations).map(c -> (Integration)((Integration.Builder)Integration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIntegrationsResponse build() {
            return new DescribeIntegrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIntegrationsResponse> {
        public Builder marker(String var1);

        public Builder integrations(Collection<Integration> var1);

        public Builder integrations(Integration ... var1);

        public Builder integrations(Consumer<Integration.Builder> ... var1);
    }
}

