/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.LimitlessDatabaseStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LimitlessDatabase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LimitlessDatabase> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LimitlessDatabase.getter(LimitlessDatabase::statusAsString)).setter(LimitlessDatabase.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Double> MIN_REQUIRED_ACU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinRequiredACU").getter(LimitlessDatabase.getter(LimitlessDatabase::minRequiredACU)).setter(LimitlessDatabase.setter(Builder::minRequiredACU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRequiredACU").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, MIN_REQUIRED_ACU_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("MinRequiredACU", MIN_REQUIRED_ACU_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Double minRequiredACU;

    private LimitlessDatabase(BuilderImpl builder) {
        this.status = builder.status;
        this.minRequiredACU = builder.minRequiredACU;
    }

    public final LimitlessDatabaseStatus status() {
        return LimitlessDatabaseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Double minRequiredACU() {
        return this.minRequiredACU;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minRequiredACU());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LimitlessDatabase)) {
            return false;
        }
        LimitlessDatabase other = (LimitlessDatabase)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.minRequiredACU(), other.minRequiredACU());
    }

    public final String toString() {
        return ToString.builder((String)"LimitlessDatabase").add("Status", (Object)this.statusAsString()).add("MinRequiredACU", (Object)this.minRequiredACU()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MinRequiredACU": {
                return Optional.ofNullable(clazz.cast(this.minRequiredACU()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LimitlessDatabase, T> g) {
        return obj -> g.apply((LimitlessDatabase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Double minRequiredACU;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitlessDatabase model) {
            this.status(model.status);
            this.minRequiredACU(model.minRequiredACU);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LimitlessDatabaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getMinRequiredACU() {
            return this.minRequiredACU;
        }

        public final void setMinRequiredACU(Double minRequiredACU) {
            this.minRequiredACU = minRequiredACU;
        }

        @Override
        public final Builder minRequiredACU(Double minRequiredACU) {
            this.minRequiredACU = minRequiredACU;
            return this;
        }

        public LimitlessDatabase build() {
            return new LimitlessDatabase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LimitlessDatabase> {
        public Builder status(String var1);

        public Builder status(LimitlessDatabaseStatus var1);

        public Builder minRequiredACU(Double var1);
    }
}

