/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionPoolConfigurationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionPoolConfigurationInfo> {
    private static final SdkField<Integer> MAX_CONNECTIONS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConnectionsPercent").getter(ConnectionPoolConfigurationInfo.getter(ConnectionPoolConfigurationInfo::maxConnectionsPercent)).setter(ConnectionPoolConfigurationInfo.setter(Builder::maxConnectionsPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConnectionsPercent").build()}).build();
    private static final SdkField<Integer> MAX_IDLE_CONNECTIONS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxIdleConnectionsPercent").getter(ConnectionPoolConfigurationInfo.getter(ConnectionPoolConfigurationInfo::maxIdleConnectionsPercent)).setter(ConnectionPoolConfigurationInfo.setter(Builder::maxIdleConnectionsPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIdleConnectionsPercent").build()}).build();
    private static final SdkField<Integer> CONNECTION_BORROW_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionBorrowTimeout").getter(ConnectionPoolConfigurationInfo.getter(ConnectionPoolConfigurationInfo::connectionBorrowTimeout)).setter(ConnectionPoolConfigurationInfo.setter(Builder::connectionBorrowTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionBorrowTimeout").build()}).build();
    private static final SdkField<List<String>> SESSION_PINNING_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SessionPinningFilters").getter(ConnectionPoolConfigurationInfo.getter(ConnectionPoolConfigurationInfo::sessionPinningFilters)).setter(ConnectionPoolConfigurationInfo.setter(Builder::sessionPinningFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionPinningFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INIT_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitQuery").getter(ConnectionPoolConfigurationInfo.getter(ConnectionPoolConfigurationInfo::initQuery)).setter(ConnectionPoolConfigurationInfo.setter(Builder::initQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CONNECTIONS_PERCENT_FIELD, MAX_IDLE_CONNECTIONS_PERCENT_FIELD, CONNECTION_BORROW_TIMEOUT_FIELD, SESSION_PINNING_FILTERS_FIELD, INIT_QUERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MaxConnectionsPercent", MAX_CONNECTIONS_PERCENT_FIELD);
            this.put("MaxIdleConnectionsPercent", MAX_IDLE_CONNECTIONS_PERCENT_FIELD);
            this.put("ConnectionBorrowTimeout", CONNECTION_BORROW_TIMEOUT_FIELD);
            this.put("SessionPinningFilters", SESSION_PINNING_FILTERS_FIELD);
            this.put("InitQuery", INIT_QUERY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer maxConnectionsPercent;
    private final Integer maxIdleConnectionsPercent;
    private final Integer connectionBorrowTimeout;
    private final List<String> sessionPinningFilters;
    private final String initQuery;

    private ConnectionPoolConfigurationInfo(BuilderImpl builder) {
        this.maxConnectionsPercent = builder.maxConnectionsPercent;
        this.maxIdleConnectionsPercent = builder.maxIdleConnectionsPercent;
        this.connectionBorrowTimeout = builder.connectionBorrowTimeout;
        this.sessionPinningFilters = builder.sessionPinningFilters;
        this.initQuery = builder.initQuery;
    }

    public final Integer maxConnectionsPercent() {
        return this.maxConnectionsPercent;
    }

    public final Integer maxIdleConnectionsPercent() {
        return this.maxIdleConnectionsPercent;
    }

    public final Integer connectionBorrowTimeout() {
        return this.connectionBorrowTimeout;
    }

    public final boolean hasSessionPinningFilters() {
        return this.sessionPinningFilters != null && !(this.sessionPinningFilters instanceof SdkAutoConstructList);
    }

    public final List<String> sessionPinningFilters() {
        return this.sessionPinningFilters;
    }

    public final String initQuery() {
        return this.initQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConnectionsPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxIdleConnectionsPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionBorrowTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionPinningFilters() ? this.sessionPinningFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.initQuery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPoolConfigurationInfo)) {
            return false;
        }
        ConnectionPoolConfigurationInfo other = (ConnectionPoolConfigurationInfo)obj;
        return Objects.equals(this.maxConnectionsPercent(), other.maxConnectionsPercent()) && Objects.equals(this.maxIdleConnectionsPercent(), other.maxIdleConnectionsPercent()) && Objects.equals(this.connectionBorrowTimeout(), other.connectionBorrowTimeout()) && this.hasSessionPinningFilters() == other.hasSessionPinningFilters() && Objects.equals(this.sessionPinningFilters(), other.sessionPinningFilters()) && Objects.equals(this.initQuery(), other.initQuery());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionPoolConfigurationInfo").add("MaxConnectionsPercent", (Object)this.maxConnectionsPercent()).add("MaxIdleConnectionsPercent", (Object)this.maxIdleConnectionsPercent()).add("ConnectionBorrowTimeout", (Object)this.connectionBorrowTimeout()).add("SessionPinningFilters", this.hasSessionPinningFilters() ? this.sessionPinningFilters() : null).add("InitQuery", (Object)this.initQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxConnectionsPercent": {
                return Optional.ofNullable(clazz.cast(this.maxConnectionsPercent()));
            }
            case "MaxIdleConnectionsPercent": {
                return Optional.ofNullable(clazz.cast(this.maxIdleConnectionsPercent()));
            }
            case "ConnectionBorrowTimeout": {
                return Optional.ofNullable(clazz.cast(this.connectionBorrowTimeout()));
            }
            case "SessionPinningFilters": {
                return Optional.ofNullable(clazz.cast(this.sessionPinningFilters()));
            }
            case "InitQuery": {
                return Optional.ofNullable(clazz.cast(this.initQuery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPoolConfigurationInfo, T> g) {
        return obj -> g.apply((ConnectionPoolConfigurationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxConnectionsPercent;
        private Integer maxIdleConnectionsPercent;
        private Integer connectionBorrowTimeout;
        private List<String> sessionPinningFilters = DefaultSdkAutoConstructList.getInstance();
        private String initQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPoolConfigurationInfo model) {
            this.maxConnectionsPercent(model.maxConnectionsPercent);
            this.maxIdleConnectionsPercent(model.maxIdleConnectionsPercent);
            this.connectionBorrowTimeout(model.connectionBorrowTimeout);
            this.sessionPinningFilters(model.sessionPinningFilters);
            this.initQuery(model.initQuery);
        }

        public final Integer getMaxConnectionsPercent() {
            return this.maxConnectionsPercent;
        }

        public final void setMaxConnectionsPercent(Integer maxConnectionsPercent) {
            this.maxConnectionsPercent = maxConnectionsPercent;
        }

        @Override
        public final Builder maxConnectionsPercent(Integer maxConnectionsPercent) {
            this.maxConnectionsPercent = maxConnectionsPercent;
            return this;
        }

        public final Integer getMaxIdleConnectionsPercent() {
            return this.maxIdleConnectionsPercent;
        }

        public final void setMaxIdleConnectionsPercent(Integer maxIdleConnectionsPercent) {
            this.maxIdleConnectionsPercent = maxIdleConnectionsPercent;
        }

        @Override
        public final Builder maxIdleConnectionsPercent(Integer maxIdleConnectionsPercent) {
            this.maxIdleConnectionsPercent = maxIdleConnectionsPercent;
            return this;
        }

        public final Integer getConnectionBorrowTimeout() {
            return this.connectionBorrowTimeout;
        }

        public final void setConnectionBorrowTimeout(Integer connectionBorrowTimeout) {
            this.connectionBorrowTimeout = connectionBorrowTimeout;
        }

        @Override
        public final Builder connectionBorrowTimeout(Integer connectionBorrowTimeout) {
            this.connectionBorrowTimeout = connectionBorrowTimeout;
            return this;
        }

        public final Collection<String> getSessionPinningFilters() {
            if (this.sessionPinningFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sessionPinningFilters;
        }

        public final void setSessionPinningFilters(Collection<String> sessionPinningFilters) {
            this.sessionPinningFilters = StringListCopier.copy(sessionPinningFilters);
        }

        @Override
        public final Builder sessionPinningFilters(Collection<String> sessionPinningFilters) {
            this.sessionPinningFilters = StringListCopier.copy(sessionPinningFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionPinningFilters(String ... sessionPinningFilters) {
            this.sessionPinningFilters(Arrays.asList(sessionPinningFilters));
            return this;
        }

        public final String getInitQuery() {
            return this.initQuery;
        }

        public final void setInitQuery(String initQuery) {
            this.initQuery = initQuery;
        }

        @Override
        public final Builder initQuery(String initQuery) {
            this.initQuery = initQuery;
            return this;
        }

        public ConnectionPoolConfigurationInfo build() {
            return new ConnectionPoolConfigurationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionPoolConfigurationInfo> {
        public Builder maxConnectionsPercent(Integer var1);

        public Builder maxIdleConnectionsPercent(Integer var1);

        public Builder connectionBorrowTimeout(Integer var1);

        public Builder sessionPinningFilters(Collection<String> var1);

        public Builder sessionPinningFilters(String ... var1);

        public Builder initQuery(String var1);
    }
}

