/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClusterAutomatedBackupsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbClusterAutomatedBackupsResponse.Builder, DescribeDbClusterAutomatedBackupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbClusterAutomatedBackupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBClusterAutomatedBackup>> DB_CLUSTER_AUTOMATED_BACKUPS_FIELD = SdkField
            .<List<DBClusterAutomatedBackup>> builder(MarshallingType.LIST)
            .memberName("DBClusterAutomatedBackups")
            .getter(getter(DescribeDbClusterAutomatedBackupsResponse::dbClusterAutomatedBackups))
            .setter(setter(Builder::dbClusterAutomatedBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterAutomatedBackups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterAutomatedBackup")
                            .memberFieldInfo(
                                    SdkField.<DBClusterAutomatedBackup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterAutomatedBackup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterAutomatedBackup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_CLUSTER_AUTOMATED_BACKUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<DBClusterAutomatedBackup> dbClusterAutomatedBackups;

    private DescribeDbClusterAutomatedBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterAutomatedBackups = builder.dbClusterAutomatedBackups;
    }

    /**
     * <p>
     * The pagination token provided in the previous request. If this parameter is specified the response includes only
     * records beyond the marker, up to <code>MaxRecords</code>.
     * </p>
     * 
     * @return The pagination token provided in the previous request. If this parameter is specified the response
     *         includes only records beyond the marker, up to <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBClusterAutomatedBackups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDbClusterAutomatedBackups() {
        return dbClusterAutomatedBackups != null && !(dbClusterAutomatedBackups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DBClusterAutomatedBackup</code> backups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterAutomatedBackups} method.
     * </p>
     * 
     * @return A list of <code>DBClusterAutomatedBackup</code> backups.
     */
    public final List<DBClusterAutomatedBackup> dbClusterAutomatedBackups() {
        return dbClusterAutomatedBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterAutomatedBackups() ? dbClusterAutomatedBackups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterAutomatedBackupsResponse)) {
            return false;
        }
        DescribeDbClusterAutomatedBackupsResponse other = (DescribeDbClusterAutomatedBackupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasDbClusterAutomatedBackups() == other.hasDbClusterAutomatedBackups()
                && Objects.equals(dbClusterAutomatedBackups(), other.dbClusterAutomatedBackups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbClusterAutomatedBackupsResponse").add("Marker", marker())
                .add("DBClusterAutomatedBackups", hasDbClusterAutomatedBackups() ? dbClusterAutomatedBackups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBClusterAutomatedBackups":
            return Optional.ofNullable(clazz.cast(dbClusterAutomatedBackups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("DBClusterAutomatedBackups", DB_CLUSTER_AUTOMATED_BACKUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterAutomatedBackupsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterAutomatedBackupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbClusterAutomatedBackupsResponse> {
        /**
         * <p>
         * The pagination token provided in the previous request. If this parameter is specified the response includes
         * only records beyond the marker, up to <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        The pagination token provided in the previous request. If this parameter is specified the response
         *        includes only records beyond the marker, up to <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <code>DBClusterAutomatedBackup</code> backups.
         * </p>
         * 
         * @param dbClusterAutomatedBackups
         *        A list of <code>DBClusterAutomatedBackup</code> backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterAutomatedBackups(Collection<DBClusterAutomatedBackup> dbClusterAutomatedBackups);

        /**
         * <p>
         * A list of <code>DBClusterAutomatedBackup</code> backups.
         * </p>
         * 
         * @param dbClusterAutomatedBackups
         *        A list of <code>DBClusterAutomatedBackup</code> backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterAutomatedBackups(DBClusterAutomatedBackup... dbClusterAutomatedBackups);

        /**
         * <p>
         * A list of <code>DBClusterAutomatedBackup</code> backups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup.Builder#build()} is called
         * immediately and its result is passed to {@link #dbClusterAutomatedBackups(List<DBClusterAutomatedBackup>)}.
         * 
         * @param dbClusterAutomatedBackups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterAutomatedBackups(java.util.Collection<DBClusterAutomatedBackup>)
         */
        Builder dbClusterAutomatedBackups(Consumer<DBClusterAutomatedBackup.Builder>... dbClusterAutomatedBackups);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBClusterAutomatedBackup> dbClusterAutomatedBackups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterAutomatedBackupsResponse model) {
            super(model);
            marker(model.marker);
            dbClusterAutomatedBackups(model.dbClusterAutomatedBackups);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBClusterAutomatedBackup.Builder> getDbClusterAutomatedBackups() {
            List<DBClusterAutomatedBackup.Builder> result = DBClusterAutomatedBackupListCopier
                    .copyToBuilder(this.dbClusterAutomatedBackups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterAutomatedBackups(Collection<DBClusterAutomatedBackup.BuilderImpl> dbClusterAutomatedBackups) {
            this.dbClusterAutomatedBackups = DBClusterAutomatedBackupListCopier.copyFromBuilder(dbClusterAutomatedBackups);
        }

        @Override
        public final Builder dbClusterAutomatedBackups(Collection<DBClusterAutomatedBackup> dbClusterAutomatedBackups) {
            this.dbClusterAutomatedBackups = DBClusterAutomatedBackupListCopier.copy(dbClusterAutomatedBackups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterAutomatedBackups(DBClusterAutomatedBackup... dbClusterAutomatedBackups) {
            dbClusterAutomatedBackups(Arrays.asList(dbClusterAutomatedBackups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterAutomatedBackups(Consumer<DBClusterAutomatedBackup.Builder>... dbClusterAutomatedBackups) {
            dbClusterAutomatedBackups(Stream.of(dbClusterAutomatedBackups)
                    .map(c -> DBClusterAutomatedBackup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbClusterAutomatedBackupsResponse build() {
            return new DescribeDbClusterAutomatedBackupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
