/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyActivityStreamResponse extends RdsResponse implements
        ToCopyableBuilder<ModifyActivityStreamResponse.Builder, ModifyActivityStreamResponse> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ModifyActivityStreamResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> KINESIS_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KinesisStreamName").getter(getter(ModifyActivityStreamResponse::kinesisStreamName))
            .setter(setter(Builder::kinesisStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModifyActivityStreamResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(ModifyActivityStreamResponse::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<Boolean> ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EngineNativeAuditFieldsIncluded")
            .getter(getter(ModifyActivityStreamResponse::engineNativeAuditFieldsIncluded))
            .setter(setter(Builder::engineNativeAuditFieldsIncluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineNativeAuditFieldsIncluded")
                    .build()).build();

    private static final SdkField<String> POLICY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyStatus").getter(getter(ModifyActivityStreamResponse::policyStatusAsString))
            .setter(setter(Builder::policyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            KINESIS_STREAM_NAME_FIELD, STATUS_FIELD, MODE_FIELD, ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD, POLICY_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String kmsKeyId;

    private final String kinesisStreamName;

    private final String status;

    private final String mode;

    private final Boolean engineNativeAuditFieldsIncluded;

    private final String policyStatus;

    private ModifyActivityStreamResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
        this.kinesisStreamName = builder.kinesisStreamName;
        this.status = builder.status;
        this.mode = builder.mode;
        this.engineNativeAuditFieldsIncluded = builder.engineNativeAuditFieldsIncluded;
        this.policyStatus = builder.policyStatus;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the Amazon Kinesis data stream to be used for the database activity stream.
     * </p>
     * 
     * @return The name of the Amazon Kinesis data stream to be used for the database activity stream.
     */
    public final String kinesisStreamName() {
        return kinesisStreamName;
    }

    /**
     * <p>
     * The status of the modification to the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the modification to the database activity stream.
     * @see ActivityStreamStatus
     */
    public final ActivityStreamStatus status() {
        return ActivityStreamStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the modification to the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the modification to the database activity stream.
     * @see ActivityStreamStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The mode of the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ActivityStreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the database activity stream.
     * @see ActivityStreamMode
     */
    public final ActivityStreamMode mode() {
        return ActivityStreamMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ActivityStreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the database activity stream.
     * @see ActivityStreamMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * Indicates whether engine-native audit fields are included in the database activity stream.
     * </p>
     * 
     * @return Indicates whether engine-native audit fields are included in the database activity stream.
     */
    public final Boolean engineNativeAuditFieldsIncluded() {
        return engineNativeAuditFieldsIncluded;
    }

    /**
     * <p>
     * The status of the modification to the policy state of the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyStatus} will
     * return {@link ActivityStreamPolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #policyStatusAsString}.
     * </p>
     * 
     * @return The status of the modification to the policy state of the database activity stream.
     * @see ActivityStreamPolicyStatus
     */
    public final ActivityStreamPolicyStatus policyStatus() {
        return ActivityStreamPolicyStatus.fromValue(policyStatus);
    }

    /**
     * <p>
     * The status of the modification to the policy state of the database activity stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyStatus} will
     * return {@link ActivityStreamPolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #policyStatusAsString}.
     * </p>
     * 
     * @return The status of the modification to the policy state of the database activity stream.
     * @see ActivityStreamPolicyStatus
     */
    public final String policyStatusAsString() {
        return policyStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineNativeAuditFieldsIncluded());
        hashCode = 31 * hashCode + Objects.hashCode(policyStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyActivityStreamResponse)) {
            return false;
        }
        ModifyActivityStreamResponse other = (ModifyActivityStreamResponse) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(kinesisStreamName(), other.kinesisStreamName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(engineNativeAuditFieldsIncluded(), other.engineNativeAuditFieldsIncluded())
                && Objects.equals(policyStatusAsString(), other.policyStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyActivityStreamResponse").add("KmsKeyId", kmsKeyId())
                .add("KinesisStreamName", kinesisStreamName()).add("Status", statusAsString()).add("Mode", modeAsString())
                .add("EngineNativeAuditFieldsIncluded", engineNativeAuditFieldsIncluded())
                .add("PolicyStatus", policyStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "KinesisStreamName":
            return Optional.ofNullable(clazz.cast(kinesisStreamName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "EngineNativeAuditFieldsIncluded":
            return Optional.ofNullable(clazz.cast(engineNativeAuditFieldsIncluded()));
        case "PolicyStatus":
            return Optional.ofNullable(clazz.cast(policyStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("KinesisStreamName", KINESIS_STREAM_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("EngineNativeAuditFieldsIncluded", ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD);
        map.put("PolicyStatus", POLICY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyActivityStreamResponse, T> g) {
        return obj -> g.apply((ModifyActivityStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyActivityStreamResponse> {
        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the Amazon Kinesis data stream to be used for the database activity stream.
         * </p>
         * 
         * @param kinesisStreamName
         *        The name of the Amazon Kinesis data stream to be used for the database activity stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamName(String kinesisStreamName);

        /**
         * <p>
         * The status of the modification to the database activity stream.
         * </p>
         * 
         * @param status
         *        The status of the modification to the database activity stream.
         * @see ActivityStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the modification to the database activity stream.
         * </p>
         * 
         * @param status
         *        The status of the modification to the database activity stream.
         * @see ActivityStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamStatus
         */
        Builder status(ActivityStreamStatus status);

        /**
         * <p>
         * The mode of the database activity stream.
         * </p>
         * 
         * @param mode
         *        The mode of the database activity stream.
         * @see ActivityStreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the database activity stream.
         * </p>
         * 
         * @param mode
         *        The mode of the database activity stream.
         * @see ActivityStreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamMode
         */
        Builder mode(ActivityStreamMode mode);

        /**
         * <p>
         * Indicates whether engine-native audit fields are included in the database activity stream.
         * </p>
         * 
         * @param engineNativeAuditFieldsIncluded
         *        Indicates whether engine-native audit fields are included in the database activity stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded);

        /**
         * <p>
         * The status of the modification to the policy state of the database activity stream.
         * </p>
         * 
         * @param policyStatus
         *        The status of the modification to the policy state of the database activity stream.
         * @see ActivityStreamPolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamPolicyStatus
         */
        Builder policyStatus(String policyStatus);

        /**
         * <p>
         * The status of the modification to the policy state of the database activity stream.
         * </p>
         * 
         * @param policyStatus
         *        The status of the modification to the policy state of the database activity stream.
         * @see ActivityStreamPolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamPolicyStatus
         */
        Builder policyStatus(ActivityStreamPolicyStatus policyStatus);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String kmsKeyId;

        private String kinesisStreamName;

        private String status;

        private String mode;

        private Boolean engineNativeAuditFieldsIncluded;

        private String policyStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyActivityStreamResponse model) {
            super(model);
            kmsKeyId(model.kmsKeyId);
            kinesisStreamName(model.kinesisStreamName);
            status(model.status);
            mode(model.mode);
            engineNativeAuditFieldsIncluded(model.engineNativeAuditFieldsIncluded);
            policyStatus(model.policyStatus);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getKinesisStreamName() {
            return kinesisStreamName;
        }

        public final void setKinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
        }

        @Override
        public final Builder kinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActivityStreamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ActivityStreamMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getEngineNativeAuditFieldsIncluded() {
            return engineNativeAuditFieldsIncluded;
        }

        public final void setEngineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
        }

        @Override
        public final Builder engineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
            return this;
        }

        public final String getPolicyStatus() {
            return policyStatus;
        }

        public final void setPolicyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
        }

        @Override
        public final Builder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        @Override
        public final Builder policyStatus(ActivityStreamPolicyStatus policyStatus) {
            this.policyStatus(policyStatus == null ? null : policyStatus.toString());
            return this;
        }

        @Override
        public ModifyActivityStreamResponse build() {
            return new ModifyActivityStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
