/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbClusterFromSnapshotRequest extends RdsRequest implements
        ToCopyableBuilder<RestoreDbClusterFromSnapshotRequest.Builder, RestoreDbClusterFromSnapshotRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(RestoreDbClusterFromSnapshotRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(RestoreDbClusterFromSnapshotRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(RestoreDbClusterFromSnapshotRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(RestoreDbClusterFromSnapshotRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(RestoreDbClusterFromSnapshotRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(RestoreDbClusterFromSnapshotRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreDbClusterFromSnapshotRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BacktrackWindow").getter(getter(RestoreDbClusterFromSnapshotRequest::backtrackWindow))
            .setter(setter(Builder::backtrackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineMode").getter(getter(RestoreDbClusterFromSnapshotRequest::engineMode))
            .setter(setter(Builder::engineMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()).build();

    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScalingConfiguration")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::scalingConfiguration))
            .setter(setter(Builder::scalingConfiguration)).constructor(ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(RestoreDbClusterFromSnapshotRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(RestoreDbClusterFromSnapshotRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(RestoreDbClusterFromSnapshotRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<String> DB_CLUSTER_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterInstanceClass").getter(getter(RestoreDbClusterFromSnapshotRequest::dbClusterInstanceClass))
            .setter(setter(Builder::dbClusterInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterInstanceClass").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(RestoreDbClusterFromSnapshotRequest::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(RestoreDbClusterFromSnapshotRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField
            .<ServerlessV2ScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerlessV2ScalingConfiguration")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::serverlessV2ScalingConfiguration))
            .setter(setter(Builder::serverlessV2ScalingConfiguration))
            .constructor(ServerlessV2ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration")
                    .build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(RestoreDbClusterFromSnapshotRequest::networkType))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<RdsCustomClusterConfiguration> RDS_CUSTOM_CLUSTER_CONFIGURATION_FIELD = SdkField
            .<RdsCustomClusterConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RdsCustomClusterConfiguration")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::rdsCustomClusterConfiguration))
            .setter(setter(Builder::rdsCustomClusterConfiguration))
            .constructor(RdsCustomClusterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsCustomClusterConfiguration")
                    .build()).build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(RestoreDbClusterFromSnapshotRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(RestoreDbClusterFromSnapshotRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> ENGINE_LIFECYCLE_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineLifecycleSupport").getter(getter(RestoreDbClusterFromSnapshotRequest::engineLifecycleSupport))
            .setter(setter(Builder::engineLifecycleSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineLifecycleSupport").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            DB_CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD,
            DB_SUBNET_GROUP_NAME_FIELD, DATABASE_NAME_FIELD, OPTION_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD,
            KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD,
            ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, ENGINE_MODE_FIELD, SCALING_CONFIGURATION_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, DELETION_PROTECTION_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, DOMAIN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD, DB_CLUSTER_INSTANCE_CLASS_FIELD, STORAGE_TYPE_FIELD, IOPS_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, NETWORK_TYPE_FIELD,
            RDS_CUSTOM_CLUSTER_CONFIGURATION_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD,
            ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD,
            PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENGINE_LIFECYCLE_SUPPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> availabilityZones;

    private final String dbClusterIdentifier;

    private final String snapshotIdentifier;

    private final String engine;

    private final String engineVersion;

    private final Integer port;

    private final String dbSubnetGroupName;

    private final String databaseName;

    private final String optionGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Long backtrackWindow;

    private final List<String> enableCloudwatchLogsExports;

    private final String engineMode;

    private final ScalingConfiguration scalingConfiguration;

    private final String dbClusterParameterGroupName;

    private final Boolean deletionProtection;

    private final Boolean copyTagsToSnapshot;

    private final String domain;

    private final String domainIAMRoleName;

    private final String dbClusterInstanceClass;

    private final String storageType;

    private final Integer iops;

    private final Boolean publiclyAccessible;

    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

    private final String networkType;

    private final RdsCustomClusterConfiguration rdsCustomClusterConfiguration;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final String engineLifecycleSupport;

    private RestoreDbClusterFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.databaseName = builder.databaseName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.engineMode = builder.engineMode;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.deletionProtection = builder.deletionProtection;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
        this.storageType = builder.storageType;
        this.iops = builder.iops;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.networkType = builder.networkType;
        this.rdsCustomClusterConfiguration = builder.rdsCustomClusterConfiguration;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.engineLifecycleSupport = builder.engineLifecycleSupport;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be
     *         created.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
     * case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-snapshot-id</code>
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
     *         case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-snapshot-id</code>
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * </p>
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can
     * use only the ARN to specify a DB snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing Snapshot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
     *         <p>
     *         You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However,
     *         you can use only the ARN to specify a DB snapshot.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing Snapshot.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The database engine to use for the new DB cluster.
     * </p>
     * <p>
     * Default: The same as source
     * </p>
     * <p>
     * Constraint: Must be compatible with the engine of the source
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The database engine to use for the new DB cluster.</p>
     *         <p>
     *         Default: The same as source
     *         </p>
     *         <p>
     *         Constraint: Must be compatible with the engine of the source
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the database engine to use for the new DB cluster. If you don't specify an engine version, the
     * default version for the database engine in the Amazon Web Services Region is used.
     * </p>
     * <p>
     * To list all of the available engine versions for Aurora MySQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * <b>Aurora MySQL</b>
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database
     * engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * <b>Aurora PostgreSQL</b>
     * </p>
     * <p>
     * See <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon
     * Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * See <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">Amazon
     * RDS for MySQL</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * See <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS
     * for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The version of the database engine to use for the new DB cluster. If you don't specify an engine version,
     *         the default version for the database engine in the Amazon Web Services Region is used.</p>
     *         <p>
     *         To list all of the available engine versions for Aurora MySQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for RDS for MySQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         <b>Aurora MySQL</b>
     *         </p>
     *         <p>
     *         See <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database
     *         engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         <b>Aurora PostgreSQL</b>
     *         </p>
     *         <p>
     *         See <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html"
     *         >Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         See <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
     *         >Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         See <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
     *         >Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The port number on which the new DB cluster accepts connections.
     * </p>
     * <p>
     * Constraints: This value must be <code>1150-65535</code>
     * </p>
     * <p>
     * Default: The same port as the original DB cluster.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The port number on which the new DB cluster accepts connections.</p>
     *         <p>
     *         Constraints: This value must be <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default: The same port as the original DB cluster.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the DB subnet group to use for the new DB cluster.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DB subnet group.
     * </p>
     * <p>
     * Example: <code>mydbsubnetgroup</code>
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The name of the DB subnet group to use for the new DB cluster.</p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DB subnet group.
     *         </p>
     *         <p>
     *         Example: <code>mydbsubnetgroup</code>
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The database name for the restored DB cluster.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The database name for the restored DB cluster.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the option group to use for the restored DB cluster.
     * </p>
     * <p>
     * DB clusters are associated with a default option group that can't be modified.
     * </p>
     * 
     * @return The name of the option group to use for the restored DB cluster.</p>
     *         <p>
     *         DB clusters are associated with a default option group that can't be modified.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the new DB cluster will belong to.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security groups that the new DB cluster will belong to.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the restored DB cluster.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be assigned to the restored DB cluster.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB
     * cluster snapshot.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * When you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB
     * cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> isn't encrypted, then the restored
     * DB cluster isn't encrypted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB
     *         snapshot or DB cluster snapshot.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         When you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the
     *         restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster
     *         snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> isn't encrypted, then the
     *         restored DB cluster isn't encrypted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
     * database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM database
     * authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts
     *         to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
     *         Database Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM database
     *         authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * </p>
     * <note>
     * <p>
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     * </p>
     * </note>
     * <p>
     * Default: 0
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note>
     *         <p>
     *         Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     *         </p>
     *         </note>
     *         <p>
     *         Default: 0
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final Long backtrackWindow() {
        return backtrackWindow;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list
     * depend on the DB engine being used.
     * </p>
     * <p>
     * <b>RDS for MySQL</b>
     * </p>
     * <p>
     * Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     * </p>
     * <p>
     * <b>RDS for PostgreSQL</b>
     * </p>
     * <p>
     * Possible values are <code>postgresql</code> and <code>upgrade</code>.
     * </p>
     * <p>
     * <b>Aurora MySQL</b>
     * </p>
     * <p>
     * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     * </p>
     * <p>
     * <b>Aurora PostgreSQL</b>
     * </p>
     * <p>
     * Possible value is <code>postgresql</code>.
     * </p>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the
     *         list depend on the DB engine being used.</p>
     *         <p>
     *         <b>RDS for MySQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     *         </p>
     *         <p>
     *         <b>RDS for PostgreSQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>postgresql</code> and <code>upgrade</code>.
     *         </p>
     *         <p>
     *         <b>Aurora MySQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
     *         <code>slowquery</code>.
     *         </p>
     *         <p>
     *         <b>Aurora PostgreSQL</b>
     *         </p>
     *         <p>
     *         Possible value is <code>postgresql</code>.
     *         </p>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html">
     *         CreateDBCluster</a>.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final String engineMode() {
        return engineMode;
    }

    /**
     * <p>
     * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final ScalingConfiguration scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the
     * default DB cluster parameter group for the specified engine is used.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing default DB cluster parameter group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be 1 to 255 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The name of the DB cluster parameter group to associate with this DB cluster. If this argument is
     *         omitted, the default DB cluster parameter group for the specified engine is used.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing default DB cluster parameter group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * <p>
     * Specifies whether to enable deletion protection for the DB cluster. The database can't be deleted when deletion
     * protection is enabled. By default, deletion protection isn't enabled.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to enable deletion protection for the DB cluster. The database can't be deleted when
     *         deletion protection is enabled. By default, deletion protection isn't enabled.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The
     * default is not to copy them.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster.
     *         The default is not to copy them.</p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this
     * operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an
     * Active Directory Domain.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     * Authentication</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this
     *         operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be
     *         created in an Active Directory Domain.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     *         Authentication</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return The name of the IAM role to be used when making API calls to the Directory Service.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge.
     * Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     * </p>
     * <p>
     * For the full list of DB instance classes, and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a>
     * in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example
     *         db.m6gd.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all
     *         database engines.</p>
     *         <p>
     *         For the full list of DB instance classes, and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
     *         Class</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for: Multi-AZ DB clusters only
     */
    public final String dbClusterInstanceClass() {
        return dbClusterInstanceClass;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB cluster.
     * </p>
     * <p>
     * When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
     * </p>
     * <p>
     * Valid Values: <code>aurora</code>, <code>aurora-iopt1</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB
     * clusters)
     * </p>
     * <p>
     * Default: <code>aurora</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies the storage type to be associated with the DB cluster.</p>
     *         <p>
     *         When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
     *         </p>
     *         <p>
     *         Valid Values: <code>aurora</code>, <code>aurora-iopt1</code> (Aurora DB clusters); <code>io1</code>
     *         (Multi-AZ DB clusters)
     *         </p>
     *         <p>
     *         Default: <code>aurora</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     * instance in the Multi-AZ DB cluster.
     * </p>
     * <p>
     * For information about valid IOPS values, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned
     * IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     *         instance in the Multi-AZ DB cluster.</p>
     *         <p>
     *         For information about valid IOPS values, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
     *         Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Specifies whether the DB cluster is publicly accessible.
     * </p>
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses.
     * That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
     * </p>
     * <p>
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * </p>
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether the DB cluster is publicly accessible.</p>
     *         <p>
     *         When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private
     *         IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address
     *         from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security
     *         group it uses. That public access is not permitted if the security group assigned to the DB cluster
     *         doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves
     *         to a private IP address.
     *         </p>
     *         <p>
     *         Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     *         </p>
     *         <p>
     *         If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified,
     *         the following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster
     *         is private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     *         following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is
     *         private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * Returns the value of the ServerlessV2ScalingConfiguration property for this object.
     * 
     * @return The value of the ServerlessV2ScalingConfiguration property for this object.
     */
    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return serverlessV2ScalingConfiguration;
    }

    /**
     * <p>
     * The network type of the DB cluster.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DUAL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
     * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     * <code>DUAL</code>).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
     * Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return The network type of the DB cluster.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DUAL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
     *         <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     *         <code>DUAL</code>).
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"
     *         > Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final RdsCustomClusterConfiguration rdsCustomClusterConfiguration() {
        return rdsCustomClusterConfiguration;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To
     * turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than
     * <code>0</code>.
     * </p>
     * <p>
     * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other
     *         than <code>0</code>.
     *         </p>
     *         <p>
     *         Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon
     * CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>.
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to
     *         Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
     *         <code>MonitoringRoleArn</code> value.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * Specifies whether to turn on Performance Insights for the DB cluster.
     * </p>
     * 
     * @return Specifies whether to turn on Performance Insights for the DB cluster.
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS
     * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default KMS key for each Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
     *         Services account has a different default KMS key for each Amazon Web Services Region.
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The number of days to retain Performance Insights data.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31),
     * <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>731</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>7</code> days
     * </p>
     * <p>
     * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
     * </p>
     * 
     * @return The number of days to retain Performance Insights data.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
     *         months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>731</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>7</code> days
     *         </p>
     *         <p>
     *         If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * <p>
     * The life cycle type for this DB cluster.
     * </p>
     * <note>
     * <p>
     * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB cluster
     * into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by
     * setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically
     * upgrades your restored DB cluster to a higher engine version, if the major engine version is past its end of
     * standard support date.
     * </p>
     * </note>
     * <p>
     * You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support,
     * you can run the selected major engine version on your DB cluster past the end of standard support for that engine
     * version. For more information, see the following sections:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Aurora - <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS
     * Extended Support</a> in the <i>Amazon Aurora User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon
     * RDS Extended Support</a> in the <i>Amazon RDS User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     * </p>
     * <p>
     * Default: <code>open-source-rds-extended-support</code>
     * </p>
     * 
     * @return The life cycle type for this DB cluster.</p> <note>
     *         <p>
     *         By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
     *         cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
     *         Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this
     *         case, RDS automatically upgrades your restored DB cluster to a higher engine version, if the major engine
     *         version is past its end of standard support date.
     *         </p>
     *         </note>
     *         <p>
     *         You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended
     *         Support, you can run the selected major engine version on your DB cluster past the end of standard
     *         support for that engine version. For more information, see the following sections:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Aurora - <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon
     *         RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using
     *         Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     *         </p>
     *         <p>
     *         Default: <code>open-source-rds-extended-support</code>
     */
    public final String engineLifecycleSupport() {
        return engineLifecycleSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(rdsCustomClusterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(engineLifecycleSupport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreDbClusterFromSnapshotRequest other = (RestoreDbClusterFromSnapshotRequest) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(port(), other.port())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(backtrackWindow(), other.backtrackWindow())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(engineMode(), other.engineMode())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(domain(), other.domain())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(dbClusterInstanceClass(), other.dbClusterInstanceClass())
                && Objects.equals(storageType(), other.storageType()) && Objects.equals(iops(), other.iops())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration())
                && Objects.equals(networkType(), other.networkType())
                && Objects.equals(rdsCustomClusterConfiguration(), other.rdsCustomClusterConfiguration())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && Objects.equals(engineLifecycleSupport(), other.engineLifecycleSupport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreDbClusterFromSnapshotRequest")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("SnapshotIdentifier", snapshotIdentifier())
                .add("Engine", engine()).add("EngineVersion", engineVersion()).add("Port", port())
                .add("DBSubnetGroupName", dbSubnetGroupName()).add("DatabaseName", databaseName())
                .add("OptionGroupName", optionGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("KmsKeyId", kmsKeyId())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("BacktrackWindow", backtrackWindow())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("EngineMode", engineMode()).add("ScalingConfiguration", scalingConfiguration())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("DeletionProtection", deletionProtection()).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("Domain", domain()).add("DomainIAMRoleName", domainIAMRoleName())
                .add("DBClusterInstanceClass", dbClusterInstanceClass()).add("StorageType", storageType()).add("Iops", iops())
                .add("PubliclyAccessible", publiclyAccessible())
                .add("ServerlessV2ScalingConfiguration", serverlessV2ScalingConfiguration()).add("NetworkType", networkType())
                .add("RdsCustomClusterConfiguration", rdsCustomClusterConfiguration())
                .add("MonitoringInterval", monitoringInterval()).add("MonitoringRoleArn", monitoringRoleArn())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("EngineLifecycleSupport", engineLifecycleSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "BacktrackWindow":
            return Optional.ofNullable(clazz.cast(backtrackWindow()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "EngineMode":
            return Optional.ofNullable(clazz.cast(engineMode()));
        case "ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "DBClusterInstanceClass":
            return Optional.ofNullable(clazz.cast(dbClusterInstanceClass()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "ServerlessV2ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(serverlessV2ScalingConfiguration()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "RdsCustomClusterConfiguration":
            return Optional.ofNullable(clazz.cast(rdsCustomClusterConfiguration()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "EngineLifecycleSupport":
            return Optional.ofNullable(clazz.cast(engineLifecycleSupport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("SnapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("EnableIAMDatabaseAuthentication", ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("BacktrackWindow", BACKTRACK_WINDOW_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("EngineMode", ENGINE_MODE_FIELD);
        map.put("ScalingConfiguration", SCALING_CONFIGURATION_FIELD);
        map.put("DBClusterParameterGroupName", DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("CopyTagsToSnapshot", COPY_TAGS_TO_SNAPSHOT_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainIAMRoleName", DOMAIN_IAM_ROLE_NAME_FIELD);
        map.put("DBClusterInstanceClass", DB_CLUSTER_INSTANCE_CLASS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("ServerlessV2ScalingConfiguration", SERVERLESS_V2_SCALING_CONFIGURATION_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("RdsCustomClusterConfiguration", RDS_CUSTOM_CLUSTER_CONFIGURATION_FIELD);
        map.put("MonitoringInterval", MONITORING_INTERVAL_FIELD);
        map.put("MonitoringRoleArn", MONITORING_ROLE_ARN_FIELD);
        map.put("EnablePerformanceInsights", ENABLE_PERFORMANCE_INSIGHTS_FIELD);
        map.put("PerformanceInsightsKMSKeyId", PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD);
        map.put("PerformanceInsightsRetentionPeriod", PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD);
        map.put("EngineLifecycleSupport", ENGINE_LIFECYCLE_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreDbClusterFromSnapshotRequest> {
        /**
         * <p>
         * Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be
         *        created.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be
         *        created.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
         * case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-snapshot-id</code>
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
         *        case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-snapshot-id</code>
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The identifier for the DB snapshot or DB cluster snapshot to restore from.
         * </p>
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you
         * can use only the ARN to specify a DB snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing Snapshot.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
         *        <p>
         *        You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot.
         *        However, you can use only the ARN to specify a DB snapshot.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing Snapshot.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The database engine to use for the new DB cluster.
         * </p>
         * <p>
         * Default: The same as source
         * </p>
         * <p>
         * Constraint: Must be compatible with the engine of the source
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param engine
         *        The database engine to use for the new DB cluster.</p>
         *        <p>
         *        Default: The same as source
         *        </p>
         *        <p>
         *        Constraint: Must be compatible with the engine of the source
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the database engine to use for the new DB cluster. If you don't specify an engine version, the
         * default version for the database engine in the Amazon Web Services Region is used.
         * </p>
         * <p>
         * To list all of the available engine versions for Aurora MySQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * <b>Aurora MySQL</b>
         * </p>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database
         * engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * <b>Aurora PostgreSQL</b>
         * </p>
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html"
         * >Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         * >Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon
         * RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine to use for the new DB cluster. If you don't specify an engine
         *        version, the default version for the database engine in the Amazon Web Services Region is used.</p>
         *        <p>
         *        To list all of the available engine versions for Aurora MySQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for RDS for MySQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        <b>Aurora MySQL</b>
         *        </p>
         *        <p>
         *        See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">
         *        Database engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        <b>Aurora PostgreSQL</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html"
         *        >Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         *        >Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
         *        >Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The port number on which the new DB cluster accepts connections.
         * </p>
         * <p>
         * Constraints: This value must be <code>1150-65535</code>
         * </p>
         * <p>
         * Default: The same port as the original DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param port
         *        The port number on which the new DB cluster accepts connections.</p>
         *        <p>
         *        Constraints: This value must be <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default: The same port as the original DB cluster.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the DB subnet group to use for the new DB cluster.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DB subnet group.
         * </p>
         * <p>
         * Example: <code>mydbsubnetgroup</code>
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The name of the DB subnet group to use for the new DB cluster.</p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DB subnet group.
         *        </p>
         *        <p>
         *        Example: <code>mydbsubnetgroup</code>
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The database name for the restored DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param databaseName
         *        The database name for the restored DB cluster.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the option group to use for the restored DB cluster.
         * </p>
         * <p>
         * DB clusters are associated with a default option group that can't be modified.
         * </p>
         * 
         * @param optionGroupName
         *        The name of the option group to use for the restored DB cluster.</p>
         *        <p>
         *        DB clusters are associated with a default option group that can't be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster will belong to.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster will belong to.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster will belong to.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster will belong to.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The tags to be assigned to the restored DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored DB cluster.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the restored DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored DB cluster.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the restored DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot
         * or DB cluster snapshot.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * When you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored
         * DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> isn't encrypted, then the
         * restored DB cluster isn't encrypted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB
         *        snapshot or DB cluster snapshot.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        When you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the
         *        restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB
         *        cluster snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> isn't encrypted, then the
         *        restored DB cluster isn't encrypted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM database
         * authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         *        accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        database authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         * </p>
         * <note>
         * <p>
         * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         * </p>
         * </note>
         * <p>
         * Default: 0
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param backtrackWindow
         *        The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note>
         *        <p>
         *        Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         *        </p>
         *        </note>
         *        <p>
         *        Default: 0
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackWindow(Long backtrackWindow);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list
         * depend on the DB engine being used.
         * </p>
         * <p>
         * <b>RDS for MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>RDS for PostgreSQL</b>
         * </p>
         * <p>
         * Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * </p>
         * <p>
         * <b>Aurora MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Aurora PostgreSQL</b>
         * </p>
         * <p>
         * Possible value is <code>postgresql</code>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in
         *        the list depend on the DB engine being used.</p>
         *        <p>
         *        <b>RDS for MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>RDS for PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>postgresql</code> and <code>upgrade</code>.
         *        </p>
         *        <p>
         *        <b>Aurora MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Aurora PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible value is <code>postgresql</code>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list
         * depend on the DB engine being used.
         * </p>
         * <p>
         * <b>RDS for MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>RDS for PostgreSQL</b>
         * </p>
         * <p>
         * Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * </p>
         * <p>
         * <b>Aurora MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Aurora PostgreSQL</b>
         * </p>
         * <p>
         * Possible value is <code>postgresql</code>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in
         *        the list depend on the DB engine being used.</p>
         *        <p>
         *        <b>RDS for MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>RDS for PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>postgresql</code> and <code>upgrade</code>.
         *        </p>
         *        <p>
         *        <b>Aurora MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Aurora PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible value is <code>postgresql</code>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html">
         * CreateDBCluster</a>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param engineMode
         *        The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html">
         *        CreateDBCluster</a>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineMode(String engineMode);

        /**
         * <p>
         * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param scalingConfiguration
         *        For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB
         *        cluster.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfiguration scalingConfiguration);

        /**
         * <p>
         * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfiguration(ScalingConfiguration)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfiguration)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfiguration.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted,
         * the default DB cluster parameter group for the specified engine is used.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing default DB cluster parameter group.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be 1 to 255 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to associate with this DB cluster. If this argument is
         *        omitted, the default DB cluster parameter group for the specified engine is used.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing default DB cluster parameter group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * Specifies whether to enable deletion protection for the DB cluster. The database can't be deleted when
         * deletion protection is enabled. By default, deletion protection isn't enabled.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether to enable deletion protection for the DB cluster. The database can't be deleted when
         *        deletion protection is enabled. By default, deletion protection isn't enabled.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The
         * default is not to copy them.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB
         *        cluster. The default is not to copy them.</p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this
         * operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in
         * an Active Directory Domain.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         * Authentication</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param domain
         *        The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to
         *        this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can
         *        be created in an Active Directory Domain.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         *        Authentication</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the IAM role to be used when making API calls to the Directory Service.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param domainIAMRoleName
         *        The name of the IAM role to be used when making API calls to the Directory Service.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example
         * db.m6gd.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all
         * database engines.
         * </p>
         * <p>
         * For the full list of DB instance classes, and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
         * Class</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * </p>
         * 
         * @param dbClusterInstanceClass
         *        The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example
         *        db.m6gd.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for
         *        all database engines.</p>
         *        <p>
         *        For the full list of DB instance classes, and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        Instance Class</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterInstanceClass(String dbClusterInstanceClass);

        /**
         * <p>
         * Specifies the storage type to be associated with the DB cluster.
         * </p>
         * <p>
         * When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
         * </p>
         * <p>
         * Valid Values: <code>aurora</code>, <code>aurora-iopt1</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ
         * DB clusters)
         * </p>
         * <p>
         * Default: <code>aurora</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type to be associated with the DB cluster.</p>
         *        <p>
         *        When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
         *        </p>
         *        <p>
         *        Valid Values: <code>aurora</code>, <code>aurora-iopt1</code> (Aurora DB clusters); <code>io1</code>
         *        (Multi-AZ DB clusters)
         *        </p>
         *        <p>
         *        Default: <code>aurora</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
         * instance in the Multi-AZ DB cluster.
         * </p>
         * <p>
         * For information about valid IOPS values, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         * Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each
         *        DB instance in the Multi-AZ DB cluster.</p>
         *        <p>
         *        For information about valid IOPS values, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         *        Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Specifies whether the DB cluster is publicly accessible.
         * </p>
         * <p>
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
         * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
         * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it
         * uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
         * </p>
         * <p>
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to
         * a private IP address.
         * </p>
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * </p>
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies whether the DB cluster is publicly accessible.</p>
         *        <p>
         *        When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public
         *        IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by
         *        the security group it uses. That public access is not permitted if the security group assigned to the
         *        DB cluster doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *        </p>
         *        <p>
         *        If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't
         *        specified, the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB
         *        cluster is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified,
         *        the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster
         *        is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * @param serverlessV2ScalingConfiguration
         *        The new value for the ServerlessV2ScalingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServerlessV2ScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServerlessV2ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessV2ScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)}.
         * 
         * @param serverlessV2ScalingConfiguration
         *        a consumer that will call methods on {@link ServerlessV2ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)
         */
        default Builder serverlessV2ScalingConfiguration(
                Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.builder()
                    .applyMutation(serverlessV2ScalingConfiguration).build());
        }

        /**
         * <p>
         * The network type of the DB cluster.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DUAL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
         * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         * <code>DUAL</code>).
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         * Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param networkType
         *        The network type of the DB cluster.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DUAL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
         *        <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         *        <code>DUAL</code>).
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"
         *        > Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param rdsCustomClusterConfiguration
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsCustomClusterConfiguration(RdsCustomClusterConfiguration rdsCustomClusterConfiguration);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsCustomClusterConfiguration.Builder}
         * avoiding the need to create one manually via {@link RdsCustomClusterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsCustomClusterConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rdsCustomClusterConfiguration(RdsCustomClusterConfiguration)}.
         * 
         * @param rdsCustomClusterConfiguration
         *        a consumer that will call methods on {@link RdsCustomClusterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsCustomClusterConfiguration(RdsCustomClusterConfiguration)
         */
        default Builder rdsCustomClusterConfiguration(
                Consumer<RdsCustomClusterConfiguration.Builder> rdsCustomClusterConfiguration) {
            return rdsCustomClusterConfiguration(RdsCustomClusterConfiguration.builder()
                    .applyMutation(rdsCustomClusterConfiguration).build());
        }

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
         * To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other
         * than <code>0</code>.
         * </p>
         * <p>
         * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value
         *        other than <code>0</code>.
         *        </p>
         *        <p>
         *        Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to
         * Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>.
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics
         *        to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
         *        <code>MonitoringRoleArn</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * Specifies whether to turn on Performance Insights for the DB cluster.
         * </p>
         * 
         * @param enablePerformanceInsights
         *        Specifies whether to turn on Performance Insights for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The number of days to retain Performance Insights data.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months *
         * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>731</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>7</code> days
         * </p>
         * <p>
         * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The number of days to retain Performance Insights data.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
         *        months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>731</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>7</code> days
         *        </p>
         *        <p>
         *        If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * The life cycle type for this DB cluster.
         * </p>
         * <note>
         * <p>
         * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB cluster
         * into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support
         * by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS
         * automatically upgrades your restored DB cluster to a higher engine version, if the major engine version is
         * past its end of standard support date.
         * </p>
         * </note>
         * <p>
         * You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended
         * Support, you can run the selected major engine version on your DB cluster past the end of standard support
         * for that engine version. For more information, see the following sections:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora - <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS
         * Extended Support</a> in the <i>Amazon Aurora User Guide</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using
         * Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         * </p>
         * <p>
         * Default: <code>open-source-rds-extended-support</code>
         * </p>
         * 
         * @param engineLifecycleSupport
         *        The life cycle type for this DB cluster.</p> <note>
         *        <p>
         *        By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
         *        cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
         *        Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In
         *        this case, RDS automatically upgrades your restored DB cluster to a higher engine version, if the
         *        major engine version is past its end of standard support date.
         *        </p>
         *        </note>
         *        <p>
         *        You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended
         *        Support, you can run the selected major engine version on your DB cluster past the end of standard
         *        support for that engine version. For more information, see the following sections:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora - <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon
         *        RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon RDS - <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS
         *        Extended Support</a> in the <i>Amazon RDS User Guide</i>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Valid Values:
         *        <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         *        </p>
         *        <p>
         *        Default: <code>open-source-rds-extended-support</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineLifecycleSupport(String engineLifecycleSupport);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterIdentifier;

        private String snapshotIdentifier;

        private String engine;

        private String engineVersion;

        private Integer port;

        private String dbSubnetGroupName;

        private String databaseName;

        private String optionGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private Boolean enableIAMDatabaseAuthentication;

        private Long backtrackWindow;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private String engineMode;

        private ScalingConfiguration scalingConfiguration;

        private String dbClusterParameterGroupName;

        private Boolean deletionProtection;

        private Boolean copyTagsToSnapshot;

        private String domain;

        private String domainIAMRoleName;

        private String dbClusterInstanceClass;

        private String storageType;

        private Integer iops;

        private Boolean publiclyAccessible;

        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

        private String networkType;

        private RdsCustomClusterConfiguration rdsCustomClusterConfiguration;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private String engineLifecycleSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterFromSnapshotRequest model) {
            super(model);
            availabilityZones(model.availabilityZones);
            dbClusterIdentifier(model.dbClusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            engine(model.engine);
            engineVersion(model.engineVersion);
            port(model.port);
            dbSubnetGroupName(model.dbSubnetGroupName);
            databaseName(model.databaseName);
            optionGroupName(model.optionGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            backtrackWindow(model.backtrackWindow);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            engineMode(model.engineMode);
            scalingConfiguration(model.scalingConfiguration);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            deletionProtection(model.deletionProtection);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            domain(model.domain);
            domainIAMRoleName(model.domainIAMRoleName);
            dbClusterInstanceClass(model.dbClusterInstanceClass);
            storageType(model.storageType);
            iops(model.iops);
            publiclyAccessible(model.publiclyAccessible);
            serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            networkType(model.networkType);
            rdsCustomClusterConfiguration(model.rdsCustomClusterConfiguration);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            engineLifecycleSupport(model.engineLifecycleSupport);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Long getBacktrackWindow() {
            return backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final String getEngineMode() {
            return engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final String getDbClusterInstanceClass() {
            return dbClusterInstanceClass;
        }

        public final void setDbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
        }

        @Override
        public final Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(
                ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final RdsCustomClusterConfiguration.Builder getRdsCustomClusterConfiguration() {
            return rdsCustomClusterConfiguration != null ? rdsCustomClusterConfiguration.toBuilder() : null;
        }

        public final void setRdsCustomClusterConfiguration(RdsCustomClusterConfiguration.BuilderImpl rdsCustomClusterConfiguration) {
            this.rdsCustomClusterConfiguration = rdsCustomClusterConfiguration != null ? rdsCustomClusterConfiguration.build()
                    : null;
        }

        @Override
        public final Builder rdsCustomClusterConfiguration(RdsCustomClusterConfiguration rdsCustomClusterConfiguration) {
            this.rdsCustomClusterConfiguration = rdsCustomClusterConfiguration;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final String getEngineLifecycleSupport() {
            return engineLifecycleSupport;
        }

        public final void setEngineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
        }

        @Override
        public final Builder engineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterFromSnapshotRequest build() {
            return new RestoreDbClusterFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
