/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter input for DescribeDBInstanceAutomatedBackups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbInstanceAutomatedBackupsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeDbInstanceAutomatedBackupsRequest.Builder, DescribeDbInstanceAutomatedBackupsRequest> {
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(DescribeDbInstanceAutomatedBackupsRequest::dbiResourceId))
            .setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DescribeDbInstanceAutomatedBackupsRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeDbInstanceAutomatedBackupsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDbInstanceAutomatedBackupsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbInstanceAutomatedBackupsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceAutomatedBackupsArn")
            .getter(getter(DescribeDbInstanceAutomatedBackupsRequest::dbInstanceAutomatedBackupsArn))
            .setter(setter(Builder::dbInstanceAutomatedBackupsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackupsArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DBI_RESOURCE_ID_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD,
                    DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD));

    private final String dbiResourceId;

    private final String dbInstanceIdentifier;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private final String dbInstanceAutomatedBackupsArn;

    private DescribeDbInstanceAutomatedBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.dbiResourceId = builder.dbiResourceId;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.dbInstanceAutomatedBackupsArn = builder.dbInstanceAutomatedBackupsArn;
    }

    /**
     * <p>
     * The resource ID of the DB instance that is the source of the automated backup. This parameter isn't
     * case-sensitive.
     * </p>
     * 
     * @return The resource ID of the DB instance that is the source of the automated backup. This parameter isn't
     *         case-sensitive.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * (Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of
     * an existing DB instance. It returns information from the specific DB instance's automated backup. This parameter
     * isn't case-sensitive.
     * </p>
     * 
     * @return (Optional) The user-supplied instance identifier. If this parameter is specified, it must match the
     *         identifier of an existing DB instance. It returns information from the specific DB instance's automated
     *         backup. This parameter isn't case-sensitive.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter that specifies which resources to return based on status.
     * </p>
     * <p>
     * Supported filters are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - Automated backups for current instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>retained</code> - Automated backups for deleted instances and after backup replication is stopped.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results list
     * includes only information about the DB instance automated backups identified by these ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list
     * includes only information about the DB instance resources identified by these ARNs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Returns all resources by default. The status for each resource is specified in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A filter that specifies which resources to return based on status.</p>
     *         <p>
     *         Supported filters are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - Automated backups for current instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>retained</code> - Automated backups for deleted instances and after backup replication is stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The
     *         results list includes only information about the DB instance automated backups identified by these ARNs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The
     *         results list includes only information about the DB instance resources identified by these ARNs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Returns all resources by default. The status for each resource is specified in the response.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
     * retrieve the remaining results.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you
     *         can retrieve the remaining results.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The pagination token provided in the previous request. If this parameter is specified the response includes only
     * records beyond the marker, up to <code>MaxRecords</code>.
     * </p>
     * 
     * @return The pagination token provided in the previous request. If this parameter is specified the response
     *         includes only records beyond the marker, up to <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicated automated backups, for example,
     * <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicated automated backups, for example,
     *         <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final String dbInstanceAutomatedBackupsArn() {
        return dbInstanceAutomatedBackupsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceAutomatedBackupsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbInstanceAutomatedBackupsRequest)) {
            return false;
        }
        DescribeDbInstanceAutomatedBackupsRequest other = (DescribeDbInstanceAutomatedBackupsRequest) obj;
        return Objects.equals(dbiResourceId(), other.dbiResourceId())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker())
                && Objects.equals(dbInstanceAutomatedBackupsArn(), other.dbInstanceAutomatedBackupsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbInstanceAutomatedBackupsRequest").add("DbiResourceId", dbiResourceId())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxRecords", maxRecords()).add("Marker", marker())
                .add("DBInstanceAutomatedBackupsArn", dbInstanceAutomatedBackupsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBInstanceAutomatedBackupsArn":
            return Optional.ofNullable(clazz.cast(dbInstanceAutomatedBackupsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbInstanceAutomatedBackupsRequest, T> g) {
        return obj -> g.apply((DescribeDbInstanceAutomatedBackupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbInstanceAutomatedBackupsRequest> {
        /**
         * <p>
         * The resource ID of the DB instance that is the source of the automated backup. This parameter isn't
         * case-sensitive.
         * </p>
         * 
         * @param dbiResourceId
         *        The resource ID of the DB instance that is the source of the automated backup. This parameter isn't
         *        case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * (Optional) The user-supplied instance identifier. If this parameter is specified, it must match the
         * identifier of an existing DB instance. It returns information from the specific DB instance's automated
         * backup. This parameter isn't case-sensitive.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        (Optional) The user-supplied instance identifier. If this parameter is specified, it must match the
         *        identifier of an existing DB instance. It returns information from the specific DB instance's
         *        automated backup. This parameter isn't case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * A filter that specifies which resources to return based on status.
         * </p>
         * <p>
         * Supported filters are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - Automated backups for current instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retained</code> - Automated backups for deleted instances and after backup replication is stopped.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB instance automated backups identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB instance resources identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Returns all resources by default. The status for each resource is specified in the response.
         * </p>
         * 
         * @param filters
         *        A filter that specifies which resources to return based on status.</p>
         *        <p>
         *        Supported filters are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - Automated backups for current instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>retained</code> - Automated backups for deleted instances and after backup replication is
         *        stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The
         *        results list includes only information about the DB instance automated backups identified by these
         *        ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The
         *        results list includes only information about the DB instance resources identified by these ARNs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Returns all resources by default. The status for each resource is specified in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * A filter that specifies which resources to return based on status.
         * </p>
         * <p>
         * Supported filters are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - Automated backups for current instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retained</code> - Automated backups for deleted instances and after backup replication is stopped.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB instance automated backups identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB instance resources identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Returns all resources by default. The status for each resource is specified in the response.
         * </p>
         * 
         * @param filters
         *        A filter that specifies which resources to return based on status.</p>
         *        <p>
         *        Supported filters are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - Automated backups for current instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>retained</code> - Automated backups for deleted instances and after backup replication is
         *        stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The
         *        results list includes only information about the DB instance automated backups identified by these
         *        ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The
         *        results list includes only information about the DB instance resources identified by these ARNs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Returns all resources by default. The status for each resource is specified in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A filter that specifies which resources to return based on status.
         * </p>
         * <p>
         * Supported filters are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - Automated backups for current instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retained</code> - Automated backups for deleted instances and after backup replication is stopped.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB instance automated backups identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB instance resources identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Returns all resources by default. The status for each resource is specified in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
         * retrieve the remaining results.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
         *        you can retrieve the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The pagination token provided in the previous request. If this parameter is specified the response includes
         * only records beyond the marker, up to <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        The pagination token provided in the previous request. If this parameter is specified the response
         *        includes only records beyond the marker, up to <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicated automated backups, for example,
         * <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param dbInstanceAutomatedBackupsArn
         *        The Amazon Resource Name (ARN) of the replicated automated backups, for example,
         *        <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbiResourceId;

        private String dbInstanceIdentifier;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private String dbInstanceAutomatedBackupsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbInstanceAutomatedBackupsRequest model) {
            super(model);
            dbiResourceId(model.dbiResourceId);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
            dbInstanceAutomatedBackupsArn(model.dbInstanceAutomatedBackupsArn);
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getDbInstanceAutomatedBackupsArn() {
            return dbInstanceAutomatedBackupsArn;
        }

        public final void setDbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn) {
            this.dbInstanceAutomatedBackupsArn = dbInstanceAutomatedBackupsArn;
        }

        @Override
        public final Builder dbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn) {
            this.dbInstanceAutomatedBackupsArn = dbInstanceAutomatedBackupsArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbInstanceAutomatedBackupsRequest build() {
            return new DescribeDbInstanceAutomatedBackupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
