/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCurrentDbClusterCapacityRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyCurrentDbClusterCapacityRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(ModifyCurrentDbClusterCapacityRequest.getter(ModifyCurrentDbClusterCapacityRequest::dbClusterIdentifier)).setter(ModifyCurrentDbClusterCapacityRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Capacity").getter(ModifyCurrentDbClusterCapacityRequest.getter(ModifyCurrentDbClusterCapacityRequest::capacity)).setter(ModifyCurrentDbClusterCapacityRequest.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<Integer> SECONDS_BEFORE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondsBeforeTimeout").getter(ModifyCurrentDbClusterCapacityRequest.getter(ModifyCurrentDbClusterCapacityRequest::secondsBeforeTimeout)).setter(ModifyCurrentDbClusterCapacityRequest.setter(Builder::secondsBeforeTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsBeforeTimeout").build()}).build();
    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeoutAction").getter(ModifyCurrentDbClusterCapacityRequest.getter(ModifyCurrentDbClusterCapacityRequest::timeoutAction)).setter(ModifyCurrentDbClusterCapacityRequest.setter(Builder::timeoutAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, CAPACITY_FIELD, SECONDS_BEFORE_TIMEOUT_FIELD, TIMEOUT_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyCurrentDbClusterCapacityRequest.memberNameToFieldInitializer();
    private final String dbClusterIdentifier;
    private final Integer capacity;
    private final Integer secondsBeforeTimeout;
    private final String timeoutAction;

    private ModifyCurrentDbClusterCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.capacity = builder.capacity;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
        this.timeoutAction = builder.timeoutAction;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final Integer capacity() {
        return this.capacity;
    }

    public final Integer secondsBeforeTimeout() {
        return this.secondsBeforeTimeout;
    }

    public final String timeoutAction() {
        return this.timeoutAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsBeforeTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCurrentDbClusterCapacityRequest)) {
            return false;
        }
        ModifyCurrentDbClusterCapacityRequest other = (ModifyCurrentDbClusterCapacityRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.secondsBeforeTimeout(), other.secondsBeforeTimeout()) && Objects.equals(this.timeoutAction(), other.timeoutAction());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCurrentDbClusterCapacityRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("Capacity", (Object)this.capacity()).add("SecondsBeforeTimeout", (Object)this.secondsBeforeTimeout()).add("TimeoutAction", (Object)this.timeoutAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "SecondsBeforeTimeout": {
                return Optional.ofNullable(clazz.cast(this.secondsBeforeTimeout()));
            }
            case "TimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.timeoutAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("SecondsBeforeTimeout", SECONDS_BEFORE_TIMEOUT_FIELD);
        map.put("TimeoutAction", TIMEOUT_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCurrentDbClusterCapacityRequest, T> g) {
        return obj -> g.apply((ModifyCurrentDbClusterCapacityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Integer capacity;
        private Integer secondsBeforeTimeout;
        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCurrentDbClusterCapacityRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.capacity(model.capacity);
            this.secondsBeforeTimeout(model.secondsBeforeTimeout);
            this.timeoutAction(model.timeoutAction);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final Integer getSecondsBeforeTimeout() {
            return this.secondsBeforeTimeout;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        @Override
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        public final String getTimeoutAction() {
            return this.timeoutAction;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCurrentDbClusterCapacityRequest build() {
            return new ModifyCurrentDbClusterCapacityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCurrentDbClusterCapacityRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder capacity(Integer var1);

        public Builder secondsBeforeTimeout(Integer var1);

        public Builder timeoutAction(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

