/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbClusterAutomatedBackupResponse extends RdsResponse implements
        ToCopyableBuilder<DeleteDbClusterAutomatedBackupResponse.Builder, DeleteDbClusterAutomatedBackupResponse> {
    private static final SdkField<DBClusterAutomatedBackup> DB_CLUSTER_AUTOMATED_BACKUP_FIELD = SdkField
            .<DBClusterAutomatedBackup> builder(MarshallingType.SDK_POJO).memberName("DBClusterAutomatedBackup")
            .getter(getter(DeleteDbClusterAutomatedBackupResponse::dbClusterAutomatedBackup))
            .setter(setter(Builder::dbClusterAutomatedBackup)).constructor(DBClusterAutomatedBackup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterAutomatedBackup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DB_CLUSTER_AUTOMATED_BACKUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DBClusterAutomatedBackup dbClusterAutomatedBackup;

    private DeleteDbClusterAutomatedBackupResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterAutomatedBackup = builder.dbClusterAutomatedBackup;
    }

    /**
     * Returns the value of the DBClusterAutomatedBackup property for this object.
     * 
     * @return The value of the DBClusterAutomatedBackup property for this object.
     */
    public final DBClusterAutomatedBackup dbClusterAutomatedBackup() {
        return dbClusterAutomatedBackup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterAutomatedBackup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbClusterAutomatedBackupResponse)) {
            return false;
        }
        DeleteDbClusterAutomatedBackupResponse other = (DeleteDbClusterAutomatedBackupResponse) obj;
        return Objects.equals(dbClusterAutomatedBackup(), other.dbClusterAutomatedBackup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDbClusterAutomatedBackupResponse")
                .add("DBClusterAutomatedBackup", dbClusterAutomatedBackup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterAutomatedBackup":
            return Optional.ofNullable(clazz.cast(dbClusterAutomatedBackup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBClusterAutomatedBackup", DB_CLUSTER_AUTOMATED_BACKUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbClusterAutomatedBackupResponse, T> g) {
        return obj -> g.apply((DeleteDbClusterAutomatedBackupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDbClusterAutomatedBackupResponse> {
        /**
         * Sets the value of the DBClusterAutomatedBackup property for this object.
         *
         * @param dbClusterAutomatedBackup
         *        The new value for the DBClusterAutomatedBackup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterAutomatedBackup(DBClusterAutomatedBackup dbClusterAutomatedBackup);

        /**
         * Sets the value of the DBClusterAutomatedBackup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DBClusterAutomatedBackup.Builder}
         * avoiding the need to create one manually via {@link DBClusterAutomatedBackup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DBClusterAutomatedBackup.Builder#build()} is called immediately
         * and its result is passed to {@link #dbClusterAutomatedBackup(DBClusterAutomatedBackup)}.
         * 
         * @param dbClusterAutomatedBackup
         *        a consumer that will call methods on {@link DBClusterAutomatedBackup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterAutomatedBackup(DBClusterAutomatedBackup)
         */
        default Builder dbClusterAutomatedBackup(Consumer<DBClusterAutomatedBackup.Builder> dbClusterAutomatedBackup) {
            return dbClusterAutomatedBackup(DBClusterAutomatedBackup.builder().applyMutation(dbClusterAutomatedBackup).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBClusterAutomatedBackup dbClusterAutomatedBackup;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbClusterAutomatedBackupResponse model) {
            super(model);
            dbClusterAutomatedBackup(model.dbClusterAutomatedBackup);
        }

        public final DBClusterAutomatedBackup.Builder getDbClusterAutomatedBackup() {
            return dbClusterAutomatedBackup != null ? dbClusterAutomatedBackup.toBuilder() : null;
        }

        public final void setDbClusterAutomatedBackup(DBClusterAutomatedBackup.BuilderImpl dbClusterAutomatedBackup) {
            this.dbClusterAutomatedBackup = dbClusterAutomatedBackup != null ? dbClusterAutomatedBackup.build() : null;
        }

        @Override
        public final Builder dbClusterAutomatedBackup(DBClusterAutomatedBackup dbClusterAutomatedBackup) {
            this.dbClusterAutomatedBackup = dbClusterAutomatedBackup;
            return this;
        }

        @Override
        public DeleteDbClusterAutomatedBackupResponse build() {
            return new DeleteDbClusterAutomatedBackupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
