/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbInstanceFromS3Request extends RdsRequest implements
        ToCopyableBuilder<RestoreDbInstanceFromS3Request.Builder, RestoreDbInstanceFromS3Request> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DBName")
            .getter(getter(RestoreDbInstanceFromS3Request::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(RestoreDbInstanceFromS3Request::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(RestoreDbInstanceFromS3Request::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(RestoreDbInstanceFromS3Request::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(RestoreDbInstanceFromS3Request::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(RestoreDbInstanceFromS3Request::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(RestoreDbInstanceFromS3Request::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroups")
            .getter(getter(RestoreDbInstanceFromS3Request::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreDbInstanceFromS3Request::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(RestoreDbInstanceFromS3Request::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(RestoreDbInstanceFromS3Request::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(RestoreDbInstanceFromS3Request::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(RestoreDbInstanceFromS3Request::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(RestoreDbInstanceFromS3Request::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(RestoreDbInstanceFromS3Request::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreDbInstanceFromS3Request::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(RestoreDbInstanceFromS3Request::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(RestoreDbInstanceFromS3Request::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(RestoreDbInstanceFromS3Request::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(RestoreDbInstanceFromS3Request::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(RestoreDbInstanceFromS3Request::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(RestoreDbInstanceFromS3Request::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(RestoreDbInstanceFromS3Request::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RestoreDbInstanceFromS3Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(RestoreDbInstanceFromS3Request::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(RestoreDbInstanceFromS3Request::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreDbInstanceFromS3Request::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(RestoreDbInstanceFromS3Request::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(RestoreDbInstanceFromS3Request::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(RestoreDbInstanceFromS3Request::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(RestoreDbInstanceFromS3Request::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<String> SOURCE_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEngine").getter(getter(RestoreDbInstanceFromS3Request::sourceEngine))
            .setter(setter(Builder::sourceEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngine").build()).build();

    private static final SdkField<String> SOURCE_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEngineVersion").getter(getter(RestoreDbInstanceFromS3Request::sourceEngineVersion))
            .setter(setter(Builder::sourceEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngineVersion").build())
            .build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(RestoreDbInstanceFromS3Request::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(RestoreDbInstanceFromS3Request::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_INGESTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3IngestionRoleArn").getter(getter(RestoreDbInstanceFromS3Request::s3IngestionRoleArn))
            .setter(setter(Builder::s3IngestionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3IngestionRoleArn").build())
            .build();

    private static final SdkField<String> DATABASE_INSIGHTS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInsightsMode").getter(getter(RestoreDbInstanceFromS3Request::databaseInsightsModeAsString))
            .setter(setter(Builder::databaseInsightsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInsightsMode").build())
            .build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(RestoreDbInstanceFromS3Request::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(RestoreDbInstanceFromS3Request::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(RestoreDbInstanceFromS3Request::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(RestoreDbInstanceFromS3Request::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<ProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(RestoreDbInstanceFromS3Request::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProcessorFeature")
                            .memberFieldInfo(
                                    SdkField.<ProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProcessorFeature").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseDefaultProcessorFeatures")
            .getter(getter(RestoreDbInstanceFromS3Request::useDefaultProcessorFeatures))
            .setter(setter(Builder::useDefaultProcessorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(RestoreDbInstanceFromS3Request::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllocatedStorage").getter(getter(RestoreDbInstanceFromS3Request::maxAllocatedStorage))
            .setter(setter(Builder::maxAllocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build())
            .build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(RestoreDbInstanceFromS3Request::networkType))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageThroughput").getter(getter(RestoreDbInstanceFromS3Request::storageThroughput))
            .setter(setter(Builder::storageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()).build();

    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword")
            .getter(getter(RestoreDbInstanceFromS3Request::manageMasterUserPassword))
            .setter(setter(Builder::manageMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build())
            .build();

    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserSecretKmsKeyId").getter(getter(RestoreDbInstanceFromS3Request::masterUserSecretKmsKeyId))
            .setter(setter(Builder::masterUserSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build())
            .build();

    private static final SdkField<Boolean> DEDICATED_LOG_VOLUME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedLogVolume").getter(getter(RestoreDbInstanceFromS3Request::dedicatedLogVolume))
            .setter(setter(Builder::dedicatedLogVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedLogVolume").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(RestoreDbInstanceFromS3Request::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> ENGINE_LIFECYCLE_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineLifecycleSupport").getter(getter(RestoreDbInstanceFromS3Request::engineLifecycleSupport))
            .setter(setter(Builder::engineLifecycleSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineLifecycleSupport").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD,
            DB_INSTANCE_IDENTIFIER_FIELD, ALLOCATED_STORAGE_FIELD, DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, MASTER_USERNAME_FIELD,
            MASTER_USER_PASSWORD_FIELD, DB_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, AVAILABILITY_ZONE_FIELD,
            DB_SUBNET_GROUP_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, DB_PARAMETER_GROUP_NAME_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PORT_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, STORAGE_TYPE_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD,
            COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD,
            ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, SOURCE_ENGINE_FIELD, SOURCE_ENGINE_VERSION_FIELD, S3_BUCKET_NAME_FIELD,
            S3_PREFIX_FIELD, S3_INGESTION_ROLE_ARN_FIELD, DATABASE_INSIGHTS_MODE_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD,
            PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD,
            ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD, USE_DEFAULT_PROCESSOR_FEATURES_FIELD,
            DELETION_PROTECTION_FIELD, MAX_ALLOCATED_STORAGE_FIELD, NETWORK_TYPE_FIELD, STORAGE_THROUGHPUT_FIELD,
            MANAGE_MASTER_USER_PASSWORD_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD, DEDICATED_LOG_VOLUME_FIELD,
            CA_CERTIFICATE_IDENTIFIER_FIELD, ENGINE_LIFECYCLE_SUPPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbName;

    private final String dbInstanceIdentifier;

    private final Integer allocatedStorage;

    private final String dbInstanceClass;

    private final String engine;

    private final String masterUsername;

    private final String masterUserPassword;

    private final List<String> dbSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final String availabilityZone;

    private final String dbSubnetGroupName;

    private final String preferredMaintenanceWindow;

    private final String dbParameterGroupName;

    private final Integer backupRetentionPeriod;

    private final String preferredBackupWindow;

    private final Integer port;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final String licenseModel;

    private final Integer iops;

    private final String optionGroupName;

    private final Boolean publiclyAccessible;

    private final List<Tag> tags;

    private final String storageType;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final Boolean enableIAMDatabaseAuthentication;

    private final String sourceEngine;

    private final String sourceEngineVersion;

    private final String s3BucketName;

    private final String s3Prefix;

    private final String s3IngestionRoleArn;

    private final String databaseInsightsMode;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final List<String> enableCloudwatchLogsExports;

    private final List<ProcessorFeature> processorFeatures;

    private final Boolean useDefaultProcessorFeatures;

    private final Boolean deletionProtection;

    private final Integer maxAllocatedStorage;

    private final String networkType;

    private final Integer storageThroughput;

    private final Boolean manageMasterUserPassword;

    private final String masterUserSecretKmsKeyId;

    private final Boolean dedicatedLogVolume;

    private final String caCertificateIdentifier;

    private final String engineLifecycleSupport;

    private RestoreDbInstanceFromS3Request(BuilderImpl builder) {
        super(builder);
        this.dbName = builder.dbName;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.storageType = builder.storageType;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.sourceEngine = builder.sourceEngine;
        this.sourceEngineVersion = builder.sourceEngineVersion;
        this.s3BucketName = builder.s3BucketName;
        this.s3Prefix = builder.s3Prefix;
        this.s3IngestionRoleArn = builder.s3IngestionRoleArn;
        this.databaseInsightsMode = builder.databaseInsightsMode;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.networkType = builder.networkType;
        this.storageThroughput = builder.storageThroughput;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.dedicatedLogVolume = builder.dedicatedLogVolume;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.engineLifecycleSupport = builder.engineLifecycleSupport;
    }

    /**
     * <p>
     * The name of the database to create when the DB instance is created. Follow the naming rules specified in
     * <code>CreateDBInstance</code>.
     * </p>
     * 
     * @return The name of the database to create when the DB instance is created. Follow the naming rules specified in
     *         <code>CreateDBInstance</code>.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The DB instance identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbinstance</code>
     * </p>
     * 
     * @return The DB instance identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbinstance</code>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation rules
     * specified in <code>CreateDBInstance</code>.
     * </p>
     * <p>
     * This setting isn't valid for RDS for SQL Server.
     * </p>
     * <note>
     * <p>
     * Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed. You can
     * also allocate additional storage for future growth.
     * </p>
     * </note>
     * 
     * @return The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation
     *         rules specified in <code>CreateDBInstance</code>.</p>
     *         <p>
     *         This setting isn't valid for RDS for SQL Server.
     *         </p>
     *         <note>
     *         <p>
     *         Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed.
     *         You can also allocate additional storage for future growth.
     *         </p>
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are
     * available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance
     * classes, and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a>
     * in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class.
     * </p>
     * 
     * @return The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes
     *         are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB
     *         instance classes, and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
     *         Class</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The name of the database engine to be used for this instance.
     * </p>
     * <p>
     * Valid Values: <code>mysql</code>
     * </p>
     * 
     * @return The name of the database engine to be used for this instance.</p>
     *         <p>
     *         Valid Values: <code>mysql</code>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The name for the master user.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 16 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the master user.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 16 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The password for the master user.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can include any printable ASCII character except "/",
     * """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes) character.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Length Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RDS for Db2 - Must contain from 8 to 128 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MariaDB - Must contain from 8 to 41 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - Must contain from 8 to 41 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Oracle - Must contain from 8 to 30 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - Must contain from 8 to 128 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The password for the master user.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can include any printable ASCII character except "/",
     *         """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes)
     *         character.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Length Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         RDS for Db2 - Must contain from 8 to 128 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MariaDB - Must contain from 8 to 41 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - Must contain from 8 to 41 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Oracle - Must contain from 8 to 30 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - Must contain from 8 to 128 characters.
     *         </p>
     *         </li>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBSecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB security groups to associate with this DB instance.
     * </p>
     * <p>
     * Default: The default DB security group for the database engine.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbSecurityGroups} method.
     * </p>
     * 
     * @return A list of DB security groups to associate with this DB instance.</p>
     *         <p>
     *         Default: The default DB security group for the database engine.
     */
    public final List<String> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups to associate with this DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security groups to associate with this DB instance.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions and
     * Availability Zones, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions
     * and Availability Zones</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     * </p>
     * <p>
     * Example: <code>us-east-1d</code>
     * </p>
     * <p>
     * Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ
     * deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current
     * endpoint.
     * </p>
     * 
     * @return The Availability Zone that the DB instance is created in. For information about Amazon Web Services
     *         Regions and Availability Zones, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
     *         >Regions and Availability Zones</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Example: <code>us-east-1d</code>
     *         </p>
     *         <p>
     *         Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a
     *         Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as
     *         the current endpoint.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A DB subnet group to associate with this DB instance.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * </p>
     * <p>
     * Example: <code>mydbsubnetgroup</code>
     * </p>
     * 
     * @return A DB subnet group to associate with this DB instance.</p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *         </p>
     *         <p>
     *         Example: <code>mydbsubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     * >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred backup window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     *         >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred backup window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The name of the DB parameter group to associate with this DB instance.
     * </p>
     * <p>
     * If you do not specify a value for <code>DBParameterGroupName</code>, then the default
     * <code>DBParameterGroup</code> for the specified DB engine is used.
     * </p>
     * 
     * @return The name of the DB parameter group to associate with this DB instance.</p>
     *         <p>
     *         If you do not specify a value for <code>DBParameterGroupName</code>, then the default
     *         <code>DBParameterGroup</code> for the specified DB engine is used.
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained. Setting this parameter to a positive number enables
     * backups. For more information, see <code>CreateDBInstance</code>.
     * </p>
     * 
     * @return The number of days for which automated backups are retained. Setting this parameter to a positive number
     *         enables backups. For more information, see <code>CreateDBInstance</code>.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The time range each day during which automated backups are created if automated backups are enabled. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     * >Backup window</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The time range each day during which automated backups are created if automated backups are enabled. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     *         >Backup window</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The port number on which the database accepts connections.
     * </p>
     * <p>
     * Type: Integer
     * </p>
     * <p>
     * Valid Values: <code>1150</code>-<code>65535</code>
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * 
     * @return The port number on which the database accepts connections.</p>
     *         <p>
     *         Type: Integer
     *         </p>
     *         <p>
     *         Valid Values: <code>1150</code>-<code>65535</code>
     *         </p>
     *         <p>
     *         Default: <code>3306</code>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you
     * can't set the <code>AvailabilityZone</code> parameter.
     * </p>
     * 
     * @return Specifies whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment,
     *         you can't set the <code>AvailabilityZone</code> parameter.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The version number of the database engine to use. Choose the latest minor version of your database engine. For
     * information about engine versions, see <code>CreateDBInstance</code>, or call
     * <code>DescribeDBEngineVersions</code>.
     * </p>
     * 
     * @return The version number of the database engine to use. Choose the latest minor version of your database
     *         engine. For information about engine versions, see <code>CreateDBInstance</code>, or call
     *         <code>DescribeDBEngineVersions</code>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Specifies whether to automatically apply minor engine upgrades to the DB instance during the maintenance window.
     * By default, minor engine upgrades are not applied automatically.
     * </p>
     * 
     * @return Specifies whether to automatically apply minor engine upgrades to the DB instance during the maintenance
     *         window. By default, minor engine upgrades are not applied automatically.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The license model for this DB instance. Use <code>general-public-license</code>.
     * </p>
     * 
     * @return The license model for this DB instance. Use <code>general-public-license</code>.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB instance.
     * For information about valid IOPS values, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned
     * IOPS storage</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB
     *         instance. For information about valid IOPS values, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
     *         Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The name of the option group to associate with this DB instance. If this argument is omitted, the default option
     * group for the specified engine is used.
     * </p>
     * 
     * @return The name of the option group to associate with this DB instance. If this argument is omitted, the default
     *         option group for the specified engine is used.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * Specifies whether the DB instance is publicly accessible.
     * </p>
     * <p>
     * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it
     * uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.
     * </p>
     * <p>
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * For more information, see <a>CreateDBInstance</a>.
     * </p>
     * 
     * @return Specifies whether the DB instance is publicly accessible.</p>
     *         <p>
     *         When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
     *         private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public
     *         IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by
     *         the security group it uses. That public access is not permitted if the security group assigned to the DB
     *         instance doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
     *         resolves to a private IP address.
     *         </p>
     *         <p>
     *         For more information, see <a>CreateDBInstance</a>.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to associate with this DB instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a>
     * in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to associate with this DB instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS
     *         Resources</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     * <p>
     * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
     * </p>
     * <p>
     * If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the
     * <code>Iops</code> parameter.
     * </p>
     * <p>
     * Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>gp2</code>
     * </p>
     * 
     * @return Specifies the storage type to be associated with the DB instance.</p>
     *         <p>
     *         Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
     *         </p>
     *         <p>
     *         If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for
     *         the <code>Iops</code> parameter.
     *         </p>
     *         <p>
     *         Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>gp2</code>
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * Specifies whether the new DB instance is encrypted or not.
     * </p>
     * 
     * @return Specifies whether the new DB instance is encrypted or not.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for an encrypted DB instance.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * If the <code>StorageEncrypted</code> parameter is enabled, and you do not specify a value for the
     * <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS key for
     * your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each
     * Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         If the <code>StorageEncrypted</code> parameter is enabled, and you do not specify a value for the
     *         <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS
     *         key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS
     *         key for each Amazon Web Services Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not
     * copied.
     * </p>
     * 
     * @return Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags
     *         are not copied.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To
     * disable collecting Enhanced Monitoring metrics, specify 0.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value
     * other than 0.
     * </p>
     * <p>
     * Valid Values: 0, 1, 5, 10, 15, 30, 60
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         instance. To disable collecting Enhanced Monitoring metrics, specify 0.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to
     *         a value other than 0.
     *         </p>
     *         <p>
     *         Valid Values: 0, 1, 5, 10, 15, 30, 60
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
     * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see
     * <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     * >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * 
     * @return The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     *         For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
     *         monitoring role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     *         >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     *         <code>MonitoringRoleArn</code> value.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
     * database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * For more information about IAM database authentication, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts
     *         to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         For more information about IAM database authentication, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     *         Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The name of the engine of your source database.
     * </p>
     * <p>
     * Valid Values: <code>mysql</code>
     * </p>
     * 
     * @return The name of the engine of your source database.</p>
     *         <p>
     *         Valid Values: <code>mysql</code>
     */
    public final String sourceEngine() {
        return sourceEngine;
    }

    /**
     * <p>
     * The version of the database that the backup files were created from.
     * </p>
     * <p>
     * MySQL versions 5.6 and 5.7 are supported.
     * </p>
     * <p>
     * Example: <code>5.6.40</code>
     * </p>
     * 
     * @return The version of the database that the backup files were created from.</p>
     *         <p>
     *         MySQL versions 5.6 and 5.7 are supported.
     *         </p>
     *         <p>
     *         Example: <code>5.6.40</code>
     */
    public final String sourceEngineVersion() {
        return sourceEngineVersion;
    }

    /**
     * <p>
     * The name of your Amazon S3 bucket that contains your database backup file.
     * </p>
     * 
     * @return The name of your Amazon S3 bucket that contains your database backup file.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The prefix of your Amazon S3 bucket.
     * </p>
     * 
     * @return The prefix of your Amazon S3 bucket.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * An Amazon Web Services Identity and Access Management (IAM) role with a trust policy and a permissions policy
     * that allows Amazon RDS to access your Amazon S3 bucket. For information about this role, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html#MySQL.Procedural.Importing.Enabling.IAM"
     * > Creating an IAM role manually</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return An Amazon Web Services Identity and Access Management (IAM) role with a trust policy and a permissions
     *         policy that allows Amazon RDS to access your Amazon S3 bucket. For information about this role, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html#MySQL.Procedural.Importing.Enabling.IAM"
     *         > Creating an IAM role manually</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String s3IngestionRoleArn() {
        return s3IngestionRoleArn;
    }

    /**
     * <p>
     * Specifies the mode of Database Insights to enable for the DB instance.
     * </p>
     * <note>
     * <p>
     * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of Database Insights to enable for the DB instance.</p> <note>
     *         <p>
     *         Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     *         </p>
     * @see DatabaseInsightsMode
     */
    public final DatabaseInsightsMode databaseInsightsMode() {
        return DatabaseInsightsMode.fromValue(databaseInsightsMode);
    }

    /**
     * <p>
     * Specifies the mode of Database Insights to enable for the DB instance.
     * </p>
     * <note>
     * <p>
     * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of Database Insights to enable for the DB instance.</p> <note>
     *         <p>
     *         Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     *         </p>
     * @see DatabaseInsightsMode
     */
    public final String databaseInsightsModeAsString() {
        return databaseInsightsMode;
    }

    /**
     * <p>
     * Specifies whether to enable Performance Insights for the DB instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
     * Insights</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable Performance Insights for the DB instance.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
     *         Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS
     * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default KMS key for each Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
     *         Services account has a different default KMS key for each Amazon Web Services Region.
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 7
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23
     * </p>
     * </li>
     * <li>
     * <p>
     * 731
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, the following values are valid:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 93 (3 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * 341 (11 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * 589 (19 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * 731
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
     * </p>
     * 
     * @return The number of days to retain Performance Insights data. The default is 7 days. The following values are
     *         valid:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         7
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>month</i> * 31, where <i>month</i> is a number of months from 1-23
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         731
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, the following values are valid:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         93 (3 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         341 (11 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         589 (19 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         731
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on
     * the DB engine being used. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list
     *         depend on the DB engine being used. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessorFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessorFeatures} method.
     * </p>
     * 
     * @return The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    public final List<ProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    /**
     * <p>
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     * </p>
     * 
     * @return Specifies whether the DB instance class of the DB instance uses its default processor features.
     */
    public final Boolean useDefaultProcessorFeatures() {
        return useDefaultProcessorFeatures;
    }

    /**
     * <p>
     * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when deletion
     * protection is enabled. By default, deletion protection isn't enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     * Instance</a>.
     * </p>
     * 
     * @return Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when
     *         deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     *         Instance</a>.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * </p>
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
     * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
     *         instance.</p>
     *         <p>
     *         For more information about this setting, including limitations that apply to it, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
     *         > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
     *         Guide</i>.
     */
    public final Integer maxAllocatedStorage() {
        return maxAllocatedStorage;
    }

    /**
     * <p>
     * The network type of the DB instance.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DUAL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
     * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     * <code>DUAL</code>).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working
     * with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The network type of the DB instance.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DUAL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
     *         <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     *         <code>DUAL</code>).
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
     *         Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * <p>
     * Specifies the storage throughput value for the DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom or Amazon Aurora.
     * </p>
     * 
     * @return Specifies the storage throughput value for the DB instance.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom or Amazon Aurora.
     */
    public final Integer storageThroughput() {
        return storageThroughput;
    }

    /**
     * <p>
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with
     * Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code>
     * is specified.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't manage the master user password with Amazon Web Services Secrets Manager if
     *         <code>MasterUserPassword</code> is specified.
     *         </p>
     *         </li>
     */
    public final Boolean manageMasterUserPassword() {
        return manageMasterUserPassword;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
     * Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager
     * for the DB instance.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is
     * used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the
     * <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.
     * </p>
     * <p>
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
     *         managed in Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
     *         Manager for the DB instance.
     *         </p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS
     *         key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you
     *         can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer
     *         managed KMS key.
     *         </p>
     *         <p>
     *         There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     *         different default KMS key for each Amazon Web Services Region.
     */
    public final String masterUserSecretKmsKeyId() {
        return masterUserSecretKmsKeyId;
    }

    /**
     * <p>
     * Specifies whether to enable a dedicated log volume (DLV) for the DB instance.
     * </p>
     * 
     * @return Specifies whether to enable a dedicated log volume (DLV) for the DB instance.
     */
    public final Boolean dedicatedLogVolume() {
        return dedicatedLogVolume;
    }

    /**
     * <p>
     * The CA certificate identifier to use for the DB instance's server certificate.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return The CA certificate identifier to use for the DB instance's server certificate.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
     *         encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS
     *         to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * The life cycle type for this DB instance.
     * </p>
     * <note>
     * <p>
     * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB instance
     * into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by
     * setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically
     * upgrades your restored DB instance to a higher engine version, if the major engine version is past its end of
     * standard support date.
     * </p>
     * </note>
     * <p>
     * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support,
     * you can run the selected major engine version on your DB instance past the end of standard support for that
     * engine version. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended
     * Support</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle
     * type is managed by the DB cluster.
     * </p>
     * <p>
     * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     * </p>
     * <p>
     * Default: <code>open-source-rds-extended-support</code>
     * </p>
     * 
     * @return The life cycle type for this DB instance.</p> <note>
     *         <p>
     *         By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
     *         instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
     *         Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this
     *         case, RDS automatically upgrades your restored DB instance to a higher engine version, if the major
     *         engine version is past its end of standard support date.
     *         </p>
     *         </note>
     *         <p>
     *         You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended
     *         Support, you can run the selected major engine version on your DB instance past the end of standard
     *         support for that engine version. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS
     *         Extended Support</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the
     *         life cycle type is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     *         </p>
     *         <p>
     *         Default: <code>open-source-rds-extended-support</code>
     */
    public final String engineLifecycleSupport() {
        return engineLifecycleSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEngine());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3IngestionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInsightsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(storageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(engineLifecycleSupport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbInstanceFromS3Request)) {
            return false;
        }
        RestoreDbInstanceFromS3Request other = (RestoreDbInstanceFromS3Request) obj;
        return Objects.equals(dbName(), other.dbName()) && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(engine(), other.engine())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(port(), other.port())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(storageType(), other.storageType())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(sourceEngine(), other.sourceEngine())
                && Objects.equals(sourceEngineVersion(), other.sourceEngineVersion())
                && Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(s3Prefix(), other.s3Prefix())
                && Objects.equals(s3IngestionRoleArn(), other.s3IngestionRoleArn())
                && Objects.equals(databaseInsightsModeAsString(), other.databaseInsightsModeAsString())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures())
                && Objects.equals(useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(maxAllocatedStorage(), other.maxAllocatedStorage())
                && Objects.equals(networkType(), other.networkType())
                && Objects.equals(storageThroughput(), other.storageThroughput())
                && Objects.equals(manageMasterUserPassword(), other.manageMasterUserPassword())
                && Objects.equals(masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId())
                && Objects.equals(dedicatedLogVolume(), other.dedicatedLogVolume())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(engineLifecycleSupport(), other.engineLifecycleSupport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreDbInstanceFromS3Request").add("DBName", dbName())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("AllocatedStorage", allocatedStorage())
                .add("DBInstanceClass", dbInstanceClass()).add("Engine", engine()).add("MasterUsername", masterUsername())
                .add("MasterUserPassword", masterUserPassword())
                .add("DBSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("AvailabilityZone", availabilityZone()).add("DBSubnetGroupName", dbSubnetGroupName())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("DBParameterGroupName", dbParameterGroupName()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("PreferredBackupWindow", preferredBackupWindow()).add("Port", port()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("LicenseModel", licenseModel()).add("Iops", iops()).add("OptionGroupName", optionGroupName())
                .add("PubliclyAccessible", publiclyAccessible()).add("Tags", hasTags() ? tags() : null)
                .add("StorageType", storageType()).add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId())
                .add("CopyTagsToSnapshot", copyTagsToSnapshot()).add("MonitoringInterval", monitoringInterval())
                .add("MonitoringRoleArn", monitoringRoleArn())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication()).add("SourceEngine", sourceEngine())
                .add("SourceEngineVersion", sourceEngineVersion()).add("S3BucketName", s3BucketName())
                .add("S3Prefix", s3Prefix()).add("S3IngestionRoleArn", s3IngestionRoleArn())
                .add("DatabaseInsightsMode", databaseInsightsModeAsString())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null)
                .add("UseDefaultProcessorFeatures", useDefaultProcessorFeatures())
                .add("DeletionProtection", deletionProtection()).add("MaxAllocatedStorage", maxAllocatedStorage())
                .add("NetworkType", networkType()).add("StorageThroughput", storageThroughput())
                .add("ManageMasterUserPassword", manageMasterUserPassword())
                .add("MasterUserSecretKmsKeyId", masterUserSecretKmsKeyId()).add("DedicatedLogVolume", dedicatedLogVolume())
                .add("CACertificateIdentifier", caCertificateIdentifier())
                .add("EngineLifecycleSupport", engineLifecycleSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "DBSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "SourceEngine":
            return Optional.ofNullable(clazz.cast(sourceEngine()));
        case "SourceEngineVersion":
            return Optional.ofNullable(clazz.cast(sourceEngineVersion()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3IngestionRoleArn":
            return Optional.ofNullable(clazz.cast(s3IngestionRoleArn()));
        case "DatabaseInsightsMode":
            return Optional.ofNullable(clazz.cast(databaseInsightsModeAsString()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        case "UseDefaultProcessorFeatures":
            return Optional.ofNullable(clazz.cast(useDefaultProcessorFeatures()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "MaxAllocatedStorage":
            return Optional.ofNullable(clazz.cast(maxAllocatedStorage()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "StorageThroughput":
            return Optional.ofNullable(clazz.cast(storageThroughput()));
        case "ManageMasterUserPassword":
            return Optional.ofNullable(clazz.cast(manageMasterUserPassword()));
        case "MasterUserSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterUserSecretKmsKeyId()));
        case "DedicatedLogVolume":
            return Optional.ofNullable(clazz.cast(dedicatedLogVolume()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "EngineLifecycleSupport":
            return Optional.ofNullable(clazz.cast(engineLifecycleSupport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBName", DB_NAME_FIELD);
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("MasterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("DBSecurityGroups", DB_SECURITY_GROUPS_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("DBParameterGroupName", DB_PARAMETER_GROUP_NAME_FIELD);
        map.put("BackupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("PreferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("LicenseModel", LICENSE_MODEL_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("CopyTagsToSnapshot", COPY_TAGS_TO_SNAPSHOT_FIELD);
        map.put("MonitoringInterval", MONITORING_INTERVAL_FIELD);
        map.put("MonitoringRoleArn", MONITORING_ROLE_ARN_FIELD);
        map.put("EnableIAMDatabaseAuthentication", ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("SourceEngine", SOURCE_ENGINE_FIELD);
        map.put("SourceEngineVersion", SOURCE_ENGINE_VERSION_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("S3IngestionRoleArn", S3_INGESTION_ROLE_ARN_FIELD);
        map.put("DatabaseInsightsMode", DATABASE_INSIGHTS_MODE_FIELD);
        map.put("EnablePerformanceInsights", ENABLE_PERFORMANCE_INSIGHTS_FIELD);
        map.put("PerformanceInsightsKMSKeyId", PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD);
        map.put("PerformanceInsightsRetentionPeriod", PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("ProcessorFeatures", PROCESSOR_FEATURES_FIELD);
        map.put("UseDefaultProcessorFeatures", USE_DEFAULT_PROCESSOR_FEATURES_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("MaxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        map.put("ManageMasterUserPassword", MANAGE_MASTER_USER_PASSWORD_FIELD);
        map.put("MasterUserSecretKmsKeyId", MASTER_USER_SECRET_KMS_KEY_ID_FIELD);
        map.put("DedicatedLogVolume", DEDICATED_LOG_VOLUME_FIELD);
        map.put("CACertificateIdentifier", CA_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("EngineLifecycleSupport", ENGINE_LIFECYCLE_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbInstanceFromS3Request, T> g) {
        return obj -> g.apply((RestoreDbInstanceFromS3Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreDbInstanceFromS3Request> {
        /**
         * <p>
         * The name of the database to create when the DB instance is created. Follow the naming rules specified in
         * <code>CreateDBInstance</code>.
         * </p>
         * 
         * @param dbName
         *        The name of the database to create when the DB instance is created. Follow the naming rules specified
         *        in <code>CreateDBInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The DB instance identifier. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbinstance</code>
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbinstance</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation rules
         * specified in <code>CreateDBInstance</code>.
         * </p>
         * <p>
         * This setting isn't valid for RDS for SQL Server.
         * </p>
         * <note>
         * <p>
         * Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed. You
         * can also allocate additional storage for future growth.
         * </p>
         * </note>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation
         *        rules specified in <code>CreateDBInstance</code>.</p>
         *        <p>
         *        This setting isn't valid for RDS for SQL Server.
         *        </p>
         *        <note>
         *        <p>
         *        Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed.
         *        You can also allocate additional storage for future growth.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are
         * available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance
         * classes, and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
         * Class</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class.
         * </p>
         * 
         * @param dbInstanceClass
         *        The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance
         *        classes are available in all Amazon Web Services Regions, or for all database engines. For the full
         *        list of DB instance classes, and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p>
         *        <p>
         *        Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The name of the database engine to be used for this instance.
         * </p>
         * <p>
         * Valid Values: <code>mysql</code>
         * </p>
         * 
         * @param engine
         *        The name of the database engine to be used for this instance.</p>
         *        <p>
         *        Valid Values: <code>mysql</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The name for the master user.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 16 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUsername
         *        The name for the master user.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 16 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The password for the master user.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can include any printable ASCII character except "/",
         * """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes) character.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Length Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RDS for Db2 - Must contain from 8 to 128 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MariaDB - Must contain from 8 to 41 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - Must contain from 8 to 41 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Oracle - Must contain from 8 to 30 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - Must contain from 8 to 128 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUserPassword
         *        The password for the master user.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can include any printable ASCII character except "/",
         *        """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes)
         *        character.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Length Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        RDS for Db2 - Must contain from 8 to 128 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MariaDB - Must contain from 8 to 41 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - Must contain from 8 to 41 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Oracle - Must contain from 8 to 30 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - Must contain from 8 to 128 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * A list of DB security groups to associate with this DB instance.
         * </p>
         * <p>
         * Default: The default DB security group for the database engine.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to associate with this DB instance.</p>
         *        <p>
         *        Default: The default DB security group for the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<String> dbSecurityGroups);

        /**
         * <p>
         * A list of DB security groups to associate with this DB instance.
         * </p>
         * <p>
         * Default: The default DB security group for the database engine.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to associate with this DB instance.</p>
         *        <p>
         *        Default: The default DB security group for the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(String... dbSecurityGroups);

        /**
         * <p>
         * A list of VPC security groups to associate with this DB instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups to associate with this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups to associate with this DB instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups to associate with this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions
         * and Availability Zones, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         * >Regions and Availability Zones</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         * </p>
         * <p>
         * Example: <code>us-east-1d</code>
         * </p>
         * <p>
         * Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ
         * deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current
         * endpoint.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that the DB instance is created in. For information about Amazon Web Services
         *        Regions and Availability Zones, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         *        >Regions and Availability Zones</a> in the <i>Amazon RDS User Guide.</i> </p>
         *        <p>
         *        Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Example: <code>us-east-1d</code>
         *        </p>
         *        <p>
         *        Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a
         *        Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as
         *        the current endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A DB subnet group to associate with this DB instance.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * </p>
         * <p>
         * Example: <code>mydbsubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        A DB subnet group to associate with this DB instance.</p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *        </p>
         *        <p>
         *        Example: <code>mydbsubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         * >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred backup window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredMaintenanceWindow
         *        The time range each week during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC). For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         *        >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred backup window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The name of the DB parameter group to associate with this DB instance.
         * </p>
         * <p>
         * If you do not specify a value for <code>DBParameterGroupName</code>, then the default
         * <code>DBParameterGroup</code> for the specified DB engine is used.
         * </p>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group to associate with this DB instance.</p>
         *        <p>
         *        If you do not specify a value for <code>DBParameterGroupName</code>, then the default
         *        <code>DBParameterGroup</code> for the specified DB engine is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * The number of days for which automated backups are retained. Setting this parameter to a positive number
         * enables backups. For more information, see <code>CreateDBInstance</code>.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained. Setting this parameter to a positive
         *        number enables backups. For more information, see <code>CreateDBInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The time range each day during which automated backups are created if automated backups are enabled. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         * >Backup window</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The time range each day during which automated backups are created if automated backups are enabled.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         *        >Backup window</a> in the <i>Amazon RDS User Guide.</i> </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The port number on which the database accepts connections.
         * </p>
         * <p>
         * Type: Integer
         * </p>
         * <p>
         * Valid Values: <code>1150</code>-<code>65535</code>
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * 
         * @param port
         *        The port number on which the database accepts connections.</p>
         *        <p>
         *        Type: Integer
         *        </p>
         *        <p>
         *        Valid Values: <code>1150</code>-<code>65535</code>
         *        </p>
         *        <p>
         *        Default: <code>3306</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you
         * can't set the <code>AvailabilityZone</code> parameter.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ
         *        deployment, you can't set the <code>AvailabilityZone</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The version number of the database engine to use. Choose the latest minor version of your database engine.
         * For information about engine versions, see <code>CreateDBInstance</code>, or call
         * <code>DescribeDBEngineVersions</code>.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to use. Choose the latest minor version of your database
         *        engine. For information about engine versions, see <code>CreateDBInstance</code>, or call
         *        <code>DescribeDBEngineVersions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Specifies whether to automatically apply minor engine upgrades to the DB instance during the maintenance
         * window. By default, minor engine upgrades are not applied automatically.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Specifies whether to automatically apply minor engine upgrades to the DB instance during the
         *        maintenance window. By default, minor engine upgrades are not applied automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The license model for this DB instance. Use <code>general-public-license</code>.
         * </p>
         * 
         * @param licenseModel
         *        The license model for this DB instance. Use <code>general-public-license</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB
         * instance. For information about valid IOPS values, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         * Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB
         *        instance. For information about valid IOPS values, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         *        Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The name of the option group to associate with this DB instance. If this argument is omitted, the default
         * option group for the specified engine is used.
         * </p>
         * 
         * @param optionGroupName
         *        The name of the option group to associate with this DB instance. If this argument is omitted, the
         *        default option group for the specified engine is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * Specifies whether the DB instance is publicly accessible.
         * </p>
         * <p>
         * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
         * address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from
         * outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it
         * uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit
         * it.
         * </p>
         * <p>
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves
         * to a private IP address.
         * </p>
         * <p>
         * For more information, see <a>CreateDBInstance</a>.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies whether the DB instance is publicly accessible.</p>
         *        <p>
         *        When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the
         *        public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately
         *        controlled by the security group it uses. That public access is not permitted if the security group
         *        assigned to the DB instance doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        For more information, see <a>CreateDBInstance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * A list of tags to associate with this DB instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS
         * Resources</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with this DB instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS
         *        Resources</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associate with this DB instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS
         * Resources</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with this DB instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS
         *        Resources</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associate with this DB instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS
         * Resources</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies the storage type to be associated with the DB instance.
         * </p>
         * <p>
         * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         * </p>
         * <p>
         * If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the
         * <code>Iops</code> parameter.
         * </p>
         * <p>
         * Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>gp2</code>
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type to be associated with the DB instance.</p>
         *        <p>
         *        Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         *        </p>
         *        <p>
         *        If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value
         *        for the <code>Iops</code> parameter.
         *        </p>
         *        <p>
         *        Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>gp2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * Specifies whether the new DB instance is encrypted or not.
         * </p>
         * 
         * @param storageEncrypted
         *        Specifies whether the new DB instance is encrypted or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for an encrypted DB instance.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * If the <code>StorageEncrypted</code> parameter is enabled, and you do not specify a value for the
         * <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS key
         * for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for
         * each Amazon Web Services Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        If the <code>StorageEncrypted</code> parameter is enabled, and you do not specify a value for the
         *        <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS
         *        key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS
         *        key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are
         * not copied.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default,
         *        tags are not copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * To disable collecting Enhanced Monitoring metrics, specify 0.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a
         * value other than 0.
         * </p>
         * <p>
         * Valid Values: 0, 1, 5, 10, 15, 30, 60
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        instance. To disable collecting Enhanced Monitoring metrics, specify 0.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code>
         *        to a value other than 0.
         *        </p>
         *        <p>
         *        Valid Values: 0, 1, 5, 10, 15, 30, 60
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
         * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
         * see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         * >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch
         *        Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
         *        monitoring role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         *        >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         *        <code>MonitoringRoleArn</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * For more information about IAM database authentication, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         *        accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        For more information about IAM database authentication, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The name of the engine of your source database.
         * </p>
         * <p>
         * Valid Values: <code>mysql</code>
         * </p>
         * 
         * @param sourceEngine
         *        The name of the engine of your source database.</p>
         *        <p>
         *        Valid Values: <code>mysql</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEngine(String sourceEngine);

        /**
         * <p>
         * The version of the database that the backup files were created from.
         * </p>
         * <p>
         * MySQL versions 5.6 and 5.7 are supported.
         * </p>
         * <p>
         * Example: <code>5.6.40</code>
         * </p>
         * 
         * @param sourceEngineVersion
         *        The version of the database that the backup files were created from.</p>
         *        <p>
         *        MySQL versions 5.6 and 5.7 are supported.
         *        </p>
         *        <p>
         *        Example: <code>5.6.40</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEngineVersion(String sourceEngineVersion);

        /**
         * <p>
         * The name of your Amazon S3 bucket that contains your database backup file.
         * </p>
         * 
         * @param s3BucketName
         *        The name of your Amazon S3 bucket that contains your database backup file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The prefix of your Amazon S3 bucket.
         * </p>
         * 
         * @param s3Prefix
         *        The prefix of your Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * An Amazon Web Services Identity and Access Management (IAM) role with a trust policy and a permissions policy
         * that allows Amazon RDS to access your Amazon S3 bucket. For information about this role, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html#MySQL.Procedural.Importing.Enabling.IAM"
         * > Creating an IAM role manually</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param s3IngestionRoleArn
         *        An Amazon Web Services Identity and Access Management (IAM) role with a trust policy and a permissions
         *        policy that allows Amazon RDS to access your Amazon S3 bucket. For information about this role, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html#MySQL.Procedural.Importing.Enabling.IAM"
         *        > Creating an IAM role manually</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3IngestionRoleArn(String s3IngestionRoleArn);

        /**
         * <p>
         * Specifies the mode of Database Insights to enable for the DB instance.
         * </p>
         * <note>
         * <p>
         * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         * </p>
         * </note>
         * 
         * @param databaseInsightsMode
         *        Specifies the mode of Database Insights to enable for the DB instance.</p> <note>
         *        <p>
         *        Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         *        </p>
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(String databaseInsightsMode);

        /**
         * <p>
         * Specifies the mode of Database Insights to enable for the DB instance.
         * </p>
         * <note>
         * <p>
         * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         * </p>
         * </note>
         * 
         * @param databaseInsightsMode
         *        Specifies the mode of Database Insights to enable for the DB instance.</p> <note>
         *        <p>
         *        Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         *        </p>
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode);

        /**
         * <p>
         * Specifies whether to enable Performance Insights for the DB instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
         * Insights</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param enablePerformanceInsights
         *        Specifies whether to enable Performance Insights for the DB instance.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
         *        Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The number of days to retain Performance Insights data. The default is 7 days. The following values are
         * valid:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 7
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23
         * </p>
         * </li>
         * <li>
         * <p>
         * 731
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, the following values are valid:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 93 (3 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * 341 (11 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * 589 (19 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * 731
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The number of days to retain Performance Insights data. The default is 7 days. The following values
         *        are valid:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        7
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>month</i> * 31, where <i>month</i> is a number of months from 1-23
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        731
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, the following values are valid:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        93 (3 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        341 (11 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        589 (19 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        731
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend
         * on the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend
         * on the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<ProcessorFeature> processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(ProcessorFeature... processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.ProcessorFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder#build()} is called immediately and
         * its result is passed to {@link #processorFeatures(List<ProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(java.util.Collection<ProcessorFeature>)
         */
        Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures);

        /**
         * <p>
         * Specifies whether the DB instance class of the DB instance uses its default processor features.
         * </p>
         * 
         * @param useDefaultProcessorFeatures
         *        Specifies whether the DB instance class of the DB instance uses its default processor features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures);

        /**
         * <p>
         * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when
         * deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         * Instance</a>.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether to enable deletion protection for the DB instance. The database can't be deleted
         *        when deletion protection is enabled. By default, deletion protection isn't enabled. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         *        Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         * instance.
         * </p>
         * <p>
         * For more information about this setting, including limitations that apply to it, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
         * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param maxAllocatedStorage
         *        The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         *        instance.</p>
         *        <p>
         *        For more information about this setting, including limitations that apply to it, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
         *        > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllocatedStorage(Integer maxAllocatedStorage);

        /**
         * <p>
         * The network type of the DB instance.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DUAL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
         * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         * <code>DUAL</code>).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         * Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param networkType
         *        The network type of the DB instance.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DUAL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
         *        <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         *        <code>DUAL</code>).
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         *        Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Specifies the storage throughput value for the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom or Amazon Aurora.
         * </p>
         * 
         * @param storageThroughput
         *        Specifies the storage throughput value for the DB instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom or Amazon Aurora.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageThroughput(Integer storageThroughput);

        /**
         * <p>
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management
         * with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't manage the master user password with Amazon Web Services Secrets Manager if
         * <code>MasterUserPassword</code> is specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param manageMasterUserPassword
         *        Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't manage the master user password with Amazon Web Services Secrets Manager if
         *        <code>MasterUserPassword</code> is specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageMasterUserPassword(Boolean manageMasterUserPassword);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
         * Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
         * Manager for the DB instance.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key
         * is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't
         * use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed
         * KMS key.
         * </p>
         * <p>
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default KMS key for each Amazon Web Services Region.
         * </p>
         * 
         * @param masterUserSecretKmsKeyId
         *        The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
         *        managed in Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        This setting is valid only if the master user password is managed by RDS in Amazon Web Services
         *        Secrets Manager for the DB instance.
         *        </p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code>
         *        KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account,
         *        then you can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use
         *        a customer managed KMS key.
         *        </p>
         *        <p>
         *        There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
         *        a different default KMS key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId);

        /**
         * <p>
         * Specifies whether to enable a dedicated log volume (DLV) for the DB instance.
         * </p>
         * 
         * @param dedicatedLogVolume
         *        Specifies whether to enable a dedicated log volume (DLV) for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedLogVolume(Boolean dedicatedLogVolume);

        /**
         * <p>
         * The CA certificate identifier to use for the DB instance's server certificate.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt
         * a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
         * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The CA certificate identifier to use for the DB instance's server certificate.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
         *        encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using
         *        SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * The life cycle type for this DB instance.
         * </p>
         * <note>
         * <p>
         * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
         * instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended
         * Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS
         * automatically upgrades your restored DB instance to a higher engine version, if the major engine version is
         * past its end of standard support date.
         * </p>
         * </note>
         * <p>
         * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended
         * Support, you can run the selected major engine version on your DB instance past the end of standard support
         * for that engine version. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended
         * Support</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life
         * cycle type is managed by the DB cluster.
         * </p>
         * <p>
         * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         * </p>
         * <p>
         * Default: <code>open-source-rds-extended-support</code>
         * </p>
         * 
         * @param engineLifecycleSupport
         *        The life cycle type for this DB instance.</p> <note>
         *        <p>
         *        By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
         *        instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
         *        Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In
         *        this case, RDS automatically upgrades your restored DB instance to a higher engine version, if the
         *        major engine version is past its end of standard support date.
         *        </p>
         *        </note>
         *        <p>
         *        You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS
         *        Extended Support, you can run the selected major engine version on your DB instance past the end of
         *        standard support for that engine version. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS
         *        Extended Support</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the
         *        life cycle type is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Valid Values:
         *        <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         *        </p>
         *        <p>
         *        Default: <code>open-source-rds-extended-support</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineLifecycleSupport(String engineLifecycleSupport);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbName;

        private String dbInstanceIdentifier;

        private Integer allocatedStorage;

        private String dbInstanceClass;

        private String engine;

        private String masterUsername;

        private String masterUserPassword;

        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private String dbSubnetGroupName;

        private String preferredMaintenanceWindow;

        private String dbParameterGroupName;

        private Integer backupRetentionPeriod;

        private String preferredBackupWindow;

        private Integer port;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private String licenseModel;

        private Integer iops;

        private String optionGroupName;

        private Boolean publiclyAccessible;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String storageType;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private Boolean enableIAMDatabaseAuthentication;

        private String sourceEngine;

        private String sourceEngineVersion;

        private String s3BucketName;

        private String s3Prefix;

        private String s3IngestionRoleArn;

        private String databaseInsightsMode;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private Boolean useDefaultProcessorFeatures;

        private Boolean deletionProtection;

        private Integer maxAllocatedStorage;

        private String networkType;

        private Integer storageThroughput;

        private Boolean manageMasterUserPassword;

        private String masterUserSecretKmsKeyId;

        private Boolean dedicatedLogVolume;

        private String caCertificateIdentifier;

        private String engineLifecycleSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbInstanceFromS3Request model) {
            super(model);
            dbName(model.dbName);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            allocatedStorage(model.allocatedStorage);
            dbInstanceClass(model.dbInstanceClass);
            engine(model.engine);
            masterUsername(model.masterUsername);
            masterUserPassword(model.masterUserPassword);
            dbSecurityGroups(model.dbSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            availabilityZone(model.availabilityZone);
            dbSubnetGroupName(model.dbSubnetGroupName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            dbParameterGroupName(model.dbParameterGroupName);
            backupRetentionPeriod(model.backupRetentionPeriod);
            preferredBackupWindow(model.preferredBackupWindow);
            port(model.port);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            publiclyAccessible(model.publiclyAccessible);
            tags(model.tags);
            storageType(model.storageType);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            sourceEngine(model.sourceEngine);
            sourceEngineVersion(model.sourceEngineVersion);
            s3BucketName(model.s3BucketName);
            s3Prefix(model.s3Prefix);
            s3IngestionRoleArn(model.s3IngestionRoleArn);
            databaseInsightsMode(model.databaseInsightsMode);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            processorFeatures(model.processorFeatures);
            useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            deletionProtection(model.deletionProtection);
            maxAllocatedStorage(model.maxAllocatedStorage);
            networkType(model.networkType);
            storageThroughput(model.storageThroughput);
            manageMasterUserPassword(model.manageMasterUserPassword);
            masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            dedicatedLogVolume(model.dedicatedLogVolume);
            caCertificateIdentifier(model.caCertificateIdentifier);
            engineLifecycleSupport(model.engineLifecycleSupport);
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroups;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final String getSourceEngine() {
            return sourceEngine;
        }

        public final void setSourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
        }

        @Override
        public final Builder sourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
            return this;
        }

        public final String getSourceEngineVersion() {
            return sourceEngineVersion;
        }

        public final void setSourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
        }

        @Override
        public final Builder sourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3IngestionRoleArn() {
            return s3IngestionRoleArn;
        }

        public final void setS3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
        }

        @Override
        public final Builder s3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
            return this;
        }

        public final String getDatabaseInsightsMode() {
            return databaseInsightsMode;
        }

        public final void setDatabaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
        }

        @Override
        public final Builder databaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        @Override
        public final Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode) {
            this.databaseInsightsMode(databaseInsightsMode == null ? null : databaseInsightsMode.toString());
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> ProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return useDefaultProcessorFeatures;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        @Override
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final Integer getStorageThroughput() {
            return storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final Boolean getDedicatedLogVolume() {
            return dedicatedLogVolume;
        }

        public final void setDedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
        }

        @Override
        public final Builder dedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getEngineLifecycleSupport() {
            return engineLifecycleSupport;
        }

        public final void setEngineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
        }

        @Override
        public final Builder engineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbInstanceFromS3Request build() {
            return new RestoreDbInstanceFromS3Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
