/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CharacterSet implements SdkPojo, Serializable, ToCopyableBuilder<CharacterSet.Builder, CharacterSet> {
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(CharacterSet::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> CHARACTER_SET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetDescription").getter(getter(CharacterSet::characterSetDescription))
            .setter(setter(Builder::characterSetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHARACTER_SET_NAME_FIELD,
            CHARACTER_SET_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String characterSetName;

    private final String characterSetDescription;

    private CharacterSet(BuilderImpl builder) {
        this.characterSetName = builder.characterSetName;
        this.characterSetDescription = builder.characterSetDescription;
    }

    /**
     * <p>
     * The name of the character set.
     * </p>
     * 
     * @return The name of the character set.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The description of the character set.
     * </p>
     * 
     * @return The description of the character set.
     */
    public final String characterSetDescription() {
        return characterSetDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterSet)) {
            return false;
        }
        CharacterSet other = (CharacterSet) obj;
        return Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(characterSetDescription(), other.characterSetDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CharacterSet").add("CharacterSetName", characterSetName())
                .add("CharacterSetDescription", characterSetDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "CharacterSetDescription":
            return Optional.ofNullable(clazz.cast(characterSetDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CharacterSetName", CHARACTER_SET_NAME_FIELD);
        map.put("CharacterSetDescription", CHARACTER_SET_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CharacterSet, T> g) {
        return obj -> g.apply((CharacterSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CharacterSet> {
        /**
         * <p>
         * The name of the character set.
         * </p>
         * 
         * @param characterSetName
         *        The name of the character set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The description of the character set.
         * </p>
         * 
         * @param characterSetDescription
         *        The description of the character set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetDescription(String characterSetDescription);
    }

    static final class BuilderImpl implements Builder {
        private String characterSetName;

        private String characterSetDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CharacterSet model) {
            characterSetName(model.characterSetName);
            characterSetDescription(model.characterSetDescription);
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getCharacterSetDescription() {
            return characterSetDescription;
        }

        public final void setCharacterSetDescription(String characterSetDescription) {
            this.characterSetDescription = characterSetDescription;
        }

        @Override
        public final Builder characterSetDescription(String characterSetDescription) {
            this.characterSetDescription = characterSetDescription;
            return this;
        }

        @Override
        public CharacterSet build() {
            return new CharacterSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
