/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCurrentDbClusterCapacityResponse extends RdsResponse implements
        ToCopyableBuilder<ModifyCurrentDbClusterCapacityResponse.Builder, ModifyCurrentDbClusterCapacityResponse> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(ModifyCurrentDbClusterCapacityResponse::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Integer> PENDING_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PendingCapacity").getter(getter(ModifyCurrentDbClusterCapacityResponse::pendingCapacity))
            .setter(setter(Builder::pendingCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingCapacity").build()).build();

    private static final SdkField<Integer> CURRENT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentCapacity").getter(getter(ModifyCurrentDbClusterCapacityResponse::currentCapacity))
            .setter(setter(Builder::currentCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentCapacity").build()).build();

    private static final SdkField<Integer> SECONDS_BEFORE_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondsBeforeTimeout").getter(getter(ModifyCurrentDbClusterCapacityResponse::secondsBeforeTimeout))
            .setter(setter(Builder::secondsBeforeTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsBeforeTimeout").build())
            .build();

    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeoutAction").getter(getter(ModifyCurrentDbClusterCapacityResponse::timeoutAction))
            .setter(setter(Builder::timeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            PENDING_CAPACITY_FIELD, CURRENT_CAPACITY_FIELD, SECONDS_BEFORE_TIMEOUT_FIELD, TIMEOUT_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbClusterIdentifier;

    private final Integer pendingCapacity;

    private final Integer currentCapacity;

    private final Integer secondsBeforeTimeout;

    private final String timeoutAction;

    private ModifyCurrentDbClusterCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.pendingCapacity = builder.pendingCapacity;
        this.currentCapacity = builder.currentCapacity;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
        this.timeoutAction = builder.timeoutAction;
    }

    /**
     * <p>
     * A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
     * </p>
     * 
     * @return A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * A value that specifies the capacity that the DB cluster scales to next.
     * </p>
     * 
     * @return A value that specifies the capacity that the DB cluster scales to next.
     */
    public final Integer pendingCapacity() {
        return pendingCapacity;
    }

    /**
     * <p>
     * The current capacity of the DB cluster.
     * </p>
     * 
     * @return The current capacity of the DB cluster.
     */
    public final Integer currentCapacity() {
        return currentCapacity;
    }

    /**
     * <p>
     * The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.
     * </p>
     * 
     * @return The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.
     */
    public final Integer secondsBeforeTimeout() {
        return secondsBeforeTimeout;
    }

    /**
     * <p>
     * The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
     * <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
     * </p>
     * 
     * @return The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
     *         <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
     */
    public final String timeoutAction() {
        return timeoutAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(pendingCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(currentCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(secondsBeforeTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCurrentDbClusterCapacityResponse)) {
            return false;
        }
        ModifyCurrentDbClusterCapacityResponse other = (ModifyCurrentDbClusterCapacityResponse) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(pendingCapacity(), other.pendingCapacity())
                && Objects.equals(currentCapacity(), other.currentCapacity())
                && Objects.equals(secondsBeforeTimeout(), other.secondsBeforeTimeout())
                && Objects.equals(timeoutAction(), other.timeoutAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCurrentDbClusterCapacityResponse").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("PendingCapacity", pendingCapacity()).add("CurrentCapacity", currentCapacity())
                .add("SecondsBeforeTimeout", secondsBeforeTimeout()).add("TimeoutAction", timeoutAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "PendingCapacity":
            return Optional.ofNullable(clazz.cast(pendingCapacity()));
        case "CurrentCapacity":
            return Optional.ofNullable(clazz.cast(currentCapacity()));
        case "SecondsBeforeTimeout":
            return Optional.ofNullable(clazz.cast(secondsBeforeTimeout()));
        case "TimeoutAction":
            return Optional.ofNullable(clazz.cast(timeoutAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("PendingCapacity", PENDING_CAPACITY_FIELD);
        map.put("CurrentCapacity", CURRENT_CAPACITY_FIELD);
        map.put("SecondsBeforeTimeout", SECONDS_BEFORE_TIMEOUT_FIELD);
        map.put("TimeoutAction", TIMEOUT_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCurrentDbClusterCapacityResponse, T> g) {
        return obj -> g.apply((ModifyCurrentDbClusterCapacityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyCurrentDbClusterCapacityResponse> {
        /**
         * <p>
         * A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * A value that specifies the capacity that the DB cluster scales to next.
         * </p>
         * 
         * @param pendingCapacity
         *        A value that specifies the capacity that the DB cluster scales to next.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingCapacity(Integer pendingCapacity);

        /**
         * <p>
         * The current capacity of the DB cluster.
         * </p>
         * 
         * @param currentCapacity
         *        The current capacity of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentCapacity(Integer currentCapacity);

        /**
         * <p>
         * The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.
         * </p>
         * 
         * @param secondsBeforeTimeout
         *        The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsBeforeTimeout(Integer secondsBeforeTimeout);

        /**
         * <p>
         * The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
         * <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
         * </p>
         * 
         * @param timeoutAction
         *        The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
         *        <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutAction(String timeoutAction);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private Integer pendingCapacity;

        private Integer currentCapacity;

        private Integer secondsBeforeTimeout;

        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCurrentDbClusterCapacityResponse model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            pendingCapacity(model.pendingCapacity);
            currentCapacity(model.currentCapacity);
            secondsBeforeTimeout(model.secondsBeforeTimeout);
            timeoutAction(model.timeoutAction);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Integer getPendingCapacity() {
            return pendingCapacity;
        }

        public final void setPendingCapacity(Integer pendingCapacity) {
            this.pendingCapacity = pendingCapacity;
        }

        @Override
        public final Builder pendingCapacity(Integer pendingCapacity) {
            this.pendingCapacity = pendingCapacity;
            return this;
        }

        public final Integer getCurrentCapacity() {
            return currentCapacity;
        }

        public final void setCurrentCapacity(Integer currentCapacity) {
            this.currentCapacity = currentCapacity;
        }

        @Override
        public final Builder currentCapacity(Integer currentCapacity) {
            this.currentCapacity = currentCapacity;
            return this;
        }

        public final Integer getSecondsBeforeTimeout() {
            return secondsBeforeTimeout;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        @Override
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        public final String getTimeoutAction() {
            return timeoutAction;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        @Override
        public ModifyCurrentDbClusterCapacityResponse build() {
            return new ModifyCurrentDbClusterCapacityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
