/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableHttpEndpointResponse extends RdsResponse implements
        ToCopyableBuilder<DisableHttpEndpointResponse.Builder, DisableHttpEndpointResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DisableHttpEndpointResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Boolean> HTTP_ENDPOINT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HttpEndpointEnabled").getter(getter(DisableHttpEndpointResponse::httpEndpointEnabled))
            .setter(setter(Builder::httpEndpointEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            HTTP_ENDPOINT_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final Boolean httpEndpointEnabled;

    private DisableHttpEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.httpEndpointEnabled = builder.httpEndpointEnabled;
    }

    /**
     * <p>
     * The ARN of the DB cluster.
     * </p>
     * 
     * @return The ARN of the DB cluster.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Indicates whether the HTTP endpoint is enabled or disabled for the DB cluster.
     * </p>
     * 
     * @return Indicates whether the HTTP endpoint is enabled or disabled for the DB cluster.
     */
    public final Boolean httpEndpointEnabled() {
        return httpEndpointEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableHttpEndpointResponse)) {
            return false;
        }
        DisableHttpEndpointResponse other = (DisableHttpEndpointResponse) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(httpEndpointEnabled(), other.httpEndpointEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableHttpEndpointResponse").add("ResourceArn", resourceArn())
                .add("HttpEndpointEnabled", httpEndpointEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "HttpEndpointEnabled":
            return Optional.ofNullable(clazz.cast(httpEndpointEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("HttpEndpointEnabled", HTTP_ENDPOINT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableHttpEndpointResponse, T> g) {
        return obj -> g.apply((DisableHttpEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisableHttpEndpointResponse> {
        /**
         * <p>
         * The ARN of the DB cluster.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Indicates whether the HTTP endpoint is enabled or disabled for the DB cluster.
         * </p>
         * 
         * @param httpEndpointEnabled
         *        Indicates whether the HTTP endpoint is enabled or disabled for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpEndpointEnabled(Boolean httpEndpointEnabled);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String resourceArn;

        private Boolean httpEndpointEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableHttpEndpointResponse model) {
            super(model);
            resourceArn(model.resourceArn);
            httpEndpointEnabled(model.httpEndpointEnabled);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Boolean getHttpEndpointEnabled() {
            return httpEndpointEnabled;
        }

        public final void setHttpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
        }

        @Override
        public final Builder httpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
            return this;
        }

        @Override
        public DisableHttpEndpointResponse build() {
            return new DisableHttpEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
