/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbProxyEndpointRequest extends RdsRequest implements
        ToCopyableBuilder<CreateDbProxyEndpointRequest.Builder, CreateDbProxyEndpointRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBProxyName").getter(getter(CreateDbProxyEndpointRequest::dbProxyName))
            .setter(setter(Builder::dbProxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()).build();

    private static final SdkField<String> DB_PROXY_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBProxyEndpointName").getter(getter(CreateDbProxyEndpointRequest::dbProxyEndpointName))
            .setter(setter(Builder::dbProxyEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpointName").build())
            .build();

    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSubnetIds")
            .getter(getter(CreateDbProxyEndpointRequest::vpcSubnetIds))
            .setter(setter(Builder::vpcSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(CreateDbProxyEndpointRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetRole").getter(getter(CreateDbProxyEndpointRequest::targetRoleAsString))
            .setter(setter(Builder::targetRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRole").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbProxyEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD,
            DB_PROXY_ENDPOINT_NAME_FIELD, VPC_SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TARGET_ROLE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbProxyName;

    private final String dbProxyEndpointName;

    private final List<String> vpcSubnetIds;

    private final List<String> vpcSecurityGroupIds;

    private final String targetRole;

    private final List<Tag> tags;

    private CreateDbProxyEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.dbProxyEndpointName = builder.dbProxyEndpointName;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.targetRole = builder.targetRole;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the DB proxy associated with the DB proxy endpoint that you create.
     * </p>
     * 
     * @return The name of the DB proxy associated with the DB proxy endpoint that you create.
     */
    public final String dbProxyName() {
        return dbProxyName;
    }

    /**
     * <p>
     * The name of the DB proxy endpoint to create.
     * </p>
     * 
     * @return The name of the DB proxy endpoint to create.
     */
    public final String dbProxyEndpointName() {
        return dbProxyEndpointName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSubnetIds() {
        return vpcSubnetIds != null && !(vpcSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than
     * for the original DB proxy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSubnetIds} method.
     * </p>
     * 
     * @return The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet
     *         IDs than for the original DB proxy.
     */
    public final List<String> vpcSubnetIds() {
        return vpcSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security
     * group IDs than for the original DB proxy. The default is the default security group for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of
     *         security group IDs than for the original DB proxy. The default is the default security group for the VPC.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write or only
     * read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS for Microsoft SQL
     * Server support is <code>READ_WRITE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetRole} will
     * return {@link DBProxyEndpointTargetRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetRoleAsString}.
     * </p>
     * 
     * @return The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write or
     *         only read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS for
     *         Microsoft SQL Server support is <code>READ_WRITE</code>.
     * @see DBProxyEndpointTargetRole
     */
    public final DBProxyEndpointTargetRole targetRole() {
        return DBProxyEndpointTargetRole.fromValue(targetRole);
    }

    /**
     * <p>
     * The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write or only
     * read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS for Microsoft SQL
     * Server support is <code>READ_WRITE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetRole} will
     * return {@link DBProxyEndpointTargetRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetRoleAsString}.
     * </p>
     * 
     * @return The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write or
     *         only read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS for
     *         Microsoft SQL Server support is <code>READ_WRITE</code>.
     * @see DBProxyEndpointTargetRole
     */
    public final String targetRoleAsString() {
        return targetRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSubnetIds() ? vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbProxyEndpointRequest)) {
            return false;
        }
        CreateDbProxyEndpointRequest other = (CreateDbProxyEndpointRequest) obj;
        return Objects.equals(dbProxyName(), other.dbProxyName())
                && Objects.equals(dbProxyEndpointName(), other.dbProxyEndpointName())
                && hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(vpcSubnetIds(), other.vpcSubnetIds())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(targetRoleAsString(), other.targetRoleAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbProxyEndpointRequest").add("DBProxyName", dbProxyName())
                .add("DBProxyEndpointName", dbProxyEndpointName()).add("VpcSubnetIds", hasVpcSubnetIds() ? vpcSubnetIds() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("TargetRole", targetRoleAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyName":
            return Optional.ofNullable(clazz.cast(dbProxyName()));
        case "DBProxyEndpointName":
            return Optional.ofNullable(clazz.cast(dbProxyEndpointName()));
        case "VpcSubnetIds":
            return Optional.ofNullable(clazz.cast(vpcSubnetIds()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "TargetRole":
            return Optional.ofNullable(clazz.cast(targetRoleAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBProxyName", DB_PROXY_NAME_FIELD);
        map.put("DBProxyEndpointName", DB_PROXY_ENDPOINT_NAME_FIELD);
        map.put("VpcSubnetIds", VPC_SUBNET_IDS_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("TargetRole", TARGET_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbProxyEndpointRequest, T> g) {
        return obj -> g.apply((CreateDbProxyEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbProxyEndpointRequest> {
        /**
         * <p>
         * The name of the DB proxy associated with the DB proxy endpoint that you create.
         * </p>
         * 
         * @param dbProxyName
         *        The name of the DB proxy associated with the DB proxy endpoint that you create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyName(String dbProxyName);

        /**
         * <p>
         * The name of the DB proxy endpoint to create.
         * </p>
         * 
         * @param dbProxyEndpointName
         *        The name of the DB proxy endpoint to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyEndpointName(String dbProxyEndpointName);

        /**
         * <p>
         * The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs
         * than for the original DB proxy.
         * </p>
         * 
         * @param vpcSubnetIds
         *        The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of
         *        subnet IDs than for the original DB proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(Collection<String> vpcSubnetIds);

        /**
         * <p>
         * The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs
         * than for the original DB proxy.
         * </p>
         * 
         * @param vpcSubnetIds
         *        The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of
         *        subnet IDs than for the original DB proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(String... vpcSubnetIds);

        /**
         * <p>
         * The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of
         * security group IDs than for the original DB proxy. The default is the default security group for the VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set
         *        of security group IDs than for the original DB proxy. The default is the default security group for
         *        the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of
         * security group IDs than for the original DB proxy. The default is the default security group for the VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set
         *        of security group IDs than for the original DB proxy. The default is the default security group for
         *        the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write or
         * only read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS for
         * Microsoft SQL Server support is <code>READ_WRITE</code>.
         * </p>
         * 
         * @param targetRole
         *        The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write
         *        or only read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS
         *        for Microsoft SQL Server support is <code>READ_WRITE</code>.
         * @see DBProxyEndpointTargetRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DBProxyEndpointTargetRole
         */
        Builder targetRole(String targetRole);

        /**
         * <p>
         * The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write or
         * only read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS for
         * Microsoft SQL Server support is <code>READ_WRITE</code>.
         * </p>
         * 
         * @param targetRole
         *        The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write
         *        or only read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS
         *        for Microsoft SQL Server support is <code>READ_WRITE</code>.
         * @see DBProxyEndpointTargetRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DBProxyEndpointTargetRole
         */
        Builder targetRole(DBProxyEndpointTargetRole targetRole);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbProxyName;

        private String dbProxyEndpointName;

        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String targetRole;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbProxyEndpointRequest model) {
            super(model);
            dbProxyName(model.dbProxyName);
            dbProxyEndpointName(model.dbProxyEndpointName);
            vpcSubnetIds(model.vpcSubnetIds);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            targetRole(model.targetRole);
            tags(model.tags);
        }

        public final String getDbProxyName() {
            return dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getDbProxyEndpointName() {
            return dbProxyEndpointName;
        }

        public final void setDbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
        }

        @Override
        public final Builder dbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String... vpcSubnetIds) {
            vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getTargetRole() {
            return targetRole;
        }

        public final void setTargetRole(String targetRole) {
            this.targetRole = targetRole;
        }

        @Override
        public final Builder targetRole(String targetRole) {
            this.targetRole = targetRole;
            return this;
        }

        @Override
        public final Builder targetRole(DBProxyEndpointTargetRole targetRole) {
            this.targetRole(targetRole == null ? null : targetRole.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbProxyEndpointRequest build() {
            return new CreateDbProxyEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
