/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of a tenant database in a snapshot of a DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBSnapshotTenantDatabase implements SdkPojo, Serializable,
        ToCopyableBuilder<DBSnapshotTenantDatabase.Builder, DBSnapshotTenantDatabase> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSnapshotIdentifier").getter(getter(DBSnapshotTenantDatabase::dbSnapshotIdentifier))
            .setter(setter(Builder::dbSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DBSnapshotTenantDatabase::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(DBSnapshotTenantDatabase::dbiResourceId))
            .setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineName").getter(getter(DBSnapshotTenantDatabase::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(DBSnapshotTenantDatabase::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<Instant> TENANT_DATABASE_CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("TenantDatabaseCreateTime")
            .getter(getter(DBSnapshotTenantDatabase::tenantDatabaseCreateTime)).setter(setter(Builder::tenantDatabaseCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseCreateTime").build())
            .build();

    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDBName").getter(getter(DBSnapshotTenantDatabase::tenantDBName))
            .setter(setter(Builder::tenantDBName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(DBSnapshotTenantDatabase::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> TENANT_DATABASE_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDatabaseResourceId").getter(getter(DBSnapshotTenantDatabase::tenantDatabaseResourceId))
            .setter(setter(Builder::tenantDatabaseResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseResourceId").build())
            .build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(DBSnapshotTenantDatabase::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> DB_SNAPSHOT_TENANT_DATABASE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBSnapshotTenantDatabaseARN")
            .getter(getter(DBSnapshotTenantDatabase::dbSnapshotTenantDatabaseARN))
            .setter(setter(Builder::dbSnapshotTenantDatabaseARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotTenantDatabaseARN")
                    .build()).build();

    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NcharCharacterSetName").getter(getter(DBSnapshotTenantDatabase::ncharCharacterSetName))
            .setter(setter(Builder::ncharCharacterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build())
            .build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagList")
            .getter(getter(DBSnapshotTenantDatabase::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD,
            DB_INSTANCE_IDENTIFIER_FIELD, DBI_RESOURCE_ID_FIELD, ENGINE_NAME_FIELD, SNAPSHOT_TYPE_FIELD,
            TENANT_DATABASE_CREATE_TIME_FIELD, TENANT_DB_NAME_FIELD, MASTER_USERNAME_FIELD, TENANT_DATABASE_RESOURCE_ID_FIELD,
            CHARACTER_SET_NAME_FIELD, DB_SNAPSHOT_TENANT_DATABASE_ARN_FIELD, NCHAR_CHARACTER_SET_NAME_FIELD, TAG_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbSnapshotIdentifier;

    private final String dbInstanceIdentifier;

    private final String dbiResourceId;

    private final String engineName;

    private final String snapshotType;

    private final Instant tenantDatabaseCreateTime;

    private final String tenantDBName;

    private final String masterUsername;

    private final String tenantDatabaseResourceId;

    private final String characterSetName;

    private final String dbSnapshotTenantDatabaseARN;

    private final String ncharCharacterSetName;

    private final List<Tag> tagList;

    private DBSnapshotTenantDatabase(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbiResourceId = builder.dbiResourceId;
        this.engineName = builder.engineName;
        this.snapshotType = builder.snapshotType;
        this.tenantDatabaseCreateTime = builder.tenantDatabaseCreateTime;
        this.tenantDBName = builder.tenantDBName;
        this.masterUsername = builder.masterUsername;
        this.tenantDatabaseResourceId = builder.tenantDatabaseResourceId;
        this.characterSetName = builder.characterSetName;
        this.dbSnapshotTenantDatabaseARN = builder.dbSnapshotTenantDatabaseARN;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.tagList = builder.tagList;
    }

    /**
     * <p>
     * The identifier for the snapshot of the DB instance.
     * </p>
     * 
     * @return The identifier for the snapshot of the DB instance.
     */
    public final String dbSnapshotIdentifier() {
        return dbSnapshotIdentifier;
    }

    /**
     * <p>
     * The ID for the DB instance that contains the tenant databases.
     * </p>
     * 
     * @return The ID for the DB instance that contains the tenant databases.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The resource identifier of the source CDB instance. This identifier can't be changed and is unique to an Amazon
     * Web Services Region.
     * </p>
     * 
     * @return The resource identifier of the source CDB instance. This identifier can't be changed and is unique to an
     *         Amazon Web Services Region.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The name of the database engine.
     * </p>
     * 
     * @return The name of the database engine.
     */
    public final String engineName() {
        return engineName;
    }

    /**
     * <p>
     * The type of DB snapshot.
     * </p>
     * 
     * @return The type of DB snapshot.
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * The time the DB snapshot was taken, specified in Coordinated Universal Time (UTC). If you copy the snapshot, the
     * creation time changes.
     * </p>
     * 
     * @return The time the DB snapshot was taken, specified in Coordinated Universal Time (UTC). If you copy the
     *         snapshot, the creation time changes.
     */
    public final Instant tenantDatabaseCreateTime() {
        return tenantDatabaseCreateTime;
    }

    /**
     * <p>
     * The name of the tenant database.
     * </p>
     * 
     * @return The name of the tenant database.
     */
    public final String tenantDBName() {
        return tenantDBName;
    }

    /**
     * <p>
     * The master username of the tenant database.
     * </p>
     * 
     * @return The master username of the tenant database.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The resource ID of the tenant database.
     * </p>
     * 
     * @return The resource ID of the tenant database.
     */
    public final String tenantDatabaseResourceId() {
        return tenantDatabaseResourceId;
    }

    /**
     * <p>
     * The name of the character set of a tenant database.
     * </p>
     * 
     * @return The name of the character set of a tenant database.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the snapshot tenant database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the snapshot tenant database.
     */
    public final String dbSnapshotTenantDatabaseARN() {
        return dbSnapshotTenantDatabaseARN;
    }

    /**
     * <p>
     * The <code>NCHAR</code> character set name of the tenant database.
     * </p>
     * 
     * @return The <code>NCHAR</code> character set name of the tenant database.
     */
    public final String ncharCharacterSetName() {
        return ncharCharacterSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDatabaseCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDatabaseResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotTenantDatabaseARN());
        hashCode = 31 * hashCode + Objects.hashCode(ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotTenantDatabase)) {
            return false;
        }
        DBSnapshotTenantDatabase other = (DBSnapshotTenantDatabase) obj;
        return Objects.equals(dbSnapshotIdentifier(), other.dbSnapshotIdentifier())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbiResourceId(), other.dbiResourceId()) && Objects.equals(engineName(), other.engineName())
                && Objects.equals(snapshotType(), other.snapshotType())
                && Objects.equals(tenantDatabaseCreateTime(), other.tenantDatabaseCreateTime())
                && Objects.equals(tenantDBName(), other.tenantDBName())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(tenantDatabaseResourceId(), other.tenantDatabaseResourceId())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(dbSnapshotTenantDatabaseARN(), other.dbSnapshotTenantDatabaseARN())
                && Objects.equals(ncharCharacterSetName(), other.ncharCharacterSetName()) && hasTagList() == other.hasTagList()
                && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBSnapshotTenantDatabase").add("DBSnapshotIdentifier", dbSnapshotIdentifier())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("DbiResourceId", dbiResourceId())
                .add("EngineName", engineName()).add("SnapshotType", snapshotType())
                .add("TenantDatabaseCreateTime", tenantDatabaseCreateTime()).add("TenantDBName", tenantDBName())
                .add("MasterUsername", masterUsername()).add("TenantDatabaseResourceId", tenantDatabaseResourceId())
                .add("CharacterSetName", characterSetName()).add("DBSnapshotTenantDatabaseARN", dbSnapshotTenantDatabaseARN())
                .add("NcharCharacterSetName", ncharCharacterSetName()).add("TagList", hasTagList() ? tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbSnapshotIdentifier()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "TenantDatabaseCreateTime":
            return Optional.ofNullable(clazz.cast(tenantDatabaseCreateTime()));
        case "TenantDBName":
            return Optional.ofNullable(clazz.cast(tenantDBName()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "TenantDatabaseResourceId":
            return Optional.ofNullable(clazz.cast(tenantDatabaseResourceId()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "DBSnapshotTenantDatabaseARN":
            return Optional.ofNullable(clazz.cast(dbSnapshotTenantDatabaseARN()));
        case "NcharCharacterSetName":
            return Optional.ofNullable(clazz.cast(ncharCharacterSetName()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBSnapshotIdentifier", DB_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("DbiResourceId", DBI_RESOURCE_ID_FIELD);
        map.put("EngineName", ENGINE_NAME_FIELD);
        map.put("SnapshotType", SNAPSHOT_TYPE_FIELD);
        map.put("TenantDatabaseCreateTime", TENANT_DATABASE_CREATE_TIME_FIELD);
        map.put("TenantDBName", TENANT_DB_NAME_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("TenantDatabaseResourceId", TENANT_DATABASE_RESOURCE_ID_FIELD);
        map.put("CharacterSetName", CHARACTER_SET_NAME_FIELD);
        map.put("DBSnapshotTenantDatabaseARN", DB_SNAPSHOT_TENANT_DATABASE_ARN_FIELD);
        map.put("NcharCharacterSetName", NCHAR_CHARACTER_SET_NAME_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBSnapshotTenantDatabase, T> g) {
        return obj -> g.apply((DBSnapshotTenantDatabase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBSnapshotTenantDatabase> {
        /**
         * <p>
         * The identifier for the snapshot of the DB instance.
         * </p>
         * 
         * @param dbSnapshotIdentifier
         *        The identifier for the snapshot of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotIdentifier(String dbSnapshotIdentifier);

        /**
         * <p>
         * The ID for the DB instance that contains the tenant databases.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The ID for the DB instance that contains the tenant databases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The resource identifier of the source CDB instance. This identifier can't be changed and is unique to an
         * Amazon Web Services Region.
         * </p>
         * 
         * @param dbiResourceId
         *        The resource identifier of the source CDB instance. This identifier can't be changed and is unique to
         *        an Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The name of the database engine.
         * </p>
         * 
         * @param engineName
         *        The name of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * The type of DB snapshot.
         * </p>
         * 
         * @param snapshotType
         *        The type of DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * The time the DB snapshot was taken, specified in Coordinated Universal Time (UTC). If you copy the snapshot,
         * the creation time changes.
         * </p>
         * 
         * @param tenantDatabaseCreateTime
         *        The time the DB snapshot was taken, specified in Coordinated Universal Time (UTC). If you copy the
         *        snapshot, the creation time changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDatabaseCreateTime(Instant tenantDatabaseCreateTime);

        /**
         * <p>
         * The name of the tenant database.
         * </p>
         * 
         * @param tenantDBName
         *        The name of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDBName(String tenantDBName);

        /**
         * <p>
         * The master username of the tenant database.
         * </p>
         * 
         * @param masterUsername
         *        The master username of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The resource ID of the tenant database.
         * </p>
         * 
         * @param tenantDatabaseResourceId
         *        The resource ID of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDatabaseResourceId(String tenantDatabaseResourceId);

        /**
         * <p>
         * The name of the character set of a tenant database.
         * </p>
         * 
         * @param characterSetName
         *        The name of the character set of a tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the snapshot tenant database.
         * </p>
         * 
         * @param dbSnapshotTenantDatabaseARN
         *        The Amazon Resource Name (ARN) for the snapshot tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotTenantDatabaseARN(String dbSnapshotTenantDatabaseARN);

        /**
         * <p>
         * The <code>NCHAR</code> character set name of the tenant database.
         * </p>
         * 
         * @param ncharCharacterSetName
         *        The <code>NCHAR</code> character set name of the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ncharCharacterSetName(String ncharCharacterSetName);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);
    }

    static final class BuilderImpl implements Builder {
        private String dbSnapshotIdentifier;

        private String dbInstanceIdentifier;

        private String dbiResourceId;

        private String engineName;

        private String snapshotType;

        private Instant tenantDatabaseCreateTime;

        private String tenantDBName;

        private String masterUsername;

        private String tenantDatabaseResourceId;

        private String characterSetName;

        private String dbSnapshotTenantDatabaseARN;

        private String ncharCharacterSetName;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotTenantDatabase model) {
            dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbiResourceId(model.dbiResourceId);
            engineName(model.engineName);
            snapshotType(model.snapshotType);
            tenantDatabaseCreateTime(model.tenantDatabaseCreateTime);
            tenantDBName(model.tenantDBName);
            masterUsername(model.masterUsername);
            tenantDatabaseResourceId(model.tenantDatabaseResourceId);
            characterSetName(model.characterSetName);
            dbSnapshotTenantDatabaseARN(model.dbSnapshotTenantDatabaseARN);
            ncharCharacterSetName(model.ncharCharacterSetName);
            tagList(model.tagList);
        }

        public final String getDbSnapshotIdentifier() {
            return dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getEngineName() {
            return engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Instant getTenantDatabaseCreateTime() {
            return tenantDatabaseCreateTime;
        }

        public final void setTenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
        }

        @Override
        public final Builder tenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
            return this;
        }

        public final String getTenantDBName() {
            return tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getTenantDatabaseResourceId() {
            return tenantDatabaseResourceId;
        }

        public final void setTenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
        }

        @Override
        public final Builder tenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
            return this;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDbSnapshotTenantDatabaseARN() {
            return dbSnapshotTenantDatabaseARN;
        }

        public final void setDbSnapshotTenantDatabaseARN(String dbSnapshotTenantDatabaseARN) {
            this.dbSnapshotTenantDatabaseARN = dbSnapshotTenantDatabaseARN;
        }

        @Override
        public final Builder dbSnapshotTenantDatabaseARN(String dbSnapshotTenantDatabaseARN) {
            this.dbSnapshotTenantDatabaseARN = dbSnapshotTenantDatabaseARN;
            return this;
        }

        public final String getNcharCharacterSetName() {
            return ncharCharacterSetName;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DBSnapshotTenantDatabase build() {
            return new DBSnapshotTenantDatabase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
