/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbProxyTargetGroupRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbProxyTargetGroupRequest.Builder, ModifyDbProxyTargetGroupRequest> {
    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetGroupName").getter(getter(ModifyDbProxyTargetGroupRequest::targetGroupName))
            .setter(setter(Builder::targetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()).build();

    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBProxyName").getter(getter(ModifyDbProxyTargetGroupRequest::dbProxyName))
            .setter(setter(Builder::dbProxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()).build();

    private static final SdkField<ConnectionPoolConfiguration> CONNECTION_POOL_CONFIG_FIELD = SdkField
            .<ConnectionPoolConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConnectionPoolConfig")
            .getter(getter(ModifyDbProxyTargetGroupRequest::connectionPoolConfig)).setter(setter(Builder::connectionPoolConfig))
            .constructor(ConnectionPoolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPoolConfig").build())
            .build();

    private static final SdkField<String> NEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewName").getter(getter(ModifyDbProxyTargetGroupRequest::newName)).setter(setter(Builder::newName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_NAME_FIELD,
            DB_PROXY_NAME_FIELD, CONNECTION_POOL_CONFIG_FIELD, NEW_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetGroupName;

    private final String dbProxyName;

    private final ConnectionPoolConfiguration connectionPoolConfig;

    private final String newName;

    private ModifyDbProxyTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.targetGroupName = builder.targetGroupName;
        this.dbProxyName = builder.dbProxyName;
        this.connectionPoolConfig = builder.connectionPoolConfig;
        this.newName = builder.newName;
    }

    /**
     * <p>
     * The name of the target group to modify.
     * </p>
     * 
     * @return The name of the target group to modify.
     */
    public final String targetGroupName() {
        return targetGroupName;
    }

    /**
     * <p>
     * The name of the proxy.
     * </p>
     * 
     * @return The name of the proxy.
     */
    public final String dbProxyName() {
        return dbProxyName;
    }

    /**
     * <p>
     * The settings that determine the size and behavior of the connection pool for the target group.
     * </p>
     * 
     * @return The settings that determine the size and behavior of the connection pool for the target group.
     */
    public final ConnectionPoolConfiguration connectionPoolConfig() {
        return connectionPoolConfig;
    }

    /**
     * <p>
     * The new name for the modified <code>DBProxyTarget</code>. An identifier must begin with a letter and must contain
     * only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * <p>
     * You can't rename the <code>default</code> target group.
     * </p>
     * 
     * @return The new name for the modified <code>DBProxyTarget</code>. An identifier must begin with a letter and must
     *         contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive
     *         hyphens.</p>
     *         <p>
     *         You can't rename the <code>default</code> target group.
     */
    public final String newName() {
        return newName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(newName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyTargetGroupRequest)) {
            return false;
        }
        ModifyDbProxyTargetGroupRequest other = (ModifyDbProxyTargetGroupRequest) obj;
        return Objects.equals(targetGroupName(), other.targetGroupName()) && Objects.equals(dbProxyName(), other.dbProxyName())
                && Objects.equals(connectionPoolConfig(), other.connectionPoolConfig())
                && Objects.equals(newName(), other.newName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbProxyTargetGroupRequest").add("TargetGroupName", targetGroupName())
                .add("DBProxyName", dbProxyName()).add("ConnectionPoolConfig", connectionPoolConfig()).add("NewName", newName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetGroupName":
            return Optional.ofNullable(clazz.cast(targetGroupName()));
        case "DBProxyName":
            return Optional.ofNullable(clazz.cast(dbProxyName()));
        case "ConnectionPoolConfig":
            return Optional.ofNullable(clazz.cast(connectionPoolConfig()));
        case "NewName":
            return Optional.ofNullable(clazz.cast(newName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetGroupName", TARGET_GROUP_NAME_FIELD);
        map.put("DBProxyName", DB_PROXY_NAME_FIELD);
        map.put("ConnectionPoolConfig", CONNECTION_POOL_CONFIG_FIELD);
        map.put("NewName", NEW_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyTargetGroupRequest, T> g) {
        return obj -> g.apply((ModifyDbProxyTargetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbProxyTargetGroupRequest> {
        /**
         * <p>
         * The name of the target group to modify.
         * </p>
         * 
         * @param targetGroupName
         *        The name of the target group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupName(String targetGroupName);

        /**
         * <p>
         * The name of the proxy.
         * </p>
         * 
         * @param dbProxyName
         *        The name of the proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyName(String dbProxyName);

        /**
         * <p>
         * The settings that determine the size and behavior of the connection pool for the target group.
         * </p>
         * 
         * @param connectionPoolConfig
         *        The settings that determine the size and behavior of the connection pool for the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPoolConfig(ConnectionPoolConfiguration connectionPoolConfig);

        /**
         * <p>
         * The settings that determine the size and behavior of the connection pool for the target group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPoolConfiguration.Builder}
         * avoiding the need to create one manually via {@link ConnectionPoolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPoolConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionPoolConfig(ConnectionPoolConfiguration)}.
         * 
         * @param connectionPoolConfig
         *        a consumer that will call methods on {@link ConnectionPoolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionPoolConfig(ConnectionPoolConfiguration)
         */
        default Builder connectionPoolConfig(Consumer<ConnectionPoolConfiguration.Builder> connectionPoolConfig) {
            return connectionPoolConfig(ConnectionPoolConfiguration.builder().applyMutation(connectionPoolConfig).build());
        }

        /**
         * <p>
         * The new name for the modified <code>DBProxyTarget</code>. An identifier must begin with a letter and must
         * contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive
         * hyphens.
         * </p>
         * <p>
         * You can't rename the <code>default</code> target group.
         * </p>
         * 
         * @param newName
         *        The new name for the modified <code>DBProxyTarget</code>. An identifier must begin with a letter and
         *        must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two
         *        consecutive hyphens.</p>
         *        <p>
         *        You can't rename the <code>default</code> target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newName(String newName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String targetGroupName;

        private String dbProxyName;

        private ConnectionPoolConfiguration connectionPoolConfig;

        private String newName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyTargetGroupRequest model) {
            super(model);
            targetGroupName(model.targetGroupName);
            dbProxyName(model.dbProxyName);
            connectionPoolConfig(model.connectionPoolConfig);
            newName(model.newName);
        }

        public final String getTargetGroupName() {
            return targetGroupName;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final String getDbProxyName() {
            return dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final ConnectionPoolConfiguration.Builder getConnectionPoolConfig() {
            return connectionPoolConfig != null ? connectionPoolConfig.toBuilder() : null;
        }

        public final void setConnectionPoolConfig(ConnectionPoolConfiguration.BuilderImpl connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig != null ? connectionPoolConfig.build() : null;
        }

        @Override
        public final Builder connectionPoolConfig(ConnectionPoolConfiguration connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig;
            return this;
        }

        public final String getNewName() {
            return newName;
        }

        public final void setNewName(String newName) {
            this.newName = newName;
        }

        @Override
        public final Builder newName(String newName) {
            this.newName = newName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbProxyTargetGroupRequest build() {
            return new ModifyDbProxyTargetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
